/*
 * Decompiled with CFR 0.152.
 */
package se.walkercrou.places;

import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.imageio.ImageIO;
import org.json.JSONArray;
import org.json.JSONObject;
import se.walkercrou.places.AddressComponent;
import se.walkercrou.places.AltId;
import se.walkercrou.places.Day;
import se.walkercrou.places.GoogleServices;
import se.walkercrou.places.Hours;
import se.walkercrou.places.Param;
import se.walkercrou.places.Photo;
import se.walkercrou.places.Price;
import se.walkercrou.places.Review;
import se.walkercrou.places.Scope;
import se.walkercrou.places.Status;
import se.walkercrou.places.exception.GooglePlacesException;

public class Place {
    private final List<String> types = new ArrayList<String>();
    private final List<Photo> photos = new ArrayList<Photo>();
    private final List<Review> reviews = new ArrayList<Review>();
    private final List<AddressComponent> addressComponents = new ArrayList<AddressComponent>();
    private final List<AltId> altIds = new ArrayList<AltId>();
    private GoogleServices client;
    private String placeId;
    private Scope scope;
    private double lat = -1.0;
    private double lng = -1.0;
    private JSONObject json;
    private String iconUrl;
    private InputStream icon;
    private String name;
    private String addr;
    private String vicinity;
    private double rating = -1.0;
    private Status status = Status.NONE;
    private Price price = Price.NONE;
    private String phone;
    private String internationalPhone;
    private String googleUrl;
    private String website;
    private Hours hours;
    private int utcOffset;
    private int accuracy;
    private String lang;
    private String zipCode;
    private String street;
    private String route;

    /*
     * WARNING - void declaration
     */
    public static Place parseDetails(GoogleServices client, String rawJson) {
        System.out.println("rawJson : " + rawJson);
        JSONObject json = new JSONObject(rawJson);
        if (!"OK".equals(json.getString("status"))) {
            return null;
        }
        JSONObject result = json.getJSONObject("result");
        String name = result.getString("name");
        String id = result.getString("place_id");
        String address = result.optString("formatted_address", null);
        String phone = result.optString("formatted_phone_number", null);
        String iconUrl = result.optString("icon", null);
        String internationalPhone = result.optString("international_phone_number", null);
        double rating = result.optDouble("rating", -1.0);
        String url = result.optString("url", null);
        String vicinity = result.optString("vicinity", null);
        String website = result.optString("website", null);
        int utcOffset = result.optInt("utc_offset", -1);
        String scopeName = result.optString("scope");
        System.out.println("++++++++++++ scopeName : " + scopeName);
        Scope scope = scopeName == null || scopeName.isEmpty() ? null : Scope.valueOf(scopeName);
        Price price = Price.NONE;
        if (result.has("price_level")) {
            price = Price.values()[result.getInt("price_level")];
        }
        JSONObject location = result.getJSONObject("geometry").getJSONObject("location");
        double lat = location.getDouble("lat");
        double lng = location.getDouble("lng");
        JSONObject hours = result.optJSONObject("opening_hours");
        Status status = Status.NONE;
        Hours schedule = new Hours();
        if (hours != null) {
            boolean statusDefined = hours.has("open_now");
            status = statusDefined && hours.getBoolean("open_now") ? Status.OPENED : Status.CLOSED;
            JSONArray jsonPeriods = hours.optJSONArray("periods");
            if (jsonPeriods != null) {
                for (int i = 0; i < jsonPeriods.length(); ++i) {
                    boolean alwaysOpened;
                    JSONObject jsonPeriod = jsonPeriods.getJSONObject(i);
                    JSONObject opens = jsonPeriod.getJSONObject("open");
                    Day openingDay = Day.values()[opens.getInt("day")];
                    String openingTime = opens.getString("time");
                    boolean bl = alwaysOpened = openingDay == Day.SUNDAY && openingTime.equals("0000") && !jsonPeriod.has("close");
                    if (alwaysOpened) {
                        schedule.setAlwaysOpened(true);
                        break;
                    }
                    JSONObject closes = jsonPeriod.getJSONObject("close");
                    Day closingDay = Day.values()[closes.getInt("day")];
                    String string = closes.getString("time");
                    schedule.addPeriod(new Hours.Period().setOpeningDay(openingDay).setOpeningTime(openingTime).setClosingDay(closingDay).setClosingTime(string));
                }
            }
        }
        Place place = new Place();
        JSONArray jsonPhotos = result.optJSONArray("photos");
        ArrayList<Photo> photos = new ArrayList<Photo>();
        if (jsonPhotos != null) {
            for (int i = 0; i < jsonPhotos.length(); ++i) {
                JSONObject jsonPhoto = jsonPhotos.getJSONObject(i);
                String photoReference = jsonPhoto.getString("photo_reference");
                int width = jsonPhoto.getInt("width");
                int height = jsonPhoto.getInt("height");
                photos.add(new Photo(place, photoReference, width, height));
            }
        }
        JSONArray addrComponents = result.optJSONArray("address_components");
        ArrayList<AddressComponent> addressComponents = new ArrayList<AddressComponent>();
        if (addrComponents != null) {
            for (int i = 0; i < addrComponents.length(); ++i) {
                JSONObject ac = addrComponents.getJSONObject(i);
                AddressComponent addr = new AddressComponent();
                String longName = ac.optString("long_name", null);
                String shortName = ac.optString("short_name", null);
                addr.setLongName(longName);
                addr.setShortName(shortName);
                JSONArray jSONArray = ac.optJSONArray("types");
                if (jSONArray != null) {
                    for (int a = 0; a < jSONArray.length(); ++a) {
                        addr.addType(jSONArray.getString(a));
                    }
                }
                addressComponents.add(addr);
            }
        }
        String zipCode = "";
        for (AddressComponent addressComponent : addressComponents) {
            int found = -1;
            for (String string : addressComponent.getTypes()) {
                if (!"postal_code".equals(string)) continue;
                found = 1;
            }
            if (found != 1) continue;
            zipCode = addressComponent.getLongName();
        }
        String street = "";
        for (AddressComponent addressComponent : addressComponents) {
            int found = -1;
            for (String type : addressComponent.getTypes()) {
                if (!"street_number".equals(type)) continue;
                found = 1;
            }
            if (found != 1) continue;
            street = addressComponent.getLongName();
        }
        String route = "";
        for (AddressComponent addressComponent : addressComponents) {
            boolean bl;
            int n = -1;
            for (String type : addressComponent.getTypes()) {
                if (!"route".equals(type)) continue;
                bl = true;
            }
            if (!bl) continue;
            route = addressComponent.getLongName();
        }
        JSONArray jsonTypes = result.optJSONArray("types");
        ArrayList<String> types = new ArrayList<String>();
        if (jsonTypes != null) {
            void var37_58;
            boolean bl = false;
            while (var37_58 < jsonTypes.length()) {
                types.add(jsonTypes.getString((int)var37_58));
                ++var37_58;
            }
        }
        JSONArray jSONArray = result.optJSONArray("reviews");
        ArrayList<Review> reviews = new ArrayList<Review>();
        if (jSONArray != null) {
            for (int i = 0; i < jSONArray.length(); ++i) {
                JSONObject jsonReview = jSONArray.getJSONObject(i);
                String author = jsonReview.optString("author_name", null);
                String authorUrl = jsonReview.optString("author_url", null);
                String lang = jsonReview.optString("language", null);
                int reviewRating = jsonReview.optInt("rating", -1);
                String text = jsonReview.optString("text", null);
                long time = jsonReview.optLong("time", -1L);
                JSONArray jsonAspects = jsonReview.optJSONArray("aspects");
                ArrayList<Review.Aspect> aspects = new ArrayList<Review.Aspect>();
                if (jsonAspects != null) {
                    for (int a = 0; a < jsonAspects.length(); ++a) {
                        JSONObject jsonAspect = jsonAspects.getJSONObject(a);
                        String aspectType = jsonAspect.getString("type");
                        int aspectRating = jsonAspect.getInt("rating");
                        aspects.add(new Review.Aspect(aspectRating, aspectType));
                    }
                }
                reviews.add(new Review().addAspects(aspects).setAuthor(author).setAuthorUrl(authorUrl).setLanguage(lang).setRating(reviewRating).setText(text).setTime(time));
            }
        }
        JSONArray jsonAltIds = result.optJSONArray("alt_ids");
        ArrayList<AltId> altIds = new ArrayList<AltId>();
        if (jsonAltIds != null) {
            for (int i = 0; i < jsonAltIds.length(); ++i) {
                JSONObject jsonAltId = jsonAltIds.getJSONObject(i);
                String placeId = jsonAltId.getString("place_id");
                String sn = jsonAltId.getString("scope");
                Scope s = sn == null ? null : Scope.valueOf(sn);
                altIds.add(new AltId(client, placeId, s));
            }
        }
        return place.setPlaceId(id).setClient(client).setName(name).setAddress(address).setIconUrl(iconUrl).setPrice(price).setLatitude(lat).setLongitude(lng).addTypes(types).setRating(rating).setStatus(status).setVicinity(vicinity).setPhoneNumber(phone).setInternationalPhoneNumber(internationalPhone).setGoogleUrl(url).setWebsite(website).addPhotos(photos).addAddressComponents(addressComponents).setRoute(route).setZipCode(zipCode).setStreet(street).setHours(schedule).addReviews(reviews).setUtcOffset(utcOffset).setScope(scope).addAltIds(altIds).setJson(result);
    }

    public GoogleServices getClient() {
        return this.client;
    }

    protected Place setClient(GoogleServices client) {
        this.client = client;
        return this;
    }

    public String getPlaceId() {
        return this.placeId;
    }

    protected Place setPlaceId(String placeId) {
        this.placeId = placeId;
        return this;
    }

    public double getLatitude() {
        return this.lat;
    }

    protected Place setLatitude(double lat) {
        this.lat = lat;
        return this;
    }

    public double getLongitude() {
        return this.lng;
    }

    protected Place setLongitude(double lon) {
        this.lng = lon;
        return this;
    }

    public int getUtcOffset() {
        return this.utcOffset;
    }

    protected Place setUtcOffset(int utcOffset) {
        this.utcOffset = utcOffset;
        return this;
    }

    public Hours getHours() {
        return this.hours;
    }

    protected Place setHours(Hours hours) {
        this.hours = hours;
        return this;
    }

    public boolean isAlwaysOpened() {
        return this.hours.isAlwaysOpened();
    }

    public String getPhoneNumber() {
        return this.phone;
    }

    protected Place setPhoneNumber(String phone) {
        this.phone = phone;
        return this;
    }

    public String getInternationalPhoneNumber() {
        return this.internationalPhone;
    }

    protected Place setInternationalPhoneNumber(String internationalPhone) {
        this.internationalPhone = internationalPhone;
        return this;
    }

    public String getGoogleUrl() {
        return this.googleUrl;
    }

    protected Place setGoogleUrl(String googleUrl) {
        this.googleUrl = googleUrl;
        return this;
    }

    public String getWebsite() {
        return this.website;
    }

    protected Place setWebsite(String website) {
        this.website = website;
        return this;
    }

    public String getVicinity() {
        return this.vicinity;
    }

    protected Place setVicinity(String vicinity) {
        this.vicinity = vicinity;
        return this;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    protected Place setIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
        return this;
    }

    public Place downloadIcon() {
        this.icon = this.client.download(this.iconUrl);
        return this;
    }

    public InputStream getIconInputStream() {
        return this.icon;
    }

    public BufferedImage getIconImage() {
        try {
            return ImageIO.read(this.icon);
        }
        catch (Exception e) {
            throw new GooglePlacesException(e);
        }
    }

    public String getName() {
        return this.name;
    }

    protected Place setName(String name) {
        this.name = name;
        return this;
    }

    public String getAddress() {
        return this.addr;
    }

    protected Place setAddress(String addr) {
        this.addr = addr;
        return this;
    }

    protected Place addAddressComponents(Collection<AddressComponent> c) {
        this.addressComponents.addAll(c);
        return this;
    }

    public List<AddressComponent> getAddressComponents() {
        return Collections.unmodifiableList(this.addressComponents);
    }

    protected Place addPhotos(Collection<Photo> photos) {
        this.photos.addAll(photos);
        return this;
    }

    public List<Photo> getPhotos() {
        return Collections.unmodifiableList(this.photos);
    }

    protected Place addReviews(Collection<Review> reviews) {
        this.reviews.addAll(reviews);
        return this;
    }

    public List<Review> getReviews() {
        return Collections.unmodifiableList(this.reviews);
    }

    protected Place addTypes(Collection<String> types) {
        this.types.addAll(types);
        return this;
    }

    public List<String> getTypes() {
        return Collections.unmodifiableList(this.types);
    }

    protected Place addAltIds(Collection<AltId> altIds) {
        this.altIds.addAll(altIds);
        return this;
    }

    public List<AltId> getAltIds() {
        return Collections.unmodifiableList(this.altIds);
    }

    public double getRating() {
        return this.rating;
    }

    protected Place setRating(double rating) {
        this.rating = rating;
        return this;
    }

    public Status getStatus() {
        return this.status;
    }

    protected Place setStatus(Status status) {
        this.status = status;
        return this;
    }

    public Price getPrice() {
        return this.price;
    }

    public String getZipCode() {
        return this.zipCode;
    }

    public Place setZipCode(String zipCode) {
        this.zipCode = zipCode;
        return this;
    }

    public String getStreet() {
        return this.street;
    }

    public Place setStreet(String street) {
        this.street = street;
        return this;
    }

    public String getRoute() {
        return this.route;
    }

    public Place setRoute(String route) {
        this.route = route;
        return this;
    }

    protected Place setPrice(Price price) {
        this.price = price;
        return this;
    }

    public JSONObject getJson() {
        return this.json;
    }

    protected Place setJson(JSONObject json) {
        this.json = json;
        return this;
    }

    public int getAccuracy() {
        return this.accuracy;
    }

    protected Place setAccuracy(int accuracy) {
        this.accuracy = accuracy;
        return this;
    }

    public String getLanguage() {
        return this.lang;
    }

    protected Place setLanguage(String lang) {
        this.lang = lang;
        return this;
    }

    public Scope getScope() {
        return this.scope;
    }

    protected Place setScope(Scope scope) {
        this.scope = scope;
        return this;
    }

    public Place getDetails(Param ... params) {
        return this.client.getPlaceById(this.placeId);
    }

    public String toString() {
        return this.getAddress();
    }

    public boolean equals(Object obj) {
        return obj instanceof Place && ((Place)obj).placeId.equals(this.placeId);
    }
}

