/*
 * Decompiled with CFR 0.152.
 */
package se.walkercrou.places;

import java.awt.image.BufferedImage;
import java.io.InputStream;
import javax.imageio.ImageIO;
import se.walkercrou.places.Param;
import se.walkercrou.places.Place;
import se.walkercrou.places.exception.GooglePlacesException;

public class Photo {
    private final Place place;
    private final String reference;
    private final int width;
    private final int height;
    private InputStream image;

    protected Photo(Place place, String reference, int width, int height) {
        this.place = place;
        this.reference = reference;
        this.width = width;
        this.height = height;
    }

    public Photo download(int maxWidth, int maxHeight, Param ... extraParams) {
        return this;
    }

    public Photo download(Param ... extraParams) {
        return this.download(1600, 1600, extraParams);
    }

    public InputStream getInputStream() {
        return this.image;
    }

    public BufferedImage getImage() {
        try {
            return ImageIO.read(this.image);
        }
        catch (Exception e) {
            throw new GooglePlacesException(e);
        }
    }

    public String getReference() {
        return this.reference;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

