/*
 * Decompiled with CFR 0.152.
 */
package se.walkercrou.places;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import se.walkercrou.places.Day;

public class Hours {
    private final List<Period> periods = new ArrayList<Period>();
    private boolean alwaysOpened;

    protected Hours() {
    }

    public boolean isAlwaysOpened() {
        return this.alwaysOpened;
    }

    protected Hours setAlwaysOpened(boolean alwaysOpened) {
        this.alwaysOpened = alwaysOpened;
        return this;
    }

    protected Hours addPeriod(Period period) {
        this.periods.add(period);
        return this;
    }

    public List<Period> getPeriods() {
        return Collections.unmodifiableList(this.periods);
    }

    public String toString() {
        Object str = "";
        for (Period period : this.periods) {
            str = (String)str + period + "\n";
        }
        return str;
    }

    public static class Period {
        private Day openingDay;
        private Day closingDay;
        private String openingTime;
        private String closingTime;

        protected Period() {
        }

        public Day getOpeningDay() {
            return this.openingDay;
        }

        protected Period setOpeningDay(Day openingDay) {
            this.openingDay = openingDay;
            return this;
        }

        public String getOpeningTime() {
            return this.openingTime;
        }

        protected Period setOpeningTime(String openingTime) {
            this.openingTime = openingTime;
            return this;
        }

        public Day getClosingDay() {
            return this.closingDay;
        }

        protected Period setClosingDay(Day closingDay) {
            this.closingDay = closingDay;
            return this;
        }

        public String getClosingTime() {
            return this.closingTime;
        }

        protected Period setClosingTime(String closingTime) {
            this.closingTime = closingTime;
            return this;
        }

        public String toString() {
            return String.format("%s %s:%s -- %s %s:%s", new Object[]{this.openingDay, this.openingTime.substring(0, 2), this.openingTime.substring(2), this.closingDay, this.closingTime.substring(0, 2), this.closingTime.substring(2)});
        }
    }
}

