/*
 * Decompiled with CFR 0.152.
 */
package se.walkercrou.places;

import com.google.maps.internal.PolylineEncoding;
import com.google.maps.model.LatLng;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.ticket.Point;
import com.utils.NetworkUtils;
import fr.protactile.procaisse.dao.entities.AddressInfo;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONObject;
import se.walkercrou.places.DefaultRequestHandler;
import se.walkercrou.places.GooglePlacesInterface;
import se.walkercrou.places.Param;
import se.walkercrou.places.Place;
import se.walkercrou.places.Prediction;
import se.walkercrou.places.Price;
import se.walkercrou.places.RequestHandler;
import se.walkercrou.places.Status;
import se.walkercrou.places.exception.GooglePlacesException;

public class GoogleServices
implements GooglePlacesInterface {
    public static String API_URL_FORMAT_STRING = "%s%s/json?%s";
    private static String GOOGLE_API_HOST = "maps.googleapis.com";
    private static String apiKeyPlace = "AIzaSyDL3krd6VMcWXgvA7LeiPH7tXyql0AY5Sk";
    private static String apiKeyDuration = "AIzaSyDL3krd6VMcWXgvA7LeiPH7tXyql0AY5Sk";
    private static String apiKeyDirection = "AIzaSyDL3krd6VMcWXgvA7LeiPH7tXyql0AY5Sk";
    public static final String MAP_ADDRESS_API_KEY = "AIzaSyDL3krd6VMcWXgvA7LeiPH7tXyql0AY5Sk";
    private RequestHandler requestHandler;
    private boolean debugModeEnabled;

    public GoogleServices() {
        DefaultRequestHandler drh = new DefaultRequestHandler();
        this.requestHandler = drh;
    }

    private static String addExtraParams(String base, Param ... extraParams) {
        for (Param param : extraParams) {
            base = (String)base + "&" + param.name + (String)(param.value != null ? "=" + param.value : "");
        }
        return base;
    }

    private static String buildUrl(String method, String params, Param ... extraParams) {
        String url = String.format(Locale.ENGLISH, API_URL_FORMAT_STRING, "https://maps.googleapis.com/maps/api/place/", method, params);
        url = GoogleServices.addExtraParams(url, extraParams);
        url = url.replace(' ', '+');
        return url;
    }

    protected static void checkStatus(String statusCode, String errorMessage) {
        GooglePlacesException e = GooglePlacesException.parse(statusCode, errorMessage);
        if (e != null) {
            throw e;
        }
    }

    public static String parse(GoogleServices client, List<Place> places, String str, int limit) {
        JSONObject json = new JSONObject(str);
        String statusCode = json.getString("status");
        GoogleServices.checkStatus(statusCode, json.optString("error_message"));
        if (statusCode.equals("ZERO_RESULTS")) {
            return null;
        }
        JSONArray results = json.getJSONArray("results");
        GoogleServices.parseResults(client, places, results, Math.min(limit, 20));
        return json.optString("next_page_token", null);
    }

    private static void parseResults(GoogleServices client, List<Place> places, JSONArray results, int limit) {
        for (int i = 0; i < limit; ++i) {
            if (i >= results.length()) {
                return;
            }
            JSONObject result = results.getJSONObject(i);
            JSONObject location = result.getJSONObject("geometry").getJSONObject("location");
            double lat = location.getDouble("lat");
            double lon = location.getDouble("lng");
            String placeId = result.getString("place_id");
            String iconUrl = result.optString("icon", null);
            String name = result.optString("name");
            String addr = result.optString("formatted_address", null);
            double rating = result.optDouble("rating", -1.0);
            String vicinity = result.optString("vicinity", null);
            JSONObject hours = result.optJSONObject("opening_hours");
            boolean hoursDefined = hours != null && hours.has("open_now");
            Status status = Status.NONE;
            if (hoursDefined) {
                boolean opened = hours.getBoolean("open_now");
                status = opened ? Status.OPENED : Status.CLOSED;
            }
            boolean priceDefined = result.has("price_level");
            Price price = Price.NONE;
            if (priceDefined) {
                price = Price.values()[result.getInt("price_level")];
            }
            ArrayList<String> types = new ArrayList<String>();
            JSONArray jsonTypes = result.optJSONArray("types");
            if (jsonTypes != null) {
                for (int a = 0; a < jsonTypes.length(); ++a) {
                    types.add(jsonTypes.getString(a));
                }
            }
            Place place = new Place();
            places.add(place.setClient(client).setPlaceId(placeId).setLatitude(lat).setLongitude(lon).setIconUrl(iconUrl).setName(name).setAddress(addr).setRating(rating).setStatus(status).setPrice(price).addTypes(types).setVicinity(vicinity).setJson(result));
        }
    }

    @Override
    public boolean isDebugModeEnabled() {
        return this.debugModeEnabled;
    }

    @Override
    public void setDebugModeEnabled(boolean debugModeEnabled) {
        this.debugModeEnabled = debugModeEnabled;
    }

    private void debug(String msg) {
        if (this.debugModeEnabled) {
            // empty if block
        }
    }

    @Override
    public RequestHandler getRequestHandler() {
        return this.requestHandler;
    }

    @Override
    public void setRequestHandler(RequestHandler requestHandler) {
        this.requestHandler = requestHandler;
    }

    private boolean isNetworkConnected() {
        return NetworkUtils.isNetworkConnected(GOOGLE_API_HOST, 80, 5000);
    }

    public Place getPlaceById(String placeId) {
        try {
            String uri = "https://maps.googleapis.com/maps/api/place/details/json?key=" + apiKeyPlace + "&placeid=" + placeId;
            System.out.println("+++++++++++++= uri : " + uri);
            return Place.parseDetails(this, this.requestHandler.get(uri));
        }
        catch (Exception e) {
            throw new GooglePlacesException(e);
        }
    }

    protected InputStream download(String uri) {
        try {
            InputStream in = this.requestHandler.getInputStream(uri);
            if (in == null) {
                throw new GooglePlacesException("Could not attain input stream at " + uri);
            }
            this.debug("Successfully attained InputStream at " + uri);
            return in;
        }
        catch (Exception e) {
            throw new GooglePlacesException(e);
        }
    }

    public List<Prediction> getPlacePredictions(String input) {
        try {
            if (!this.isNetworkConnected()) {
                return null;
            }
            input = input.replace(' ', '+');
            String uri = "https://maps.googleapis.com/maps/api/place/autocomplete/json?input=" + input + "&key=" + apiKeyPlace;
            System.out.println("uri : " + uri);
            if (AppLocal.lat != null && AppLocal.lon != null) {
                uri = uri + "&location=" + AppLocal.lat + "," + AppLocal.lon;
                double radius = AppLocal.radius != null && !AppLocal.radius.isEmpty() ? Double.parseDouble(AppLocal.radius) * 1000.0 : 50000.0;
                uri = uri + "&radius=" + radius;
            }
            System.out.println("++++++++++++ uri 1 : " + uri);
            String response = this.requestHandler.get(uri);
            return Prediction.parse(this, response);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String duration(String src, String dest) {
        try {
            if (!this.isNetworkConnected()) {
                return "error";
            }
            src = src.replace(' ', '+');
            dest = dest.replace(' ', '+');
            String uri = "https://maps.googleapis.com/maps/api/distancematrix/json?units=imperial&origins=" + src + "&destinations=" + dest + "&key=" + apiKeyDuration;
            return this.getResponseString(uri);
        }
        catch (Exception e) {
            return "error";
        }
    }

    private String getResponseString(String uri) throws IOException {
        String response = this.requestHandler.get(uri);
        JSONObject json = new JSONObject(response);
        String status = json.getString("status");
        if ("OK".equals(status)) {
            JSONArray rows = json.getJSONArray("rows");
            JSONObject row = rows.getJSONObject(0);
            JSONArray elements = row.getJSONArray("elements");
            JSONObject element = elements.getJSONObject(0);
            String statusElement = element.getString("status");
            if ("OK".equals(statusElement)) {
                JSONObject durations = element.getJSONObject("duration");
                String textDurations = durations.getString("text");
                return textDurations;
            }
            return "error";
        }
        return "error";
    }

    public String duration(double latSrc, double lonSrc, double latDest, double lonDest) {
        try {
            if (!this.isNetworkConnected()) {
                return "error";
            }
            String uri = "https://maps.googleapis.com/maps/api/distancematrix/json?units=imperial&origins=" + latSrc + "," + lonSrc + "&destinations=" + latDest + "," + lonDest + "&key=" + apiKeyDuration;
            return this.getResponseString(uri);
        }
        catch (Exception e) {
            return "error";
        }
    }

    private AddressInfo getLatLon(String address) {
        if (!this.isNetworkConnected()) {
            return null;
        }
        AddressInfo addressResto = new AddressInfo();
        try {
            addressResto.setAddress(address);
            address = address.replace(' ', '+');
            String uri = "https://maps.google.com/maps/api/geocode/json?address=" + address + "&sensor=false&region=France&key=AIzaSyDL3krd6VMcWXgvA7LeiPH7tXyql0AY5Sk";
            String response = this.requestHandler.get(uri);
            JSONObject json = new JSONObject(response);
            String status = json.getString("status");
            if ("OK".equals(status)) {
                JSONArray results = json.getJSONArray("results");
                JSONObject result = results.getJSONObject(0);
                JSONObject location = result.getJSONObject("geometry").getJSONObject("location");
                double lat = location.getDouble("lat");
                double lng = location.getDouble("lng");
                addressResto.setLat(lat);
                addressResto.setLon(lng);
                return addressResto;
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    List<LatLng> decodePath(String path) {
        return PolylineEncoding.decode((String)path);
    }

    List<Point> getDirection(String src, String dest) {
        src = src.replace(' ', '+');
        dest = dest.replace(' ', '+');
        ArrayList<Point> points = new ArrayList<Point>();
        try {
            String uri = "https://maps.googleapis.com/maps/api/directions/json?origin=" + src + "&destination=" + dest + "&key=" + apiKeyDirection;
            return this.getPoints(points, uri);
        }
        catch (Exception e) {
            return null;
        }
    }

    private List<Point> getPoints(List<Point> points, String uri) throws IOException {
        String response = this.requestHandler.get(uri);
        JSONObject json = new JSONObject(response);
        String status = json.getString("status");
        if ("OK".equals(status)) {
            JSONArray routes = json.getJSONArray("routes");
            for (int i = 0; i < routes.length(); ++i) {
                JSONObject route = routes.getJSONObject(i);
                JSONArray legs = route.getJSONArray("legs");
                for (int j = 0; j < legs.length(); ++j) {
                    JSONObject leg = legs.getJSONObject(j);
                    JSONArray steps = leg.getJSONArray("steps");
                    for (int h = 0; h < steps.length(); ++h) {
                        JSONObject step = steps.getJSONObject(h);
                        JSONObject polyline = step.getJSONObject("polyline");
                        List<LatLng> stepsPoints = this.decodePath(polyline.getString("points"));
                        for (LatLng stepPoint : stepsPoints) {
                            points.add(new Point(stepPoint.lat, stepPoint.lng));
                        }
                    }
                }
            }
            return points;
        }
        return null;
    }

    public List<Point> getDirectionLatLon(double latSrc, double lonSrc, double latDes, double lonDest) {
        ArrayList<Point> points = new ArrayList<Point>();
        if (!this.isNetworkConnected()) {
            return null;
        }
        try {
            String uri = "https://maps.googleapis.com/maps/api/directions/json?origin=" + latSrc + "," + lonSrc + "&destination=" + latDes + "," + lonDest + "&key=" + apiKeyDirection;
            return this.getPoints(points, uri);
        }
        catch (Exception e) {
            return null;
        }
    }

    public LatLng localizationLatitudeLonguitude(String address) {
        try {
            if (!this.isNetworkConnected()) {
                return null;
            }
            String uri = "https://maps.google.com/maps/api/geocode/json?address=" + (address = address.replace(' ', '+')) + "&sensor=false&region=France&key=AIzaSyDL3krd6VMcWXgvA7LeiPH7tXyql0AY5Sk";
            String response = this.requestHandler.get(uri);
            JSONObject json = new JSONObject(response);
            String status = json.getString("status");
            if ("OK".equals(status)) {
                JSONArray results = json.getJSONArray("results");
                JSONObject result = results.getJSONObject(0);
                JSONObject location = result.getJSONObject("geometry").getJSONObject("location");
                double lat = location.getDouble("lat");
                double lng = location.getDouble("lng");
                return new LatLng(lat, lng);
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

