/*
 * Decompiled with CFR 0.152.
 */
package se.walkercrou.places;

import com.openbravo.pos.util.LogToFile;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import se.walkercrou.places.RequestHandler;

public class DefaultRequestHandler
implements RequestHandler {
    public static final String DEFAULT_CHARACTER_ENCODING = "UTF-8";
    private final HttpClient client = new DefaultHttpClient();
    private String characterEncoding;

    public DefaultRequestHandler(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public DefaultRequestHandler() {
        this(DEFAULT_CHARACTER_ENCODING);
    }

    @Override
    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    @Override
    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    private String readString(HttpResponse response) throws IOException {
        String str = IOUtils.toString((InputStream)response.getEntity().getContent(), (String)this.characterEncoding);
        if (str == null || str.trim().length() == 0) {
            return null;
        }
        return str.trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getInputStream(String uri) {
        HttpGet get = null;
        try {
            get = new HttpGet(uri);
            InputStream inputStream = this.client.execute((HttpUriRequest)get).getEntity().getContent();
            return inputStream;
        }
        catch (Exception e) {
            LogToFile.log("severe", null, e);
        }
        finally {
            if (get != null) {
                get.releaseConnection();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String get(String uri) {
        HttpGet get = null;
        try {
            get = new HttpGet(uri);
            String string = this.readString(this.client.execute((HttpUriRequest)get));
            return string;
        }
        catch (Exception e) {
            LogToFile.log("severe", null, e);
        }
        finally {
            if (get != null) {
                get.releaseConnection();
            }
        }
        return null;
    }

    @Override
    public String post(HttpPost data) {
        try {
            String string = this.readString(this.client.execute((HttpUriRequest)data));
            return string;
        }
        catch (Exception e) {
            LogToFile.log("severe", null, e);
        }
        finally {
            if (data != null) {
                data.releaseConnection();
            }
        }
        return null;
    }
}

