/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.tpeCmi;

import java.util.HashMap;

public class TransactionStatusChecker {
    public static final String SUCCESSFUL_PROCESS = "Processus r\u00e9ussi. OK";
    public static final String ABORTING_OPERATION_FAILURE = "\u00c9chec d'annulation de l'op\u00e9ration. Veuillez attendre la r\u00e9ponse du TPE.";
    public static final String NO_SESSION_AVAILABLE = "\u00c9chec de l'op\u00e9ration : Pas de session disponible. Veuillez ouvrir une session.";
    public static final String WRONG_SESSION_ID = "\u00c9chec du processus : Mauvais identifiant de session. Veuillez v\u00e9rifier l'ID de session.";
    public static final String PROVIDER_SERVER_UNAVAILABLE = "\u00c9chec du processus ou serveur du fournisseur indisponible. Veuillez r\u00e9essayer.";
    public static final String PROCESS_TIMEOUT = "\u00c9chec du processus : D\u00e9lai d'attente d\u00e9pass\u00e9. Veuillez r\u00e9essayer si c'est un appel de paiement.";
    public static final String SIGN_ON_ALREADY_SIGNED = "\u00c9chec de connexion : D\u00e9j\u00e0 sign\u00e9. Veuillez vous d\u00e9connecter puis vous reconnecter.";
    public static final String CONNECTION_FAILURE = "\u00c9chec de connexion ECR-EFT. Veuillez v\u00e9rifier le mat\u00e9riel.";
    public static final String WRONG_STATION_ID = "\u00c9chec de connexion : Mauvais identifiant de station. Veuillez v\u00e9rifier l'ID du terminal.";
    public static final String EFT_NOT_SIGNED_ON = "\u00c9chec de l'ouverture de session : EFT n'est pas connect\u00e9. Veuillez vous connecter.";
    public static final String CANNOT_ALLOCATE_SESSION_ID = "\u00c9chec de l'ouverture de session : Impossible d'allouer l'ID de session. Veuillez reformater TAG_SESSION_ID.";
    public static final String SESSION_STILL_OPENED = "\u00c9chec de l'ouverture de session : La session est toujours ouverte. Veuillez fermer la session puis l'ouvrir \u00e0 nouveau.";
    public static final String UNFINISHED_OPERATIONS = "\u00c9chec de la fermeture de la session : Op\u00e9rations non termin\u00e9es. Veuillez attendre avant de r\u00e9essayer.";
    public static final String NO_SESSION_AVAILABLE_CLOSE = "\u00c9chec de la fermeture de la session : Aucune session disponible. Veuillez continuer.";
    public static final String WRONG_SESSION_ID_CLOSE = "\u00c9chec de la fermeture de la session : Mauvais identifiant de session. Veuillez v\u00e9rifier l'ID de session.";
    public static final String INVALID_CARD = "Carte illisible ou invalide. Veuillez rendre le focus \u00e0 l'h\u00f4tesse.";
    public static final String WRONG_CARD_CODE = "Code de carte incorrect. Veuillez rendre le focus \u00e0 l'h\u00f4tesse.";
    public static final String TRANSACTION_NO_SESSION_AVAILABLE = "\u00c9chec de la transaction : Pas de session disponible. Veuillez ouvrir une session.";
    public static final String OPERATION_REFUSED = "\u00c9chec de la transaction : Op\u00e9ration refus\u00e9e par le fournisseur. Veuillez rendre le focus \u00e0 l'h\u00f4tesse.";
    public static final String INPUT_DATA_ERROR = "\u00c9chec de la transaction : Erreur de donn\u00e9es d'entr\u00e9e (paiement manuel). Veuillez rendre le focus \u00e0 l'h\u00f4tesse.";
    public static final String WRONG_SESSION_ID_PAYMENT = "\u00c9chec de la transaction : Mauvais identifiant de session. Veuillez v\u00e9rifier l'ID de session.";
    public static final String INEXISTENT_TRANSACTION = "Transaction inexistante. Veuillez rendre le focus \u00e0 l'h\u00f4tesse.";
    public static final String END_OF_DAY_SUCCESSFUL = "Fin de journ\u00e9e r\u00e9ussie. OK";
    public static final String END_OF_DAY_FAILURE = "\u00c9chec de la fin de journ\u00e9e. Veuillez r\u00e9essayer.";
    public static final String END_OF_DAY_IMPOSSIBLE = "Impossible de terminer la journ\u00e9e. Veuillez r\u00e9essayer.";
    public static final String END_OF_DAY_NO_SESSION = "\u00c9chec de la fin de journ\u00e9e : Pas de session disponible. Veuillez ouvrir une session.";
    public static final String END_OF_DAY_WRONG_SESSION_ID = "\u00c9chec de la fin de journ\u00e9e : Mauvais identifiant de session. Veuillez v\u00e9rifier l'ID de session.";
    public static final String SIGN_OFF_FAILURE = "\u00c9chec de la d\u00e9connexion : La session est toujours ouverte. Veuillez fermer la session puis vous d\u00e9connecter.";
    public static final String NO_TRANSACTION_TO_VOID = "Aucune transaction \u00e0 annuler. Veuillez r\u00e9introduire le STAN.";
    public static final String VOID_TRANSACTION_FAILURE = "\u00c9chec de l'annulation de la transaction. Veuillez r\u00e9essayer ou rendre le focus \u00e0 l'h\u00f4tesse.";

    public static HashMap<Boolean, String> getStatusValueFromDC2(String dc1Code) {
        String statusCode = dc1Code.substring(dc1Code.length() - 4);
        HashMap<Boolean, String> statusMap = new HashMap<Boolean, String>();
        switch (statusCode) {
            case "0000": {
                statusMap.put(true, SUCCESSFUL_PROCESS);
                break;
            }
            case "1058": {
                statusMap.put(false, ABORTING_OPERATION_FAILURE);
                break;
            }
            case "1066": {
                statusMap.put(false, NO_SESSION_AVAILABLE);
                break;
            }
            case "1067": {
                statusMap.put(false, WRONG_SESSION_ID);
                break;
            }
            case "1068": {
                statusMap.put(false, PROVIDER_SERVER_UNAVAILABLE);
                break;
            }
            case "106B": {
                statusMap.put(false, PROCESS_TIMEOUT);
                break;
            }
            case "1063": {
                statusMap.put(false, SIGN_ON_ALREADY_SIGNED);
                break;
            }
            case "1050": {
                statusMap.put(false, CONNECTION_FAILURE);
                break;
            }
            case "106C": {
                statusMap.put(false, WRONG_STATION_ID);
                break;
            }
            case "1051": {
                statusMap.put(false, EFT_NOT_SIGNED_ON);
                break;
            }
            case "1052": {
                statusMap.put(false, CANNOT_ALLOCATE_SESSION_ID);
                break;
            }
            case "1062": {
                statusMap.put(false, SESSION_STILL_OPENED);
                break;
            }
            case "105B": {
                statusMap.put(false, UNFINISHED_OPERATIONS);
                break;
            }
            case "105C": {
                statusMap.put(false, NO_SESSION_AVAILABLE_CLOSE);
                break;
            }
            case "1069": {
                statusMap.put(false, WRONG_SESSION_ID_CLOSE);
                break;
            }
            case "1053": {
                statusMap.put(false, INVALID_CARD);
                break;
            }
            case "1054": {
                statusMap.put(false, WRONG_CARD_CODE);
                break;
            }
            case "1055": {
                statusMap.put(false, TRANSACTION_NO_SESSION_AVAILABLE);
                break;
            }
            case "1056": {
                statusMap.put(false, OPERATION_REFUSED);
                break;
            }
            case "1057": {
                statusMap.put(false, INPUT_DATA_ERROR);
                break;
            }
            case "106A": {
                statusMap.put(false, WRONG_SESSION_ID_PAYMENT);
                break;
            }
            case "1070": {
                statusMap.put(false, INEXISTENT_TRANSACTION);
                break;
            }
            case "105E": {
                statusMap.put(true, END_OF_DAY_SUCCESSFUL);
                break;
            }
            case "105F": 
            case "1060": 
            case "1061": {
                statusMap.put(false, END_OF_DAY_FAILURE);
                break;
            }
            case "1064": {
                statusMap.put(false, END_OF_DAY_NO_SESSION);
                break;
            }
            case "1065": {
                statusMap.put(false, END_OF_DAY_WRONG_SESSION_ID);
                break;
            }
            case "105D": {
                statusMap.put(false, SIGN_OFF_FAILURE);
                break;
            }
            case "1059": {
                statusMap.put(false, NO_TRANSACTION_TO_VOID);
                break;
            }
            case "105A": {
                statusMap.put(false, VOID_TRANSACTION_FAILURE);
                break;
            }
            default: {
                statusMap.put(false, null);
            }
        }
        return statusMap;
    }

    public static String getStatusCodeDC2(String dc1Code) {
        String statusCode = dc1Code.substring(dc1Code.length() - 4);
        return statusCode;
    }

    public static HashMap<String, String> parseTags(String input) {
        HashMap<String, String> tagValueMap = new HashMap<String, String>();
        int index = 0;
        while (index < input.length()) {
            String value;
            String tagCode;
            int length = 0;
            if (input.startsWith("A", index)) {
                tagCode = input.substring(index, index + 4);
                value = "root";
                tagValueMap.put(tagCode, value);
                index += 8;
                continue;
            }
            tagCode = input.substring(index, index + 4);
            if ((index += 4) + 4 > input.length() || (index += 4) + (length = Integer.parseInt(input.substring(index, index + 4))) > input.length()) break;
            value = input.substring(index, index + length);
            tagValueMap.put(tagCode, value);
            index += length;
        }
        return tagValueMap;
    }
}

