/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.tpeCmi;

import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.util.LogToFile;
import fr.protactile.procaisse.tpeCmi.DCGenerator;
import fr.protactile.procaisse.tpeCmi.TransactionStatusChecker;
import java.io.File;
import java.io.FileWriter;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TPECmi {
    private static TPECmi instance;
    private final String OPERATION_PAYMENT = "Payment";
    private final String OPERATION_CANCEL_PAYMENT = "Void";
    private final String OPERATION_TRANSACTION_STATUS = "TransactStatus";
    private final String OPERATION_TRANSACTION_RECEIPT_DUPLICATE = "TransactReceiptDuplicate";
    private final int maxAttempts = 2;
    private int attempt = 0;

    public void initCmi() {
        try {
            File file = new File(System.getProperty("user.home") + File.separator + "Cmi_transactions" + File.separator + "transactions_Cmi.txt");
            File parentDir = file.getParentFile();
            if (!parentDir.exists()) {
                parentDir.mkdirs();
            }
            if (!file.exists()) {
                file.createNewFile();
            }
            String scriptPath = System.getProperty("user.home") + File.separator + "cmi_tpe" + File.separator + "run.ps1";
            System.out.println("************** scriptPath: " + scriptPath);
            String command = "powershell.exe -ExecutionPolicy Bypass -File \"" + scriptPath + "\"";
            ProcessBuilder processBuilder = new ProcessBuilder("cmd.exe", "/c", command);
            System.out.println("****** After CMD Builder *********************");
            Process process = processBuilder.start();
            System.out.println("****** After process ********************* PID: " + process.pid());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static TPECmi getInstance() {
        if (instance == null) {
            instance = new TPECmi();
        }
        return instance;
    }

    private TPECmi() {
    }

    public Object[] paymentTPECmi(TicketInfo ticket, String operation_type) {
        Object[] results = new Object[]{false, null, null, null, null, null, null};
        double total_order = ticket.getTotal();
        Pattern pattern = null;
        boolean forPayment = false;
        String dc2Code = null;
        boolean isPos = AppLocal.modeCaisse.equals("Caisse");
        File file = new File(System.getProperty("user.home") + File.separator + "Cmi_transactions" + File.separator + "transactions_Cmi.txt");
        try {
            File parentDir = file.getParentFile();
            if (!parentDir.exists()) {
                parentDir.mkdirs();
            }
            if (!file.exists()) {
                file.createNewFile();
            } else {
                try (FileWriter writer = new FileWriter(file, false);){
                    writer.write("");
                }
            }
            String timeStamp = String.valueOf(new Date().getTime());
            String DC1 = "";
            String DcPattern = null;
            switch (operation_type) {
                case "Payment": {
                    DC1 = DCGenerator.generatePaymentDC1(total_order);
                    DcPattern = "Payment\\s*-\\s*DC2\\s*:\\s*(\\S+)\\s*-\\s*DC3\\s*:\\s*(\\S+)";
                    forPayment = true;
                    break;
                }
                case "Void": {
                    DC1 = DCGenerator.generateCancelDC1(ticket.getTag_erc_stan(), ticket.getEft_stan(), ticket.getLast_digit());
                    DcPattern = "Void\\s*-\\s*DC2\\s*:\\s*(\\S+)\\s*-\\s*DC3\\s*:\\s*(\\S+)";
                    forPayment = false;
                }
            }
            String session_id_ecr = AppLocal.CURRENT_SESSION_ID;
            try (FileWriter writer = new FileWriter(file);){
                writer.write("Total Order:" + total_order + "\n");
                writer.write("timestamp:" + timeStamp + "\n");
                writer.write("operation_type: " + operation_type + "\n");
                writer.write("DC1:" + DC1 + "\n");
                writer.write("session_id: " + session_id_ecr + "\n");
            }
            long startTime = System.currentTimeMillis();
            long timeout = 40000L;
            long checkInterval = 3000L;
            while (System.currentTimeMillis() - startTime < timeout) {
                SimpleDateFormat dayFormat;
                String dayFolder;
                SimpleDateFormat monthFormat;
                String monthFolder;
                String userHome = System.getProperty("user.home");
                File file_log = new File(userHome + File.separator + "Cmi_transactions" + File.separator + (monthFolder = (monthFormat = new SimpleDateFormat("MM-yyyy")).format(new Date())) + File.separator + (dayFolder = (dayFormat = new SimpleDateFormat("dd-MM-yyyy")).format(new Date())) + File.separator + "transactions_Cmi_" + timeStamp + ".txt");
                if (file_log.exists()) {
                    String content = new String(Files.readAllBytes(Paths.get(file_log.getPath(), new String[0])));
                    String DC2 = "";
                    String DC3 = "";
                    pattern = Pattern.compile(DcPattern);
                    Matcher matcher = pattern.matcher(content);
                    if (matcher.find()) {
                        DC2 = matcher.group(1);
                        DC3 = matcher.group(2);
                        System.out.println("Extracted DC2 For " + operation_type + " : " + DC2);
                        System.out.println("Extracted DC3 For " + operation_type + " : " + DC3);
                        dc2Code = TransactionStatusChecker.getStatusCodeDC2(DC2);
                        HashMap<Boolean, String> payemnt_transaction_result = TransactionStatusChecker.getStatusValueFromDC2(dc2Code);
                        for (Map.Entry<Boolean, String> entry : payemnt_transaction_result.entrySet()) {
                            results[0] = entry.getKey();
                            results[1] = entry.getValue();
                        }
                        if (!((Boolean)results[0]).booleanValue()) break;
                        String ticket_cmi = this.extractSecondTicket(content);
                        results[2] = ticket_cmi;
                        HashMap<String, String> eft_response = TransactionStatusChecker.parseTags(DC3);
                        if (eft_response.isEmpty()) break;
                        String session_id = AppLocal.CURRENT_SESSION_ID;
                        String ecr_stan = eft_response.get("000F");
                        String eft_stan = eft_response.get("0029");
                        String last4_digits = eft_response.get("005D");
                        results[3] = session_id;
                        results[4] = ecr_stan;
                        results[5] = eft_stan;
                        results[6] = last4_digits;
                        break;
                    }
                }
                Thread.sleep(checkInterval);
            }
            if ((results[1] == null || dc2Code.equals("105A")) && isPos) {
                results = operation_type.equals("Void") ? this.doCmiTransactStatus("TransactStatus", forPayment, ticket.getTag_erc_stan(), ticket.getEft_stan(), ticket.getEcrDateTime()) : this.doCmiTransactStatus("TransactStatus", forPayment, AppLocal.CURRENT_ECR_STAN, null, AppLocal.CURRENT_ECR_DATE_TIME);
            }
        }
        catch (Exception ex) {
            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, String.valueOf(ex.getMessage()), 1500, NPosition.BOTTOM_RIGHT);
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return results;
    }

    public Object[] dopaymentTPECmi(TicketInfo ticket) {
        return this.paymentTPECmi(ticket, "Payment");
    }

    public Object[] doCmiTransactStatus(String type_operation, boolean forPayment, String ecr_stan, String eft_stan, String erc_date_time) {
        Object[] results = new Object[]{false, null, null, null, null, null, null};
        Pattern pattern = null;
        File file = new File(System.getProperty("user.home") + File.separator + "Cmi_transactions" + File.separator + "transactions_Cmi.txt");
        try {
            File parentDir = file.getParentFile();
            if (!parentDir.exists()) {
                parentDir.mkdirs();
            }
            if (!file.exists()) {
                file.createNewFile();
            } else {
                try (FileWriter writer = new FileWriter(file, false);){
                    writer.write("");
                }
            }
            String timeStamp = String.valueOf(new Date().getTime());
            String DcPattern = null;
            String DC1 = "";
            switch (type_operation) {
                case "TransactStatus": {
                    DC1 = DCGenerator.generateTransactStatusDC1(ecr_stan);
                    DcPattern = "TransactStatus\\s*-\\s*DC2\\s*:\\s*(\\S+)\\s*-\\s*DC3\\s*:\\s*(\\S+)";
                    break;
                }
                case "TransactReceiptDuplicate": {
                    DC1 = DCGenerator.generateTransactReceiptDuplicateDC1(ecr_stan, erc_date_time);
                    DcPattern = forPayment ? "Payment\\s*-\\s*DC2\\s*:\\s*(\\S+)\\s*-\\s*DC3\\s*:\\s*(\\S+)" : "Void\\s*-\\s*DC2\\s*:\\s*(\\S+)\\s*-\\s*DC3\\s*:\\s*(\\S+)";
                }
            }
            String session_id_ecr = AppLocal.CURRENT_SESSION_ID;
            try (FileWriter writer = new FileWriter(file);){
                writer.write("Total Order:0.0\n");
                writer.write("timestamp:" + timeStamp + "\n");
                writer.write("operation_type: " + type_operation + "\n");
                writer.write("DC1:" + DC1 + "\n");
                writer.write("session_id: " + session_id_ecr + "\n");
            }
            long startTime = System.currentTimeMillis();
            long timeout = 40000L;
            long checkInterval = 3000L;
            while (System.currentTimeMillis() - startTime < timeout) {
                SimpleDateFormat dayFormat;
                String dayFolder;
                SimpleDateFormat monthFormat;
                String monthFolder;
                String userHome = System.getProperty("user.home");
                File file_log = new File(userHome + File.separator + "Cmi_transactions" + File.separator + (monthFolder = (monthFormat = new SimpleDateFormat("MM-yyyy")).format(new Date())) + File.separator + (dayFolder = (dayFormat = new SimpleDateFormat("dd-MM-yyyy")).format(new Date())) + File.separator + "transactions_Cmi_" + timeStamp + ".txt");
                if (file_log.exists()) {
                    String content = new String(Files.readAllBytes(Paths.get(file_log.getPath(), new String[0])));
                    String DC2 = "";
                    String DC3 = "";
                    pattern = Pattern.compile(DcPattern);
                    Matcher matcher = pattern.matcher(content);
                    if (matcher.find()) {
                        HashMap<String, String> eft_response;
                        DC2 = matcher.group(1);
                        DC3 = matcher.group(2);
                        System.out.println("Extracted DC2 For " + type_operation + " : " + DC2);
                        System.out.println("Extracted DC3 For " + type_operation + " : " + DC3);
                        String dc2Code = TransactionStatusChecker.getStatusCodeDC2(DC2);
                        HashMap<Boolean, String> payemnt_transaction_result = TransactionStatusChecker.getStatusValueFromDC2(dc2Code);
                        for (Map.Entry<Boolean, String> entry : payemnt_transaction_result.entrySet()) {
                            results[0] = entry.getKey();
                            results[1] = entry.getValue();
                        }
                        if (!((Boolean)results[0]).booleanValue() || (eft_response = TransactionStatusChecker.parseTags(DC3)).isEmpty()) break;
                        ecr_stan = eft_response.get("000F");
                        eft_stan = eft_response.get("0029");
                        String last4_digits = eft_response.get("005D") == null ? DCGenerator.getLastFourChars(eft_response.get("005D")) : eft_response.get("005D");
                        results[3] = AppLocal.CURRENT_SESSION_ID;
                        results[4] = ecr_stan;
                        results[5] = eft_stan;
                        results[6] = last4_digits;
                        if (type_operation.equals("TransactReceiptDuplicate")) break;
                        this.doTransactReceiptDuplicate(eft_stan, ecr_stan, erc_date_time, forPayment);
                        break;
                    }
                }
                Thread.sleep(checkInterval);
            }
            if (results[1] == null) {
                results[1] = "Erreur Connexion TPE ";
            }
        }
        catch (Exception ex) {
            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, String.valueOf(ex.getMessage()), 1500, NPosition.BOTTOM_RIGHT);
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return results;
    }

    public Object[] doTransactReceiptDuplicate(String eft_stan, String ecr_stan, String EcrDateTime, boolean forPayment) {
        System.out.println("++++++++++forPayment : " + forPayment);
        return this.doCmiTransactStatus("TransactReceiptDuplicate", forPayment, ecr_stan, eft_stan, EcrDateTime);
    }

    public Object[] doCancelCurrentPayment(TicketInfo ticketInfo) {
        return this.paymentTPECmi(ticketInfo, "Void");
    }

    public String extractSecondTicket(String content) {
        StringBuilder ticketBuilder = new StringBuilder();
        Scanner contentScanner = new Scanner(content);
        int ticketCount = 0;
        boolean capturing = false;
        boolean skipFirstLine = true;
        while (contentScanner.hasNextLine()) {
            String line = contentScanner.nextLine();
            if (line.startsWith("Ticket :")) {
                if (++ticketCount == 2) {
                    capturing = true;
                    skipFirstLine = true;
                    continue;
                }
                if (ticketCount <= 2) continue;
                break;
            }
            if (!capturing) continue;
            if (skipFirstLine) {
                skipFirstLine = false;
                continue;
            }
            ticketBuilder.append(line).append("\n");
            if (!line.contains("COPIE CLIENT")) continue;
            break;
        }
        contentScanner.close();
        return ticketBuilder.toString().trim();
    }

    public void SignOn() {
        Object[] results = new Object[2];
        Pattern pattern = null;
        String operation_type = "SignOn";
        File file = new File(System.getProperty("user.home") + File.separator + "Cmi_transactions" + File.separator + "transactions_Cmi.txt");
        while (this.attempt < 2) {
            System.out.println("******** attempt" + this.attempt);
            try {
                results[0] = false;
                results[1] = null;
                File parentDir = file.getParentFile();
                if (!parentDir.exists()) {
                    parentDir.mkdirs();
                }
                if (!file.exists()) {
                    file.createNewFile();
                } else {
                    try (FileWriter writer = new FileWriter(file, false);){
                        writer.write("");
                    }
                }
                String timeStamp = String.valueOf(new Date().getTime());
                String DC1 = DCGenerator.generateSignOnDC1();
                String DcPattern = "SignOn\\s*-\\s*DC2\\s*:\\s*(\\S+)\\s*-\\s*DC3\\s*:\\s*(\\S+)";
                try (FileWriter writer = new FileWriter(file);){
                    writer.write("timestamp:" + timeStamp + "\n");
                    writer.write("operation_type: " + operation_type + "\n");
                    writer.write("DC1:" + DC1 + "\n");
                }
                long startTime = System.currentTimeMillis();
                long timeout = 60000L;
                long checkInterval = 3000L;
                while (System.currentTimeMillis() - startTime < timeout) {
                    SimpleDateFormat dayFormat;
                    String dayFolder;
                    SimpleDateFormat monthFormat;
                    String monthFolder;
                    String userHome = System.getProperty("user.home");
                    File file_log = new File(userHome + File.separator + "Cmi_transactions" + File.separator + (monthFolder = (monthFormat = new SimpleDateFormat("MM-yyyy")).format(new Date())) + File.separator + (dayFolder = (dayFormat = new SimpleDateFormat("dd-MM-yyyy")).format(new Date())) + File.separator + "transactions_Cmi_" + timeStamp + ".txt");
                    if (file_log.exists()) {
                        String content = new String(Files.readAllBytes(Paths.get(file_log.getPath(), new String[0])));
                        String DC2 = "";
                        String DC3 = "";
                        pattern = Pattern.compile(DcPattern);
                        Matcher matcher = pattern.matcher(content);
                        if (matcher.find()) {
                            DC2 = matcher.group(1);
                            DC3 = matcher.group(2);
                            System.out.println("Extracted DC2 for " + operation_type + " : " + DC2);
                            System.out.println("Extracted DC3 for " + operation_type + " : " + DC3);
                            String dc2Code = TransactionStatusChecker.getStatusCodeDC2(DC2);
                            HashMap<Boolean, String> SignOn_result = TransactionStatusChecker.getStatusValueFromDC2(dc2Code);
                            for (Map.Entry<Boolean, String> entry : SignOn_result.entrySet()) {
                                results[0] = entry.getKey();
                                results[1] = entry.getValue();
                            }
                            if (((Boolean)results[0]).booleanValue()) break;
                        }
                    }
                    Thread.sleep(checkInterval);
                }
                if (((Boolean)results[0]).booleanValue()) {
                    new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, String.valueOf(results[1]), 1500, NPosition.BOTTOM_RIGHT);
                    break;
                }
            }
            catch (Exception ex) {
                new NotifyWindow(NotifyType.ERROR_NOTIFICATION, String.valueOf(ex.getMessage()), 1500, NPosition.BOTTOM_RIGHT);
                LogToFile.log("severe", ex.getMessage(), ex);
            }
            ++this.attempt;
            if (this.attempt < 2 || ((Boolean)results[0]).booleanValue()) continue;
            results[1] = "Erreur de connexion TPE, veuillez red\u00e9marrer le logiciel ou v\u00e9rifier le d\u00e9marrage du TPE.";
            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, String.valueOf(results[1]), 1500, NPosition.BOTTOM_RIGHT);
        }
    }
}

