/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.tpeCmi;

import com.openbravo.basic.BasicException;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.util.LogToFile;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class DCGenerator {
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyMMddHHmmss");
    private static final AtomicInteger counter = new AtomicInteger(0);
    private static final Set<Integer> generatedNumbers = new HashSet<Integer>();
    private static final Random random = new Random();

    public static String generatePaymentDC1(double total) {
        StringBuilder sb = new StringBuilder();
        try {
            String ecrDateTimeFormatted;
            String amount = DCGenerator.convertEuroToCentimesInBase6(total);
            String session_id = DCGenerator.SetSessionId();
            String erc_stan = DCGenerator.generateUniqueECRSTAN();
            LocalDateTime ecrDateTime = LocalDateTime.now();
            String erc_date_time = ecrDateTimeFormatted = ecrDateTime.format(formatter);
            AppLocal.CURRENT_ECR_STAN = erc_stan;
            AppLocal.CURRENT_ECR_DATE_TIME = erc_date_time;
            System.out.println("+++++erc_stan  Payment :" + erc_stan);
            System.out.println("+++++erc_date_time Payment :" + erc_date_time);
            AppLocal.CURRENT_SESSION_ID = session_id;
            int size_additional_data = DCGenerator.calculateBase4SizeSegment("000F", erc_stan) + DCGenerator.calculateBase4SizeSegment("0010", erc_date_time);
            String additional_data_converted = String.format("%04d", size_additional_data);
            int size_extra_data = Integer.parseInt(additional_data_converted) + 8;
            String extra_data = String.format("%04d", size_extra_data);
            int size_std_data = DCGenerator.calculateBase4SizeSegment("000C", amount) + DCGenerator.calculateBase4SizeSegment("0036", "4145") + DCGenerator.calculateBase4SizeSegment("000D", "504") + DCGenerator.calculateBase4SizeSegment("000E", "0") + DCGenerator.calculateBase4SizeSegment("0032", "1") + DCGenerator.calculateBase4SizeSegment("002A", session_id);
            String std_data_converted = String.format("%04d", size_std_data);
            int size_data = Integer.parseInt(extra_data) + Integer.parseInt(std_data_converted) + 16;
            String size_data_converted = String.format("%04d", size_data);
            sb.append("A005").append(size_data_converted).append("A006").append(std_data_converted).append("0036").append(DCGenerator.calculateBase4Size("4145")).append("4145").append("000C").append(DCGenerator.calculateBase4Size(amount)).append(amount).append("000D").append(DCGenerator.calculateBase4Size("504")).append("504").append("000E").append(DCGenerator.calculateBase4Size("0")).append("0").append("0032").append(DCGenerator.calculateBase4Size("1")).append("1").append("002A").append(DCGenerator.calculateBase4Size(session_id)).append(session_id).append("A007").append(extra_data).append("A008").append(additional_data_converted).append("000F").append(DCGenerator.calculateBase4Size(erc_stan)).append(erc_stan).append("0010").append(DCGenerator.calculateBase4Size(erc_date_time)).append(erc_date_time);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return sb.toString();
    }

    public static String generateCancelDC1(String erc_stan, String eft_stan, String last_digit) {
        System.out.println("++++++++++  generateCancelDC1 erc_stan :" + erc_stan);
        System.out.println("++++++++++ generateCancelDC1 eft_stan :" + eft_stan);
        System.out.println("++++++++++ generateCancelDC1 last_digit :" + last_digit);
        int size_additional_data = 0;
        StringBuilder sb = new StringBuilder();
        try {
            String session_id;
            AppLocal.CURRENT_SESSION_ID = session_id = DCGenerator.SetSessionId();
            eft_stan = eft_stan != null && !eft_stan.isEmpty() ? eft_stan : "0";
            int size_requested_data = DCGenerator.calculateBase4SizeSegment("006E", "2") + DCGenerator.calculateBase4SizeSegment("0029", eft_stan) + DCGenerator.calculateBase4SizeSegment("0032", "1") + DCGenerator.calculateBase4SizeSegment("002A", session_id);
            String size_requested_data_converted = String.format("%04d", size_requested_data);
            size_additional_data = last_digit == null ? DCGenerator.calculateBase4SizeSegment("000F", erc_stan) + DCGenerator.calculateBase4SizeSegment("0028", "5") : DCGenerator.calculateBase4SizeSegment("000F", erc_stan) + DCGenerator.calculateBase4SizeSegment("0028", "5") + DCGenerator.calculateBase4SizeSegment("005D", last_digit);
            String size_additional_data_converted = String.format("%04d", size_additional_data);
            int size_data = Integer.parseInt(size_requested_data_converted) + Integer.parseInt(size_additional_data_converted) + 16;
            String size_data_converted = String.format("%04d", size_data);
            if (last_digit == null || last_digit.equals("null")) {
                sb.append("A016").append(size_data_converted).append("A017").append(size_requested_data_converted).append("006E").append(DCGenerator.calculateBase4Size("2")).append("2").append("0029").append(DCGenerator.calculateBase4Size(eft_stan)).append(eft_stan).append("0032").append(DCGenerator.calculateBase4Size("1")).append("1").append("002A").append(DCGenerator.calculateBase4Size(session_id)).append(session_id).append("A018").append(size_additional_data_converted).append("000F").append(DCGenerator.calculateBase4Size(erc_stan)).append(erc_stan).append("0028").append(DCGenerator.calculateBase4Size("5")).append("5");
            } else {
                sb.append("A016").append(size_data_converted).append("A017").append(size_requested_data_converted).append("006E").append(DCGenerator.calculateBase4Size("2")).append("2").append("0029").append(DCGenerator.calculateBase4Size(eft_stan)).append(eft_stan).append("0032").append(DCGenerator.calculateBase4Size("1")).append("1").append("002A").append(DCGenerator.calculateBase4Size(session_id)).append(session_id).append("A018").append(size_additional_data_converted).append("000F").append(DCGenerator.calculateBase4Size(erc_stan)).append(erc_stan).append("0028").append(DCGenerator.calculateBase4Size("5")).append("5").append("005D").append(DCGenerator.calculateBase4Size(last_digit)).append(last_digit);
            }
            System.out.println("+++++++++++ Cancel DC1 :" + sb.toString());
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return sb.toString();
    }

    public static String generateTransactStatusDC1(String ecr_stan) {
        String ecrDateTimeFormatted;
        System.out.println("++++++++++erc_stan generateTransactStatus:" + ecr_stan);
        LocalDateTime ecrDateTime = LocalDateTime.now();
        String erc_date_time = ecrDateTimeFormatted = ecrDateTime.format(formatter);
        StringBuilder sb = new StringBuilder();
        try {
            String session_id;
            AppLocal.CURRENT_SESSION_ID = session_id = DCGenerator.incrementLastSession(AppLocal.CURRENT_SESSION_ID);
            int size_requested_data = DCGenerator.calculateBase4SizeSegment("006E", "2") + DCGenerator.calculateBase4SizeSegment("000F", ecr_stan) + DCGenerator.calculateBase4SizeSegment("002A", session_id) + DCGenerator.calculateBase4SizeSegment("0010", erc_date_time) + DCGenerator.calculateBase4SizeSegment("0032", "1");
            String size_requested_data_converted = String.format("%04d", size_requested_data);
            sb.append("A024").append(size_requested_data_converted).append("006E").append(DCGenerator.calculateBase4Size("2")).append("2").append("000F").append(DCGenerator.calculateBase4Size(ecr_stan)).append(ecr_stan).append("0010").append(DCGenerator.calculateBase4Size(erc_date_time)).append(erc_date_time).append("0032").append(DCGenerator.calculateBase4Size("1")).append("1").append("002A").append(DCGenerator.calculateBase4Size(session_id)).append(session_id);
            System.out.println("+++++++++++ TransactStatus DC1 :" + sb.toString());
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return sb.toString();
    }

    public static String generateTransactReceiptDuplicateDC1(String erc_stan, String erc_date_time) {
        StringBuilder sb = new StringBuilder();
        try {
            String session_id;
            AppLocal.CURRENT_SESSION_ID = session_id = DCGenerator.incrementLastSession(AppLocal.CURRENT_SESSION_ID);
            int size_requested_data = DCGenerator.calculateBase4SizeSegment("006E", "2") + DCGenerator.calculateBase4SizeSegment("000F", erc_stan) + DCGenerator.calculateBase4SizeSegment("0010", session_id) + DCGenerator.calculateBase4SizeSegment("0010", erc_date_time) + DCGenerator.calculateBase4SizeSegment("0032", "1") + DCGenerator.calculateBase4SizeSegment("002A", session_id);
            String size_requested_data_converted = String.format("%04d", size_requested_data);
            sb.append("A023").append(size_requested_data_converted).append("006E").append(DCGenerator.calculateBase4Size("2")).append("2").append("000F").append(DCGenerator.calculateBase4Size(erc_stan)).append(erc_stan).append("0010").append(DCGenerator.calculateBase4Size(erc_date_time)).append(erc_date_time).append("0032").append(DCGenerator.calculateBase4Size("1")).append("1").append("002A").append(DCGenerator.calculateBase4Size(session_id)).append(session_id);
            System.out.println("+++++++++++ TransactReceiptDuplicate DC1 :" + sb.toString());
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return sb.toString();
    }

    public static String generateSignOnDC1() {
        StringBuilder sb = new StringBuilder();
        try {
            int size_requested_data = DCGenerator.calculateBase4SizeSegment("0001", "01") + DCGenerator.calculateBase4SizeSegment("0002", "01") + DCGenerator.calculateBase4SizeSegment("0003", "01") + DCGenerator.calculateBase4SizeSegment("0004", "1234");
            String size_requested_data_converted = String.format("%04d", size_requested_data);
            int sizeTimeOut = DCGenerator.calculateBase4SizeSegment("0006", "60") + DCGenerator.calculateBase4SizeSegment("0035", "0180") + DCGenerator.calculateBase4SizeSegment("0007", "20");
            String size_time_out = String.format("%04d", sizeTimeOut);
            sb.append("A000").append(size_requested_data_converted).append("0001").append(DCGenerator.calculateBase4Size("01")).append("01").append("0002").append(DCGenerator.calculateBase4Size("01")).append("01").append("0003").append(DCGenerator.calculateBase4Size("01")).append("01").append("0004").append(DCGenerator.calculateBase4Size("1234")).append("1234").append("A001").append(size_time_out).append("0006").append(DCGenerator.calculateBase4Size("60")).append("60").append("0035").append(DCGenerator.calculateBase4Size("0180")).append("0180").append("0007").append(DCGenerator.calculateBase4Size("20")).append("20");
            System.out.println("+++++++++++ SignOn DC1 :" + sb.toString());
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return sb.toString();
    }

    public String generateDC2(String type_operation) {
        return null;
    }

    public String generateDC3(String type_operation) {
        return type_operation;
    }

    public static String convertEuroToCentimesInBase6(double euros) {
        int cents = (int)Math.round(euros * 100.0);
        return String.format("%06d", cents);
    }

    public static String encodeTagValue(String value, boolean isNumeric) {
        StringBuilder encoded = new StringBuilder();
        if (isNumeric) {
            for (char digit : value.toCharArray()) {
                encoded.append(String.format("0x%02X", digit));
            }
        } else {
            for (char ch : value.toCharArray()) {
                encoded.append(String.format("0x%02X", ch));
            }
        }
        return encoded.toString();
    }

    public static String SetSessionId() throws BasicException {
        TicketInfo last_ticket = AppLocal.dlSales.getLastCmiOrder();
        String lastSessionId = null;
        String session_id = null;
        if (last_ticket != null) {
            lastSessionId = last_ticket.getSession_id();
            session_id = DCGenerator.incrementLastSession(lastSessionId);
        } else {
            session_id = "0001";
        }
        System.out.println("generated session_id : " + session_id);
        return session_id;
    }

    private static String incrementLastSession(String lastSessionId) {
        System.out.println("+++++++++ lastSessionId " + lastSessionId);
        int sessionNumber = Integer.parseInt(lastSessionId);
        if (++sessionNumber > 9999) {
            sessionNumber = 1;
        }
        return String.format("%04d", sessionNumber);
    }

    public static String generateUniqueECRSTAN() {
        int number = random.nextInt(900000);
        return String.format("%06d", number);
    }

    public static String calculateBase4Size(String input) {
        int length = 0;
        if (input != null) {
            length = input.length();
        }
        return String.format("%04d", length);
    }

    public static int calculateBase4SizeSegment(String tag, String value) {
        int length = Integer.parseInt(DCGenerator.calculateBase4Size(value)) + 8;
        return length;
    }

    public static String getLastFourChars(String input) {
        if (input != null && input.length() > 4) {
            return input.substring(input.length() - 4);
        }
        return input;
    }
}

