/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.tpeCB;

import com.biborne.yavin.YavinManager;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.util.LogToFile;
import fr.protactile.procaisse.dao.entities.CustomerInfo;
import fr.protactile.procaisse.tpeCB.PaymentByCard;
import fr.protactile.procaisse.tpeCB.PaymentResult;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class TPECBYavin
implements PaymentByCard {
    private static TPECBYavin mTPECBYavin;
    private YavinManager mYavinManager;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private final Integer SUCCESS_OPERATION = 0;
    private static final ObjectMapper objectMapper;

    public TPECBYavin() {
        this.mYavinManager = YavinManager.getInstance();
    }

    public static TPECBYavin getInstance(String ipAdress) {
        if (mTPECBYavin == null) {
            mTPECBYavin = new TPECBYavin();
        }
        return mTPECBYavin;
    }

    @Override
    public PaymentResult doDebit(double amount, CustomerInfo customer, String lastTransactionId) {
        return this.initAndSend(amount, customer, "debit", lastTransactionId);
    }

    @Override
    public int doRefund(double amount, CustomerInfo customer, String idPayment) {
        PaymentResult paymentResult = this.initAndSend(amount, customer, "refund", null);
        return paymentResult != null ? paymentResult.getResult() : -1;
    }

    @Override
    public boolean isTransactionSuccessed(int result) {
        return result == this.SUCCESS_OPERATION;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.support.addPropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.support.removePropertyChangeListener(pcl);
    }

    @Override
    public void doLogin() {
        String result = this.mYavinManager.pingTerminal(AppLocal.PAYMENT_TYPE_CB_TPE_PORT, true);
        try {
            int status = this.checkStatusConnection(result);
            if (status == 1) {
                System.out.println("+++++++++++++ doLogin 2********");
                final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
                ScheduledFuture<?> scheduledFuture = scheduler.schedule(new Runnable(){

                    @Override
                    public void run() {
                        TPECBYavin.this.doLogin();
                        scheduler.shutdown();
                    }
                }, 60L, TimeUnit.SECONDS);
            }
        }
        catch (Exception e) {
            LogToFile.log("severe", e.getMessage(), e);
        }
    }

    @Override
    public void debitAutomate_ClotureNTry(double amount, String ref_to_Close) {
    }

    private PaymentResult initAndSend(double amount, CustomerInfo customer, String transactionType, String lastTransactionId) {
        PaymentResult paymentResult = new PaymentResult();
        try {
            paymentResult = this.mYavinManager.sendPaymentRequest(amount, customer, transactionType, lastTransactionId);
        }
        catch (Exception e) {
            LogToFile.log("severe", e.getMessage(), e);
        }
        return paymentResult;
    }

    public int checkStatusConnection(String response) {
        try {
            JsonNode jsonNode = objectMapper.readTree(response);
            if (jsonNode.has("status") && jsonNode.get("status").asText().equals("ok") && response != null) {
                return 0;
            }
            return 1;
        }
        catch (Exception e) {
            return 1;
        }
    }

    @Override
    public int doPing() {
        return 0;
    }

    static {
        objectMapper = new ObjectMapper();
    }
}

