/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.tpeCB;

import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.pos.util.NumericUtils;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import fr.protactile.procaisse.dao.entities.CustomerInfo;
import fr.protactile.procaisse.tpeCB.NeptingTPEInterface;
import fr.protactile.procaisse.tpeCB.PaymentByCard;
import fr.protactile.procaisse.tpeCB.PaymentResult;
import java.beans.PropertyChangeListener;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class TPECBNepting
implements PaymentByCard {
    private String eftAdress = "192.168.0.220:8888";
    private String currencyCode = "978";
    private String posNumber = "1";
    private String eftNumber = "1";
    private String user = null;
    private String password = null;
    private String url = null;
    private String merchantCode = "10002";
    private final String currencyFraction = "2";
    private final String currencyAlpha = "EUR";
    private String pos_capabilities = "2000000";
    static int messageId = 0;
    public static final String TRANSACTION_DEBIT = "Debit";
    public static final String TRANSACTION_REFUND = "Refund";
    public static final String TRANSACTION_REVERSAL = "Reversal";
    private static NeptingTPEInterface INSTANCE = null;
    private static HashMap<Integer, String> ERRORS_MSG = null;
    private final String NepPosDLL64 = "/dll/NepPosDLL64.dll";
    private final String NepPosDLL32 = "/dll/NepPosDLL32.dll";
    private static TPECBNepting INSTANCETPECBNepting;
    final int LOGIN = 1;
    final int TRANSACTION = 2;
    final int ABANDON = 3;
    final int INTERACTION_POSDISPLAY = 4;
    final int INTERACTION_POSQUESTION = 5;
    final int INTERACTION_POSENTRY = 6;
    final int INTERACTION_POSMENU = 7;
    final int INTERACTION_POSPRINT = 8;
    final int UNKNOW = 9;
    private String merchantTrsId;
    private String ref_to_Close;

    public static TPECBNepting getInstance(String eftAdress, String posNumber, String eftNumber, String merchantCode) {
        if (INSTANCETPECBNepting == null) {
            INSTANCETPECBNepting = new TPECBNepting(eftAdress, posNumber, eftNumber, merchantCode);
        }
        return INSTANCETPECBNepting;
    }

    public static TPECBNepting getInstance() {
        if (INSTANCETPECBNepting == null) {
            INSTANCETPECBNepting = new TPECBNepting();
        }
        return INSTANCETPECBNepting;
    }

    private TPECBNepting() {
    }

    private TPECBNepting(String eftAdress, String posNumber, String eftNumber, String merchantCode) {
        this.eftAdress = eftAdress;
        this.posNumber = posNumber;
        this.eftNumber = eftNumber;
        this.merchantCode = merchantCode;
    }

    @Override
    public PaymentResult doDebit(double amount, CustomerInfo customer, String lastTransactionId) {
        PaymentResult paymentResult = new PaymentResult();
        paymentResult.setResult(-1);
        try {
            Pointer transaction_result;
            String amountCentieme = "" + (int)NumericUtils.round(amount * 100.0);
            String transactionId = "" + new Date().getTime();
            System.out.println("Amount : " + amountCentieme);
            int result = this.getNeptingTPELibraryInstance().doTransaction(this.getPointerFromString(this.eftAdress), this.getPointerFromString(TRANSACTION_DEBIT), this.getPointerFromString(amountCentieme), this.getPointerFromString(this.currencyCode), this.getPointerFromString(this.posNumber), this.getPointerFromString(transactionId), this.getPointerFromString(this.eftNumber));
            paymentResult.setResult(result);
            Pointer ticket = this.getNeptingTPELibraryInstance().GetNepField(null, this.getPointerFromString("HOLDER_TICKET"));
            if (ticket != null) {
                paymentResult.setHolder_ticket(ticket.getString(0L));
                this.getNeptingTPELibraryInstance().FreeNepMessage(ticket);
            }
            if ((transaction_result = this.getNeptingTPELibraryInstance().GetNepField(null, this.getPointerFromString("GLOBAL_STATUS"))) != null) {
                int global_status_value;
                String global_status = transaction_result.getString(0L);
                System.out.println("++++++ global_status : " + global_status);
                if (global_status != null && !global_status.isEmpty() && global_status.length() == 1 && (global_status_value = Integer.parseInt(global_status)) == 1) {
                    paymentResult.setResult(0);
                }
            }
            return paymentResult;
        }
        catch (Exception ex) {
            LogToFile.log("severe", null, ex);
            return paymentResult;
        }
    }

    @Override
    public int doRefund(double amount, CustomerInfo customer, String idPayment) {
        String amountCentieme = "" + (int)(amount * 100.0);
        String transactionId = "" + new Date().getTime();
        return this.getNeptingTPELibraryInstance().doTransaction(this.getPointerFromString(this.eftAdress), this.getPointerFromString(TRANSACTION_REFUND), this.getPointerFromString(amountCentieme), this.getPointerFromString(this.currencyCode), this.getPointerFromString(this.posNumber), this.getPointerFromString(transactionId), this.getPointerFromString(this.eftNumber));
    }

    @Override
    public int doCancel(double amount, String transactionId) {
        String amountCentieme = "" + (int)(amount * 100.0);
        int result = this.getNeptingTPELibraryInstance().doTransaction(this.getPointerFromString(this.eftAdress), this.getPointerFromString(TRANSACTION_REFUND), this.getPointerFromString(amountCentieme), this.getPointerFromString(this.currencyCode), this.getPointerFromString(this.posNumber), this.getPointerFromString(transactionId), this.getPointerFromString(this.eftNumber));
        return result;
    }

    @Override
    public int doPing() {
        return 0;
    }

    @Override
    public void doLogin() {
        String[] results = this.login();
        System.out.println("+++++ results : " + results);
        if (results != null && results[0] != null && results[0].equals("2") && results[1] != null && results[1].equals("9")) {
            System.out.println("+++++++++++++ doLogin 2********");
            final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
            ScheduledFuture<?> scheduledFuture = scheduler.schedule(new Runnable(){

                @Override
                public void run() {
                    TPECBNepting.this.doLogin();
                    scheduler.shutdown();
                }
            }, 60L, TimeUnit.SECONDS);
        }
    }

    @Override
    public String getErrorMassage(int errorCode) {
        String retour = ERRORS_MSG.get(errorCode);
        if (retour == null) {
            retour = "Erreur non d\u00e9finit";
        }
        return retour;
    }

    private NeptingTPEInterface getNeptingTPELibraryInstance() {
        if (INSTANCE == null && Platform.isWindows()) {
            try {
                INSTANCE = (NeptingTPEInterface)Native.loadLibrary((String)(Platform.is64Bit() ? "/dll/NepPosDLL64.dll" : "/dll/NepPosDLL32.dll"), NeptingTPEInterface.class);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ERRORS_MSG = new HashMap();
            ERRORS_MSG.put(1, "Pas de r\u00e9sultat");
            ERRORS_MSG.put(3, "L'op\u00e9ration a \u00e9t\u00e9 refus\u00e9e par le serveur");
            ERRORS_MSG.put(4, "Erreur technique");
            ERRORS_MSG.put(5, "Erreur grave");
            ERRORS_MSG.put(6, "Un param\u00e8tre non optionnel est manquant");
            ERRORS_MSG.put(7, "Le format de la requ\u00eate est incorrect");
            ERRORS_MSG.put(8, "L'op\u00e9ration n'a pas aboutie mais des informations ont \u00e9t\u00e9 modifi\u00e9es en base");
            ERRORS_MSG.put(9, "Un nouveau login est n\u00e9cessaire avant de r\u00e9p\u00e9ter l'op\u00e9ration");
            ERRORS_MSG.put(12, "La devise n'est pas support\u00e9e par le contrat");
            ERRORS_MSG.put(13, "Information contextuelle incorrecte");
            ERRORS_MSG.put(14, "Transaction non permise");
            ERRORS_MSG.put(15, "Longueur du PAN incorrecte");
            ERRORS_MSG.put(16, "Longueur de la cl\u00e9 de Luhn incorrecte");
            ERRORS_MSG.put(17, "Date de fin de validit\u00e9 expir\u00e9e");
            ERRORS_MSG.put(18, "BIN interdit");
            ERRORS_MSG.put(19, "BIN refus\u00e9");
            ERRORS_MSG.put(20, "Carte interdite");
            ERRORS_MSG.put(21, "Carte refus\u00e9");
            ERRORS_MSG.put(22, "Incident d'autorisation");
            ERRORS_MSG.put(23, "Refus d'autorisation");
            ERRORS_MSG.put(24, "Carte interdite suite \u00e0 autorisation");
            ERRORS_MSG.put(25, "Montant trop \u00e9lev\u00e9");
            ERRORS_MSG.put(26, "Montant trop faible");
            ERRORS_MSG.put(27, "Transaction \u00e0 annuler non trouv\u00e9e");
            ERRORS_MSG.put(28, "Transaction \u00e0 annuler d\u00e9j\u00e0 annul\u00e9e");
            ERRORS_MSG.put(29, "Date de validit\u00e9 non atteinte");
            ERRORS_MSG.put(30, "Abandon");
            ERRORS_MSG.put(31, "Abandon caisse");
            ERRORS_MSG.put(32, "Cryptogramme invalide");
            ERRORS_MSG.put(33, "Carte arrach\u00e9e");
            ERRORS_MSG.put(34, "Transaction d\u00e9grad\u00e9e");
            ERRORS_MSG.put(35, "Carte \u00e9trang\u00e8re");
            ERRORS_MSG.put(36, "AID inconnu");
            ERRORS_MSG.put(37, "Date requise apr\u00e8s la date de fin validit\u00e9");
            ERRORS_MSG.put(38, "BIN inconnu");
            ERRORS_MSG.put(60, "Mot de passe ou nom d'utilisateur incorrect");
            ERRORS_MSG.put(61, "Compte bloqu\u00e9");
            ERRORS_MSG.put(62, "Jeton temporaire expir\u00e9");
            ERRORS_MSG.put(63, "Erreur technique d'authentification");
            ERRORS_MSG.put(64, "Compte commer\u00e7ant inconnu");
            ERRORS_MSG.put(65, "Niveau de privil\u00e8ge requis insuffisant");
            ERRORS_MSG.put(66, "La date de validit\u00e9 du mot de passe a expir\u00e9");
            ERRORS_MSG.put(70, "Terminal inconnu");
            ERRORS_MSG.put(71, "Mod\u00e8le de terminal inconnu");
            ERRORS_MSG.put(72, "Terminal inactif");
            ERRORS_MSG.put(80, "Ilot inconnu");
            ERRORS_MSG.put(81, "Ilot non renseign\u00e9");
            ERRORS_MSG.put(90, "Cl\u00e9 cryptographique inconnue");
            ERRORS_MSG.put(91, "Probl\u00e8me d'int\u00e9grit\u00e9 de message entre le terminal et le serveur");
            ERRORS_MSG.put(101, "Objet existant d\u00e9j\u00e0 dans le syst\u00e8me");
            ERRORS_MSG.put(102, "Op\u00e9ration demand\u00e9e interdite");
            ERRORS_MSG.put(103, "Activation de contrat en \u00e9chec");
            ERRORS_MSG.put(104, "Pas de r\u00e9ponse dans le d\u00e9lai impartis");
            ERRORS_MSG.put(105, "Echec de connexion au terminal");
            ERRORS_MSG.put(106, "Echec de dialogue avec le terminal");
            ERRORS_MSG.put(107, "Transaction d\u00e9j\u00e0 en cours");
            ERRORS_MSG.put(108, "Echec de connexion au serveur Nepting");
            ERRORS_MSG.put(109, "Dossier non trouv\u00e9");
            ERRORS_MSG.put(110, "Dossier non cl\u00f4tur\u00e9");
            ERRORS_MSG.put(111, "Pas de r\u00e9ponse dans le d\u00e9lai impartis lors de l\u2019enregistrement de la transaction");
            ERRORS_MSG.put(112, "Pr\u00e9requis mode d\u00e9grad\u00e9 non atteint");
            ERRORS_MSG.put(113, "Identifiant de transaction invalide");
        }
        return INSTANCE;
    }

    @Override
    public boolean isTransactionSuccessed(int result) {
        return result == 0;
    }

    private Pointer getPointerFromString(String s) {
        Memory p = new Memory((long)(Native.WCHAR_SIZE * (s.length() + 1)));
        p.setString(0L, s);
        return p;
    }

    @Override
    public int getReport() {
        System.out.println("[ INFO ]  :: Report() start \n");
        Pointer reportRequest = this.getNeptingTPELibraryInstance().CreateNepMessage();
        Pointer reportResponse = this.getNeptingTPELibraryInstance().CreateNepMessage();
        this.getNeptingTPELibraryInstance().SetNepField(reportRequest, this.getPointerFromString("MESSAGE_NAME"), this.getPointerFromString("PosRequest"));
        this.getNeptingTPELibraryInstance().SetNepField(reportRequest, this.getPointerFromString("MESSAGE_TYPE"), this.getPointerFromString("Report"));
        this.getNeptingTPELibraryInstance().SetNepField(reportRequest, this.getPointerFromString("SUB_MESSAGE_TYPE"), this.getPointerFromString("SummaryReport"));
        this.getNeptingTPELibraryInstance().SetNepField(reportRequest, this.getPointerFromString("MESSAGE_ID"), this.getPointerFromString("1234"));
        this.mainLoop(reportRequest, reportResponse, messageId);
        this.getNeptingTPELibraryInstance().FreeNepMessage(reportRequest);
        this.getNeptingTPELibraryInstance().FreeNepMessage(reportResponse);
        System.out.print("[ INFO ]  :: Report() end \n");
        return 1;
    }

    int mainLoop(Pointer messageToSend, Pointer messageToReceive, int message_id_value) {
        System.out.println("start loop");
        int step = 0;
        while (true) {
            System.out.println("info :  mainloop step : " + step);
            switch (step) {
                case 0: {
                    step = this.send(messageToSend);
                    break;
                }
                case 1: {
                    step = this.receive(messageToReceive);
                    break;
                }
                case 2: {
                    step = this.analyse(messageToReceive);
                    break;
                }
                case 3: {
                    step = this.dealInteractions(messageToReceive, message_id_value);
                    break;
                }
                case 4: {
                    System.out.println("main loop end OK");
                    return 1;
                }
                case 999: {
                    System.out.println("error main loop end");
                    return -1;
                }
            }
        }
    }

    int send(Pointer messageToSend) {
        System.out.println("send start");
        int status = this.getNeptingTPELibraryInstance().SendNepMessage(messageToSend);
        System.out.println("status : " + status);
        if (status < 0) {
            System.out.print("error SendNepMessage response");
            int step = 999;
        } else if (status == 0) {
            System.out.print("error SendNepMessage problem Ack");
            int step = 999;
        } else {
            System.out.print("SendNepMessage OK");
            boolean step = true;
        }
        System.out.println("send end");
        return status;
    }

    int receive(Pointer messageToReceive) {
        int step;
        System.out.println("send receive");
        int status = this.getNeptingTPELibraryInstance().ReceiveNepMessage(messageToReceive, 1000);
        System.out.println("status : " + status);
        if (status < 0) {
            System.out.print("error ReceiveNepMessage");
            step = 999;
        } else if (status == 0) {
            System.out.print("ReceiveNepMessage nothing received");
            step = 1;
        } else {
            Pointer fieldName;
            System.out.print("ReceiveNepMessage OK");
            int index = 0;
            do {
                Pointer fieldValue;
                if ((fieldName = this.getNeptingTPELibraryInstance().GetNepFieldNameAt(messageToReceive, index++)) == null || (fieldValue = this.getNeptingTPELibraryInstance().GetNepField(messageToReceive, fieldName)) == null) continue;
                System.out.println(fieldName.getString(0L) + "=" + fieldValue.getString(0L));
            } while (fieldName != null);
            step = 2;
        }
        System.out.println("receive end");
        return step;
    }

    int analyse(Pointer messageReceive) {
        System.out.print("analyse start");
        int step = 0;
        Pointer value = this.getNeptingTPELibraryInstance().GetNepField(messageReceive, this.getPointerFromString("MESSAGE_ID"));
        System.out.println("++++ value message : " + value);
        if (value != null) {
            System.out.println("value.getString(0) : " + value.getString(0L));
            System.out.println("messageId : " + messageId);
        }
        if (value == null) {
            System.out.print("error analyse : MESSAGE_ID value is NULL");
            step = 1;
        } else if (!value.getString(0L).equals(String.valueOf(messageId))) {
            System.out.print("error analyse : message ID incorrect  actuel = " + value.getString(0L) + ",  exepted = " + messageId);
            step = 1;
        } else {
            System.out.print("analyse MESSAGE_ID OK ");
        }
        Pointer fieldValue = this.getNeptingTPELibraryInstance().GetNepField(messageReceive, this.getPointerFromString("MESSAGE_NAME"));
        if (fieldValue != null) {
            System.out.println("+++++ fieldValue.getString(0) MESSAGE_NAME: " + fieldValue.getString(0L));
        }
        if (fieldValue != null && fieldValue.getString(0L).equals("PosResponse")) {
            step = 4;
        } else if (fieldValue != null && fieldValue.getString(0L).equals("EftRequest")) {
            step = 3;
        }
        System.out.print("analyse end");
        return step;
    }

    int getTransactionType(Pointer nepMessageReception) {
        int type;
        System.out.println("getTransactionType start");
        if (nepMessageReception == null) {
            System.out.println("error getTransactionType :  nepMessageReception = NULL");
            return 9;
        }
        Pointer messageTypeP = this.getNeptingTPELibraryInstance().GetNepField(nepMessageReception, this.getPointerFromString("MESSAGE_TYPE"));
        String messageType = messageTypeP.getString(0L);
        System.out.println("++++++ messageType : " + messageType);
        if (messageType.equals("Login")) {
            type = 1;
        } else if (messageType.equals("ReprintLastTrs") || messageType.equals("Reconciliation") || messageType.equals("RemoteParameterization") || messageType.equals(TRANSACTION_DEBIT) || messageType.equals(TRANSACTION_REFUND) || messageType.equals(TRANSACTION_REVERSAL)) {
            type = 2;
        } else if (messageType.equals("Abort")) {
            type = 3;
        } else if (messageType.equals("PosDisplay")) {
            type = 4;
        } else if (messageType.equals("PosQuestion")) {
            type = 5;
        } else if (messageType.equals("PosEntry")) {
            type = 6;
        } else if (messageType.equals("PosMenu")) {
            type = 7;
        } else if (messageType.equals("PosPrint")) {
            type = 8;
        } else {
            System.out.println("getTransactionType UNKNOW");
            type = 9;
        }
        System.out.println("type : " + type);
        System.out.println("getTransactionType end");
        return type;
    }

    int dealPosDisplay(Pointer displayRequest, int message_id_value) {
        System.out.println("dealPosDisplay start");
        int status = 1;
        boolean displayOK = false;
        Pointer text = this.getNeptingTPELibraryInstance().GetNepField(displayRequest, this.getPointerFromString("TEXT"));
        if (text == null) {
            System.out.println("error dealPosDisplay TEXT is NULL");
        } else {
            System.out.println("++++++ text : " + text.getString(0L));
            displayOK = true;
        }
        System.out.println("+++++ displayOK : " + displayOK);
        Pointer sendDisplayStatus = this.getNeptingTPELibraryInstance().GetNepField(displayRequest, this.getPointerFromString("NO_ACK"));
        if (sendDisplayStatus == null || sendDisplayStatus.getString(0L).equals("1")) {
            Pointer displayResponse = this.getNeptingTPELibraryInstance().CreateNepMessage();
            this.getNeptingTPELibraryInstance().SetNepField(displayResponse, this.getPointerFromString("MESSAGE_NAME"), this.getPointerFromString("EftResponse"));
            this.getNeptingTPELibraryInstance().SetNepField(displayResponse, this.getPointerFromString("MESSAGE_TYPE"), this.getPointerFromString("PosDisplay"));
            this.setMessageID(displayResponse, message_id_value);
            this.getNeptingTPELibraryInstance().SetNepField(displayResponse, this.getPointerFromString("GLOBAL_STATUS"), displayOK ? this.getPointerFromString("1") : this.getPointerFromString("GS_Error"));
            status = this.send(displayResponse);
            this.getNeptingTPELibraryInstance().FreeNepMessage(displayResponse);
        }
        System.out.println("dealPosDisplay end");
        return status;
    }

    void setMessageID(Pointer nepMessageEmission, int message_id_value) {
        System.out.println("++++++ send message : " + message_id_value);
        this.getNeptingTPELibraryInstance().SetNepField(nepMessageEmission, this.getPointerFromString("MESSAGE_ID"), this.getPointerFromString("" + message_id_value));
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener pcl) {
    }

    @Override
    public String[] debitAutomate_Reservation(double amount) {
        String[] results = this.debitAutomate_Reservation_check_final_amount(amount);
        if (results != null && results.length > 0 && results[0] != null && results[0].equals("1") && results.length > 3 && results[3] != null && results[3].equals("1")) {
            String ref_to_close = results.length > 2 ? results[2] : null;
            this.debitAutomate_Cloture(0.0, ref_to_close);
            results[0] = "0";
        }
        return results;
    }

    @Override
    public String[] debitAutomate_Cloture(double amount, String ref_to_Close) {
        int status;
        System.out.println("debitAutomate_Cloture");
        String amountCentieme = "" + (int)(amount * 100.0);
        String[] trsStatus = new String[]{null, null, null};
        this.getNeptingTPELibraryInstance().setLogLevel(5);
        if (this.getNeptingTPELibraryInstance().InitNepLib(this.getPointerFromString(this.eftAdress)) <= 0) {
            System.out.println("error debitAutomate_Cloture");
            return trsStatus;
        }
        this.merchantTrsId = "" + new Date().getTime();
        Pointer request = this.getNeptingTPELibraryInstance().CreateNepMessage();
        Pointer response = this.getNeptingTPELibraryInstance().CreateNepMessage();
        this.getNeptingTPELibraryInstance().SetNepField(request, this.getPointerFromString("MESSAGE_NAME"), this.getPointerFromString("PosRequest"));
        this.getNeptingTPELibraryInstance().SetNepField(request, this.getPointerFromString("MESSAGE_TYPE"), this.getPointerFromString("Advice_Debit"));
        this.setMessageID(request, ++messageId);
        this.getNeptingTPELibraryInstance().SetNepField(request, this.getPointerFromString("AMOUNT"), this.getPointerFromString(amountCentieme));
        this.getNeptingTPELibraryInstance().SetNepField(request, this.getPointerFromString("CURRENCY_CODE"), this.getPointerFromString(this.currencyCode));
        this.getNeptingTPELibraryInstance().SetNepField(request, this.getPointerFromString("CURRENCY_FRACTION"), this.getPointerFromString("2"));
        this.getNeptingTPELibraryInstance().SetNepField(request, this.getPointerFromString("CURRENCY_ALPHA"), this.getPointerFromString("EUR"));
        System.out.println("++++ AppLocal.TOKEN_TPE : " + AppLocal.TOKEN_TPE);
        if (AppLocal.TOKEN_TPE != null) {
            this.getNeptingTPELibraryInstance().SetNepField(request, this.getPointerFromString("TOKEN"), this.getPointerFromString(AppLocal.TOKEN_TPE));
        }
        if (this.merchantTrsId != null) {
            this.getNeptingTPELibraryInstance().SetNepField(request, this.getPointerFromString("MERCHANT_TRS_ID"), this.getPointerFromString(this.merchantTrsId));
        }
        System.out.println("+++++++++++ Ref_to_Close onetimeReservation : " + ref_to_Close);
        if (ref_to_Close != null) {
            this.getNeptingTPELibraryInstance().SetNepField(request, this.getPointerFromString("TRS_ADVICE_IDENTIFIER"), this.getPointerFromString(ref_to_Close));
            System.out.println("sending TRS_ADVICE_IDENTIFIER =   " + ref_to_Close);
        }
        if ((status = this.sendRequestAndWaitForResponse(request, response, messageId)) <= 0) {
            System.out.println("[ ERROR ] :: debitAutomate_Cloture() sendRequestAndWaitForResponse KO");
        } else {
            Pointer extendedResult;
            Pointer fieldName;
            trsStatus[0] = "0";
            int index = 0;
            do {
                Pointer fieldValue;
                if ((fieldName = this.getNeptingTPELibraryInstance().GetNepFieldNameAt(response, index++)) == null || fieldName.getString(0L).contentEquals("EXTENDED_RESULT") || (fieldValue = this.getNeptingTPELibraryInstance().GetNepField(response, fieldName)) == null) continue;
                System.out.println(fieldName.getString(0L) + "=" + fieldValue.getString(0L));
            } while (fieldName != null);
            Pointer globalStatus = this.getNeptingTPELibraryInstance().GetNepField(response, this.getPointerFromString("GLOBAL_STATUS"));
            if (globalStatus != null && "1".contentEquals(globalStatus.getString(0L))) {
                Pointer finalAmount;
                trsStatus[0] = "1";
                Pointer ticket = this.getNeptingTPELibraryInstance().GetNepField(response, this.getPointerFromString("HOLDER_TICKET"));
                if (ticket != null) {
                    trsStatus[1] = ticket.getString(0L);
                    this.getNeptingTPELibraryInstance().FreeNepMessage(ticket);
                    System.out.println("trsStatus[1] debitAutomate_Cloture : " + trsStatus[1]);
                }
                if ((finalAmount = this.getNeptingTPELibraryInstance().GetNepField(response, this.getPointerFromString("POS_FINAL_AMOUNT"))) != null && !finalAmount.getString(0L).contentEquals(amountCentieme)) {
                    System.out.println("[ WARN ] :: debitAutomate_Cloture() partial amount processed");
                }
            }
            if ((extendedResult = this.getNeptingTPELibraryInstance().GetNepField(response, this.getPointerFromString("EXTENDED_RESULT"))) != null) {
                trsStatus[2] = extendedResult.getString(0L);
                System.out.println("++++++++++++ trsStatus[2] : " + trsStatus[2]);
            }
        }
        this.getNeptingTPELibraryInstance().FreeNepMessage(request);
        this.getNeptingTPELibraryInstance().FreeNepMessage(response);
        if (this.getNeptingTPELibraryInstance().CloseNepLib() <= 0) {
            System.out.println("error debitAutomate_Cloture CloseNepLib");
        }
        System.out.println("debitAutomate_Cloture end");
        return trsStatus;
    }

    public String[] login() {
        System.out.println("+++++++++++ AppLocal.MODE_DEV_NEPTING : " + AppLocal.MODE_DEV_NEPTING);
        String web_service_url = AppLocal.MODE_DEV_NEPTING ? "https://qualif.nepting.com/nepweb/ws?wsdl" : "https://nepsa1.nepting.com/nepweb/trx?wsdl";
        String terminal_type = AppLocal.TERMINAL_TYPE_NEPTING != null && AppLocal.TERMINAL_TYPE_NEPTING.equalsIgnoreCase("attended") ? "22" : "25";
        String[] results = new String[]{null, null};
        this.getNeptingTPELibraryInstance().setLogLevel(5);
        if (this.getNeptingTPELibraryInstance().InitNepLib(this.getPointerFromString(this.eftAdress)) <= 0) {
            System.out.println("error login");
            return results;
        }
        Pointer request = this.getNeptingTPELibraryInstance().CreateNepMessage();
        Pointer response = this.getNeptingTPELibraryInstance().CreateNepMessage();
        this.getNeptingTPELibraryInstance().SetNepField(request, this.getPointerFromString("MESSAGE_NAME"), this.getPointerFromString("PosRequest"));
        this.getNeptingTPELibraryInstance().SetNepField(request, this.getPointerFromString("MESSAGE_TYPE"), this.getPointerFromString("Login"));
        this.getNeptingTPELibraryInstance().SetNepField(request, this.getPointerFromString("MERCHANT_CODE"), this.getPointerFromString(this.merchantCode));
        this.getNeptingTPELibraryInstance().SetNepField(request, this.getPointerFromString("TERMINAL_TYPE"), this.getPointerFromString(terminal_type));
        this.getNeptingTPELibraryInstance().SetNepField(request, this.getPointerFromString("WEB_SERVICE_URL"), this.getPointerFromString(web_service_url));
        System.out.println("+++++++++++ web_service_url : " + web_service_url);
        System.out.println("+++++++++++ terminal_type : " + terminal_type);
        this.setMessageID(request, ++messageId);
        int status = this.sendRequestAndWaitForResponse(request, response, messageId);
        if (status <= 0) {
            System.out.println("error request response login");
        } else {
            Pointer extendedResult;
            Pointer fieldName;
            results[0] = "0";
            int index = 0;
            do {
                Pointer fieldValue;
                if ((fieldName = this.getNeptingTPELibraryInstance().GetNepFieldNameAt(response, index++)) == null || (fieldValue = this.getNeptingTPELibraryInstance().GetNepField(response, fieldName)) == null) continue;
                System.out.println(fieldName.getString(0L) + "=" + fieldValue.getString(0L));
            } while (fieldName != null);
            Pointer globalStatus = this.getNeptingTPELibraryInstance().GetNepField(response, this.getPointerFromString("GLOBAL_STATUS"));
            if (globalStatus != null) {
                results[0] = globalStatus.getString(0L);
                if ("1".contentEquals(results[0])) {
                    Pointer token = this.getNeptingTPELibraryInstance().GetNepField(response, this.getPointerFromString("TOKEN"));
                    System.out.println("++++++++ token : " + token.getString(0L));
                    AppLocal.TOKEN_TPE = token.getString(0L);
                }
            }
            if ((extendedResult = this.getNeptingTPELibraryInstance().GetNepField(response, this.getPointerFromString("EXTENDED_RESULT"))) != null) {
                results[1] = extendedResult.getString(0L);
                System.out.println("++++++++++++ results[1] : " + results[1]);
            }
        }
        this.getNeptingTPELibraryInstance().FreeNepMessage(request);
        this.getNeptingTPELibraryInstance().FreeNepMessage(response);
        if (this.getNeptingTPELibraryInstance().CloseNepLib() <= 0) {
            System.out.println(" error login CloseNepLib ");
        }
        System.out.println("end login");
        return results;
    }

    private int sendRequestAndWaitForResponse(Pointer messageToSend, Pointer receptionMessage, int message_id_value) {
        int receiveStatus;
        System.out.println("[ INFO ] :: sendRequestAndWaitForResponse() start");
        int sendStatus = this.send(messageToSend);
        if (sendStatus <= 0) {
            if (sendStatus == 0) {
                System.out.println("[ ERROR ] :: sendRequestAndWaitForResponse() send returned " + sendStatus);
                return -1;
            }
            System.out.println("[ ERROR ] :: sendRequestAndWaitForResponse() send returned " + sendStatus);
            return -1;
        }
        while (true) {
            if ((receiveStatus = this.getNeptingTPELibraryInstance().ReceiveNepMessage(receptionMessage, 1000)) > 0) {
                Pointer messageName = this.getNeptingTPELibraryInstance().GetNepField(receptionMessage, this.getPointerFromString("MESSAGE_NAME"));
                if (messageName != null && messageName.getString(0L).contentEquals("PosResponse")) {
                    System.out.println("[ INFO ] :: sendRequestAndWaitForResponse() Message received");
                    return 1;
                }
                if (messageName != null && messageName.getString(0L).contentEquals("EftRequest")) {
                    this.dealInteractions(receptionMessage, message_id_value);
                    continue;
                }
                System.out.println("[ ERROR ] :: sendRequestAndWaitForResponse() unknown message ignored");
                continue;
            }
            if (receiveStatus != 0) break;
        }
        System.out.println("[ ERROR ] :: sendRequestAndWaitForResponse() received returned " + receiveStatus);
        return -1;
    }

    private int dealInteractions(Pointer messageReceived, int message_id_value) {
        System.out.println("[ INFO ]  ::dealInteractions() start");
        int status = -1;
        Pointer messageTypePointer = this.getNeptingTPELibraryInstance().GetNepField(messageReceived, this.getPointerFromString("MESSAGE_TYPE"));
        String messageType = messageTypePointer.getString(0L);
        if (messageType == null) {
            System.out.println("[ ERROR ]  ::dealInteractions() no MESSAGE_TYPE received");
        } else {
            switch (messageType) {
                case "PosDisplay": {
                    System.out.println("[ INFO ]  ::dealInteractions() PosDisplay received");
                    status = this.dealPosDisplay(messageReceived, message_id_value);
                    break;
                }
                case "PosEntry": {
                    System.out.println("[ INFO ]  ::dealInteractions() PosEntry received");
                    break;
                }
                case "PosMenu": {
                    System.out.println("[ INFO ]  ::dealInteractions() PosMenu received");
                    break;
                }
                case "PosQuestion": {
                    System.out.println("[ INFO ]  ::dealInteractions() PosQuestion receivde");
                    break;
                }
                default: {
                    System.out.println("[ ERROR ]  ::dealInteractions() Message type unknow");
                    status = -1;
                }
            }
        }
        System.out.println("[ INFO ]  ::dealInteractions() end");
        return status;
    }

    @Override
    public void debitAutomate_ClotureNTry(final double amount, final String ref_to_Close) {
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                String[] results_cloture;
                while ((results_cloture = TPECBNepting.this.debitAutomate_Cloture(amount, ref_to_Close)) == null || results_cloture.length <= 0 || results_cloture[0] == null || !results_cloture[0].equals("1")) {
                }
            }
        });
    }

    @Override
    public int logout() {
        int result = -1;
        this.getNeptingTPELibraryInstance().setLogLevel(5);
        if (this.getNeptingTPELibraryInstance().InitNepLib(this.getPointerFromString(this.eftAdress)) <= 0) {
            System.out.println("error logout");
            return result;
        }
        Pointer request = this.getNeptingTPELibraryInstance().CreateNepMessage();
        Pointer response = this.getNeptingTPELibraryInstance().CreateNepMessage();
        this.getNeptingTPELibraryInstance().SetNepField(request, this.getPointerFromString("MESSAGE_NAME"), this.getPointerFromString("PosRequest"));
        this.getNeptingTPELibraryInstance().SetNepField(request, this.getPointerFromString("MESSAGE_TYPE"), this.getPointerFromString("Logout"));
        this.setMessageID(request, ++messageId);
        int status = this.sendRequestAndWaitForResponse(request, response, messageId);
        if (status <= 0) {
            System.out.println("error request response logout");
        } else {
            Pointer fieldName;
            status = 0;
            int index = 0;
            do {
                Pointer fieldValue;
                if ((fieldName = this.getNeptingTPELibraryInstance().GetNepFieldNameAt(response, index++)) == null || (fieldValue = this.getNeptingTPELibraryInstance().GetNepField(response, fieldName)) == null) continue;
                System.out.println(fieldName.getString(0L) + "=" + fieldValue.getString(0L));
            } while (fieldName != null);
            Pointer globalStatus = this.getNeptingTPELibraryInstance().GetNepField(response, this.getPointerFromString("GLOBAL_STATUS"));
            if (globalStatus != null && "1".contentEquals(globalStatus.getString(0L))) {
                result = 1;
            }
        }
        this.getNeptingTPELibraryInstance().FreeNepMessage(request);
        this.getNeptingTPELibraryInstance().FreeNepMessage(response);
        if (this.getNeptingTPELibraryInstance().CloseNepLib() <= 0) {
            System.out.println(" error logout CloseNepLib ");
        }
        System.out.println("end logout");
        return result;
    }

    public String[] debitAutomate_Reservation_check_final_amount(double amount) {
        int status;
        System.out.println("+++++++ debitAutomate_Reservation : ");
        String amountCentieme = "" + (int)(amount * 100.0);
        String[] trsStatus = new String[]{null, null, null, null};
        this.getNeptingTPELibraryInstance().setLogLevel(5);
        if (this.getNeptingTPELibraryInstance().InitNepLib(this.getPointerFromString(this.eftAdress)) <= 0) {
            System.out.println("error debitAutomate_Reservation");
            return trsStatus;
        }
        this.merchantTrsId = "" + new Date().getTime();
        Pointer request = this.getNeptingTPELibraryInstance().CreateNepMessage();
        Pointer response = this.getNeptingTPELibraryInstance().CreateNepMessage();
        boolean i = false;
        this.getNeptingTPELibraryInstance().SetNepField(request, this.getPointerFromString("MESSAGE_NAME"), this.getPointerFromString("PosRequest"));
        this.getNeptingTPELibraryInstance().SetNepField(request, this.getPointerFromString("MESSAGE_TYPE"), this.getPointerFromString("OneTimeReservation"));
        this.setMessageID(request, ++messageId);
        this.getNeptingTPELibraryInstance().SetNepField(request, this.getPointerFromString("POS_CAPABILITIES"), this.getPointerFromString(this.pos_capabilities));
        this.getNeptingTPELibraryInstance().SetNepField(request, this.getPointerFromString("AMOUNT"), this.getPointerFromString(amountCentieme));
        this.getNeptingTPELibraryInstance().SetNepField(request, this.getPointerFromString("CURRENCY_CODE"), this.getPointerFromString(this.currencyCode));
        this.getNeptingTPELibraryInstance().SetNepField(request, this.getPointerFromString("CURRENCY_FRACTION"), this.getPointerFromString("2"));
        this.getNeptingTPELibraryInstance().SetNepField(request, this.getPointerFromString("CURRENCY_ALPHA"), this.getPointerFromString("EUR"));
        System.out.println("+++++++ AppLocal.TOKEN_TPE : " + AppLocal.TOKEN_TPE);
        if (AppLocal.TOKEN_TPE != null) {
            this.getNeptingTPELibraryInstance().SetNepField(request, this.getPointerFromString("TOKEN"), this.getPointerFromString(AppLocal.TOKEN_TPE));
        }
        if (this.merchantTrsId != null) {
            this.getNeptingTPELibraryInstance().SetNepField(request, this.getPointerFromString("MERCHANT_TRS_ID"), this.getPointerFromString(this.merchantTrsId));
        }
        if ((status = this.sendRequestAndWaitForResponse(request, response, messageId)) <= 0) {
            System.out.println("[ ERROR ] :: debitAutomate_Reservation() sendRequestAndWaitForResponse KO");
        } else {
            Pointer fieldName;
            trsStatus[0] = "0";
            int index = 0;
            do {
                Pointer fieldValue;
                if ((fieldName = this.getNeptingTPELibraryInstance().GetNepFieldNameAt(response, index++)) == null || (fieldValue = this.getNeptingTPELibraryInstance().GetNepField(response, fieldName)) == null) continue;
                System.out.println(fieldName.getString(0L) + "=" + fieldValue.getString(0L));
            } while (fieldName != null);
            Pointer pointer_Ref_to_Close = this.getNeptingTPELibraryInstance().GetNepField(response, this.getPointerFromString("TRS_ADVICE_IDENTIFIER"));
            String ref_to_Close = pointer_Ref_to_Close != null ? pointer_Ref_to_Close.getString(0L) : null;
            System.out.println("+++++++++++ Ref_to_Close onetimeReservation : " + ref_to_Close);
            Pointer globalStatus = this.getNeptingTPELibraryInstance().GetNepField(response, this.getPointerFromString("GLOBAL_STATUS"));
            if (globalStatus != null && "1".contentEquals(globalStatus.getString(0L))) {
                System.out.println("++++++ globalStatus.getString(0) : " + globalStatus.getString(0L));
                trsStatus[0] = "1";
                Pointer ticket = this.getNeptingTPELibraryInstance().GetNepField(response, this.getPointerFromString("HOLDER_TICKET"));
                if (ticket != null) {
                    trsStatus[1] = ticket.getString(0L);
                    System.out.println("+++++++++++ trsStatus[1] debitAutomate_Reservation: " + trsStatus[1]);
                    this.getNeptingTPELibraryInstance().FreeNepMessage(ticket);
                }
                trsStatus[3] = "0";
                Pointer finalAmount = this.getNeptingTPELibraryInstance().GetNepField(response, this.getPointerFromString("POS_FINAL_AMOUNT"));
                if (finalAmount != null && !finalAmount.getString(0L).contentEquals(amountCentieme)) {
                    trsStatus[3] = "1";
                    System.out.println("[ WARN ] :: debitAutomate_Reservation() partial amount processed");
                }
                trsStatus[2] = ref_to_Close;
            }
        }
        this.getNeptingTPELibraryInstance().FreeNepMessage(request);
        this.getNeptingTPELibraryInstance().FreeNepMessage(response);
        if (this.getNeptingTPELibraryInstance().CloseNepLib() <= 0) {
            System.out.println("error debitAutomate_Reservation");
        }
        System.out.println("debitAutomate_Reservation end");
        return trsStatus;
    }
}

