/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.tpeCB;

import com.fazecast.jSerialComm.SerialPort;
import com.openbravo.pos.printer.escpos.ESCPOS;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.pos.util.NumericUtils;
import fr.protactile.procaisse.dao.entities.CustomerInfo;
import fr.protactile.procaisse.tpeCB.PaymentByCard;
import fr.protactile.procaisse.tpeCB.PaymentResult;
import gnu.io.CommPortIdentifier;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TPECBConcert
implements PaymentByCard {
    private static Log logger = LogFactory.getFactory().getInstance(TPECBConcert.class);
    private final Integer ENQ = 5;
    private final Integer ACK = 6;
    private final Integer NAK = 21;
    private final Integer STX = 2;
    private final Integer ETX = 3;
    private final Integer EOT = 4;
    private final Integer SUCCESS_OPERATION = 1;
    private Enumeration portList;
    private CommPortIdentifier portId;
    private SerialPort serialPort;
    private OutputStream outputStream;
    private BufferedReader inputStream;
    private String sDisplayPort;
    private static TPECBConcert INSTANCE = null;
    private boolean send_amount = true;
    private final int ASCII_7 = 55;
    private final int ASCII_0 = 48;
    private PropertyChangeSupport support;
    public static String ADD_INFO_PAYMENT = "add_info_payment";
    public static String DELETE_INFO_PAYMENT = "delete_info_payment";
    public static String TPE_CONCERT = "tpe_concert";
    private final int ASCII_STX = 50;
    private boolean wait_for_response_tpe;
    private final int ERROR_TRANSACTION_EN_COURS = 3;

    public static TPECBConcert getInstance(String m_Port) {
        if (INSTANCE == null) {
            INSTANCE = new TPECBConcert(m_Port);
        }
        return INSTANCE;
    }

    public TPECBConcert(String m_Port) {
        this.sDisplayPort = m_Port;
        this.support = new PropertyChangeSupport(this);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        System.out.println("++++++++++++++ pcl tpe concert : " + pcl);
        this.support.addPropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.support.removePropertyChangeListener(pcl);
    }

    public int init(int baud) {
        int resultOperation = 1;
        if (this.sDisplayPort != null && !this.sDisplayPort.isEmpty()) {
            try {
                this.serialPort = SerialPort.getCommPort((String)this.sDisplayPort);
                this.serialPort.setComPortParameters(baud, 7, 1, 0);
                this.serialPort.openPort();
                this.outputStream = this.serialPort.getOutputStream();
                this.inputStream = new BufferedReader(new InputStreamReader(this.serialPort.getInputStreamWithSuppressedTimeoutExceptions()));
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
        return resultOperation;
    }

    public List<Integer> append(String str) {
        ArrayList<Integer> bytes = new ArrayList<Integer>();
        try {
            byte[] newBytes;
            for (byte byt : newBytes = str.getBytes("Windows-1252")) {
                bytes.add(Integer.valueOf(byt));
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return bytes;
    }

    private int sendAmount(double amount, String type) throws InterruptedException {
        int resultOperation;
        block7: {
            resultOperation = 0;
            String ecr = "02";
            String mnt = String.format("%08d", (int)NumericUtils.round(NumericUtils.round(amount) * 100.0));
            String IND = "1";
            String mrg = "1";
            String typ = type;
            String dev = "978";
            String priv = "0000000000";
            String msg = ecr + mnt + IND + mrg + typ + dev + priv;
            int lrc = 0;
            for (int i = 0; i < msg.length(); ++i) {
                lrc ^= msg.getBytes()[i];
            }
            lrc ^= this.ETX.intValue();
            try {
                if (this.outputStream == null) break block7;
                this.outputStream.write(this.ENQ);
                Thread.sleep(500L);
                Object line = null;
                int a = 0;
                for (int i = 0; i < 6; ++i) {
                    byte[] buffer = new byte[1024];
                    int bytesRead = this.serialPort.readBytes(buffer, (long)Math.min(buffer.length, this.serialPort.bytesAvailable()));
                    if (bytesRead > 0) {
                        System.out.println("bytesRead : " + bytesRead + " buffer[0] : " + buffer[0]);
                    }
                    if (bytesRead != 1 || buffer[0] != this.ACK) continue;
                    a = buffer[0];
                    System.out.println("TPE: Ouverture de session accept\u00e9e" + a);
                    break;
                }
                if (a != this.ACK) {
                    System.out.println("R\u00e9ponse TPE=NAK : " + a);
                    return 0;
                }
                Thread.sleep(200L);
                System.out.println("+++++++++++++ outputStream");
                this.outputStream.write(this.STX);
                this.outputStream.write(msg.getBytes());
                this.outputStream.write(this.ETX);
                this.outputStream.write(lrc);
                Thread.sleep(500L);
                a = this.inputStream.read();
                System.out.println("+++++++++++++++ inputStream 2 : " + a);
                if (a == this.ACK) {
                    Thread.sleep(200L);
                    resultOperation = 1;
                    this.outputStream.write(this.EOT);
                    break block7;
                }
                return 2;
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
                return -1;
            }
        }
        return resultOperation;
    }

    public void clearVisor() {
        try {
            if (this.outputStream != null) {
                this.outputStream.write(ESCPOS.SELECT_DISPLAY);
                this.outputStream.write(ESCPOS.VISOR_CLEAR);
                this.outputStream.write(ESCPOS.VISOR_HOME);
                this.outputStream.flush();
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void close() throws IOException {
        if (this.serialPort != null && this.inputStream != null && this.outputStream != null) {
            this.inputStream.close();
            this.outputStream.close();
            this.serialPort.closePort();
        }
    }

    private PaymentResult initAndSend(double amount) {
        int result;
        PaymentResult paymentResult;
        block7: {
            paymentResult = new PaymentResult();
            result = 0;
            if (!this.wait_for_response_tpe) {
                if (this.init(9600) > 0) {
                    System.out.println("");
                    try {
                        int send_result = this.sendAmount(amount);
                        if (send_result == 1) {
                            result = this.getMessageTPE("achat");
                            this.close();
                            break block7;
                        }
                        result = send_result;
                    }
                    catch (Exception ex) {
                        LogToFile.log("severe", ex.getMessage(), ex);
                    }
                } else {
                    result = -1;
                }
            } else {
                result = 3;
            }
        }
        paymentResult.setResult(result);
        return paymentResult;
    }

    @Override
    public String getErrorMassage(int errorCode) {
        switch (errorCode) {
            case -1: {
                return "Erreur de connexion au TPE";
            }
            case 0: {
                return "Le TPE a refus\u00e9 la transaction";
            }
            case 2: {
                return "Le montant est envoy\u00e9 ,mais l'operation est impossible";
            }
            case 3: {
                return "Une autre transaction est en cours";
            }
        }
        return "Un erreur est survenu";
    }

    public void clearVisor(OutputStream outputStream) {
        try {
            if (outputStream != null) {
                outputStream.write(ESCPOS.INIT);
                outputStream.write(ESCPOS.SELECT_DISPLAY);
                outputStream.write(ESCPOS.VISOR_CLEAR);
                outputStream.write(ESCPOS.VISOR_HOME);
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void sendMessageJserialComm(String msg) throws IOException {
        SerialPort comPort = SerialPort.getCommPort((String)this.sDisplayPort);
        comPort.openPort();
        OutputStream out = comPort.getOutputStream();
        byte[] msgBytes = msg.getBytes();
        this.clearVisor(out);
        out.write(msgBytes);
        out.close();
    }

    @Override
    public PaymentResult doDebit(double amount, CustomerInfo customer, String lastTransactionId) {
        return this.initAndSend(amount);
    }

    @Override
    public int doRefund(double amount, CustomerInfo customer, String idPayment) {
        PaymentResult paymentResult = this.initAndSend(-amount);
        return paymentResult.getResult();
    }

    @Override
    public boolean isTransactionSuccessed(int result) {
        return result == this.SUCCESS_OPERATION;
    }

    private int getMessageTPE(String type_transaction) throws InterruptedException {
        int resultOperation = 0;
        try {
            if (this.outputStream != null) {
                this.wait_for_response_tpe = true;
                while (true) {
                    byte[] buffer;
                    int bytesRead;
                    if ((bytesRead = this.serialPort.readBytes(buffer = new byte[1024], (long)Math.min(buffer.length, this.serialPort.bytesAvailable()))) <= 0) {
                        continue;
                    }
                    System.out.println("+++++++++++++ bytesRead : " + type_transaction + "  " + bytesRead);
                    System.out.println("+++++++++++++ bytesRead[0] : " + buffer[0]);
                    if (bytesRead == 1 && buffer[0] == this.ENQ) {
                        System.out.println("++++++++++  reponse tpe ");
                        this.outputStream.write(this.ACK);
                        continue;
                    }
                    if (bytesRead > 1 && bytesRead > 3) {
                        byte stat_champ = buffer[0] == 50 ? buffer[3] : buffer[2];
                        String s = new String(buffer, StandardCharsets.UTF_8);
                        System.out.println("+++++++++++++++ s : " + s);
                        System.out.println("++++++++++++stat_champ : " + stat_champ);
                        if (stat_champ == 55) {
                            this.outputStream.write(this.ACK);
                            resultOperation = 0;
                        }
                        if (stat_champ == 48) {
                            this.outputStream.write(this.ACK);
                            resultOperation = 1;
                        }
                    }
                    if (bytesRead == 1 && buffer[0] == this.EOT) break;
                }
                this.outputStream.flush();
                this.wait_for_response_tpe = false;
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return resultOperation;
    }

    private int sendAmount(double amount) throws InterruptedException {
        return this.sendAmount(amount, "0");
    }

    @Override
    public boolean isWaitForResponseTPE() {
        return this.wait_for_response_tpe;
    }

    @Override
    public void debitAutomate_ClotureNTry(double amount, String ref_to_Close) {
    }

    @Override
    public void doLogin() {
    }

    @Override
    public int doPing() {
        return 0;
    }
}

