/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.tpeCB;

import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import fr.protactile.procaisse.dao.entities.CustomerInfo;
import fr.protactile.procaisse.tpeCB.PaymentByCard;
import fr.protactile.procaisse.tpeCB.PaymentByCardFactory;
import fr.protactile.procaisse.tpeCB.PaymentResult;
import java.beans.PropertyChangeListener;

public class PaymentByCardFacade {
    private AppView m_App;
    private PaymentByCard tpe;
    private static PaymentByCardFacade INSTANCE;
    boolean activated;
    String portTpe;
    String protocol;

    public static PaymentByCardFacade getInstance(AppView m_App) {
        if (INSTANCE == null) {
            INSTANCE = new PaymentByCardFacade(m_App);
        }
        return INSTANCE;
    }

    private PaymentByCardFacade(AppView m_App) {
        this.m_App = m_App;
        this.activated = m_App.getProperties().getProperty("payment.cb.tpe").equals("yes") && m_App.getProperties().getProperty("payment.cb.tpe.port") != null;
        this.portTpe = m_App.getProperties().getProperty("payment.cb.tpe.port");
        this.protocol = m_App.getProperties().getProperty("payment.cb.tpe.protocol");
        this.activated = this.activated && this.protocol != null && this.portTpe != null;
        System.out.println("++++ AppLocal.MODULE_CLOVER : " + AppLocal.MODULE_CLOVER);
        if (AppLocal.MODULE_CLOVER || this.activated) {
            String codeMerchant = m_App.getProperties().getProperty("payment.cb.tpe.idMerchant");
            this.tpe = PaymentByCardFactory.getTPEInstance(this.protocol, this.portTpe, codeMerchant, "1", "1");
        }
    }

    public String getPortTpe() {
        return this.portTpe;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public boolean isActivated() {
        return this.activated || AppLocal.MODULE_CLOVER;
    }

    public PaymentResult doDebit(double amount, CustomerInfo customer, String lastTransactionId) {
        System.out.println("do debit ******************** amount : " + amount);
        PaymentResult result = this.tpe.doDebit(amount, customer, lastTransactionId);
        return result;
    }

    public int doCancel(double amount, String transactionId) {
        return this.tpe.doCancel(amount, transactionId);
    }

    public int doRefund(double amount, CustomerInfo customer, String idPayment) {
        return this.tpe.doRefund(amount, customer, idPayment);
    }

    public int doPing() {
        int result = this.tpe.doPing();
        return result;
    }

    public boolean isTransactionSuccessed(int result) {
        return this.tpe != null && this.tpe.isTransactionSuccessed(result);
    }

    public String getErrorMessage(int codeError) {
        return this.tpe.getErrorMassage(codeError);
    }

    public void doDebitIfActivated(double amount) {
        System.out.println("____________________TPE : ");
        if (this.isActivated()) {
            System.out.println("____________________TPE :begin ");
            PaymentResult payementResult = this.doDebit(amount, null, null);
            int result = payementResult.getResult();
            System.out.println("____________________RESULT : " + result);
            if (!this.isTransactionSuccessed(result)) {
                new NotifyWindow(NotifyType.ERROR_NOTIFICATION, this.getErrorMessage(result), 4000, NPosition.BOTTOM_RIGHT);
            } else {
                new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, "Transaction a bien pass\u00e9", 4000, NPosition.BOTTOM_RIGHT);
            }
        }
    }

    public void getReport() {
        if (this.isActivated()) {
            this.tpe.getReport();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        System.out.println("++++++++++++++ addPropertyChangeListener facade : " + pcl);
        this.tpe.addPropertyChangeListener(pcl);
    }

    public boolean isWaitForResponseTPE() {
        return this.tpe.isWaitForResponseTPE();
    }

    public String[] debitAutomate_Reservation(double amount) {
        return this.tpe.debitAutomate_Reservation(amount);
    }

    public String[] debitAutomate_Cloture(double amount, String ref_to_Close) {
        return this.tpe.debitAutomate_Cloture(amount, ref_to_Close);
    }

    public void doLogin() {
        this.tpe.doLogin();
    }

    public void debitAutomate_ClotureNTry(double amount, String ref_to_Close) {
        this.tpe.debitAutomate_ClotureNTry(amount, ref_to_Close);
    }

    public int logout() {
        return this.tpe.logout();
    }
}

