/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.tpeCB;

import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.pos.util.NumericUtils;
import fr.protactile.procaisse.dao.entities.CustomerInfo;
import fr.protactile.procaisse.dao.entities.InfoClover;
import fr.protactile.procaisse.dao.entities.TransactionClover;
import fr.protactile.procaisse.dao.impl.InfoCloverDao;
import fr.protactile.procaisse.dao.impl.TransactionCloverDao;
import fr.protactile.procaisse.tpeCB.PaymentByCard;
import fr.protactile.procaisse.tpeCB.PaymentResult;
import java.beans.PropertyChangeListener;
import java.security.SecureRandom;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.json.JSONArray;
import org.json.JSONObject;

public class CloverService
implements PaymentByCard {
    private static CloverService m_instance;
    private String client_id = "";
    private String client_secret = "";
    private String client_id_test = "RJRE1BYMVB3VR";
    private String client_secret_test = "6b653898-a22f-0a41-ad36-663b2f3af739";
    private String client_id_prod = "XCJ4YPAFEK41A";
    private String client_secret_prod = "59eddb82-f642-a779-a40d-344d52d7ebcb";
    private String URL_GET_ACCESS_TOKEN = "oauth/token?";
    private String URL_BASE;
    private String URL_PAYMENTS = "connect/v1/payments";
    private String URL_WELCOME = "connect/v1/device/welcome";
    private String URL_DISPLAY = "connect/v1/device/display";
    private String URL_PING = "connect/v1/device/ping";
    private String URL_SANDBOX = "https://sandbox.dev.clover.com/";
    private String URL_READ_TIP = "connect/v1/device/read-tip";
    private String URL_RECEIPT = "connect/v1/device/receipt-options";
    private String URL_REFUNDS = "connect/v1/refunds";
    private String URL_PROD = "https://www.clover.com/";
    private String URL_GET_TOEKN = "";
    private InfoClover mInfoClover;
    private InfoCloverDao mInfoCloverDao;
    private String access_token;
    private static final SecureRandom random;
    private static final char[] vals;
    private TransactionCloverDao mTransactionCloverDao;
    private TransactionClover currentTransactionClover;
    private final Integer SUCCESS_OPERATION = 1;
    private String URL_GET_CODE_AUTHORIZATION = "https://clover.biborne.com/findLastOne/";
    private static HashMap<Integer, String> ERRORS_MSG;

    private CloverService() {
        this.setErrors();
        if (AppLocal.CLOVER_DEV_MODE) {
            this.client_id = this.client_id_test;
            this.client_secret = this.client_secret_test;
            this.URL_GET_TOEKN = this.URL_SANDBOX;
        } else {
            this.client_id = this.client_id_prod;
            this.client_secret = this.client_secret_prod;
            this.URL_GET_TOEKN = this.URL_PROD;
        }
        this.mInfoCloverDao = new InfoCloverDao();
        this.mTransactionCloverDao = new TransactionCloverDao();
        this.loadInfoClover();
        if (this.mInfoClover != null && this.mInfoClover.getIp_address_clover_device() != null && !this.mInfoClover.getIp_address_clover_device().isEmpty()) {
            StringBuilder urlBuilder = new StringBuilder();
            urlBuilder.append("https://").append(this.mInfoClover.getIp_address_clover_device()).append(":12346/");
            this.URL_BASE = urlBuilder.toString();
        }
    }

    public static CloverService getInstance() {
        if (m_instance == null) {
            m_instance = new CloverService();
        }
        return m_instance;
    }

    public static String getIdempotencyKey() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 13; ++i) {
            int idx = random.nextInt(vals.length);
            sb.append(vals[idx]);
        }
        return sb.toString();
    }

    private void getToken(String authorization_code) {
        if (this.URL_BASE != null && !this.URL_BASE.isEmpty()) {
            try {
                String url = this.URL_GET_TOEKN + this.URL_GET_ACCESS_TOKEN + "client_id" + "=" + this.client_id + "&" + "client_secret" + "=" + this.client_secret + "&" + "code" + "=" + authorization_code;
                System.out.println("+++ url : " + url);
                OkHttpClient client = new OkHttpClient().newBuilder().build();
                Request request = new Request.Builder().url(url).method("GET", null).build();
                Response response = client.newCall(request).execute();
                System.out.println("++++++++++++ response : " + response);
                if (response.code() == 200) {
                    String response_items = response.body().string();
                    JSONObject jsonResponse = new JSONObject(response_items);
                    String token = !jsonResponse.isNull("access_token") ? jsonResponse.getString("access_token") : null;
                    this.setTokenDB(token);
                }
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    private void setTokenDB(String token) {
        if (token != null && !token.isEmpty()) {
            this.access_token = token;
            if (this.mInfoClover != null) {
                this.mInfoClover.setToken(token);
                this.mInfoCloverDao.setToken(token, this.mInfoClover.getId());
            } else {
                this.mInfoClover = new InfoClover();
                this.mInfoClover.setToken(token);
                this.mInfoCloverDao.addInfoClover(this.mInfoClover);
            }
        }
    }

    private void loadInfoClover() {
        this.mInfoClover = this.mInfoCloverDao.firstElement();
        if (this.mInfoClover != null) {
            this.access_token = this.mInfoClover.getToken();
        }
    }

    public PaymentResult payment(double amount, String phone_customer, String email_customer, int tip) {
        PaymentResult paymentResult = new PaymentResult();
        paymentResult.setResult(-1);
        if (this.URL_BASE != null && !this.URL_BASE.isEmpty() && this.mInfoClover != null && this.mInfoClover.getId_clover_device() != null && !this.mInfoClover.getId_clover_device().isEmpty()) {
            int amountCentieme = (int)NumericUtils.round(amount * 100.0);
            System.out.println("amountCentieme : " + amountCentieme);
            String externalId = "" + new Date().getTime();
            String idempotency_key = CloverService.getIdempotencyKey();
            this.currentTransactionClover = new TransactionClover();
            this.currentTransactionClover.setExternal_id(externalId);
            this.currentTransactionClover.setTransaction_name("payment");
            this.currentTransactionClover.setIdempotency_key(idempotency_key);
            this.currentTransactionClover.setAmount(amountCentieme);
            this.mTransactionCloverDao.addTransactionClover(this.currentTransactionClover);
            return this.paymentRequest(this.currentTransactionClover, phone_customer, email_customer, tip);
        }
        new NotifyWindow(NotifyType.ERROR_NOTIFICATION, "Erreur de configuration sur POS.", 4000, NPosition.BOTTOM_RIGHT);
        return paymentResult;
    }

    public PaymentResult paymentRequest(TransactionClover transactionClover, String phone_customer, String email_customer, int tip) {
        PaymentResult paymentResult = new PaymentResult();
        boolean partial_payment = false;
        paymentResult.setResult(-1);
        paymentResult.setType_card("carte credit");
        if (tip != 0) {
            paymentResult.setTip(tip);
        }
        try {
            JSONObject jsonBody = new JSONObject();
            jsonBody.put("amount", transactionClover.getAmount());
            jsonBody.put("final", true);
            if (tip != 0) {
                jsonBody.put("tipAmount", tip);
            }
            jsonBody.put("externalPaymentId", (Object)transactionClover.getExternal_id());
            if (email_customer != null && !email_customer.isEmpty()) {
                jsonBody.put("receipt_email", (Object)email_customer);
            }
            System.out.println("jsonBody paymentRequest : " + jsonBody);
            OkHttpClient client = new OkHttpClient.Builder().writeTimeout(4L, TimeUnit.MINUTES).readTimeout(4L, TimeUnit.MINUTES).build();
            RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)jsonBody.toString());
            Request request = new Request.Builder().url(this.URL_BASE + this.URL_PAYMENTS).method("POST", body).addHeader("X-Clover-Device-Id", this.mInfoClover.getId_clover_device()).addHeader("X-POS-ID", this.client_id).addHeader("Idempotency-Key", transactionClover.getIdempotency_key()).addHeader("Content-Type", "application/json").addHeader("Authorization", "Bearer " + this.access_token).build();
            Response response = client.newCall(request).execute();
            if (response.code() == 200) {
                JSONObject jsonIssue;
                String idPayment = null;
                String response_items = response.body().string();
                JSONObject jsonResponse = new JSONObject(response_items);
                System.out.println("++++++ jsonResponse payment : " + jsonResponse);
                if (!jsonResponse.isNull("issues") && !(jsonIssue = jsonResponse.getJSONObject("issues")).isNull("partialPayment")) {
                    partial_payment = true;
                }
                if (!jsonResponse.isNull("payment")) {
                    JSONObject jsonPayment = jsonResponse.getJSONObject("payment");
                    if (!jsonPayment.isNull("id")) {
                        idPayment = jsonPayment.getString("id");
                    }
                    if (!jsonPayment.isNull("tender")) {
                        String type_card;
                        JSONObject jsonTender = jsonPayment.getJSONObject("tender");
                        String string = type_card = jsonTender != null && !jsonTender.isNull("label") ? jsonTender.getString("label") : null;
                        if (type_card != null && !type_card.isEmpty()) {
                            switch (type_card) {
                                case "Credit Card": {
                                    paymentResult.setType_card("carte credit");
                                    break;
                                }
                                case "Debit Card": {
                                    paymentResult.setType_card("carte debit");
                                }
                            }
                        }
                    }
                }
                response.close();
                System.out.println("partial_payment : " + partial_payment);
                if (partial_payment) {
                    this.voidRequest(idPayment);
                    paymentResult.setResult(2);
                } else {
                    if (idPayment != null && !idPayment.isEmpty()) {
                        transactionClover.setPayment_id(idPayment);
                        this.mTransactionCloverDao.setPaymentId(transactionClover);
                    }
                    paymentResult.setId_payment(idPayment);
                    paymentResult.setResult(1);
                    if (idPayment != null && !idPayment.isEmpty()) {
                        this.receiptOptionsRequest(idPayment, phone_customer, email_customer, "payment");
                    } else {
                        this.welcome();
                    }
                }
            } else {
                String response_items;
                if (response.code() == 401) {
                    new NotifyWindow(NotifyType.ERROR_NOTIFICATION, AppLocal.getIntString("Message.error.token.invalid"), 4000, NPosition.BOTTOM_RIGHT);
                }
                if ((response_items = response.body().string()) != null && !response_items.isEmpty()) {
                    JSONObject jsonResponse = new JSONObject(response_items);
                    System.out.println("++++++ jsonResponse error payment : " + jsonResponse);
                }
                response.close();
                this.welcome();
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return paymentResult;
    }

    public void welcome() {
        try {
            if (this.access_token != null && !this.access_token.isEmpty() && this.mInfoClover != null && this.mInfoClover.getId_clover_device() != null && !this.mInfoClover.getId_clover_device().isEmpty()) {
                JSONObject jsonBody = new JSONObject();
                OkHttpClient client = new OkHttpClient().newBuilder().build();
                RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)jsonBody.toString());
                Request request = new Request.Builder().url(this.URL_BASE + this.URL_WELCOME).method("POST", body).addHeader("X-Clover-Device-Id", this.mInfoClover.getId_clover_device()).addHeader("X-POS-ID", this.client_id).addHeader("Content-Type", "application/json").addHeader("Authorization", "Bearer " + this.access_token).build();
                Response response = client.newCall(request).execute();
                if (response.code() == 401) {
                    response.close();
                    new NotifyWindow(NotifyType.ERROR_NOTIFICATION, AppLocal.getIntString("Message.error.token.invalid"), 4000, NPosition.BOTTOM_RIGHT);
                } else {
                    response.close();
                }
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void voidRequest(String paymentId) {
        try {
            if (this.access_token != null && !this.access_token.isEmpty() && this.mInfoClover != null && this.mInfoClover.getId_clover_device() != null && !this.mInfoClover.getId_clover_device().isEmpty()) {
                String idempotency_key = CloverService.getIdempotencyKey();
                JSONObject jsonBody = new JSONObject();
                jsonBody.put("voidReason", (Object)"REJECT_PARTIAL_PAYMENT");
                OkHttpClient client = new OkHttpClient().newBuilder().build();
                RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)jsonBody.toString());
                Request request = new Request.Builder().url(this.URL_BASE + this.URL_PAYMENTS + "/" + paymentId + "/void").method("POST", body).addHeader("X-Clover-Device-Id", this.mInfoClover.getId_clover_device()).addHeader("X-POS-ID", this.client_id).addHeader("Idempotency-Key", idempotency_key).addHeader("Content-Type", "application/json").addHeader("Authorization", "Bearer " + this.access_token).build();
                Response response = client.newCall(request).execute();
                System.out.println("response voidRequest : " + response);
                if (response.code() == 401) {
                    new NotifyWindow(NotifyType.ERROR_NOTIFICATION, AppLocal.getIntString("Message.error.token.invalid"), 4000, NPosition.BOTTOM_RIGHT);
                }
                response.close();
                this.welcome();
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void refund(String paymentId) {
        try {
            if (this.access_token != null && !this.access_token.isEmpty() && this.mInfoClover != null && this.mInfoClover.getId_clover_device() != null && !this.mInfoClover.getId_clover_device().isEmpty()) {
                String idempotency_key = CloverService.getIdempotencyKey();
                this.currentTransactionClover = new TransactionClover();
                this.currentTransactionClover.setTransaction_name("refund");
                this.currentTransactionClover.setIdempotency_key(idempotency_key);
                this.mTransactionCloverDao.addTransactionClover(this.currentTransactionClover);
                JSONObject jsonBody = new JSONObject();
                jsonBody.put("fullRefund", true);
                OkHttpClient client = new OkHttpClient().newBuilder().build();
                RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)jsonBody.toString());
                Request request = new Request.Builder().url(this.URL_BASE + this.URL_PAYMENTS + "/" + paymentId + "/refunds").method("POST", body).addHeader("X-Clover-Device-Id", this.mInfoClover.getId_clover_device()).addHeader("X-POS-ID", this.client_id).addHeader("Idempotency-Key", idempotency_key).addHeader("Content-Type", "application/json").addHeader("Authorization", "Bearer " + this.access_token).build();
                Response response = client.newCall(request).execute();
                System.out.println("response refund : " + response);
                if (response.code() == 200) {
                    JSONObject jsonRefund;
                    String idRefund = null;
                    String response_items = response.body().string();
                    JSONObject jsonResponse = new JSONObject(response_items);
                    System.out.println("++++++ jsonResponse refund : " + jsonResponse);
                    if (!jsonResponse.isNull("refund") && !(jsonRefund = jsonResponse.getJSONObject("refund")).isNull("id")) {
                        idRefund = jsonRefund.getString("id");
                    }
                    response.close();
                    if (idRefund != null && !idRefund.isEmpty()) {
                        this.receiptOptionsAfterRefund(idRefund, paymentId);
                    } else {
                        this.welcome();
                    }
                } else {
                    if (response.code() == 401) {
                        new NotifyWindow(NotifyType.ERROR_NOTIFICATION, AppLocal.getIntString("Message.error.token.invalid"), 4000, NPosition.BOTTOM_RIGHT);
                    }
                    response.close();
                    this.welcome();
                }
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public InfoClover getmInfoClover() {
        return this.mInfoClover;
    }

    public void setmInfoClover(InfoClover mInfoClover) {
        this.mInfoClover = mInfoClover;
    }

    public void setInfosClover(String id_clover_device, String ip_address_clover, String id_merchant_clover) {
        if (this.mInfoClover != null) {
            if (!(this.mInfoClover.getId_clover_device() != null && this.mInfoClover.getId_clover_device().equals(id_clover_device) && this.mInfoClover.getIp_address_clover_device() != null && this.mInfoClover.getIp_address_clover_device().equals(ip_address_clover) && this.mInfoClover.getId_merchant_clover() != null && this.mInfoClover.getId_merchant_clover().equals(id_merchant_clover))) {
                this.mInfoClover.setId_clover_device(id_clover_device);
                this.mInfoClover.setIp_address_clover_device(ip_address_clover);
                this.mInfoClover.setId_merchant_clover(id_merchant_clover);
                this.mInfoCloverDao.updateInfoClover(this.mInfoClover);
            }
        } else {
            this.mInfoClover = new InfoClover();
            this.mInfoClover.setId_clover_device(id_clover_device);
            this.mInfoClover.setIp_address_clover_device(ip_address_clover);
            this.mInfoClover.setId_merchant_clover(id_merchant_clover);
            this.mInfoCloverDao.addInfoClover(this.mInfoClover);
        }
    }

    public void display() {
        if (this.URL_BASE != null && !this.URL_BASE.isEmpty() && this.mInfoClover != null && this.mInfoClover.getId_clover_device() != null && !this.mInfoClover.getId_clover_device().isEmpty()) {
            this.displayRequest();
        } else {
            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, AppLocal.getIntString("Message.error.configuration.pos"), 4000, NPosition.BOTTOM_RIGHT);
        }
    }

    public void displayRequest() {
        try {
            JSONObject jsonBody = new JSONObject();
            jsonBody.put("beep", true);
            jsonBody.put("text", (Object)"Message to display");
            OkHttpClient client = new OkHttpClient().newBuilder().build();
            RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)jsonBody.toString());
            Request request = new Request.Builder().url(this.URL_BASE + this.URL_DISPLAY).method("POST", body).addHeader("X-Clover-Device-Id", this.mInfoClover.getId_clover_device()).addHeader("X-POS-ID", this.client_id).addHeader("Content-Type", "application/json").addHeader("Authorization", "Bearer " + this.access_token).build();
            Response response = client.newCall(request).execute();
            System.out.println("response : " + response);
            if (response.code() == 401) {
                response.close();
                new NotifyWindow(NotifyType.ERROR_NOTIFICATION, AppLocal.getIntString("Message.error.token.invalid"), 4000, NPosition.BOTTOM_RIGHT);
            } else {
                response.close();
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void ping() {
        if (this.URL_BASE != null && !this.URL_BASE.isEmpty() && this.mInfoClover != null && this.mInfoClover.getId_clover_device() != null && !this.mInfoClover.getId_clover_device().isEmpty()) {
            boolean connected = this.pingRequest();
            if (connected) {
                new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, AppLocal.getIntString("Message.connected"), 1500, NPosition.CENTER);
            } else {
                new NotifyWindow(NotifyType.ERROR_NOTIFICATION, AppLocal.getIntString("Message.not.connected"), 1500, NPosition.CENTER);
            }
        } else {
            new NotifyWindow(NotifyType.ERROR_NOTIFICATION, AppLocal.getIntString("Message.error.configuration.pos"), 4000, NPosition.BOTTOM_RIGHT);
        }
    }

    public boolean pingRequest() {
        boolean connected = false;
        try {
            JSONObject jsonBody = new JSONObject();
            OkHttpClient client = new OkHttpClient().newBuilder().build();
            RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)jsonBody.toString());
            Request request = new Request.Builder().url(this.URL_BASE + this.URL_PING).method("POST", body).addHeader("X-Clover-Device-Id", this.mInfoClover.getId_clover_device()).addHeader("X-POS-ID", this.client_id).addHeader("Content-Type", "application/json").addHeader("Authorization", "Bearer " + this.access_token).build();
            Response response = client.newCall(request).execute();
            System.out.println("response : " + response);
            if (response.code() == 200) {
                String response_items = response.body().string();
                JSONObject jsonResponse = new JSONObject(response_items);
                boolean bl = connected = !jsonResponse.isNull("connected") ? jsonResponse.getBoolean("connected") : false;
            }
            if (response.code() == 401) {
                new NotifyWindow(NotifyType.SUCCESS_NOTIFICATION, AppLocal.getIntString("Message.unauthorized"), 1500, NPosition.CENTER);
            }
            response.close();
        }
        catch (Exception ex) {
            new NotifyWindow(NotifyType.WARNING_NOTIFICATION, AppLocal.getIntString("Message.error"), 1500, NPosition.CENTER);
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return connected;
    }

    @Override
    public PaymentResult doDebit(double amount, CustomerInfo customer, String lastTransactionId) {
        System.out.println(" doDebit clover service: " + amount);
        int tip = this.readTip(amount);
        String phoneCustomer = customer != null ? customer.getPhone() : null;
        String emailCustomer = customer != null ? customer.getEmail() : null;
        return this.payment(amount, phoneCustomer, emailCustomer, tip);
    }

    @Override
    public int doRefund(double amount, CustomerInfo customer, String idPayment) {
        this.refund(idPayment);
        return -1;
    }

    @Override
    public boolean isTransactionSuccessed(int result) {
        return result == this.SUCCESS_OPERATION;
    }

    @Override
    public int doPing() {
        boolean connected = this.pingRequest();
        return connected ? 1 : 0;
    }

    @Override
    public void doLogin() {
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener pcl) {
    }

    @Override
    public void debitAutomate_ClotureNTry(double amount, String ref_to_Close) {
    }

    @Override
    public int doCancel(double amount, String transactionId) {
        return -1;
    }

    private String getCodeAuthorization() {
        if (this.mInfoClover != null && this.URL_BASE != null && !this.URL_BASE.isEmpty()) {
            try {
                String url = this.URL_GET_CODE_AUTHORIZATION + this.mInfoClover.getId_merchant_clover() + "&" + this.client_id;
                OkHttpClient client = new OkHttpClient().newBuilder().build();
                Request request = new Request.Builder().url(url).method("GET", null).build();
                Response response = client.newCall(request).execute();
                System.out.println("++++++++++++ response : " + response);
                String response_items = response.body().string();
                if (response.code() == 200 && response_items != null && !response_items.trim().isEmpty()) {
                    JSONObject jsonResponse = new JSONObject(response_items);
                    String code_authorization = !jsonResponse.isNull("code") ? jsonResponse.getString("code") : null;
                    return code_authorization;
                }
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
        return null;
    }

    public void checkCodeAuthorization() {
        if (this.mInfoClover == null || this.mInfoClover.getCode_authorization() == null || this.mInfoClover.getCode_authorization().isEmpty()) {
            String code_authorization = this.getCodeAuthorization();
            if (code_authorization != null && !code_authorization.isEmpty()) {
                this.setCodeAuthorization(code_authorization);
                this.getToken(code_authorization);
            }
        } else {
            System.out.println("+++++++ code authorization exist");
            if (this.mInfoClover.getToken() == null || !this.mInfoClover.getToken().isEmpty()) {
                this.getToken(this.mInfoClover.getCode_authorization());
            }
        }
    }

    private void setCodeAuthorization(String code_authorization) {
        if (this.mInfoClover != null) {
            this.mInfoClover.setCode_authorization(code_authorization);
            this.mInfoCloverDao.setCodeAuthorization(code_authorization, this.mInfoClover.getId());
        } else {
            this.mInfoClover = new InfoClover();
            this.mInfoCloverDao.addInfoClover(this.mInfoClover);
        }
    }

    public int readTip(double amount) {
        int result = 0;
        try {
            if (this.access_token != null && !this.access_token.isEmpty() && this.mInfoClover != null && this.mInfoClover.getId_clover_device() != null && !this.mInfoClover.getId_clover_device().isEmpty()) {
                int amountCentieme = (int)NumericUtils.round(amount * 100.0);
                String idempotency_key = CloverService.getIdempotencyKey();
                JSONObject jsonBody = new JSONObject();
                jsonBody.put("baseAmount", amountCentieme);
                OkHttpClient client = new OkHttpClient().newBuilder().build();
                RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)jsonBody.toString());
                Request request = new Request.Builder().url(this.URL_BASE + this.URL_READ_TIP).method("POST", body).addHeader("X-Clover-Device-Id", this.mInfoClover.getId_clover_device()).addHeader("X-POS-ID", this.client_id).addHeader("Idempotency-Key", idempotency_key).addHeader("Content-Type", "application/json").addHeader("Authorization", "Bearer " + this.access_token).build();
                Response response = client.newCall(request).execute();
                System.out.println("++++++ response : " + response);
                if (response.code() == 401) {
                    response.close();
                    new NotifyWindow(NotifyType.ERROR_NOTIFICATION, AppLocal.getIntString("Message.error.token.invalid"), 4000, NPosition.BOTTOM_RIGHT);
                } else {
                    if (response.code() == 200) {
                        String response_items = response.body().string();
                        System.out.println("response_items read tip : " + response_items);
                        JSONObject jsonResponse = new JSONObject(response_items);
                        if (!jsonResponse.isNull("response")) {
                            result = jsonResponse.getInt("response");
                            System.out.println("result : " + result);
                        }
                    }
                    response.close();
                }
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return result;
    }

    public void receiptOptionsRequest(String transactionId, String phone_customer, String email_customer, String preAction) {
        try {
            JSONObject jsonBody = new JSONObject();
            JSONArray deliveryOptionsArray = new JSONArray();
            JSONObject jsonNoReceipt = new JSONObject();
            jsonNoReceipt.put("additionalData", (Object)"Nopers");
            jsonNoReceipt.put("method", (Object)"NO_RECEIPT");
            deliveryOptionsArray.put((Object)jsonNoReceipt);
            if (email_customer != null && !email_customer.isEmpty()) {
                JSONObject jsonEmail = new JSONObject();
                jsonEmail.put("additionalData", (Object)email_customer);
                jsonEmail.put("method", (Object)"EMAIL");
                deliveryOptionsArray.put((Object)jsonEmail);
            }
            if (phone_customer != null && !phone_customer.isEmpty()) {
                JSONObject jsonSMS = new JSONObject();
                jsonSMS.put("additionalData", (Object)phone_customer);
                jsonSMS.put("method", (Object)"SMS");
                deliveryOptionsArray.put((Object)jsonSMS);
            }
            JSONObject jsonPrint = new JSONObject();
            jsonPrint.put("method", (Object)"PRINT");
            deliveryOptionsArray.put((Object)jsonPrint);
            jsonBody.put("deliveryOptions", (Object)deliveryOptionsArray);
            String idempotency_key = CloverService.getIdempotencyKey();
            OkHttpClient client = new OkHttpClient.Builder().writeTimeout(3L, TimeUnit.MINUTES).readTimeout(3L, TimeUnit.MINUTES).build();
            RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)jsonBody.toString());
            System.out.println("++++++ jsonBody receipt : " + jsonBody);
            Request request = new Request.Builder().url(this.URL_BASE + this.URL_RECEIPT).method("POST", body).addHeader("X-Clover-Device-Id", this.mInfoClover.getId_clover_device()).addHeader("X-POS-ID", this.client_id).addHeader("Idempotency-Key", idempotency_key).addHeader("Content-Type", "application/json").addHeader("Authorization", "Bearer " + this.access_token).build();
            Response response = client.newCall(request).execute();
            System.out.println("+++++++++ response receipt options : " + response);
            if (response.code() == 200) {
                JSONObject deliveryOptionObject;
                JSONArray deliveryOptionArray;
                String response_items = response.body().string();
                JSONObject jsonResponse = new JSONObject(response_items);
                System.out.println("++++++ jsonResponse receipt options : " + jsonResponse);
                String deliveryOption = null;
                if (!jsonResponse.isNull("deliveryOption") && (deliveryOptionArray = jsonResponse.getJSONArray("deliveryOption")) != null && deliveryOptionArray.length() > 0 && (deliveryOptionObject = deliveryOptionArray.getJSONObject(0)) != null && !deliveryOptionObject.isNull("method")) {
                    deliveryOption = deliveryOptionObject.getString("method");
                }
                response.close();
                if (deliveryOption != null && !deliveryOption.isEmpty() && !deliveryOption.equalsIgnoreCase("NO_RECEIPT")) {
                    this.receiptRequest(transactionId, phone_customer, email_customer, deliveryOption, preAction);
                } else {
                    this.welcome();
                }
            } else {
                String response_items;
                if (response.code() == 401) {
                    new NotifyWindow(NotifyType.ERROR_NOTIFICATION, AppLocal.getIntString("Message.error.token.invalid"), 4000, NPosition.BOTTOM_RIGHT);
                }
                if ((response_items = response.body().string()) != null && !response_items.isEmpty()) {
                    JSONObject jsonResponse = new JSONObject(response_items);
                    System.out.println("++++++ jsonResponse error receipt options : " + jsonResponse);
                }
                response.close();
                this.welcome();
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void receiptRequest(String transactionId, String phone_customer, String email_customer, String deliveryOption, String preAction) {
        String url_receipt = null;
        if (preAction != null) {
            switch (preAction) {
                case "payment": {
                    url_receipt = this.URL_BASE + this.URL_PAYMENTS + "/" + transactionId + "/receipt";
                    break;
                }
                case "refund": {
                    url_receipt = this.URL_BASE + this.URL_REFUNDS + "/" + transactionId + "/receipt";
                }
            }
        }
        if (url_receipt != null) {
            try {
                JSONObject jsonBody = new JSONObject();
                JSONObject jsonDeliveryOption = new JSONObject();
                switch (deliveryOption) {
                    case "PRINT": {
                        jsonDeliveryOption.put("method", (Object)"PRINT");
                        break;
                    }
                    case "EMAIL": {
                        jsonDeliveryOption.put("additionalData", (Object)email_customer);
                        jsonDeliveryOption.put("method", (Object)"EMAIL");
                        break;
                    }
                    case "SMS": {
                        jsonDeliveryOption.put("additionalData", (Object)phone_customer);
                        jsonDeliveryOption.put("method", (Object)"SMS");
                    }
                }
                jsonBody.put("deliveryOption", (Object)jsonDeliveryOption);
                String idempotency_key = CloverService.getIdempotencyKey();
                OkHttpClient client = new OkHttpClient.Builder().writeTimeout(3L, TimeUnit.MINUTES).readTimeout(3L, TimeUnit.MINUTES).build();
                RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)jsonBody.toString());
                Request request = new Request.Builder().url(url_receipt).method("POST", body).addHeader("X-Clover-Device-Id", this.mInfoClover.getId_clover_device()).addHeader("X-POS-ID", this.client_id).addHeader("Idempotency-Key", idempotency_key).addHeader("Content-Type", "application/json").addHeader("Authorization", "Bearer " + this.access_token).build();
                Response response = client.newCall(request).execute();
                if (response.code() == 200) {
                    String response_items = response.body().string();
                    JSONObject jsonResponse = new JSONObject(response_items);
                    System.out.println("++++++ jsonResponse receipt : " + jsonResponse);
                    response.close();
                    if (preAction != null && preAction.equalsIgnoreCase("payment")) {
                        switch (deliveryOption) {
                            case "PRINT": {
                                this.mTransactionCloverDao.setReceipt(transactionId, null, "PRINT");
                                break;
                            }
                            case "EMAIL": {
                                this.mTransactionCloverDao.setReceipt(transactionId, email_customer, "EMAIL");
                                break;
                            }
                            case "SMS": {
                                this.mTransactionCloverDao.setReceipt(transactionId, phone_customer, "SMS");
                            }
                        }
                    }
                } else {
                    String response_items;
                    if (response.code() == 401) {
                        new NotifyWindow(NotifyType.ERROR_NOTIFICATION, AppLocal.getIntString("Message.error.token.invalid"), 4000, NPosition.BOTTOM_RIGHT);
                    }
                    if ((response_items = response.body().string()) != null && !response_items.isEmpty()) {
                        JSONObject jsonResponse = new JSONObject(response_items);
                        System.out.println("++++++ jsonResponse error receipt : " + jsonResponse);
                    }
                    response.close();
                }
                this.welcome();
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        } else {
            this.welcome();
        }
    }

    private void receiptOptionsAfterRefund(String idRefund, String paymentId) {
        TransactionClover transactionClover = this.mTransactionCloverDao.getTransactionClover(paymentId);
        String additionalData = transactionClover != null ? transactionClover.getAdditional_data() : null;
        String deliveryMethod = transactionClover != null ? transactionClover.getDelivery_method() : null;
        String phoneCustomer = deliveryMethod != null && deliveryMethod.equalsIgnoreCase("SMS") ? additionalData : null;
        String emailCustomer = deliveryMethod != null && deliveryMethod.equalsIgnoreCase("EMAIL") ? additionalData : null;
        this.receiptOptionsRequest(idRefund, phoneCustomer, emailCustomer, "refund");
    }

    private void setErrors() {
        ERRORS_MSG = new HashMap();
        ERRORS_MSG.put(2, "Paiement refus\u00e9");
        ERRORS_MSG.put(-1, "Echec de l'op\u00e9raion");
    }

    @Override
    public String getErrorMassage(int errorCode) {
        String retour = ERRORS_MSG.get(errorCode);
        if (retour == null) {
            retour = "Erreur non d\u00e9finit";
        }
        return retour;
    }

    static {
        random = new SecureRandom();
        vals = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'V', 'W', 'X', 'Y', 'Z'};
        ERRORS_MSG = null;
    }
}

