/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.tasks;

import com.openbravo.pos.forms.AppLocal;
import fr.protactile.procaisse.tasks.AppTimerRunnable;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AppTimerTask
extends TimerTask {
    private static Log logger = LogFactory.getFactory().getInstance(AppTimerTask.class);
    private static AppTimerTask mInstance = null;
    private Timer currentTimeTimer = new Timer("Timer Task (AppTimerTask)- " + System.currentTimeMillis());
    private AppTimerRunnable timerRunnable = null;
    private final long EVENT_ACTIVITY_MASK = 24L;
    private final long DEFAULT_TIMEOUT_INACTIVITY = 300000L;
    private long lastTimeUserActiviy;
    private AWTEventListener mAwtEventListener;
    private Boolean isModeUnlockEnabled = false;
    private long timeout_inactivity = 0L;

    private AppTimerTask() {
        this.currentTimeTimer.scheduleAtFixedRate((TimerTask)this, 0L, 1000L);
        this.lastTimeUserActiviy = System.currentTimeMillis();
    }

    private void setAppTimerRunnable(AppTimerRunnable mRunnable) {
        if (this.timerRunnable != null) {
            this.timerRunnable.doFinalize();
        }
        this.timerRunnable = mRunnable;
    }

    public static AppTimerTask getInstance(AppTimerRunnable mRunnable) {
        if (mInstance == null) {
            mInstance = new AppTimerTask();
        }
        mInstance.setAppTimerRunnable(mRunnable);
        return mInstance;
    }

    public void attachListenerActivity() {
        if (this.isModeUnlockEnabled.booleanValue() && this.mAwtEventListener == null) {
            this.mAwtEventListener = e -> {
                this.lastTimeUserActiviy = System.currentTimeMillis();
            };
            Toolkit.getDefaultToolkit().addAWTEventListener(this.mAwtEventListener, 24L);
        }
    }

    public void setModeUnlockEnabled(Boolean isModeUnlockEnabled) {
        this.isModeUnlockEnabled = isModeUnlockEnabled;
    }

    public void setTimeoutInactivity(long timeout_inactivity) {
        this.timeout_inactivity = timeout_inactivity;
    }

    private long activatedTimeInactivity() {
        if (this.timeout_inactivity > 0L) {
            return this.timeout_inactivity;
        }
        return 300000L;
    }

    public boolean shouldCloseAppView() {
        return this.isModeUnlockEnabled != false && System.currentTimeMillis() - this.lastTimeUserActiviy > this.activatedTimeInactivity() && AppLocal.user != null && (AppLocal.modeCaisse == null || !AppLocal.modeCaisse.equals("Borne"));
    }

    public boolean shouldCloseBorne() {
        return this.isModeUnlockEnabled != false && System.currentTimeMillis() - this.lastTimeUserActiviy > this.activatedTimeInactivity() && !AppLocal.START_PAYMENT_BORNE && !AppLocal.LOAD_ESPACE_MANAGER;
    }

    @Override
    public void run() {
        if (this.timerRunnable != null) {
            this.timerRunnable.executor();
        }
    }

    public static void forceGarbageCollector() {
        System.gc();
        System.runFinalization();
    }
}

