/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.system;

import com.openbravo.pos.payment.PaymentInfo;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.ticket.TicketLineInfo;
import fr.protactile.procaisse.system.DataLoaderInfos;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RestoreSystemTicket {
    private static Log logger = LogFactory.getFactory().getInstance(RestoreSystemTicket.class);
    private DataLoaderInfos mDataLoaderInfos;
    private Date mDateStart;
    private Date mDateEnd;

    public RestoreSystemTicket() {
        try {
            this.mDataLoaderInfos = new DataLoaderInfos();
            this.initializerDates();
        }
        catch (Exception ex) {
            Logger.getLogger(RestoreSystemTicket.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void initializerDates() {
        this.mDateStart = this.mDataLoaderInfos.getDateStartTicket();
        this.mDateEnd = this.mDataLoaderInfos.getDateStartUsageTablesNorme();
    }

    private void resetDates() {
        if (this.mDateStart == null) {
            this.mDateStart = new Date();
            this.mDateStart.setDate(1);
            this.mDateStart.setMonth(0);
            this.mDateStart.setYear(117);
        }
        if (this.mDateEnd == null) {
            this.mDateEnd = new Date();
        }
    }

    public void showTicket() {
        this.resetDates();
        List<TicketInfo> mList = this.mDataLoaderInfos.getTicketBetweenTwoDates(this.mDateStart, this.mDateEnd);
        if (mList != null) {
            for (TicketInfo mTicketInfo : mList) {
                List<TicketLineInfo> lines = mTicketInfo.getLines();
                List<PaymentInfo> paymentInfos = mTicketInfo.getPayments();
                for (TicketLineInfo ticketLineInfo : lines) {
                }
                for (PaymentInfo paymentInfo : paymentInfos) {
                }
                this.mDataLoaderInfos.addTicketMissedData(mTicketInfo);
            }
        } else {
            logger.debug((Object)"size : 0");
        }
    }

    private void setMissedData() {
        this.resetDates();
        logger.debug((Object)"setMissedData()");
        logger.debug((Object)("Date Start: " + this.mDateStart));
        logger.debug((Object)("Date End: " + this.mDateEnd));
        List<TicketInfo> mList = this.mDataLoaderInfos.getTicketBetweenTwoDates(this.mDateStart, this.mDateEnd);
        if (mList != null) {
            Collections.reverse(mList);
            for (TicketInfo mTicketInfo : mList) {
                if (mTicketInfo.getLastUpdate() == null) {
                    mTicketInfo.setLastUpdate(mTicketInfo.getDate());
                }
                logger.debug((Object)mTicketInfo);
                this.mDataLoaderInfos.addTicketMissedData(mTicketInfo);
                logger.debug((Object)"===================================");
            }
        }
    }

    public boolean begin() {
        this.setMissedData();
        return true;
    }
}

