/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.system;

import com.openbravo.basic.BasicException;
import com.openbravo.basic.BasicStorage;
import com.openbravo.dao.DataLogicItems;
import com.openbravo.dao.DataLogicOrder;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.payment.PaymentInfo;
import com.openbravo.pos.ticket.TaxLineInfo;
import com.openbravo.pos.ticket.TicketInfo;
import com.openbravo.pos.ticket.TicketLineInfo;
import com.openbravo.pos.ticket.TotaleEncaissement;
import com.procaisse.db.connection.Session;
import fr.protactile.norm.beans.GrandTotalTicket;
import fr.protactile.norm.beans.Line;
import fr.protactile.norm.beans.TicketPayementNorm;
import fr.protactile.norm.beans.TotalTax;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DataLoaderInfos {
    private DataLogicSales mDataLogicSales;
    private DataLogicItems mDataLogicItems;
    private DataLogicOrder mDataLogicOrder;
    private AppView mAppView = (AppView)BasicStorage.getObject("APP_ROOT_INSTANCE");
    private Double restReduction;

    public DataLoaderInfos() throws Exception {
        this.init();
    }

    private void init() throws Exception {
        if (this.mAppView == null) {
            throw new Exception("Erreur lors d'intitalisation de l'application");
        }
        this.mDataLogicSales = (DataLogicSales)this.mAppView.getBean("com.openbravo.dao.DataLogicSales");
        this.mDataLogicItems = (DataLogicItems)this.mAppView.getBean("com.openbravo.dao.DataLogicItems");
        this.mDataLogicOrder = (DataLogicOrder)this.mAppView.getBean("com.openbravo.dao.DataLogicOrder");
    }

    public Date getDateStartTicket() {
        TicketInfo mTicket = null;
        try {
            mTicket = this.mDataLogicOrder.getFirstTicket();
        }
        catch (BasicException ex) {
            Logger.getLogger(DataLoaderInfos.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (mTicket != null) {
            return mTicket.getDate();
        }
        return null;
    }

    public Date getDateStartUsageTablesNorme() {
        try {
            return this.mDataLogicOrder.getFirstDateLineTotalTax();
        }
        catch (BasicException ex) {
            Logger.getLogger(DataLoaderInfos.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public List<TicketInfo> getTicketBetweenTwoDates(Date mDateStart, Date mDateEnd) {
        List<TicketInfo> mList = null;
        try {
            mList = this.mDataLogicSales.loadAllTicket(mDateStart, mDateEnd);
            for (TicketInfo next : mList) {
                List<TicketLineInfo> lines = this.mDataLogicSales.loadLines(next.getId());
                List<TicketLineInfo> linesExterne = this.mDataLogicSales.getTicketLineExterne(next.getId());
                lines.addAll(linesExterne);
                next.setLines(lines);
                next.setPayments(this.mDataLogicSales.findPaymetsByIdTicket(next.getId()));
            }
        }
        catch (BasicException ex) {
            Logger.getLogger(DataLoaderInfos.class.getName()).log(Level.SEVERE, null, ex);
        }
        return mList;
    }

    public void addTicketMissedData(TicketInfo ticketInfo) {
        Session mSession = this.mDataLogicSales.getCurrentSession();
        try {
            mSession.begin();
            Integer documentId = this.mDataLogicOrder.getDocumentIdByTicketId(ticketInfo.getId());
            if (documentId == null) {
                documentId = this.mDataLogicItems.addDocument(ticketInfo);
            }
            double totalTVA5 = 0.0;
            double totalTVA10 = 0.0;
            double totalTVA20 = 0.0;
            double totalTVA0 = 0.0;
            double totalTVA_7_7 = 0.0;
            double totalTVA_2_5 = 0.0;
            double totalTVA_2_1 = 0.0;
            double totalTVA_8_5 = 0.0;
            double totalTVA_6 = 0.0;
            double totalTVA_12 = 0.0;
            double totalTVA_21 = 0.0;
            double totalTVA_8_1 = 0.0;
            double totalTVA_2_6 = 0.0;
            int index = 0;
            for (TaxLineInfo taxLineInfo : ticketInfo.getTaxes()) {
                TotalTax mTax;
                if (taxLineInfo.getRate() == 0.055) {
                    totalTVA5 = taxLineInfo.getSumTTC();
                } else if (taxLineInfo.getRate() == 0.1) {
                    totalTVA10 = taxLineInfo.getSumTTC();
                } else if (taxLineInfo.getRate() == 0.2) {
                    totalTVA20 = taxLineInfo.getSumTTC();
                } else if (taxLineInfo.getRate() == 0.0) {
                    totalTVA0 = taxLineInfo.getSumTTC();
                } else if (taxLineInfo.getRate() == 0.077) {
                    totalTVA_7_7 = taxLineInfo.getSumTTC();
                } else if (taxLineInfo.getRate() == 0.025) {
                    totalTVA_2_5 = taxLineInfo.getSumTTC();
                } else if (taxLineInfo.getRate() == 0.021) {
                    totalTVA_2_1 = taxLineInfo.getSumTTC();
                } else if (taxLineInfo.getRate() == 0.085) {
                    totalTVA_8_5 = taxLineInfo.getSumTTC();
                } else if (taxLineInfo.getRate() == 0.06) {
                    totalTVA_6 = taxLineInfo.getSumTTC();
                } else if (taxLineInfo.getRate() == 0.12) {
                    totalTVA_12 = taxLineInfo.getSumTTC();
                } else if (taxLineInfo.getRate() == 0.21) {
                    totalTVA_21 = taxLineInfo.getSumTTC();
                } else if (taxLineInfo.getRate() == 0.081) {
                    totalTVA_8_1 = taxLineInfo.getSumTTC();
                } else if (taxLineInfo.getRate() == 0.026) {
                    totalTVA_2_6 = taxLineInfo.getSumTTC();
                }
                if ((mTax = this.mDataLogicOrder.hasTotalTaxByRateId(ticketInfo, taxLineInfo.getRate())) != null) continue;
                this.mDataLogicSales.addTotalTax(taxLineInfo, ticketInfo, ++index, documentId, ticketInfo.getLastUpdate(), 0);
            }
            TotaleEncaissement mEncaissement = this.mDataLogicOrder.hasTotalEncaissemntById(ticketInfo);
            if (mEncaissement == null) {
                this.mDataLogicSales.addTotalEncaissement(ticketInfo, documentId);
            }
            this.restReduction = ticketInfo.getTypeDiscount().equals("pourcentage") ? ticketInfo.getDiscount() * ticketInfo.getTotal() : ticketInfo.getDiscount();
            for (TicketLineInfo line : ticketInfo.getLines()) {
                Line mLine;
                if (line.isNext() || (mLine = this.mDataLogicItems.getLineByTicketIdAndLineInfo(ticketInfo, line)) != null) continue;
                this.mDataLogicSales.addLine(line, ticketInfo, documentId, 0, "1");
            }
            for (PaymentInfo p : ticketInfo.getPayments()) {
                TicketPayementNorm mPayment = this.mDataLogicItems.getPaymentNormByTicket(ticketInfo, p);
                if (mPayment != null) continue;
                this.mDataLogicSales.addTICKET_PAYMENT(ticketInfo, p, documentId, 0, "1");
            }
            if (!ticketInfo.getStatus().equals("cancel")) {
                String string = UUID.randomUUID().toString();
                Date mDateTotal = ticketInfo.getLastUpdate();
                GrandTotalTicket mGrandTotalTicket = this.mDataLogicOrder.getGrandTotalTicketById(ticketInfo);
                Double cumulPerpetualTicket = this.mDataLogicOrder.getCumulPerpetualGrandTotalBefore(mDateTotal);
                Double cumulPerpetualReelTicket = this.mDataLogicOrder.getCumulPerpetualGrandTotalReelBefore(mDateTotal);
                if (mGrandTotalTicket != null) {
                    mGrandTotalTicket.setValueByTicketType(ticketInfo.getTicketType(), cumulPerpetualTicket, cumulPerpetualReelTicket, ticketInfo.getTotal(), totalTVA5, totalTVA10, totalTVA20, totalTVA0, totalTVA_7_7, totalTVA_2_5, totalTVA_2_1, totalTVA_8_5, totalTVA_6, totalTVA_12, totalTVA_21, totalTVA_8_1, totalTVA_2_6);
                    this.mDataLogicOrder.updateGrandTotal(mGrandTotalTicket);
                }
            }
            mSession.commit();
        }
        catch (SQLException ex) {
            try {
                mSession.rollback();
            }
            catch (SQLException ex1) {
                Logger.getLogger(DataLoaderInfos.class.getName()).log(Level.SEVERE, null, ex1);
            }
            Logger.getLogger(DataLoaderInfos.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (BasicException ex) {
            try {
                mSession.rollback();
            }
            catch (SQLException ex1) {
                Logger.getLogger(DataLoaderInfos.class.getName()).log(Level.SEVERE, null, ex1);
            }
            Logger.getLogger(DataLoaderInfos.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

