/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.services;

import fr.protactile.procaisse.dao.entities.CityDeliveryInfo;
import fr.protactile.procaisse.dao.entities.ZoneDeliveryInfo;
import fr.protactile.procaisse.dao.impl.CityDeliveryInfoDao;
import fr.protactile.procaisse.dao.impl.ZoneDeliveryInfoDao;
import java.util.List;

public class ZoneDeliveryService {
    private static ZoneDeliveryService m_instance;
    private ZoneDeliveryInfoDao mZoneDeliveryInfoDao = new ZoneDeliveryInfoDao();
    private CityDeliveryInfoDao mCityDeliveryInfoDao = new CityDeliveryInfoDao();

    private ZoneDeliveryService() {
    }

    public static ZoneDeliveryService getInstance() {
        if (m_instance == null) {
            m_instance = new ZoneDeliveryService();
        }
        return m_instance;
    }

    public void save(ZoneDeliveryInfo mZoneDeliveryInfo, List<CityDeliveryInfo> cities) {
        if (mZoneDeliveryInfo.getId() != null) {
            this.mZoneDeliveryInfoDao.change(mZoneDeliveryInfo);
            for (CityDeliveryInfo city : cities) {
                city.setIdZoneDelivery(mZoneDeliveryInfo.getId());
                this.mCityDeliveryInfoDao.setZone(city);
            }
        } else {
            this.mZoneDeliveryInfoDao.save(mZoneDeliveryInfo);
            for (CityDeliveryInfo city : cities) {
                city.setIdZoneDelivery(mZoneDeliveryInfo.getId());
                this.mCityDeliveryInfoDao.setZone(city);
            }
        }
    }

    public List<ZoneDeliveryInfo> getZones() {
        List<ZoneDeliveryInfo> zones = this.mZoneDeliveryInfoDao.list();
        for (ZoneDeliveryInfo zone : zones) {
            zone.setCityCollection(this.mCityDeliveryInfoDao.findByZone(zone.getId()));
        }
        return zones;
    }

    public void delete(ZoneDeliveryInfo mZoneDeliveryInfo) {
        if (mZoneDeliveryInfo.getCityCollection() != null) {
            for (CityDeliveryInfo cityDeliveryInfo : mZoneDeliveryInfo.getCityCollection()) {
                cityDeliveryInfo.setIdZoneDelivery(0);
                this.mCityDeliveryInfoDao.setZone(cityDeliveryInfo);
            }
        }
        this.mZoneDeliveryInfoDao.remove(mZoneDeliveryInfo);
    }

    public ZoneDeliveryInfo getZoneByZipCode(String zipCode) {
        CityDeliveryInfo city = this.mCityDeliveryInfoDao.findByZipCod(zipCode);
        if (city != null) {
            return this.mZoneDeliveryInfoDao.findZoneDelivery(city.getIdZoneDelivery());
        }
        return null;
    }
}

