/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.services;

import com.openbravo.basic.BasicException;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.ticket.GroupedTax;
import com.openbravo.pos.util.DateUtils;
import com.openbravo.pos.util.LogToFile;
import fr.protactile.norm.beans.GrandTotalPeriode;
import fr.protactile.procaisse.dao.entities.ZGlobalInfo;
import fr.protactile.procaisse.dao.entities.ZGlobalInfoDTO;
import fr.protactile.procaisse.dao.entities.ZGlobalTax;
import fr.protactile.procaisse.dao.impl.ZGlobalInfoDao;
import fr.protactile.procaisse.dao.impl.ZGlobalTaxDao;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.json.JSONArray;
import org.json.JSONObject;

public class ZGlobalService {
    private static ZGlobalService m_instance;
    private ZGlobalInfoDao mZGlobalInfoDao = new ZGlobalInfoDao();
    private ZGlobalTaxDao zGlobalTaxDao = new ZGlobalTaxDao();

    private ZGlobalService() {
    }

    public static ZGlobalService getInstance() {
        if (m_instance == null) {
            m_instance = new ZGlobalService();
        }
        return m_instance;
    }

    public List<GrandTotalPeriode> getGrandTotauxPeriod() throws BasicException {
        return AppLocal.dlOrders.getGrandTotauxPeriod();
    }

    public void synchronizePeriods(List<GrandTotalPeriode> periods, String source_periode) throws BasicException, UnknownHostException {
        if (periods != null) {
            for (GrandTotalPeriode grandTotalPeriod : periods) {
                ZGlobalInfo zGlobalInfoDB;
                ZGlobalInfo mZGlobalInfo = new ZGlobalInfo();
                mZGlobalInfo.setInfos(grandTotalPeriod, source_periode, AppLocal.source_order);
                InetAddress ip_machine = InetAddress.getLocalHost();
                if (ip_machine != null) {
                    mZGlobalInfo.setAddress_ip(ip_machine.getHostAddress());
                }
                if ((zGlobalInfoDB = mZGlobalInfo.getAddress_ip() != null && mZGlobalInfo.getId_periode() != null ? this.mZGlobalInfoDao.getZGlobalByPeriodeAndEquipement(mZGlobalInfo) : null) != null) continue;
                this.save(mZGlobalInfo);
                AppLocal.dlOrders.addToZGlobal(grandTotalPeriod);
            }
        }
    }

    public void synchronizePeriods(JSONArray jsonArrayGTP) {
        for (int i = 0; i < jsonArrayGTP.length(); ++i) {
            ZGlobalInfo zGlobalInfoDB;
            JSONObject jsonObjectGTP = jsonArrayGTP.getJSONObject(i);
            ZGlobalInfo mZGlobalInfo = new ZGlobalInfo();
            mZGlobalInfo.setInfos(jsonObjectGTP);
            ZGlobalInfo zGlobalInfo = zGlobalInfoDB = mZGlobalInfo.getAddress_ip() != null && mZGlobalInfo.getId_periode() != null ? this.mZGlobalInfoDao.getZGlobalByPeriodeAndEquipement(mZGlobalInfo) : null;
            if (zGlobalInfoDB != null) continue;
            this.save(mZGlobalInfo);
        }
    }

    public void save(ZGlobalInfo mZGlobalInfo) {
        ArrayList<ZGlobalTax> taxes = new ArrayList<ZGlobalTax>();
        if (mZGlobalInfo.getGlobalTaxes() != null) {
            for (ZGlobalTax taxe : mZGlobalInfo.getGlobalTaxes()) {
                taxes.add((ZGlobalTax)taxe.clone());
            }
            mZGlobalInfo.getGlobalTaxes().clear();
        }
        this.mZGlobalInfoDao.save(mZGlobalInfo);
        for (ZGlobalTax taxe : taxes) {
            taxe.setzGlobal(mZGlobalInfo);
            this.zGlobalTaxDao.save(taxe);
        }
    }

    public void sendPeriods(List<GrandTotalPeriode> periods, String source_periode) {
        System.out.println("**************** AppLocal.IP_MASTER ************ " + AppLocal.IP_MASTER);
        if (AppLocal.IP_MASTER != null && !AppLocal.IP_MASTER.isEmpty()) {
            try {
                String reponse;
                JSONObject jsonResponse;
                JSONArray jsonArrayGTP = new JSONArray();
                InetAddress ip_machine = InetAddress.getLocalHost();
                String address_ip = ip_machine != null ? ip_machine.getHostAddress() : "";
                for (GrandTotalPeriode mGrandTotalPeriode : periods) {
                    JSONObject jsonObjectGTP = this.getJSONGTP(mGrandTotalPeriode, source_periode, address_ip);
                    jsonArrayGTP.put((Object)jsonObjectGTP);
                }
                String url = "http://" + AppLocal.IP_MASTER + ":9097/newItems/sendZGlobal";
                OkHttpClient client = new OkHttpClient();
                RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)jsonArrayGTP.toString());
                Request request = new Request.Builder().url(url).post(body).build();
                Response response = client.newCall(request).execute();
                if (response.code() == 200 && !(jsonResponse = new JSONObject(reponse = response.body().string())).isNull("error") && jsonResponse.getString("error").equalsIgnoreCase("OK")) {
                    for (GrandTotalPeriode grandTotalPeriod : periods) {
                        AppLocal.dlOrders.addToZGlobal(grandTotalPeriod);
                    }
                }
            }
            catch (Exception ex) {
                LogToFile.log("severe", null, ex);
            }
        }
    }

    private JSONObject getJSONGTP(GrandTotalPeriode mGrandTotalPeriode, String source_periode, String address_ip) {
        JSONObject jsonObjectGTP = new JSONObject();
        jsonObjectGTP.put("id_periode", (Object)mGrandTotalPeriode.getId());
        jsonObjectGTP.put("type_periode", (Object)mGrandTotalPeriode.getTypePeriode());
        jsonObjectGTP.put("total", mGrandTotalPeriode.getCumul());
        jsonObjectGTP.put("tva_5_5", mGrandTotalPeriode.getTva5());
        jsonObjectGTP.put("tva_10", mGrandTotalPeriode.getTva10());
        jsonObjectGTP.put("tva_20", mGrandTotalPeriode.getTva20());
        jsonObjectGTP.put("tva_0", mGrandTotalPeriode.getTva0());
        jsonObjectGTP.put("tva_7_7", mGrandTotalPeriode.getTva_7_7());
        jsonObjectGTP.put("tva_2_5", mGrandTotalPeriode.getTva_2_5());
        jsonObjectGTP.put("tva_2_1", mGrandTotalPeriode.getTva_2_1());
        jsonObjectGTP.put("tva_8_5", mGrandTotalPeriode.getTva_8_5());
        jsonObjectGTP.put("tva_5_5_ht", mGrandTotalPeriode.getTva_5_5_ht());
        jsonObjectGTP.put("tva_10_ht", mGrandTotalPeriode.getTva_10_ht());
        jsonObjectGTP.put("tva_20_ht", mGrandTotalPeriode.getTva_20_ht());
        jsonObjectGTP.put("tva_0_ht", mGrandTotalPeriode.getTva_0_ht());
        jsonObjectGTP.put("tva_7_7_ht", mGrandTotalPeriode.getTva_7_7_ht());
        jsonObjectGTP.put("tva_2_5_ht", mGrandTotalPeriode.getTva_2_5_ht());
        jsonObjectGTP.put("tva_2_1_ht", mGrandTotalPeriode.getTva_2_1_ht());
        jsonObjectGTP.put("tva_8_5_ht", mGrandTotalPeriode.getTva_8_5_ht());
        jsonObjectGTP.put("cash_total", mGrandTotalPeriode.getCash_total());
        jsonObjectGTP.put("cb_total", mGrandTotalPeriode.getCb_total());
        jsonObjectGTP.put("tr_total", mGrandTotalPeriode.getTr_total());
        jsonObjectGTP.put("debit_total", mGrandTotalPeriode.getDebit_total());
        jsonObjectGTP.put("credit_employee_total", mGrandTotalPeriode.getCredit_employee_total());
        jsonObjectGTP.put("loyalty_card", mGrandTotalPeriode.getLoyalty_card());
        jsonObjectGTP.put("cashdro_total", mGrandTotalPeriode.getCashdro_total());
        jsonObjectGTP.put("cash_glory_total", mGrandTotalPeriode.getCash_glory_total());
        jsonObjectGTP.put("virement_total", mGrandTotalPeriode.getVirement_total());
        jsonObjectGTP.put("cheque_total", mGrandTotalPeriode.getCheque_total());
        jsonObjectGTP.put("avoir_decaisse_total", mGrandTotalPeriode.getAvoir_decaisse_total());
        jsonObjectGTP.put("avoir_encaisse_total", mGrandTotalPeriode.getAvoir_encaisse_total());
        jsonObjectGTP.put("twint_total", mGrandTotalPeriode.getTwint_total());
        jsonObjectGTP.put("cheque_vacances_total", mGrandTotalPeriode.getCheque_vacances_total());
        jsonObjectGTP.put("total_orders_at_spot", mGrandTotalPeriode.getTotal_orders_at_spot());
        jsonObjectGTP.put("total_orders_take_away", mGrandTotalPeriode.getTotal_orders_take_away());
        jsonObjectGTP.put("total_orders_delivery", mGrandTotalPeriode.getTotal_orders_delivery());
        jsonObjectGTP.put("total_orders_uber", mGrandTotalPeriode.getTotal_orders_uber());
        jsonObjectGTP.put("total_orders_delivero", mGrandTotalPeriode.getTotal_orders_delivero());
        jsonObjectGTP.put("total_orders_just_eat", mGrandTotalPeriode.getTotal_orders_just_eat());
        jsonObjectGTP.put("total_orders_drive", mGrandTotalPeriode.getTotal_orders_drive());
        jsonObjectGTP.put("total_orders_smood", mGrandTotalPeriode.getTotal_orders_smood());
        jsonObjectGTP.put("number_orders", mGrandTotalPeriode.getNumber_orders());
        jsonObjectGTP.put("number_cb", mGrandTotalPeriode.getNumber_cb());
        jsonObjectGTP.put("number_tr", mGrandTotalPeriode.getNumber_tr());
        jsonObjectGTP.put("number_products_sold", mGrandTotalPeriode.getNumber_products_sold());
        jsonObjectGTP.put("turnover_canceled", mGrandTotalPeriode.getTurnover_canceled());
        jsonObjectGTP.put("total_discount", mGrandTotalPeriode.getTotal_discount());
        jsonObjectGTP.put("total_discount_lines", mGrandTotalPeriode.getTotal_discount_lines());
        jsonObjectGTP.put("source_periode", (Object)source_periode);
        jsonObjectGTP.put("host_name", (Object)AppLocal.source_order);
        jsonObjectGTP.put("address_ip", (Object)address_ip);
        jsonObjectGTP.put("turnover_platform", mGrandTotalPeriode.getTurnover_platform());
        jsonObjectGTP.put("total_orders_deliveroo", mGrandTotalPeriode.getTotal_orders_deliveroo());
        jsonObjectGTP.put("tva_6", mGrandTotalPeriode.getTva_6());
        jsonObjectGTP.put("tva_12", mGrandTotalPeriode.getTva_12());
        jsonObjectGTP.put("tva_21", mGrandTotalPeriode.getTva_21());
        jsonObjectGTP.put("tva_6_ht", mGrandTotalPeriode.getTva_6_ht());
        jsonObjectGTP.put("tva_12_ht", mGrandTotalPeriode.getTva_12_ht());
        jsonObjectGTP.put("tva_21_ht", mGrandTotalPeriode.getTva_21_ht());
        jsonObjectGTP.put("turnover_ubereat", mGrandTotalPeriode.getTurnover_ubereat());
        jsonObjectGTP.put("total_orders_dishop", mGrandTotalPeriode.getTotal_orders_dishop());
        jsonObjectGTP.put("stripe_total", mGrandTotalPeriode.getStripe_total());
        jsonObjectGTP.put("cash_logy_total", mGrandTotalPeriode.getCash_logy_total());
        jsonObjectGTP.put("tva_8_1", mGrandTotalPeriode.getTva_8_1());
        jsonObjectGTP.put("tva_2_6", mGrandTotalPeriode.getTva_2_6());
        jsonObjectGTP.put("tva_8_1_ht", mGrandTotalPeriode.getTva_8_1_ht());
        jsonObjectGTP.put("tva_2_6_ht", mGrandTotalPeriode.getTva_2_6_ht());
        jsonObjectGTP.put("tps", mGrandTotalPeriode.getTps());
        jsonObjectGTP.put("tvq", mGrandTotalPeriode.getTvq());
        jsonObjectGTP.put("credit_card_total", mGrandTotalPeriode.getCredit_card_total());
        jsonObjectGTP.put("debit_card_total", mGrandTotalPeriode.getDebit_card_total());
        jsonObjectGTP.put("total_ht_taxable", mGrandTotalPeriode.getTotal_ht_taxable());
        jsonObjectGTP.put("total_ht_no_taxable", mGrandTotalPeriode.getTotal_ht_no_taxable());
        JSONArray groupedTaxesArray = new JSONArray();
        for (GroupedTax gtpTaxe : mGrandTotalPeriode.getGtpTaxes()) {
            JSONObject globalTaxObject = new JSONObject();
            globalTaxObject.put("code_tax", (Object)gtpTaxe.getCode_taxe());
            globalTaxObject.put("name", (Object)gtpTaxe.getName());
            globalTaxObject.put("rate", gtpTaxe.getRate());
            globalTaxObject.put("total_tax", gtpTaxe.getTotal_tax());
            groupedTaxesArray.put((Object)globalTaxObject);
        }
        jsonObjectGTP.put("grouped_taxes", (Object)groupedTaxesArray);
        jsonObjectGTP.put("total_ht_orders_at_spot", mGrandTotalPeriode.getTotal_ht_orders_at_spot());
        jsonObjectGTP.put("total_ht_orders_take_away", mGrandTotalPeriode.getTotal_ht_orders_take_away());
        jsonObjectGTP.put("total_ht_orders_delivery", mGrandTotalPeriode.getTotal_ht_orders_delivery());
        jsonObjectGTP.put("total_ht_orders_drive", mGrandTotalPeriode.getTotal_ht_orders_drive());
        jsonObjectGTP.put("number_orders_at_spot", mGrandTotalPeriode.getNumber_orders_at_spot());
        jsonObjectGTP.put("number_orders_take_away", mGrandTotalPeriode.getNumber_orders_take_away());
        jsonObjectGTP.put("number_orders_delivery", mGrandTotalPeriode.getNumber_orders_delivery());
        jsonObjectGTP.put("number_orders_drive", mGrandTotalPeriode.getNumber_orders_drive());
        jsonObjectGTP.put("carte_tr_total", mGrandTotalPeriode.getCarte_tr_total());
        jsonObjectGTP.put("bank_transfer_total", mGrandTotalPeriode.getBank_transfer_total());
        jsonObjectGTP.put("number_carte_tr", mGrandTotalPeriode.getNumber_carte_tr());
        return jsonObjectGTP;
    }

    public List<ZGlobalInfoDTO> getZglobal(String idPeriod, String typPeriod, List<String> equipements_address) {
        List<ZGlobalInfoDTO> list = this.mZGlobalInfoDao.getZGlobal(idPeriod, typPeriod, equipements_address);
        if (list != null) {
            for (ZGlobalInfoDTO zGlobalInfoDTO : list) {
                zGlobalInfoDTO.setType_periode("j");
            }
        }
        return list;
    }

    public List<ZGlobalInfoDTO> getZglobal(int month, int year, List<String> equipements_address) {
        StringBuilder gtpID = new StringBuilder();
        gtpID.append(year);
        gtpID.append(DateUtils.formatMonth(String.valueOf(month)));
        gtpID.append("%");
        List<ZGlobalInfoDTO> list = this.getZglobal(gtpID.toString(), "j", equipements_address);
        if (list != null) {
            for (ZGlobalInfoDTO zGlobalInfoDTO : list) {
                zGlobalInfoDTO.setType_periode("j");
            }
        }
        return list;
    }

    public List<ZGlobalInfoDTO> getZglobal(int year, List<String> equipements_address) {
        StringBuilder gtpID = new StringBuilder();
        gtpID.append(year);
        gtpID.append("%");
        List<ZGlobalInfoDTO> list = this.mZGlobalInfoDao.getZGlobal(gtpID.toString(), "m", equipements_address);
        if (list != null) {
            for (ZGlobalInfoDTO zGlobalInfoDTO : list) {
                zGlobalInfoDTO.setType_periode("m");
            }
        }
        return list;
    }

    public ZGlobalInfoDTO getZglobal(String id_periode, List<String> equipements_address) {
        ZGlobalInfoDTO result = this.mZGlobalInfoDao.getZGlobal(id_periode, equipements_address);
        return result;
    }

    public void addToZGlobal(String source_cloture) {
        List<GrandTotalPeriode> periods;
        System.out.println("++++++++ addToZGlobal ***************");
        if (AppLocal.MODEL_CAISSE != null && AppLocal.MODEL_CAISSE.equalsIgnoreCase("Esclave")) {
            try {
                System.out.println("++++++++ start :  addToZGlobal " + new Date());
                periods = this.getGrandTotauxPeriod();
                if (periods != null) {
                    System.out.println("++++ periods size : " + periods.size());
                }
                this.sendPeriods(periods, source_cloture);
            }
            catch (BasicException ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
        System.out.println("AppLocal.MODEL_CAISSE : " + AppLocal.MODEL_CAISSE);
        if (AppLocal.MODEL_CAISSE != null && AppLocal.MODEL_CAISSE.equalsIgnoreCase("Maitre")) {
            try {
                System.out.println("++++++++ start : " + new Date());
                periods = this.getGrandTotauxPeriod();
                System.out.println("++++++++++ size z global : " + periods.size());
                this.synchronizePeriods(periods, source_cloture);
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    public ZGlobalInfoDTO getXglobal(List<String> equipements_address) {
        Date date = new Date();
        if (date.getDate() > 1) {
            StringBuilder gtpID = new StringBuilder();
            gtpID.append(DateUtils.SDF_ID_MONTH_PERIOD.format(date));
            gtpID.append("%");
            ZGlobalInfoDTO result = this.mZGlobalInfoDao.getXglobal(gtpID.toString(), "j", equipements_address);
            if (result != null) {
                result.setType_periode("m");
                result.setId_periode(gtpID.toString());
                result.setRapport_title(" X global ");
            }
            return result;
        }
        return null;
    }
}

