/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.services;

import fr.protactile.procaisse.dao.entities.UberEatTimeTableInfo;
import fr.protactile.procaisse.dao.entities.UberEatWorkShiftInfo;
import fr.protactile.procaisse.dao.impl.UberEatTimeTableInfoDao;
import fr.protactile.procaisse.dao.impl.UberEatWorkShiftInfoDao;
import java.util.ArrayList;
import java.util.List;

public class UberEatTimeTableService {
    private static UberEatTimeTableService m_instance;
    private UberEatTimeTableInfoDao mUberEatTimeTableInfoDao = new UberEatTimeTableInfoDao();
    private UberEatWorkShiftInfoDao mUberEatWorkShiftInfoDao = new UberEatWorkShiftInfoDao();
    private final String MONDAY = "monday";
    private final String TUESDAY = "tuesday";
    private final String WEDNESDAY = "wednesday";
    private final String THURSDAY = "thursday";
    private final String FRIDAY = "friday";
    private final String SATURDAY = "saturday";
    private final String SUNDAY = "sunday";
    private final String START_SHIFT = "00:00";
    private final String END_SHIFT = "23:59";

    private UberEatTimeTableService() {
    }

    public static UberEatTimeTableService getInstance() {
        if (m_instance == null) {
            m_instance = new UberEatTimeTableService();
        }
        return m_instance;
    }

    public UberEatTimeTableInfo save(UberEatTimeTableInfo mUberEatTimeTableInfo) {
        this.mUberEatTimeTableInfoDao.save(mUberEatTimeTableInfo);
        this.addWorkShift(mUberEatTimeTableInfo);
        return mUberEatTimeTableInfo;
    }

    public List<UberEatTimeTableInfo> getTimesTable() {
        this.mUberEatTimeTableInfoDao.getCurrentSession();
        this.mUberEatTimeTableInfoDao.clear();
        List<UberEatTimeTableInfo> timesTable = this.mUberEatTimeTableInfoDao.list();
        if (timesTable == null || timesTable.isEmpty()) {
            this.save(new UberEatTimeTableInfo("monday", false, "00:00", "23:59"));
            this.save(new UberEatTimeTableInfo("tuesday", false, "00:00", "23:59"));
            this.save(new UberEatTimeTableInfo("wednesday", false, "00:00", "23:59"));
            this.save(new UberEatTimeTableInfo("thursday", false, "00:00", "23:59"));
            this.save(new UberEatTimeTableInfo("friday", false, "00:00", "23:59"));
            this.save(new UberEatTimeTableInfo("saturday", false, "00:00", "23:59"));
            this.save(new UberEatTimeTableInfo("sunday", false, "00:00", "23:59"));
            timesTable = this.mUberEatTimeTableInfoDao.list();
        } else {
            boolean reload = false;
            for (UberEatTimeTableInfo timeTable : timesTable) {
                if (timeTable.getWorkShiftCollection() == null || timeTable.getWorkShiftCollection().isEmpty()) {
                    this.addWorkShift(timeTable);
                    reload = true;
                    continue;
                }
                if (timeTable.getWorkShiftCollection().size() >= 3) continue;
                this.mUberEatWorkShiftInfoDao.save(new UberEatWorkShiftInfo("", "", timeTable));
                reload = true;
            }
            if (reload) {
                timesTable = this.mUberEatTimeTableInfoDao.list();
            }
        }
        return timesTable;
    }

    public void update(List<UberEatTimeTableInfo> timesTable) {
        for (UberEatTimeTableInfo timeTableInfo : timesTable) {
            this.mUberEatTimeTableInfoDao.changeTable(timeTableInfo);
            if (timeTableInfo.getWorkShiftCollection() == null) continue;
            for (UberEatWorkShiftInfo workShiftInfo : timeTableInfo.getWorkShiftCollection()) {
                if (workShiftInfo.getId() == null) {
                    workShiftInfo.setTimetable(timeTableInfo);
                    this.mUberEatWorkShiftInfoDao.save(workShiftInfo);
                    continue;
                }
                this.mUberEatWorkShiftInfoDao.updateWorkShift(workShiftInfo);
            }
        }
    }

    public void addWorkShift(UberEatTimeTableInfo mUberEatTimeTableInfo) {
        ArrayList<UberEatWorkShiftInfo> workShifts = new ArrayList<UberEatWorkShiftInfo>();
        workShifts.add(new UberEatWorkShiftInfo("00:00", "23:59", mUberEatTimeTableInfo));
        workShifts.add(new UberEatWorkShiftInfo("", "", mUberEatTimeTableInfo));
        workShifts.add(new UberEatWorkShiftInfo("", "", mUberEatTimeTableInfo));
        for (UberEatWorkShiftInfo workShiftInfo : workShifts) {
            this.mUberEatWorkShiftInfoDao.save(workShiftInfo);
        }
        mUberEatTimeTableInfo.setWorkShiftCollection(workShifts);
    }
}

