/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.services;

import com.openbravo.controlFX.TransactionMoneyView;
import com.openbravo.format.Formats;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.forms.AppView;
import com.openbravo.pos.ticket.UserInfo;
import fr.protactile.procaisse.dao.entities.PeopleInfo;
import fr.protactile.procaisse.dao.entities.TransactionMoney;
import fr.protactile.procaisse.dao.impl.TransactionMoneyDao;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class TransactionMoneyService {
    private static TransactionMoneyService INSTANCE;
    private TransactionMoneyDao dao = new TransactionMoneyDao();
    public final String TERMINAL_GLORY = "glory";
    public final String TRANSACTION_VENTE = "Vente";
    public final String TRANSACTION_ERROR_100 = "d\u00e9phasage compteur";
    public final String TRANSACTION_REFUND = "Remboursement";
    public final String TRANSACTION_CANCEL = "Annulation";
    public final String TRANSACTION_RESET = "R\u00e9enitialisation";
    public final String TRANSACTION_REBOOT = "Red\u00e9marage";
    public final String TRANSACTION_UNLOCK = "d\u00e9verrouillage";
    public final String TRANSACTION_EXTRACTION = "Sortie argent";
    public final String TRANSACTION_REPLENISH = "Entr\u00e9e argent";
    public final String TRANSACTION_COLLECT = "Collect vers Cassettes";
    public final String TRANSACTION_TAKING_CST = "pr\u00e9l\u00e8vement de Cassette";
    public final String TRANSACTION_COLLECT_SURPLUS = "Collect du surplus";
    public final String TRANSACTION_COLLECT_ALL = "Vidage du Monnayeur";
    public final String TRANSACTION_COLLECT_VERIFICATION = "Collect de v\u00e9rification";
    public final String TRANSACTION_COLLECT_LOST_MONEY = "Argents perdus";
    private AppView m_App;

    private TransactionMoneyService(AppView m_App) {
        this.m_App = m_App;
    }

    public static TransactionMoneyService getInstance(AppView m_App) {
        if (INSTANCE == null) {
            INSTANCE = new TransactionMoneyService(m_App);
        }
        return INSTANCE;
    }

    public void saveTransaction(TransactionMoney tm) {
        this.dao.saveTransactionMoney(tm);
    }

    public PeopleInfo getCurrentUser() {
        PeopleInfo mPeopleInfo = null;
        if (this.m_App.getAppUserView() != null && this.m_App.getAppUserView().getUser() != null) {
            mPeopleInfo = new PeopleInfo(this.m_App.getAppUserView().getUser().getUserInfo().getId());
        } else {
            UserInfo userInfo = new UserInfo(AppLocal.user != null ? AppLocal.user : AppLocal.user_maintenance);
            mPeopleInfo = new PeopleInfo(userInfo.getId());
        }
        return mPeopleInfo;
    }

    public void saveVenteGloryTransaction(double amount, String description) {
        TransactionMoney tm = new TransactionMoney("glory", "Vente", amount, new Date(), description, this.getCurrentUser());
        this.saveTransaction(tm);
    }

    public void saveReplenishGloryTransaction(double amount, String description) {
        TransactionMoney tm = new TransactionMoney("glory", "Entr\u00e9e argent", amount, new Date(), description, this.getCurrentUser());
        this.saveTransaction(tm);
    }

    public void saveExtractGloryTransaction(double amount, String description) {
        TransactionMoney tm = new TransactionMoney("glory", "Sortie argent", amount, new Date(), description, this.getCurrentUser());
        this.saveTransaction(tm);
    }

    public void saveCollectSurPlusGloryTransaction(double amount, String description) {
        TransactionMoney tm = new TransactionMoney("glory", "Collect du surplus", amount, new Date(), description, this.getCurrentUser());
        this.saveTransaction(tm);
    }

    public void saveCollectAllGloryTransaction(double amount, String description) {
        TransactionMoney tm = new TransactionMoney("glory", "Vidage du Monnayeur", amount, new Date(), description, this.getCurrentUser());
        this.saveTransaction(tm);
    }

    public void saveCollectVerificationGloryTransaction(double amount, String description) {
        TransactionMoney tm = new TransactionMoney("glory", "Collect de v\u00e9rification", amount, new Date(), description, this.getCurrentUser());
        this.saveTransaction(tm);
    }

    public void saveLostAmountGloryTransaction(double amount, String description) {
        TransactionMoney tm = new TransactionMoney("glory", "Argents perdus", amount, new Date(), description, this.getCurrentUser());
        this.saveTransaction(tm);
    }

    public void saveCollectGloryTransaction(double amount, String description) {
        TransactionMoney tm = new TransactionMoney("glory", "Collect vers Cassettes", amount, new Date(), description, this.getCurrentUser());
        this.saveTransaction(tm);
    }

    public void saveRefundGloryTransaction(double amount, String description) {
        TransactionMoney tm = new TransactionMoney("glory", "Remboursement", amount, new Date(), description, this.getCurrentUser());
        this.saveTransaction(tm);
    }

    public void saveResetGloryTransaction(String description) {
        TransactionMoney tm = new TransactionMoney("glory", "R\u00e9enitialisation", 0.0, new Date(), description, this.getCurrentUser());
        this.saveTransaction(tm);
    }

    public void saveRebootGloryTransaction(String description) {
        TransactionMoney tm = new TransactionMoney("glory", "Red\u00e9marage", 0.0, new Date(), description, this.getCurrentUser());
        this.saveTransaction(tm);
    }

    public void saveUnlockGloryTransaction(String description) {
        TransactionMoney tm = new TransactionMoney("glory", "d\u00e9verrouillage", 0.0, new Date(), description, this.getCurrentUser());
        this.saveTransaction(tm);
    }

    public void saveTakingCSTGloryTransaction(double amount, String description, String transaction) {
        TransactionMoney tm = new TransactionMoney("glory", transaction, amount, new Date(), description, this.getCurrentUser());
        this.saveTransaction(tm);
    }

    public List<TransactionMoney> getTransactionByTerminal(String terminal) {
        return this.dao.findByTerminal(terminal);
    }

    public List<TransactionMoney> getTransactionGlory() {
        return this.dao.findByTerminal("glory");
    }

    public List<TransactionMoney> getTransactionGloryBetween(Date dd, Date df) {
        return this.dao.findTransactionByTerminalAndBetween("glory", dd, df);
    }

    public void saveCancelGloryTransaction(double amount, String description) {
        TransactionMoney tm = new TransactionMoney("glory", "Annulation", amount, new Date(), description, this.getCurrentUser());
        this.saveTransaction(tm);
    }

    public void save100ErrorTransaction(double amount, String description) {
        TransactionMoney tm = new TransactionMoney("glory", "d\u00e9phasage compteur", amount, new Date(), description, this.getCurrentUser());
        this.saveTransaction(tm);
    }

    public ObservableList<TransactionMoneyView> getOListTransactionGloryBetween(Date dd, Date df) {
        System.out.println("_____dd" + dd);
        System.out.println("_____df" + df);
        List<TransactionMoney> items = this.getTransactionGloryBetween(dd, df);
        ArrayList<TransactionMoneyView> itemsView = new ArrayList<TransactionMoneyView>();
        for (int i = 0; i < items.size(); ++i) {
            TransactionMoney item = items.get(i);
            TransactionMoneyView view = new TransactionMoneyView(item.getId(), item.getLibelle(), item.getAmount(), Formats.DATE.formatValue(item.getTimestampgdh()), Formats.HOURMIN.formatValue(item.getTimestampgdh()), item.getDescription(), item.getUser().getName(), item);
            itemsView.add(view);
        }
        return FXCollections.observableArrayList(itemsView);
    }
}

