/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.services;

import fr.protactile.procaisse.dao.entities.TimeTableInfo;
import fr.protactile.procaisse.dao.entities.WorkShiftInfo;
import fr.protactile.procaisse.dao.impl.TimeTableInfoDao;
import fr.protactile.procaisse.dao.impl.WorkShiftInfoDao;
import java.util.ArrayList;
import java.util.List;

public class TimeTableService {
    private static TimeTableService m_instance;
    private TimeTableInfoDao mTimeTableInfoDao = new TimeTableInfoDao();
    private WorkShiftInfoDao mWorkShiftInfoDao = new WorkShiftInfoDao();

    private TimeTableService() {
    }

    public static TimeTableService getInstance() {
        if (m_instance == null) {
            m_instance = new TimeTableService();
        }
        return m_instance;
    }

    public TimeTableInfo save(TimeTableInfo mTimeTableInfo) {
        this.mTimeTableInfoDao.save(mTimeTableInfo);
        ArrayList<WorkShiftInfo> workShifts = new ArrayList<WorkShiftInfo>();
        workShifts.add(new WorkShiftInfo("", "", mTimeTableInfo));
        workShifts.add(new WorkShiftInfo("", "", mTimeTableInfo));
        for (WorkShiftInfo workShiftInfo : workShifts) {
            this.mWorkShiftInfoDao.save(workShiftInfo);
        }
        return mTimeTableInfo;
    }

    public List<TimeTableInfo> getTimesTable() {
        List timesTableTmp = this.mTimeTableInfoDao.list();
        if (timesTableTmp == null || timesTableTmp.isEmpty()) {
            this.save(new TimeTableInfo(1, "Lundi", false));
            this.save(new TimeTableInfo(2, "Mardi", false));
            this.save(new TimeTableInfo(3, "Mercredi", false));
            this.save(new TimeTableInfo(4, "Jeudi", false));
            this.save(new TimeTableInfo(5, "Vendredi", false));
            this.save(new TimeTableInfo(6, "Samedi", false));
            this.save(new TimeTableInfo(7, "Dimanche", false));
        }
        List<TimeTableInfo> timesTable = this.mTimeTableInfoDao.list();
        for (TimeTableInfo timeTableInfo : timesTable) {
            if (timeTableInfo.getWorkShiftCollection() != null && !timeTableInfo.getWorkShiftCollection().isEmpty()) {
                timeTableInfo.getWorkShiftCollection().clear();
            }
            timeTableInfo.setWorkShiftCollection(this.mWorkShiftInfoDao.getWorkShifts(timeTableInfo.getId()));
        }
        return timesTable;
    }

    public void update(List<TimeTableInfo> timesTable) {
        for (TimeTableInfo timeTableInfo : timesTable) {
            this.mTimeTableInfoDao.changeTable(timeTableInfo);
            if (timeTableInfo.getWorkShiftCollection() == null) continue;
            for (WorkShiftInfo workShiftInfo : timeTableInfo.getWorkShiftCollection()) {
                if (workShiftInfo.getId() == null) {
                    workShiftInfo.setTimetable(timeTableInfo);
                    this.mWorkShiftInfoDao.save(workShiftInfo);
                    continue;
                }
                this.mWorkShiftInfoDao.updateWorkShift(workShiftInfo);
            }
        }
    }
}

