/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.services;

import com.openbravo.basic.BasicException;
import com.openbravo.pos.forms.AppConfig;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.ticket.MarqueNFC;
import com.openbravo.pos.ticket.PhotoDispaly;
import com.openbravo.pos.util.ColorUtils;
import com.openbravo.pos.util.DateUtils;
import com.openbravo.pos.util.FilerUtils;
import com.openbravo.pos.util.LogToFile;
import com.procaisse.db.connection.firebase.FirebaseService;
import fr.protactile.procaisse.dao.entities.SettingBorne;
import fr.protactile.procaisse.dao.entities.SettingInfo;
import fr.protactile.procaisse.dao.impl.SettingBorneDao;
import fr.protactile.procaisse.dao.impl.SettingInfoDao;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.io.FileUtils;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.json.JSONArray;
import org.json.JSONObject;

public class SettingService {
    private static SettingService m_instance;
    private SettingBorneDao mSettingBorneDao;
    private SettingInfoDao mSettingInfoDao;
    private final String franchise_id;
    private final String URL_SETTINGS = "https://api-backoffice.biborne.com/api/restos/findonecaisse/";
    private final String HIDE_NAME_CAT_BORNE = "cacher_noms_categories_borne";
    private final String NAME_FRANCHISE = "franchise_name";
    private final String HIDE_NAME_SUB_CAT_BORNE = "cacher_noms_sous_categories_borne";
    private final String HIDE_NAME_PRODUCT_BORNE = "cacher_noms_produits_borne";
    private final String HIDE_TYPE_COMMANDE = "cacher_type_commande";
    private final String HIDE_FOND_BLOC_PRICE = "cacher_fond_bloc_prix";
    private final String ING_BEFOR_OPTION = "mettre_ingredients_avant_options";
    private final String HIDE_BUTTON_PAGE_BORNE = "cacher_bouton_page_de_page_borne";
    private final String BARRE_LITTERAL = "barre_laterale";
    private final String PRICE_POSITION = "position_prix";
    private final String TYPE_BORNE = "type_borne";
    private final String TYPE_MEDIA_HOME = "type";
    private final String FRANCHISE_NAME = "franchise_name";
    private final String RESIZE_IMG_WITH_FIXER = "resize_img_par_fixer";
    private final String IMP_COMMANDE_WITH = "imprimer_commande_avec";
    private final String IMP_DESCRIPTION_PRODUCT = "imprimer_description_produits";
    private final String PRINT_DESCRIPTION_PRODUCT_BORNE = "afficher_description_produits_borne";
    private final String HIDE_INGREDIENT = "cacher_ingredients";
    private final String HIDE_INGREDIENT_SUB_PRODUCT = "cacher_ingredients_sous_produits";
    private final String BACKGROUND_SUMMARY_ORDER = "background_summary_order";
    private final String BACKGROUND_CATALOG = "background_catalog";
    private final String VIDEO = "video";
    private final String BACKGROUND_TYPE = "background_type";
    private final String IMAGE_AT_SPOT = "image_at_spot";
    private final String IMAGE_TAKE_AWAY = "image_take_away";
    private final String LOGO_BORNE = "logo_borne";
    private final String CATALOG_BACKGOUND_COLOR = "catalog_background_color";
    private final String BASKET_TEXT_COLOR = "basket_text_color";
    private final String PRICE_TEXT_COLOR = "price_text_color";
    private final String BORNE_COLOR2 = "borne_color2";
    private final String CATEGORY_TEXT_COLOR = "category_text_color";
    private final String ORDER_TYPE_TEXT_COLOR = "order_type_text_color";
    private final String CATALOG_TEXT_COLOR = "catalog_text_color";
    private final String BORNE_TEXT_COLOR = "borne_text_color";
    private final String BORNE_COLOR1 = "borne_color1";
    private final String ITEMS_TEXT_COLOR = "items_text_color";
    private final String ITEMS_BACKGOUND_COLOR = "items_background_color";
    private final String BACKGROUND_SUMMARY_ORDER_PROMO = "background_summary_order_promo";
    private final String BACKGROUND_VALID_ORDER = "background_valid_order";
    private final String STR_WS_IMAGE_AT_SPOT = "imageAtspot";
    private final String STR_WS_BACKGROUND_CATALOG = "imageCatalog";
    private final String STR_WS_BACKGROUND_SUMMARY_ORDER = "imageSumorder";
    private final String STR_WS_BACKGROUND_TYPE = "imageType";
    private final String STR_WS_IMAGE_TAKE_AWAY = "imageTakeaway";
    private final String STR_WS_BACKGROUND_SUMMARY_ORDER_PROMO = "imageSumorderpromo";
    private final String STR_WS_BACKGROUND_VALID_ORDER = "imageValidorder";
    private final String STR_WS_LOGO_BORNE = "Logo";
    private final String STR_WS_VIDEO = "Video";
    private final String IMAGE_URL = "image_url";
    private final String NAME_IMAGE = "name";
    private final String UPDATEDAT = "updatedAt";
    private LinkedHashMap<String, String> mediaMap;
    private ArrayList<PhotoDispaly> HomemediaMapImage;
    private final String VIDEO_URL = "video_url";
    private final String VIDEO_NAME = "video_name";
    private final String BORNE_PARAM = "borneparam";
    private final String PARAM_HOMEBORNE = "param_homeborne";
    private final String IMAGES_HOMEBORNE = "images_homeborne";
    private final String VIDEO_HOMEBORNE = "video_homeborne";
    private List<String> colorMap;
    private List<String> settingBorneMap;
    private List<String> settingMap;
    private AppConfig appConfig;
    private LinkedHashMap<String, Integer> mapPositions = new LinkedHashMap();
    private final String TYPE_TARIF = "type_tarif";
    private FirebaseService mFirebaseService = null;
    private final String ARRIERE_PLAN_IMAGES_TYPE_COMMANDE_TRANSPARENTE = "arriere_plan_images_type_commande_transparente";
    private final String IMAGE_AT_SPOT_FR = "image_at_spot_fr";
    private final String IMAGE_AT_SPOT_AR = "image_at_spot_ar";
    private final String IMAGE_AT_SPOT_EN = "image_at_spot_en";
    private final String IMAGE_AT_SPOT_ES = "image_at_spot_es";
    private final String IMAGE_TAKE_AWAY_FR = "image_take_away_fr";
    private final String IMAGE_TAKE_AWAY_AR = "image_take_away_ar";
    private final String IMAGE_TAKE_AWAY_EN = "image_take_away_en";
    private final String IMAGE_TAKE_AWAY_ES = "image_take_away_es";
    private final String BG_COLOR_PRICE = "bg_color_price";
    private final String COLOR_SELECTED_CATEGORY = "color_selected_category";
    private final String BG_COLOR_TEXT_SUB_CATEGORIES = "bg_color_text_sub_categories";
    private final String BG_COLOR_IMAGE_SUB_CATEGORIES = "bg_color_image_sub_categories";
    private final String TEXT_COLOR_SUB_CATEGORIES = "text_color_sub_categories";
    private final String BG_COLOR_IMAGE_PRODUCT = "bg_color_image_product";
    private final String TEXT_COLOR_TOTAL_ORDER = "text_color_total_order";
    private final String BG_COLOR_CODE_PROMO = "bg_color_code_promo";
    private final String BG_COLOR_BUTTON_VALIDATION = "bg_color_button_validation";
    private final String BG_COLOR_TYPE_PAYMENT = "bg_color_type_payment";
    private final String ICON_CB = "icon_cb";
    private final String ICON_COUNTER = "icon_counter";
    private final String STR_WS_ICON_CB = "iconCB";
    private final String STR_WS_ICON_COUNTER = "iconCounter";
    private final String BG_COLOR_BUTTON_CANCEL = "bg_color_button_cancel";
    private final String TEXT_COLOR_BUTTON_CANCEL = "text_color_button_cancel";
    private final String STR_WS_ICON_NEXT = "iconNext";
    private final String STR_WS_ICON_PREVIOUS = "iconPrevious";
    private final String ICON_NEXT = "icon_next";
    private final String ICON_PREVIOUS = "icon_previous";
    private final String STR_COLOR = "color";
    private final String STR_IS_TRANSPARENT = "isTransparent";
    private final String HIDE_BACKGROUND_IMAGE_PRODUCT = "hide_background_image_product";
    private final String HIDE_BACKGROUND_NAME_PRODUCT = "hide_background_name_product";
    private final String HIDE_BACKGROUND_IMAGE_SUB_CATEGORY = "hide_background_image_sub_category";
    private final String HIDE_BACKGROUND_NAME_SUB_CATEGORY = "hide_background_name_sub_category";
    private final String HIDE_BACKGROUND_PRICE = "hide_background_price";
    private final String STR_WS_IMAGE_PRODUCT_MOMENT = "product_moment";
    private final String IMAGE_PRODUCT_MOMENT = "product_moment";
    private final String IMAGE_PRODUCT_MOMENT_FR = "product_moment_fr";
    private final String IMAGE_PRODUCT_MOMENT_AR = "product_moment_ar";
    private final String IMAGE_PRODUCT_MOMENT_EN = "product_moment_en";
    private final String IMAGE_PRODUCT_MOMENT_ES = "product_moment_es";
    private final String PRODUCT_MOMENT_ADVANCED = "product_moment_advanced";
    private final String STR_WS_BACKGROUND_TYPE_PAYMENT = "bg_type_payment";
    private final String BACKGROUND_TYPE_PAYMENT = "bg_type_payment";
    private final String BACKGROUND_TYPE_PAYMENT_FR = "bg_type_payment_fr";
    private final String BACKGROUND_TYPE_PAYMENT_AR = "bg_type_payment_ar";
    private final String BACKGROUND_TYPE_PAYMENT_EN = "bg_type_payment_en";
    private final String BACKGROUND_TYPE_PAYMENT_ES = "bg_type_payment_es";
    private final String BACKGROUND_CATALOG_FR = "background_catalog_fr";
    private final String BACKGROUND_CATALOG_AR = "background_catalog_ar";
    private final String BACKGROUND_CATALOG_EN = "background_catalog_en";
    private final String BACKGROUND_CATALOG_ES = "background_catalog_es";
    private final String STR_WS_IMAGE_INSERT_CARD = "image_insert_card";
    private final String IMAGE_INSERT_CARD = "image_insert_card";
    private final String IMAGE_INSERT_CARD_FR = "image_insert_card_fr";
    private final String IMAGE_INSERT_CARD_AR = "image_insert_card_ar";
    private final String IMAGE_INSERT_CARD_EN = "image_insert_card_en";
    private final String IMAGE_INSERT_CARD_ES = "image_insert_card_es";
    private final String STR_WS_IMAGE_VALID_ORDER_COUNTER = "image_valid_order_counter";
    private final String IMAGE_VALID_ORDER_COUNTER = "image_valid_order_counter";
    private final String IMAGE_VALID_ORDER_COUNTER_FR = "image_valid_order_counter_fr";
    private final String IMAGE_VALID_ORDER_COUNTER_AR = "image_valid_order_counter_ar";
    private final String IMAGE_VALID_ORDER_COUNTER_EN = "image_valid_order_counter_en";
    private final String IMAGE_VALID_ORDER_COUNTER_ES = "image_valid_order_counter_es";
    private final String STR_WS_IMAGE_VALID_ORDER_CB = "image_valid_order_cb";
    private final String IMAGE_VALID_ORDER_CB = "image_valid_order_cb";
    private final String IMAGE_VALID_ORDER_CB_FR = "image_valid_order_cb_fr";
    private final String IMAGE_VALID_ORDER_CB_AR = "image_valid_order_cb_ar";
    private final String IMAGE_VALID_ORDER_CB_EN = "image_valid_order_cb_en";
    private final String IMAGE_VALID_ORDER_CB_ES = "image_valid_order_cb_es";
    private final String SIZE_TEXT_NUMBER_ORDER_CB = "size_text_number_order_cb";
    private final String COLOR_TEXT_NUMBER_ORDER_CB = "color_text_number_order_cb";
    private final String BACKGROUND_ITEMS_LATER = "background_items_later";
    private final String STR_WS_BACKGROUND_ITEMS_LATER = "imageItemsLater";

    private SettingService() {
        this.mSettingBorneDao = new SettingBorneDao();
        this.mSettingInfoDao = new SettingInfoDao();
        this.HomemediaMapImage = new ArrayList();
        this.mediaMap = new LinkedHashMap();
        this.mediaMap.put("imageAtspot", "image_at_spot");
        this.mediaMap.put("imageCatalog", "background_catalog");
        this.mediaMap.put("imageSumorder", "background_summary_order");
        this.mediaMap.put("imageType", "background_type");
        this.mediaMap.put("imageTakeaway", "image_take_away");
        this.mediaMap.put("imageSumorderpromo", "background_summary_order_promo");
        this.mediaMap.put("imageValidorder", "background_valid_order");
        this.mediaMap.put("Logo", "logo_borne");
        this.mediaMap.put("iconCB", "icon_cb");
        this.mediaMap.put("iconCounter", "icon_counter");
        this.mediaMap.put("iconNext", "icon_next");
        this.mediaMap.put("iconPrevious", "icon_previous");
        this.mediaMap.put("product_moment", "product_moment");
        this.mediaMap.put("bg_type_payment", "bg_type_payment");
        this.mediaMap.put("image_insert_card", "image_insert_card");
        this.mediaMap.put("image_valid_order_counter", "image_valid_order_counter");
        this.mediaMap.put("image_valid_order_cb", "image_valid_order_cb");
        this.mediaMap.put("imageItemsLater", "background_items_later");
        this.colorMap = new ArrayList<String>();
        this.colorMap.add("catalog_background_color");
        this.colorMap.add("basket_text_color");
        this.colorMap.add("price_text_color");
        this.colorMap.add("borne_color2");
        this.colorMap.add("category_text_color");
        this.colorMap.add("order_type_text_color");
        this.colorMap.add("catalog_text_color");
        this.colorMap.add("borne_text_color");
        this.colorMap.add("borne_color1");
        this.colorMap.add("items_text_color");
        this.colorMap.add("items_background_color");
        this.colorMap.add("bg_color_price");
        this.colorMap.add("color_selected_category");
        this.colorMap.add("bg_color_text_sub_categories");
        this.colorMap.add("bg_color_text_sub_categories");
        this.colorMap.add("bg_color_image_sub_categories");
        this.colorMap.add("bg_color_image_product");
        this.colorMap.add("text_color_total_order");
        this.colorMap.add("bg_color_code_promo");
        this.colorMap.add("bg_color_button_validation");
        this.colorMap.add("bg_color_type_payment");
        this.colorMap.add("bg_color_button_cancel");
        this.colorMap.add("text_color_button_cancel");
        this.colorMap.add("text_color_sub_categories");
        this.colorMap.add("color_text_number_order_cb");
        this.settingBorneMap = new ArrayList<String>();
        this.settingBorneMap.add("cacher_noms_categories_borne");
        this.settingBorneMap.add("type_borne");
        this.settingBorneMap.add("cacher_noms_sous_categories_borne");
        this.settingBorneMap.add("cacher_noms_produits_borne");
        this.settingBorneMap.add("cacher_type_commande");
        this.settingBorneMap.add("cacher_fond_bloc_prix");
        this.settingBorneMap.add("mettre_ingredients_avant_options");
        this.settingBorneMap.add("cacher_bouton_page_de_page_borne");
        this.settingBorneMap.add("barre_laterale");
        this.settingBorneMap.add("position_prix");
        this.settingBorneMap.add("resize_img_par_fixer");
        this.settingBorneMap.add("imprimer_commande_avec");
        this.settingBorneMap.add("imprimer_description_produits");
        this.settingBorneMap.add("afficher_description_produits_borne");
        this.settingBorneMap.add("cacher_ingredients");
        this.settingBorneMap.add("cacher_ingredients_sous_produits");
        this.settingBorneMap.add("arriere_plan_images_type_commande_transparente");
        this.settingBorneMap.add("product_moment_advanced");
        this.settingBorneMap.add("size_text_number_order_cb");
        this.franchise_id = AppLocal.FRANCHISE_ID;
        this.mapPositions.put("Gauche", 0);
        this.mapPositions.put("Centre", 1);
        this.mapPositions.put("Droit", 2);
        this.mapPositions.put("Droite", 2);
        this.settingMap = new ArrayList<String>();
        this.settingMap.add("type_tarif");
        try {
            this.mFirebaseService = FirebaseService.getInstance();
        }
        catch (Exception ex) {
            Logger.getLogger(SettingService.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static SettingService getInstance() {
        if (m_instance == null) {
            m_instance = new SettingService();
        }
        return m_instance;
    }

    public SettingBorne save(SettingBorne mSettingBorne) {
        if (this.mSettingBorneDao.getSessionFactory() != null) {
            Session session = this.mSettingBorneDao.getSessionFactory().getCurrentSession();
            Transaction tx = session.beginTransaction();
            session.save((Object)mSettingBorne);
            tx.commit();
        }
        return mSettingBorne;
    }

    public SettingBorne findByName(String media_name) {
        return this.mSettingBorneDao.findByName(media_name);
    }

    public List<SettingBorne> listMedia() {
        return this.mSettingBorneDao.list();
    }

    public void setLastUpdate(SettingBorne mSettingBorne) {
        this.mSettingBorneDao.setLastUpdate(mSettingBorne);
    }

    public void setSettingBorne() {
        this.setSettingBorne(false);
    }

    public void setSettings(boolean force_download) {
        FilerUtils m_FilerUtils = FilerUtils.getInstance();
        this.appConfig = AppConfig.getInstance(true, m_FilerUtils.getFileProperties());
        this.downloadSettings(force_download);
        this.appConfig.save();
        this.appConfig.initInfoSettingBorne();
    }

    public void downloadSettingsBorne(boolean force_download) {
        try {
            JSONObject jsonParams = this.mFirebaseService.getJsonBySettingType("parametre_borne");
            System.out.println("jsonParams : " + jsonParams);
            if (jsonParams != null) {
                Date last_update;
                ArrayList<SettingBorne> settingsBorne = new ArrayList<SettingBorne>();
                if (!jsonParams.isNull("borneparam")) {
                    JSONObject jsonBorneParam = jsonParams.getJSONObject("borneparam");
                    Date date = last_update = jsonBorneParam.isNull("updatedAt") ? null : this.parseDate(jsonBorneParam.getString("updatedAt"));
                    if (last_update != null) {
                        for (String setting_name : this.settingBorneMap) {
                            if (jsonBorneParam.isNull(setting_name)) continue;
                            Object object_setting_value = jsonBorneParam.get(setting_name);
                            String setting_value = null;
                            setting_value = object_setting_value instanceof String ? (String)object_setting_value : (object_setting_value instanceof Number ? String.valueOf(object_setting_value) : this.getBooleanValue(object_setting_value));
                            if (setting_value == null || setting_value.isEmpty()) continue;
                            SettingBorne msettingBorne = new SettingBorne();
                            msettingBorne.setSetting_name(setting_name);
                            msettingBorne.setSetting_value(setting_value);
                            msettingBorne.setLast_update(last_update.getTime());
                            settingsBorne.add(msettingBorne);
                        }
                    }
                }
                if (!jsonParams.isNull("param_homeborne")) {
                    String setting_value_typeBorne;
                    System.out.println("param borne ****************");
                    JSONObject jsonBorneParamHome = jsonParams.getJSONObject("param_homeborne");
                    Date date = last_update = jsonBorneParamHome.isNull("updatedAt") ? null : this.parseDate(jsonBorneParamHome.getString("updatedAt"));
                    if (last_update != null && !jsonBorneParamHome.isNull("type") && (setting_value_typeBorne = jsonBorneParamHome.getString("type")) != null && !setting_value_typeBorne.isEmpty()) {
                        SettingBorne msettingTypeBorne = new SettingBorne();
                        msettingTypeBorne.setSetting_name("type");
                        msettingTypeBorne.setSetting_value(setting_value_typeBorne);
                        msettingTypeBorne.setLast_update(last_update.getTime());
                        this.setSettingBorne(msettingTypeBorne, AppLocal.FORCE_DOWNLOAD_MEDIA_BORNE, false);
                        settingsBorne.add(msettingTypeBorne);
                    }
                }
                this.saveSettingBorne(settingsBorne, force_download);
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void saveSettingBorne(List<SettingBorne> settingsBorne, boolean force_download) {
        if (settingsBorne != null && !settingsBorne.isEmpty()) {
            for (SettingBorne settingBorne : settingsBorne) {
                this.setSettingBorne(settingBorne, false, force_download);
            }
        }
    }

    private void setSettingBorne(SettingBorne settingBorne, boolean force_save, boolean force_download) {
        SettingBorne localSetting = this.findByName(settingBorne.getSetting_name());
        if (localSetting == null) {
            this.saveSetting(settingBorne, false);
        } else if (force_save || force_download || settingBorne.getLast_update() > localSetting.getLast_update()) {
            settingBorne.setId(localSetting.getId());
            this.saveSetting(settingBorne, true);
        }
    }

    private void saveSetting(SettingBorne settingBorne, boolean exist_setting) {
        if (exist_setting) {
            this.setLastUpdate(settingBorne);
        } else {
            this.save(settingBorne);
        }
        String value = settingBorne.getSetting_value();
        System.out.println("value : " + value);
        System.out.println("settingBorne.getSetting_name() : " + settingBorne.getSetting_name());
        if (value != null) {
            switch (settingBorne.getSetting_name()) {
                case "cacher_noms_categories_borne": {
                    this.appConfig.setProperty("hide.name.categories", value);
                    break;
                }
                case "cacher_noms_sous_categories_borne": {
                    this.appConfig.setProperty("hide.name.sub.categories", value);
                    break;
                }
                case "cacher_noms_produits_borne": {
                    this.appConfig.setProperty("hide.name.products", value);
                    break;
                }
                case "cacher_type_commande": {
                    this.appConfig.setProperty("hide.message.type.order", value);
                    break;
                }
                case "cacher_fond_bloc_prix": {
                    this.appConfig.setProperty("hide.bg.price", value);
                    break;
                }
                case "mettre_ingredients_avant_options": {
                    this.appConfig.setProperty("first.ingredient", value);
                    break;
                }
                case "cacher_bouton_page_de_page_borne": {
                    this.appConfig.setProperty("hide.footer.home", value);
                }
                case "barre_laterale": {
                    System.out.println("value :BARRE_LITTERAL  " + value);
                    this.appConfig.setProperty("lateral.bar", value);
                    break;
                }
                case "position_prix": {
                    String position_price = this.mapPositions.get(value) != null ? String.valueOf(this.mapPositions.get(value)) : "1";
                    this.appConfig.setProperty("position.price", position_price);
                    break;
                }
                case "type_borne": {
                    this.appConfig.setProperty("type.borne", value.toLowerCase());
                    break;
                }
                case "resize_img_par_fixer": {
                    this.appConfig.setProperty("dimension.fixed", value);
                    break;
                }
                case "imprimer_commande_avec": {
                    this.appConfig.setProperty("printed.code", value);
                    break;
                }
                case "imprimer_description_produits": {
                    this.appConfig.setProperty("print.description", value);
                    break;
                }
                case "afficher_description_produits_borne": {
                    this.appConfig.setProperty("show.description", value);
                    break;
                }
                case "cacher_ingredients": {
                    this.appConfig.setProperty("hide.ingredients.borne", value);
                    break;
                }
                case "cacher_ingredients_sous_produits": {
                    this.appConfig.setProperty("hide.sub.product.ingredients.borne", value);
                    break;
                }
                case "type": {
                    value = value.equalsIgnoreCase("image") ? "Image" : value;
                    this.appConfig.setProperty("type.media.home", value);
                    break;
                }
                case "arriere_plan_images_type_commande_transparente": {
                    this.appConfig.setProperty("images.type.order.transparent", value);
                    break;
                }
                case "hide_background_name_product": {
                    this.appConfig.setProperty("hide.background.name.products", value);
                    break;
                }
                case "hide_background_image_product": {
                    this.appConfig.setProperty("hide.background.products", value);
                    break;
                }
                case "hide_background_name_sub_category": {
                    this.appConfig.setProperty("hide.background.name.sub.categories", value);
                    break;
                }
                case "hide_background_image_sub_category": {
                    this.appConfig.setProperty("hide.background.image.sub.categories", value);
                    break;
                }
                case "hide_background_price": {
                    this.appConfig.setProperty("hide.bg.price", value);
                    break;
                }
                case "product_moment_advanced": {
                    this.appConfig.setProperty("product.moment.advanced", value);
                    break;
                }
                case "size_text_number_order_cb": {
                    this.appConfig.setProperty("size.text.number.order.cb", value);
                }
            }
        }
    }

    public void downloadColorsBorne(boolean force_download) {
        try {
            JSONObject jsonColors = this.mFirebaseService.getJsonBySettingType("colors_borne");
            if (jsonColors != null && !jsonColors.toString().trim().isEmpty()) {
                Date last_update;
                JSONObject jsonResponse = new JSONObject(jsonColors.toString());
                ArrayList<SettingBorne> colorsBorne = new ArrayList<SettingBorne>();
                ArrayList<SettingBorne> settingsBorne = new ArrayList<SettingBorne>();
                Date date = last_update = jsonResponse.isNull("updatedAt") ? null : this.parseDate(jsonResponse.getString("updatedAt"));
                if (last_update != null) {
                    for (String color_name : this.colorMap) {
                        if (jsonResponse.isNull(color_name)) continue;
                        Object objectColor = jsonResponse.get(color_name);
                        String color_value = null;
                        if (objectColor instanceof String) {
                            color_value = jsonResponse.getString(color_name);
                        } else {
                            JSONObject colorJson = jsonResponse.getJSONObject(color_name);
                            if (!colorJson.isNull("color")) {
                                color_value = colorJson.getString("color");
                            }
                            if (!colorJson.isNull("isTransparent")) {
                                boolean isTransparent = colorJson.getBoolean("isTransparent");
                                String setting_value = this.getBooleanValue(isTransparent);
                                String nameSetting = this.getNameSetting(color_name);
                                if (nameSetting != null && !nameSetting.isEmpty()) {
                                    SettingBorne mcolorBorne = new SettingBorne();
                                    mcolorBorne.setSetting_name(nameSetting);
                                    mcolorBorne.setSetting_value(setting_value);
                                    mcolorBorne.setLast_update(last_update.getTime());
                                    settingsBorne.add(mcolorBorne);
                                }
                            }
                        }
                        if (color_value == null || color_value.isEmpty()) continue;
                        SettingBorne mcolorBorne = new SettingBorne();
                        mcolorBorne.setSetting_name(color_name);
                        mcolorBorne.setSetting_value(color_value);
                        mcolorBorne.setLast_update(last_update.getTime());
                        colorsBorne.add(mcolorBorne);
                    }
                }
                this.saveColorBorne(colorsBorne, force_download);
                this.saveSettingBorne(settingsBorne, force_download);
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void saveColorBorne(List<SettingBorne> colorsBorne, boolean force_download) {
        if (colorsBorne != null && !colorsBorne.isEmpty()) {
            for (SettingBorne colorBorne : colorsBorne) {
                SettingBorne localSColor = this.findByName(colorBorne.getSetting_name());
                if (localSColor == null) {
                    this.saveColor(colorBorne, false);
                    continue;
                }
                if (!force_download && colorBorne.getLast_update() <= localSColor.getLast_update()) continue;
                colorBorne.setId(localSColor.getId());
                this.saveColor(colorBorne, true);
            }
        }
    }

    private void saveColor(SettingBorne settingColor, boolean exist_color) {
        if (exist_color) {
            this.setLastUpdate(settingColor);
        } else {
            this.save(settingColor);
        }
        Color color = Color.decode(settingColor.getSetting_value());
        if (color != null) {
            String color_text = ColorUtils.getColorText(color);
            switch (settingColor.getSetting_name()) {
                case "basket_text_color": {
                    this.appConfig.setProperty("text.color.basket", color_text);
                    break;
                }
                case "price_text_color": {
                    this.appConfig.setProperty("text.color.price", color_text);
                    break;
                }
                case "borne_color2": {
                    this.appConfig.setProperty("color_light.borne", color_text);
                    break;
                }
                case "category_text_color": {
                    this.appConfig.setProperty("text.color.categories", color_text);
                    break;
                }
                case "order_type_text_color": {
                    this.appConfig.setProperty("color.type.order", color_text);
                    break;
                }
                case "borne_text_color": {
                    this.appConfig.setProperty("fond.color.borne", color_text);
                    break;
                }
                case "borne_color1": {
                    this.appConfig.setProperty("color.borne", color_text);
                }
                case "items_text_color": {
                    this.appConfig.setProperty("text.color.items", color_text);
                    break;
                }
                case "items_background_color": {
                    this.appConfig.setProperty("bg.color.items", color_text);
                    break;
                }
                case "bg_color_price": {
                    this.appConfig.setProperty("bg.color.price", color_text);
                    break;
                }
                case "color_selected_category": {
                    this.appConfig.setProperty("color.selected.category", color_text);
                    break;
                }
                case "bg_color_text_sub_categories": {
                    this.appConfig.setProperty("bg.color.text.sub.categories", color_text);
                    break;
                }
                case "bg_color_image_sub_categories": {
                    this.appConfig.setProperty("bg.color.image.sub.categories", color_text);
                    break;
                }
                case "text_color_sub_categories": {
                    this.appConfig.setProperty("text.color.sub.categories", color_text);
                    break;
                }
                case "bg_color_image_product": {
                    this.appConfig.setProperty("bg.color.image.product", color_text);
                    break;
                }
                case "text_color_total_order": {
                    this.appConfig.setProperty("text.color.total.order", color_text);
                    break;
                }
                case "bg_color_code_promo": {
                    this.appConfig.setProperty("bg.color.code.promo", color_text);
                    break;
                }
                case "bg_color_button_validation": {
                    this.appConfig.setProperty("bg.color.button.validation", color_text);
                    break;
                }
                case "bg_color_type_payment": {
                    this.appConfig.setProperty("bg.color.type.payment", color_text);
                    break;
                }
                case "bg_color_button_cancel": {
                    this.appConfig.setProperty("bg.color.button.cancel", color_text);
                    break;
                }
                case "text_color_button_cancel": {
                    this.appConfig.setProperty("text.color.button.cancel", color_text);
                    break;
                }
                case "color_text_number_order_cb": {
                    this.appConfig.setProperty("color.text.number.order.cb", color_text);
                }
            }
        }
    }

    public void downloadMediaBorne(boolean force_download) {
        block8: {
            System.out.println("download media borne *******************");
            try {
                String design_borne;
                JSONObject jsonHomeBorne = this.mFirebaseService.getJsonBySettingType("design_borne");
                ArrayList<String> existedDesign = new ArrayList<String>();
                if (jsonHomeBorne == null || (design_borne = jsonHomeBorne.toString()) == null || design_borne.trim().isEmpty()) break block8;
                ArrayList<SettingBorne> mediasBorne = new ArrayList<SettingBorne>();
                for (String name_media : this.mediaMap.keySet()) {
                    if (!jsonHomeBorne.isNull(name_media)) {
                        JSONObject jsonMedia;
                        SettingBorne mSettingBorne = new SettingBorne();
                        if (this.mediaMap.get(name_media) != null) {
                            mSettingBorne.setSetting_name(this.mediaMap.get(name_media));
                        }
                        if (!(jsonMedia = jsonHomeBorne.getJSONObject(name_media)).isNull("image_url")) {
                            mSettingBorne.setSetting_value(jsonMedia.getString("image_url"));
                            Date last_update = jsonMedia.isNull("updated_at") ? null : this.parseDate(jsonMedia.getString("updated_at"));
                            mSettingBorne.setLast_update(last_update != null ? last_update.getTime() : 0L);
                            mediasBorne.add(mSettingBorne);
                        }
                        for (String code_language : AppLocal.CODE_LANGUAGES.values()) {
                            JSONObject jsonMediaByLanguage;
                            if (jsonMedia.isNull(code_language) || (jsonMediaByLanguage = jsonMedia.getJSONObject(code_language)).isNull("image_url")) continue;
                            SettingBorne mSettingBorneByLanguage = new SettingBorne();
                            if (this.mediaMap.get(name_media) != null) {
                                mSettingBorneByLanguage.setSetting_name(this.mediaMap.get(name_media) + "_" + code_language);
                            }
                            mSettingBorneByLanguage.setSetting_value(jsonMediaByLanguage.getString("image_url"));
                            Date last_update = jsonMediaByLanguage.isNull("updated_at") ? null : this.parseDate(jsonMediaByLanguage.getString("updated_at"));
                            mSettingBorneByLanguage.setLast_update(last_update != null ? last_update.getTime() : 0L);
                            mediasBorne.add(mSettingBorneByLanguage);
                        }
                        continue;
                    }
                    if (!AppLocal.SYNCHRO_PARAM_FIREBASE) continue;
                    existedDesign.add(this.mediaMap.get(name_media));
                    File directory = new File(new File(System.getProperty("user.home")), "images/logos/");
                    this.DeleteFilesByName(this.mediaMap.get(name_media), directory);
                    AppLocal.dlSales.deletePhotoByName(this.mediaMap.get(name_media));
                }
                this.downloadMedias(mediasBorne, force_download);
            }
            catch (Exception ex) {
                Logger.getLogger(SettingService.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void downloadMedias(List<SettingBorne> mediasBorne, boolean force_download) {
        if (mediasBorne != null && !mediasBorne.isEmpty()) {
            for (SettingBorne mediaBorne : mediasBorne) {
                SettingBorne localMedia = this.findByName(mediaBorne.getSetting_name());
                if (localMedia == null) {
                    this.downloadMedia(mediaBorne, false, this.appConfig);
                    continue;
                }
                if (!force_download && mediaBorne.getLast_update() <= localMedia.getLast_update()) continue;
                mediaBorne.setId(localMedia.getId());
                this.downloadMedia(mediaBorne, true, this.appConfig);
            }
        }
    }

    private void downloadMedia(SettingBorne mediaBorne, boolean exist_media, AppConfig appConfig) {
        System.out.println("++++++++++++++++DownloadMediaCaisse()");
        try {
            String ext = this.getExtention(mediaBorne.getSetting_value());
            System.out.println("++++++++++++++++++ext" + ext);
            File directory = new File(new File(System.getProperty("user.home")), "images/logos");
            FileUtils.forceMkdir((File)directory);
            String url = directory.getPath();
            File dest = new File(url + "/" + mediaBorne.getSetting_name() + "." + ext);
            this.DeleteFilesByName(mediaBorne.getSetting_name(), directory);
            if (!dest.exists()) {
                dest.createNewFile();
            }
            FileUtils.copyURLToFile((URL)new URL(mediaBorne.getSetting_value()), (File)dest);
            if (exist_media) {
                this.setLastUpdate(mediaBorne);
            } else {
                this.save(mediaBorne);
            }
            switch (mediaBorne.getSetting_name()) {
                case "background_catalog": {
                    appConfig.setProperty("catalog.background", dest.getName());
                    break;
                }
                case "background_summary_order": {
                    appConfig.setProperty("background.summary.order.borne", dest.getName());
                    break;
                }
                case "background_type": {
                    appConfig.setProperty("background.type.order.borne", dest.getName());
                    break;
                }
                case "image_at_spot": {
                    appConfig.setProperty("background.atspot.order.borne", dest.getName());
                    break;
                }
                case "image_at_spot_fr": {
                    appConfig.setProperty("background.atspot.order.borne", dest.getName());
                    break;
                }
                case "image_at_spot_ar": {
                    appConfig.setProperty("background.atspot.ar.order.borne", dest.getName());
                    break;
                }
                case "image_at_spot_en": {
                    appConfig.setProperty("background.atspot.en.order.borne", dest.getName());
                    break;
                }
                case "image_at_spot_es": {
                    appConfig.setProperty("background.atspot.es.order.borne", dest.getName());
                    break;
                }
                case "image_take_away": {
                    appConfig.setProperty("background.takeaway.order.borne", dest.getName());
                    break;
                }
                case "image_take_away_fr": {
                    appConfig.setProperty("background.takeaway.order.borne", dest.getName());
                    break;
                }
                case "image_take_away_ar": {
                    appConfig.setProperty("background.takeaway.ar.order.borne", dest.getName());
                    break;
                }
                case "image_take_away_en": {
                    appConfig.setProperty("background.takeaway.en.order.borne", dest.getName());
                    break;
                }
                case "image_take_away_es": {
                    appConfig.setProperty("background.takeaway.es.order.borne", dest.getName());
                    break;
                }
                case "logo_borne": {
                    appConfig.setProperty("logo.borne", dest.getName());
                    break;
                }
                case "background_summary_order_promo": {
                    appConfig.setProperty("background.summary.order.borne.promo", dest.getName());
                    break;
                }
                case "background_valid_order": {
                    appConfig.setProperty("background.valid.borne.order", dest.getName());
                    break;
                }
                case "icon_cb": {
                    appConfig.setProperty("icon.cb", dest.getName());
                    break;
                }
                case "icon_counter": {
                    appConfig.setProperty("icon.counter", dest.getName());
                    break;
                }
                case "icon_next": {
                    appConfig.setProperty("icon.next", dest.getName());
                    break;
                }
                case "icon_previous": {
                    appConfig.setProperty("icon.previous", dest.getName());
                    break;
                }
                case "product_moment": {
                    appConfig.setProperty("background.moment.fr.borne", dest.getName());
                    break;
                }
                case "product_moment_fr": {
                    appConfig.setProperty("background.moment.fr.borne", dest.getName());
                    break;
                }
                case "product_moment_ar": {
                    appConfig.setProperty("background.moment.ar.borne", dest.getName());
                    break;
                }
                case "product_moment_en": {
                    appConfig.setProperty("background.moment.en.borne", dest.getName());
                    break;
                }
                case "product_moment_es": {
                    appConfig.setProperty("background.moment.es.borne", dest.getName());
                    break;
                }
                case "bg_type_payment": {
                    appConfig.setProperty("background.type.payment.fr", dest.getName());
                    break;
                }
                case "bg_type_payment_fr": {
                    appConfig.setProperty("background.type.payment.fr", dest.getName());
                    break;
                }
                case "bg_type_payment_ar": {
                    appConfig.setProperty("background.type.payment.ar", dest.getName());
                    break;
                }
                case "bg_type_payment_en": {
                    appConfig.setProperty("background.type.payment.en", dest.getName());
                    break;
                }
                case "bg_type_payment_es": {
                    appConfig.setProperty("background.type.payment.es", dest.getName());
                    break;
                }
                case "background_catalog_fr": {
                    appConfig.setProperty("catalog.background.fr", dest.getName());
                    break;
                }
                case "background_catalog_ar": {
                    appConfig.setProperty("catalog.background.ar", dest.getName());
                    break;
                }
                case "background_catalog_en": {
                    appConfig.setProperty("catalog.background.en", dest.getName());
                    break;
                }
                case "background_catalog_es": {
                    appConfig.setProperty("catalog.background.es", dest.getName());
                    break;
                }
                case "image_insert_card": {
                    appConfig.setProperty("image.insert.card", dest.getName());
                    break;
                }
                case "image_insert_card_fr": {
                    appConfig.setProperty("image.insert.card.fr", dest.getName());
                    break;
                }
                case "image_insert_card_ar": {
                    appConfig.setProperty("image.insert.card.ar", dest.getName());
                    break;
                }
                case "image_insert_card_en": {
                    appConfig.setProperty("image.insert.card.en", dest.getName());
                    break;
                }
                case "image_insert_card_es": {
                    appConfig.setProperty("image.insert.card.es", dest.getName());
                    break;
                }
                case "image_valid_order_counter": {
                    appConfig.setProperty("background.valid.borne.order", dest.getName());
                    break;
                }
                case "image_valid_order_counter_fr": {
                    appConfig.setProperty("image.valid.order.counter.fr", dest.getName());
                    break;
                }
                case "image_valid_order_counter_ar": {
                    appConfig.setProperty("image.valid.order.counter.ar", dest.getName());
                    break;
                }
                case "image_valid_order_counter_en": {
                    appConfig.setProperty("image.valid.order.counter.en", dest.getName());
                    break;
                }
                case "image_valid_order_counter_es": {
                    appConfig.setProperty("image.valid.order.counter.es", dest.getName());
                    break;
                }
                case "image_valid_order_cb": {
                    appConfig.setProperty("image.valid.order.cb", dest.getName());
                    break;
                }
                case "image_valid_order_cb_fr": {
                    appConfig.setProperty("image.valid.order.cb.fr", dest.getName());
                    break;
                }
                case "image_valid_order_cb_ar": {
                    appConfig.setProperty("image.valid.order.cb.ar", dest.getName());
                    break;
                }
                case "image_valid_order_cb_en": {
                    appConfig.setProperty("image.valid.order.cb.en", dest.getName());
                    break;
                }
                case "image_valid_order_cb_es": {
                    appConfig.setProperty("image.valid.order.cb.es", dest.getName());
                    break;
                }
                case "background_items_later": {
                    appConfig.setProperty("background.items.later", dest.getName());
                }
            }
        }
        catch (Exception ex) {
            Logger.getLogger(SettingService.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void downloadMediaHomeBorne(boolean force_download) {
        try {
            String Media2;
            JSONObject jsonMediaHomeBorne = this.mFirebaseService.getJsonBySettingType("home_borne");
            if (jsonMediaHomeBorne != null && (Media2 = jsonMediaHomeBorne.toString()) != null && !Media2.trim().isEmpty()) {
                Date last_update = null;
                if (!jsonMediaHomeBorne.isNull("param_homeborne")) {
                    String setting_value_typeBorne;
                    JSONObject param_homeborne = jsonMediaHomeBorne.getJSONObject("param_homeborne");
                    if (!param_homeborne.isNull("updatedAt")) {
                        Date date = last_update = param_homeborne.isNull("updatedAt") ? null : this.parseDate(param_homeborne.getString("updatedAt"));
                    }
                    if (!param_homeborne.isNull("type") && (setting_value_typeBorne = param_homeborne.getString("type")) != null && !setting_value_typeBorne.isEmpty()) {
                        SettingBorne msettingTypeBorne = new SettingBorne();
                        msettingTypeBorne.setSetting_name("type");
                        msettingTypeBorne.setSetting_value(setting_value_typeBorne);
                        System.out.println("setting_value_typeBorne ***************** : " + setting_value_typeBorne);
                        msettingTypeBorne.setLast_update(last_update.getTime());
                        this.setSettingBorne(msettingTypeBorne, force_download, false);
                    }
                }
                if (last_update != null) {
                    if (!jsonMediaHomeBorne.isNull("images_homeborne") && jsonMediaHomeBorne.getJSONArray("images_homeborne").length() > 0) {
                        JSONArray images_homeborne = jsonMediaHomeBorne.getJSONArray("images_homeborne");
                        List<PhotoDispaly> images_home_borne = AppLocal.dlSales.getSortHomeBornePhoto();
                        if (AppLocal.FORCE_DOWNLOAD_MEDIA_BORNE || images_home_borne == null || images_home_borne.isEmpty() || images_home_borne.get(0).getLast_update() == null || images_home_borne.get(0).getLast_update().before(last_update) || force_download) {
                            this.deleteAllPhotoHomeBorne();
                            for (int i = 0; i < images_homeborne.length(); ++i) {
                                JSONObject jsonImageHome = images_homeborne.getJSONObject(i);
                                if (jsonImageHome.isNull("image_url")) continue;
                                String image_url = jsonImageHome.getString("image_url");
                                PhotoDispaly newPhoto = new PhotoDispaly();
                                String ext = this.getExtention(image_url);
                                File directory = new File(new File(System.getProperty("user.home")), "images/photosBorne");
                                FileUtils.forceMkdir((File)directory);
                                String url = directory.getPath();
                                File dest = new File(url + "/image" + i + "." + ext);
                                if (!dest.exists()) {
                                    dest.createNewFile();
                                }
                                FileUtils.copyURLToFile((URL)new URL(image_url), (File)dest);
                                newPhoto.setPath("image" + i + "." + ext);
                                newPhoto.setLast_update(last_update);
                                AppLocal.dlSales.addHomeBornePhoto(newPhoto);
                            }
                        }
                    }
                    if (!jsonMediaHomeBorne.isNull("video_homeborne") && jsonMediaHomeBorne.getJSONArray("video_homeborne").length() > 0) {
                        JSONObject jsonVideoHome;
                        JSONArray video_homeborne = jsonMediaHomeBorne.getJSONArray("video_homeborne");
                        if (video_homeborne != null && video_homeborne.length() > 0 && !(jsonVideoHome = video_homeborne.getJSONObject(video_homeborne.length() - 1)).isNull("video_url")) {
                            SettingBorne mSettingBorne = new SettingBorne();
                            mSettingBorne.setSetting_name("video");
                            SettingBorne localSettingBorne = this.findByName("video");
                            if (AppLocal.FORCE_DOWNLOAD_MEDIA_BORNE || localSettingBorne == null || localSettingBorne.getLast_update() < last_update.getTime() || force_download) {
                                String video_url = jsonVideoHome.getString("video_url");
                                String ext = this.getExtention(video_url);
                                File directory = new File(new File(System.getProperty("user.home")), "images/logos");
                                FileUtils.forceMkdir((File)directory);
                                String url = directory.getPath();
                                File dest = new File(url + "/video." + ext);
                                if (!dest.exists()) {
                                    dest.createNewFile();
                                }
                                FileUtils.copyURLToFile((URL)new URL(video_url), (File)dest);
                                this.appConfig.setProperty("video.borne", dest.getName());
                                if (localSettingBorne == null) {
                                    localSettingBorne = new SettingBorne();
                                    localSettingBorne.setSetting_name("video");
                                    localSettingBorne.setLast_update(last_update.getTime());
                                    this.save(localSettingBorne);
                                } else {
                                    localSettingBorne.setLast_update(last_update.getTime());
                                    this.setLastUpdate(localSettingBorne);
                                }
                            }
                        }
                    } else {
                        this.deleteOldHomeBornePhoto("video.mp4", "video");
                    }
                }
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private String getBooleanValue(Object object) {
        if (object.equals(true)) {
            return "yes";
        }
        return "no";
    }

    public void setSettingBorne(boolean force_download) {
        FilerUtils m_FilerUtils = FilerUtils.getInstance();
        this.appConfig = AppConfig.getInstance(true, m_FilerUtils.getFileProperties());
        if (AppLocal.FRANCHISE_ID != null && !AppLocal.FRANCHISE_ID.isEmpty()) {
            this.downloadMediaBorne(force_download);
            this.downloadColorsBorne(force_download);
            this.downloadSettingsBorne(force_download);
            this.downloadMediaHomeBorne(force_download);
        }
        this.appConfig.save();
        this.appConfig.initInfoSettingBorne();
    }

    private void downloadSettings(boolean force_download) {
        System.out.println("download setting ************");
        try {
            MarqueNFC marqueNF = MarqueNFC.fetchOrStore(AppLocal.dlSales);
            if (marqueNF != null && marqueNF.getSiret() != null && !marqueNF.getSiret().isEmpty()) {
                OkHttpClient client = new OkHttpClient().newBuilder().build();
                Request request = new Request.Builder().url("https://api-backoffice.biborne.com/api/restos/findonecaisse/" + marqueNF.getSiret()).method("GET", null).build();
                Response response = client.newCall(request).execute();
                String response_items = response.body().string();
                if (response.code() == 200 && response_items != null && !response_items.trim().isEmpty()) {
                    Date last_update;
                    JSONObject jsonResponse = new JSONObject(response_items);
                    ArrayList<SettingInfo> settings = new ArrayList<SettingInfo>();
                    Date date = last_update = jsonResponse.isNull("updatedAt") ? null : DateUtils.FORMATTER_DATE_TIME_ZONE_SSS.parse(jsonResponse.getString("updatedAt"));
                    if (last_update != null) {
                        for (String setting_name : this.settingMap) {
                            Object object_setting_value;
                            String setting_value;
                            if (jsonResponse.isNull(setting_name) || (setting_value = (object_setting_value = jsonResponse.get(setting_name)) instanceof String ? (String)object_setting_value : this.getBooleanValue(object_setting_value)) == null || setting_value.isEmpty()) continue;
                            SettingInfo mSettingInfo = new SettingInfo();
                            mSettingInfo.setSetting_name(setting_name);
                            mSettingInfo.setSetting_value(setting_value);
                            mSettingInfo.setLast_update(last_update.getTime());
                            settings.add(mSettingInfo);
                        }
                    }
                    this.saveSetting(settings, force_download);
                }
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void saveSetting(List<SettingInfo> settings, boolean force_download) {
        if (settings != null && !settings.isEmpty()) {
            for (SettingInfo settingInfo : settings) {
                SettingInfo localSetting = this.findSettingByName(settingInfo.getSetting_name());
                if (localSetting == null) {
                    this.saveSetting(settingInfo, false);
                    continue;
                }
                if (!force_download && settingInfo.getLast_update() <= localSetting.getLast_update()) continue;
                settingInfo.setId(localSetting.getId());
                this.saveSetting(settingInfo, true);
            }
        }
    }

    private void saveSetting(SettingInfo mSettingInfo, boolean exist_setting) {
        if (exist_setting) {
            this.setLastUpdateSetting(mSettingInfo);
        } else {
            this.saveSetting(mSettingInfo);
        }
        String value = mSettingInfo.getSetting_value();
        if (value != null) {
            switch (mSettingInfo.getSetting_name()) {
                case "type_tarif": {
                    this.appConfig.setProperty("tariff", value);
                }
            }
        }
    }

    public SettingInfo saveSetting(SettingInfo mSettingInfo) {
        if (this.mSettingInfoDao.getSessionFactory() != null) {
            Session session = this.mSettingInfoDao.getSessionFactory().getCurrentSession();
            Transaction tx = session.beginTransaction();
            session.save((Object)mSettingInfo);
            tx.commit();
        }
        return mSettingInfo;
    }

    public SettingInfo findSettingByName(String media_name) {
        return this.mSettingInfoDao.findByName(media_name);
    }

    public void setLastUpdateSetting(SettingInfo mSettingInfo) {
        this.mSettingInfoDao.setLastUpdate(mSettingInfo);
    }

    public String getExtention(String URL2) {
        String ext = null;
        int lastSlashIndex = URL2.lastIndexOf("/");
        if (lastSlashIndex != -1) {
            ext = URL2.substring(lastSlashIndex + 1, URL2.indexOf("?"));
        }
        return ext.substring(ext.lastIndexOf(".") + 1);
    }

    public void DeleteFilesByName(String fileNameToMatch, File directory) {
        if (directory.exists() && directory.isDirectory()) {
            File[] files;
            for (File file : files = directory.listFiles()) {
                if (!file.isFile() || !file.getName().startsWith(fileNameToMatch)) continue;
                if (file.delete()) {
                    System.out.println("Deleted file: " + file.getAbsolutePath());
                    continue;
                }
                System.err.println("Failed to delete file: " + file.getAbsolutePath());
            }
        }
    }

    public static void deleteAllFilesInDirectory(File directoryPath) throws IOException {
        Path dirPath = directoryPath.toPath();
        if (Files.exists(dirPath, new LinkOption[0]) && Files.isDirectory(dirPath, new LinkOption[0])) {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(dirPath);){
                for (Path filePath : stream) {
                    Files.delete(filePath);
                }
            }
        }
    }

    public void deleteAllPhotoHomeBorne() {
        try {
            List<PhotoDispaly> allPub = AppLocal.dlSales.getHomeBornePhoto();
            for (PhotoDispaly photoDispaly : allPub) {
                this.deleteOldHomeBornePhoto(photoDispaly.getPath(), "image");
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", null, ex);
        }
    }

    public void deleteOldHomeBornePhoto(String name, String type) throws BasicException {
        AppLocal.dlSales.deleteHomeBornePhoto(name);
        File directory = null;
        if (type.equals("image")) {
            directory = new File(new File(System.getProperty("user.home")), "images/photosBorne");
        } else if (type.equals("video")) {
            directory = new File(new File(System.getProperty("user.home")), "images/logos");
        }
        this.DeleteFilesByName(name, directory);
    }

    private String getNameSetting(String color_name) {
        String nameSetting = null;
        if (color_name != null) {
            switch (color_name) {
                case "bg_color_text_sub_categories": {
                    nameSetting = "hide_background_name_sub_category";
                    break;
                }
                case "bg_color_image_sub_categories": {
                    nameSetting = "hide_background_image_sub_category";
                    break;
                }
                case "bg_color_image_product": {
                    nameSetting = "hide_background_image_product";
                    break;
                }
                case "items_background_color": {
                    nameSetting = "hide_background_name_product";
                    break;
                }
                case "bg_color_price": {
                    nameSetting = "hide_background_price";
                }
            }
        }
        return nameSetting;
    }

    public Date parseDate(String text_date) {
        Date date = null;
        try {
            date = DateUtils.FORMATTER_DATE_TIME_T.parse(text_date);
        }
        catch (ParseException ex) {
            try {
                date = DateUtils.FORMATTER_DATE_TIME.parse(text_date);
            }
            catch (ParseException ex1) {
                LogToFile.log("severe", null, ex);
            }
        }
        return date;
    }
}

