/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.services;

import com.openbravo.pos.util.DateEncryptor;
import com.openbravo.pos.util.LogToFile;
import fr.protactile.procaisse.dao.entities.SecurityCheck;
import fr.protactile.procaisse.dao.impl.SecurityCheckDao;
import java.util.Date;

public class SecurityCheckService {
    private static SecurityCheckService m_instance;
    private SecurityCheckDao securityCheckDao = new SecurityCheckDao();

    private SecurityCheckService() {
    }

    public static SecurityCheckService getInstance() {
        if (m_instance == null) {
            m_instance = new SecurityCheckService();
        }
        return m_instance;
    }

    public void setDateVerification(int unlockPeriod) {
        SecurityCheck mSecurity = this.securityCheckDao.getLastSecurityCheck();
        if (mSecurity != null) {
            try {
                mSecurity.setTemporaryPasswordUsed(true);
                mSecurity.setLastVerificationCodeDateCrypted(DateEncryptor.encryptDate(new Date()));
                mSecurity.setUnlock_period(unlockPeriod);
                this.securityCheckDao.setVerificationInfos(mSecurity);
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
    }

    public void setDateValidation(Date dateValidation, int validationDays) {
        try {
            SecurityCheck securityCheck = this.securityCheckDao.getLastSecurityCheck();
            if (securityCheck != null) {
                securityCheck.setLastValidationDateCrypted(DateEncryptor.encryptDate(dateValidation));
                securityCheck.setTemporaryPasswordUsed(false);
                securityCheck.setTemporary_use_period(validationDays);
                this.securityCheckDao.updateSecurityCheck(securityCheck);
            } else {
                securityCheck = new SecurityCheck(DateEncryptor.encryptDate(dateValidation), false, validationDays);
                this.securityCheckDao.addSecurityCheck(securityCheck);
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public SecurityCheck getLastSecurityCheck() {
        return this.securityCheckDao.getLastSecurityCheck();
    }
}

