/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.services;

import com.openbravo.basic.BasicException;
import com.openbravo.pos.forms.AppConfig;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.ticket.PhotoDispaly;
import com.openbravo.pos.util.DateUtils;
import com.openbravo.pos.util.FilerUtils;
import com.openbravo.pos.util.LogToFile;
import com.procaisse.db.connection.firebase.FirebaseService;
import fr.protactile.procaisse.dao.entities.PublicationBorne;
import fr.protactile.procaisse.dao.impl.PublicationBorneDao;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.json.JSONArray;
import org.json.JSONObject;

public class PublicationBorneService {
    private static PublicationBorneService m_instance;
    private final PublicationBorneDao mPublicationBorneDao = new PublicationBorneDao();
    private final String URL_PUBLICATION_BORNE = "https://api-backoffice.biborne.com/api/publicationsTab/publicationOne/";
    private final String IMAGE_URL = "image_url";
    private final String START_AT = "datedebut";
    private final String END_AT = "datefin";
    private final String UPDATEDAT = "updatedAt";
    private final String TYPE_MEDIA = "type";
    private final String CREATEDAT = "createdAt";
    private final String PUBLICATION_IMAGES = "bornePublicationImages";
    private final String PUB_BORNEVIDEO = "bornePublicationVideos";
    private final String URLS_IMAGES = "image_url";
    private AppConfig appConfig;
    private LinkedHashMap<String, String> pubMap = new LinkedHashMap();
    private FirebaseService mFirebaseService = null;

    public static PublicationBorneService getInstance() {
        if (m_instance == null) {
            m_instance = new PublicationBorneService();
        }
        return m_instance;
    }

    public PublicationBorne save(PublicationBorne mPublicationBorne) {
        if (this.mPublicationBorneDao.getSessionFactory() != null) {
            Session session = this.mPublicationBorneDao.getSessionFactory().getCurrentSession();
            Transaction tx = session.beginTransaction();
            session.save((Object)mPublicationBorne);
            tx.commit();
        }
        return mPublicationBorne;
    }

    public void updateExpired(PublicationBorne mPublicationBorne) {
        this.mPublicationBorneDao.updateExpired(mPublicationBorne);
    }

    public void update(PublicationBorne mPublicationBorne) {
        this.mPublicationBorneDao.update(mPublicationBorne);
    }

    public void setPublicationBorne() {
        FilerUtils m_FilerUtils = FilerUtils.getInstance();
        this.appConfig = AppConfig.getInstance(true, m_FilerUtils.getFileProperties());
        System.out.println("++++++++++++++++appConfig" + this.appConfig);
        this.downloadPublicationBorne();
        this.appConfig.save();
    }

    public void downloadPublicationBorne() {
        try {
            this.mFirebaseService = FirebaseService.getInstance();
            JSONObject jsonPublications = this.mFirebaseService.getJsonPubBySiret();
            System.out.println("++++++++++++++jsonPublications *******" + jsonPublications.toString());
            ArrayList<String> existedPub = new ArrayList<String>();
            if (jsonPublications != null) {
                String responseItems = jsonPublications.toString();
                if (responseItems != null && !responseItems.trim().isEmpty()) {
                    PublicationBorne publicationsBorne;
                    String namePub;
                    Date end_date;
                    Date start_date;
                    Date createdAt;
                    int i;
                    JSONObject jsonResponse = new JSONObject(responseItems);
                    Date dateNow = new Date();
                    JSONArray jsonImages = jsonResponse.getJSONArray("bornePublicationImages");
                    JSONArray jsonVideo = jsonResponse.getJSONArray("bornePublicationVideos");
                    System.out.println("+++++++++++++jsonVideo" + jsonVideo.toString());
                    if (!jsonImages.toString().isEmpty() && jsonImages.toString() != null) {
                        for (i = 0; i < jsonImages.length(); ++i) {
                            PublicationBorne publicationBorne;
                            createdAt = jsonImages.getJSONObject(i).isNull("createdAt") ? null : DateUtils.FORMATTER_DATE_TIME.parse(jsonImages.getJSONObject(i).getString("createdAt"));
                            start_date = jsonImages.getJSONObject(i).isNull("datedebut") ? null : DateUtils.FORMATTER_DATE_TIME.parse(jsonImages.getJSONObject(i).getString("datedebut"));
                            end_date = jsonImages.getJSONObject(i).isNull("datefin") ? null : DateUtils.FORMATTER_DATE_TIME.parse(jsonImages.getJSONObject(i).getString("datefin"));
                            namePub = jsonImages.getJSONObject(i).isNull("nom_publication") ? null : jsonImages.getJSONObject(i).getString("nom_publication");
                            System.out.println("LES DATES : Start : " + start_date + "End :" + end_date + "nom_publication :" + namePub + "createdAt :" + createdAt);
                            publicationsBorne = this.mPublicationBorneDao.findByName(namePub);
                            PublicationBorne publicationBorne2 = publicationBorne = publicationsBorne != null ? publicationsBorne : null;
                            if (dateNow.after(start_date) && dateNow.before(end_date)) {
                                if (publicationBorne == null) {
                                    JSONObject jsonImagePublication = jsonImages.getJSONObject(i);
                                    this.savePub(jsonImagePublication, publicationBorne, namePub, start_date, end_date, createdAt);
                                    existedPub.add(namePub);
                                }
                                AppLocal.IGNOR_DOWNLOAD_MEDIA_BORNE = true;
                                this.appConfig.setProperty("type.media.home", "Image");
                                continue;
                            }
                            if (publicationBorne == null) continue;
                            this.mPublicationBorneDao.deletePub(publicationBorne);
                            this.deleteExpiredPub(namePub, "image");
                        }
                    } else {
                        System.out.println("++++++++++++++delete Photo Pub");
                        this.deleteAllPhotoPub();
                        AppLocal.dlSales.deletePubs();
                    }
                    if (jsonVideo.length() > 0 && existedPub.isEmpty()) {
                        for (i = 0; i < jsonVideo.length(); ++i) {
                            PublicationBorne publicationVideoBorne;
                            jsonVideo.getJSONObject(i).toString();
                            createdAt = jsonVideo.getJSONObject(i).isNull("createdAt") ? null : DateUtils.FORMATTER_DATE_TIME.parse(jsonVideo.getJSONObject(i).getString("createdAt"));
                            start_date = jsonVideo.getJSONObject(i).isNull("datedebut") ? null : DateUtils.FORMATTER_DATE_TIME.parse(jsonVideo.getJSONObject(i).getString("datedebut"));
                            end_date = jsonVideo.getJSONObject(i).isNull("datefin") ? null : DateUtils.FORMATTER_DATE_TIME.parse(jsonVideo.getJSONObject(i).getString("datefin"));
                            namePub = jsonVideo.getJSONObject(i).isNull("nom_publication") ? null : jsonVideo.getJSONObject(i).getString("nom_publication");
                            System.out.println("LES DATES : Start : " + start_date + "End :" + end_date + "nom_publication :" + namePub + "createdAt :" + createdAt);
                            publicationsBorne = this.mPublicationBorneDao.findByName(namePub);
                            PublicationBorne publicationBorne = publicationVideoBorne = publicationsBorne != null ? publicationsBorne : null;
                            if (dateNow.after(start_date) && dateNow.before(end_date)) {
                                if (publicationVideoBorne == null) {
                                    this.savePubVid(jsonVideo, publicationsBorne, namePub, start_date, end_date, createdAt, i);
                                }
                                AppLocal.IGNOR_DOWNLOAD_MEDIA_BORNE = true;
                                this.appConfig.setProperty("type.media.home", "Video");
                                continue;
                            }
                            if (publicationVideoBorne == null) continue;
                            this.mPublicationBorneDao.deletePub(publicationVideoBorne);
                            this.deleteExpiredPub("videoPub", "video");
                        }
                    } else {
                        this.deleteExpiredPub("videoPub", "video");
                        AppLocal.dlSales.deletePubs();
                    }
                } else {
                    this.deleteAllPhotoPub();
                    AppLocal.dlSales.deletePubs();
                }
            } else {
                this.deleteAllPhotoPub();
                AppLocal.dlSales.deletePubs();
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", null, ex);
        }
    }

    public String getExtention(String URL2) {
        String ext = null;
        int lastSlashIndex = URL2.lastIndexOf("/");
        if (lastSlashIndex != -1) {
            ext = URL2.substring(lastSlashIndex + 1, URL2.indexOf("?"));
        }
        return ext.substring(ext.lastIndexOf(".") + 1);
    }

    public void saveDownloadedPublication(PublicationBorne publicationBorne, String type_media, Date last_update, Date start_date, Date end_date, Date createdAt, String namePub) {
        if (publicationBorne == null) {
            publicationBorne = new PublicationBorne();
            publicationBorne.setPublication_type(type_media);
            publicationBorne.setLast_update(last_update.getTime());
            publicationBorne.setStart_date(start_date.getTime());
            publicationBorne.setEnd_date(end_date.getTime());
            publicationBorne.setCreatdAt(createdAt.getTime());
            publicationBorne.setName_pub(namePub);
            this.save(publicationBorne);
        } else {
            publicationBorne.setPublication_type(type_media);
            publicationBorne.setLast_update(last_update.getTime());
            publicationBorne.setStart_date(start_date.getTime());
            publicationBorne.setEnd_date(end_date.getTime());
            publicationBorne.setCreatdAt(createdAt.getTime());
            publicationBorne.setName_pub(namePub);
            this.update(publicationBorne);
        }
    }

    public void setExpiredPublication(PublicationBorne publicationBorne) {
        if (publicationBorne != null && !publicationBorne.isExpired()) {
            AppLocal.FORCE_DOWNLOAD_MEDIA_BORNE = true;
            publicationBorne.setExpired(true);
            this.updateExpired(publicationBorne);
        }
    }

    public PublicationBorne getVideo(String Type2) {
        return this.mPublicationBorneDao.findByType(Type2);
    }

    public void DeleteFilesByName(String fileNameToMatch, File directory) {
        if (directory.exists() && directory.isDirectory()) {
            File[] files;
            for (File file : files = directory.listFiles()) {
                if (!file.isFile() || !file.getName().startsWith(fileNameToMatch)) continue;
                if (file.delete()) {
                    System.out.println("Deleted file: " + file.getAbsolutePath());
                    continue;
                }
                System.err.println("Failed to delete file: " + file.getAbsolutePath());
            }
        }
    }

    public void deleteAllPhotoPub() {
        try {
            List<PhotoDispaly> allPub = AppLocal.dlSales.getPubPhoto();
            for (PhotoDispaly photoDispaly : allPub) {
                this.deleteExpiredPub(photoDispaly.getPath(), "image");
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", null, ex);
        }
    }

    public void deleteExpiredPub(String namePub, String type) throws BasicException {
        AppLocal.dlSales.deletePubBornePhoto(namePub);
        File directory = null;
        if (type.equals("image")) {
            directory = new File(new File(System.getProperty("user.home")), "images/photosBorne");
        } else if (type.equals("video")) {
            directory = new File(new File(System.getProperty("user.home")), "images/logos");
        }
        this.DeleteFilesByName(namePub, directory);
    }

    public void savePub(JSONObject jsonImagePublication, PublicationBorne publicationBorne, String namePub, Date start_date, Date end_date, Date createdAt) {
        try {
            if (!jsonImagePublication.isNull("image_url")) {
                JSONArray jsonUrls = jsonImagePublication.getJSONArray("image_url");
                for (int j = 0; j < jsonUrls.length(); ++j) {
                    String imagelink = jsonUrls.getString(j);
                    System.out.println("+++++++++++++++jsonUrls" + jsonUrls.toString());
                    PhotoDispaly newPhoto = new PhotoDispaly();
                    String ext = this.getExtention(imagelink);
                    File directory = new File(new File(System.getProperty("user.home")), "images/photosBorne");
                    FileUtils.forceMkdir((File)directory);
                    String url = directory.getPath();
                    File dest = new File(url + "/" + namePub + j + "." + ext);
                    if (!dest.exists()) {
                        dest.createNewFile();
                    }
                    FileUtils.copyURLToFile((URL)new URL(imagelink), (File)dest);
                    newPhoto.setPath(namePub + j + "." + ext);
                    newPhoto.setLast_update(new Date());
                    System.out.println("+++++++++++++++++++++newPhoto" + newPhoto);
                    AppLocal.dlSales.addPubPhoto(newPhoto);
                }
            }
            this.saveDownloadedPublication(publicationBorne, "Image", new Date(), start_date, end_date, createdAt, namePub);
        }
        catch (Exception ex) {
            LogToFile.log("severe", null, ex);
        }
    }

    public void savePubVid(JSONArray jsonVideo, PublicationBorne publicationBorne, String namePub, Date start_date, Date end_date, Date createdAt, int i) {
        try {
            JSONObject jsonVideoPublication = jsonVideo.getJSONObject(i);
            System.out.println("++++++++++++++jsonVideoPublication" + jsonVideoPublication);
            if (!jsonVideoPublication.isNull("video_url")) {
                String linkVedio = jsonVideoPublication.getString("video_url");
                System.out.println("+++++++++++++++linkVedio" + linkVedio);
                String ext = this.getExtention(linkVedio);
                File directory = new File(new File(System.getProperty("user.home")), "images/logos");
                FileUtils.forceMkdir((File)directory);
                String url = directory.getPath();
                File dest = new File(url + "/videoPub." + ext);
                if (!dest.exists()) {
                    dest.createNewFile();
                }
                FileUtils.copyURLToFile((URL)new URL(linkVedio), (File)dest);
                this.appConfig.setProperty("video.borne", dest.getName());
            }
            this.saveDownloadedPublication(publicationBorne, "video", new Date(), start_date, end_date, createdAt, namePub);
        }
        catch (Exception ex) {
            LogToFile.log("severe", null, ex);
        }
    }
}

