/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.services;

import com.openbravo.basic.BasicException;
import com.openbravo.pos.forms.AppConfig;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.ticket.MarqueNFC;
import com.openbravo.pos.util.DateUtils;
import com.openbravo.pos.util.LogToFile;
import fr.protactile.procaisse.dao.entities.PromoCode;
import fr.protactile.procaisse.dao.impl.PromoCodeDao;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.json.JSONArray;
import org.json.JSONObject;

public class PromoCodeService {
    private static PromoCodeService m_instance;
    private PromoCodeDao mPromoCodeDao;
    private String URL_PROMO_CODE = "https://api-backoffice.biborne.com/api/reductions/redfind/";
    private final String ID = "id";
    private final String PROMO_CODE = "code_promo";
    private final String TYPE = "type";
    private final String AMOUNT = "montant";
    private final String SOURCE = "source";
    private final String DATE_START = "datedebut";
    private final String DATE_END = "datefin";
    private final String DELIVERY = "en_livraison";
    private final String TAKE_AWAY = "a_emporter";
    private final String AT_SPOT = "sur_place";
    private final String DRIVE = "drive";
    private final String UPDATEDAT = "updatedAt";
    private AppConfig appConfig;
    private String URL_PROMO_CODE_BY_FRANSHISE_SIRET = "https://api-backoffice.biborne.com/api/reductions/clickandcollect/";
    private String URL_SEND_PROMOCODE_USED = "https://json.biborne.com/api/v1/codepromoitem/NewItemused";
    private String SIRET_VAL = "";
    private final String CUSTOMER = "client";
    private final String FRANCHISE_ID = "franchiseId";
    private final String SIRET = "siret";
    private final String KEENIO = "KeenIo";
    private final String CODE_PROMO = "code_promo";
    private String KEENIO_VAL = "";
    public final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");

    private PromoCodeService() {
        this.mPromoCodeDao = new PromoCodeDao();
        if (AppLocal.dlSales != null) {
            try {
                MarqueNFC marqueNF = MarqueNFC.fetchOrStore(AppLocal.dlSales);
                if (marqueNF != null) {
                    this.SIRET_VAL = marqueNF.getSiret();
                }
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
        if (AppLocal.dlItems != null) {
            try {
                this.KEENIO_VAL = AppLocal.dlItems.getUserKeenIo();
                if (this.KEENIO_VAL == null) {
                    this.KEENIO_VAL = "-";
                }
            }
            catch (BasicException ex) {
                LogToFile.log("severe", null, ex);
            }
        }
    }

    public static PromoCodeService getInstance() {
        if (m_instance == null) {
            m_instance = new PromoCodeService();
        }
        return m_instance;
    }

    public void downloadPromoCode() {
        try {
            MarqueNFC marqueNF = MarqueNFC.fetchOrStore(AppLocal.dlSales);
            System.out.println("+++++++++ marqueNF : " + marqueNF);
            if (marqueNF != null) {
                System.out.println("++++++++++++ marqueNF.getSiret() : " + marqueNF.getSiret());
                if (marqueNF.getSiret() != null && !marqueNF.getSiret().isEmpty()) {
                    Request request;
                    String url = this.URL_PROMO_CODE + marqueNF.getSiret();
                    OkHttpClient client = new OkHttpClient().newBuilder().build();
                    Response response = client.newCall(request = new Request.Builder().url(url).method("GET", null).build()).execute();
                    if (response.code() == 200) {
                        String response_promo_code = response.body().string();
                        JSONArray arrayPromoCode = new JSONArray(response_promo_code);
                        System.out.println("++++++++++++++++ jsonResponse ********************: " + arrayPromoCode);
                        for (int i = 0; i < arrayPromoCode.length(); ++i) {
                            JSONObject jsonPromoCode = arrayPromoCode.getJSONObject(i);
                            int id_source = jsonPromoCode.isNull("id") ? 0 : jsonPromoCode.getInt("id");
                            PromoCode mPromoCode = this.mPromoCodeDao.findByIdSource(id_source);
                            System.out.println("++++++++++++ mPromoCode : " + mPromoCode);
                            if (mPromoCode != null) {
                                Date last_update;
                                Date date = last_update = jsonPromoCode.isNull("updatedAt") ? null : DateUtils.FORMATTER_DATE_TIME_ZONE_SSS.parse(jsonPromoCode.getString("updatedAt"));
                                if (!mPromoCode.getLast_update().before(last_update)) continue;
                                this.setInfoPromoCode(mPromoCode, jsonPromoCode);
                                this.mPromoCodeDao.merge(mPromoCode);
                                continue;
                            }
                            mPromoCode = new PromoCode();
                            this.setInfoPromoCode(mPromoCode, jsonPromoCode);
                            this.mPromoCodeDao.save(mPromoCode);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            LogToFile.log("severe", e.getMessage(), e);
        }
    }

    private void setInfoPromoCode(PromoCode mPromoCode, JSONObject jsonPromoCode) throws ParseException {
        mPromoCode.setPromo_code(jsonPromoCode.getString("code_promo"));
        mPromoCode.setType(jsonPromoCode.getString("type"));
        mPromoCode.setAmount(jsonPromoCode.getDouble("montant"));
        mPromoCode.setSource(jsonPromoCode.optString("source"));
        mPromoCode.setDelivery(jsonPromoCode.getBoolean("en_livraison"));
        mPromoCode.setTake_away(jsonPromoCode.getBoolean("a_emporter"));
        mPromoCode.setAt_spot(jsonPromoCode.getBoolean("sur_place"));
        mPromoCode.setDrive(jsonPromoCode.getBoolean("drive"));
        mPromoCode.setId_source(jsonPromoCode.getInt("id"));
        Date date_start = jsonPromoCode.isNull("datedebut") ? null : DateUtils.FORMATTER_DATE_TIME_ZONE_SSS.parse(jsonPromoCode.getString("datedebut"));
        Date date_end = jsonPromoCode.isNull("datefin") ? null : DateUtils.FORMATTER_DATE_TIME_ZONE_SSS.parse(jsonPromoCode.getString("datefin"));
        Date last_update = jsonPromoCode.isNull("updatedAt") ? null : DateUtils.FORMATTER_DATE_TIME_ZONE_SSS.parse(jsonPromoCode.getString("updatedAt"));
        mPromoCode.setDate_start(date_start);
        mPromoCode.setDate_end(date_end);
        mPromoCode.setLast_update(last_update);
    }

    public PromoCode getPromoCode(String promo_code) {
        return this.mPromoCodeDao.getPromoCode(promo_code);
    }

    public PromoCode downloadPromoCodeByCode(String code) {
        if (AppLocal.FRANCHISE_ID != null && !AppLocal.FRANCHISE_ID.isEmpty()) {
            try {
                MarqueNFC marqueNF = MarqueNFC.fetchOrStore(AppLocal.dlSales);
                System.out.println("+++++++++ marqueNF : " + marqueNF);
                if (marqueNF != null) {
                    System.out.println("++++++++++++ marqueNF.getSiret() : " + marqueNF.getSiret());
                    if (marqueNF.getSiret() != null && !marqueNF.getSiret().isEmpty()) {
                        String response_promo_code;
                        String url = this.URL_PROMO_CODE_BY_FRANSHISE_SIRET + AppLocal.FRANCHISE_ID + "&" + code + "&" + marqueNF.getSiret();
                        System.out.println("+++++ url : " + url);
                        OkHttpClient client = new OkHttpClient().newBuilder().build();
                        Request request = new Request.Builder().url(url).method("GET", null).build();
                        Response response = client.newCall(request).execute();
                        if (response.code() == 200 && (response_promo_code = response.body().string()) != null && !response_promo_code.isEmpty()) {
                            System.out.println("++ response_promo_code : " + response_promo_code);
                            JSONObject jsonPromoCode = new JSONObject(response_promo_code);
                            PromoCode mPromoCode = new PromoCode();
                            this.setInfoPromoCode(mPromoCode, jsonPromoCode);
                            System.out.println("+++++ mPromoCode : " + mPromoCode);
                            return mPromoCode;
                        }
                    }
                }
            }
            catch (Exception e) {
                LogToFile.log("severe", e.getMessage(), e);
            }
        }
        return null;
    }

    public void sendUsedPromocode(String promoCode, String type, String phoneCustomer) {
        try {
            JSONObject json = new JSONObject();
            json.put("siret", (Object)this.SIRET_VAL);
            json.put("franchiseId", (Object)AppLocal.FRANCHISE_ID);
            json.put("code_promo", (Object)promoCode);
            json.put("KeenIo", (Object)this.KEENIO_VAL);
            json.put("type", (Object)type);
            json.put("client", (Object)phoneCustomer);
            System.out.println("+++++++++ json : " + json);
            OkHttpClient client = new OkHttpClient();
            RequestBody body = RequestBody.create((MediaType)this.JSON, (String)json.toString());
            Request request = new Request.Builder().url(this.URL_SEND_PROMOCODE_USED).post(body).build();
            Response response = client.newCall(request).execute();
            System.out.println("+++++++ response : " + response);
        }
        catch (IOException e) {
            LogToFile.log("severe", e.getMessage(), e);
        }
    }
}

