/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.services;

import fr.protactile.procaisse.dao.entities.PertEntity;
import fr.protactile.procaisse.dao.impl.PertEntityDao;
import fr.protactile.procaisse.dao.impl.PertInfosDao;
import java.util.Date;
import java.util.List;

public class PertEntityServices {
    private static PertEntityServices m_instance;
    private PertEntityDao mPertEntityDao = new PertEntityDao();
    private PertInfosDao mPertInfosDao = new PertInfosDao();

    private PertEntityServices() {
    }

    public static PertEntityServices getInstance() {
        if (m_instance == null) {
            m_instance = new PertEntityServices();
        }
        return m_instance;
    }

    public List<PertEntity> getPertes() {
        return this.mPertEntityDao.getPertes();
    }

    public void addPerteEntity(PertEntity mPertEntity) {
        this.mPertEntityDao.addPerteInfo(mPertEntity);
    }

    public void deletePerteEntity(PertEntity mPertEntity) {
        this.mPertEntityDao.deletePerte(mPertEntity);
    }

    public void updatePerteEntity(PertEntity mPertEntity) {
        this.mPertEntityDao.updatePerte(mPertEntity);
    }

    public List<PertEntity> getAllPertEntitys() {
        return this.mPertEntityDao.list();
    }

    public List<PertEntity> findPertByTimeRange(Date dateStart, Date dateEnd) {
        List<PertEntity> pertes = this.mPertEntityDao.findPertByTimeRange(dateStart, dateEnd);
        for (PertEntity perte : pertes) {
            perte.setPertInfoCollection(this.mPertInfosDao.findByEntity(perte.getId()));
        }
        return pertes;
    }
}

