/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.services;

import com.openbravo.basic.BasicException;
import fr.protactile.procaisse.dao.entities.NutrientData;
import fr.protactile.procaisse.dao.impl.NutrientDataDao;
import java.util.List;

public class NutrientDataService {
    private static NutrientDataService m_instance;
    private NutrientDataDao mNutrientDao = new NutrientDataDao();

    private NutrientDataService() {
    }

    public static NutrientDataService getInstance() {
        if (m_instance == null) {
            m_instance = new NutrientDataService();
        }
        return m_instance;
    }

    public NutrientData findOne(Integer id) {
        return this.mNutrientDao.getById(id);
    }

    public NutrientData add(NutrientData data) throws BasicException {
        data.onBeforeSave();
        this.mNutrientDao.addNutrientData(data);
        if (data.getId() == null) {
            throw new BasicException("\u00c9chec de l'enregistrement de NutrientData.");
        }
        return data;
    }

    public void update(NutrientData data) {
        if (data == null || data.getNutrient() == null || data.getNutrient().isEmpty()) {
            return;
        }
        NutrientData existingNutrientData = this.mNutrientDao.getByNutrient(data.getNutrient());
        if (existingNutrientData != null) {
            existingNutrientData.setColor(data.getColor());
            existingNutrientData.setImage(data.getImage());
            this.mNutrientDao.updateNutrientData(existingNutrientData);
        } else {
            this.mNutrientDao.addNutrientData(data);
        }
    }

    public void delete(NutrientData data) {
        this.mNutrientDao.deleteNutrientData(data);
    }

    public List<NutrientData> findAll() {
        return this.mNutrientDao.getAllNutrients();
    }

    public NutrientData findNutri(String nutrient) {
        return this.mNutrientDao.getByNutrient(nutrient);
    }
}

