/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.services;

import fr.protactile.procaisse.dao.entities.LoyaltyCardInfo;
import fr.protactile.procaisse.dao.impl.LoyaltyCardInfoDao;
import java.util.Date;
import java.util.List;

public class LoyaltyCardService {
    private static LoyaltyCardService m_instance;
    private LoyaltyCardInfoDao mLoyaltyCardInfoDao = new LoyaltyCardInfoDao();

    private LoyaltyCardService() {
    }

    public static LoyaltyCardService getInstance() {
        if (m_instance == null) {
            m_instance = new LoyaltyCardService();
        }
        return m_instance;
    }

    public LoyaltyCardInfo getLoyaltyCardByBarCode(String code_carte) {
        return this.mLoyaltyCardInfoDao.getLoyaltyCardByBarCode(code_carte);
    }

    public void increaseCredit(double tunover, int id_customer) {
        try {
            this.mLoyaltyCardInfoDao.getCurrentSession().getTransaction().begin();
            this.mLoyaltyCardInfoDao.increaseCredit(tunover, id_customer);
            this.mLoyaltyCardInfoDao.getCurrentSession().getTransaction().commit();
        }
        catch (Exception e) {
            this.mLoyaltyCardInfoDao.getCurrentSession().getTransaction().rollback();
        }
    }

    public void decreaseCredit(double credit, int idLoyaltyCard) {
        try {
            this.mLoyaltyCardInfoDao.getCurrentSession().getTransaction().begin();
            this.mLoyaltyCardInfoDao.decreaseCredit(credit, idLoyaltyCard);
            LoyaltyCardInfo mLoyaltyCardInfo = (LoyaltyCardInfo)this.mLoyaltyCardInfoDao.find(idLoyaltyCard);
            Date date_now = new Date();
            if (date_now.getDate() != mLoyaltyCardInfo.getInitialized_at().getDate() || date_now.getYear() != mLoyaltyCardInfo.getInitialized_at().getYear() || date_now.getMonth() != mLoyaltyCardInfo.getInitialized_at().getMonth()) {
                this.mLoyaltyCardInfoDao.initializeCard(mLoyaltyCardInfo.getId());
            }
            this.mLoyaltyCardInfoDao.increaseNumberUser(mLoyaltyCardInfo.getId());
            this.mLoyaltyCardInfoDao.getCurrentSession().getTransaction().commit();
        }
        catch (Exception e) {
            this.mLoyaltyCardInfoDao.getCurrentSession().getTransaction().rollback();
        }
    }

    public List<LoyaltyCardInfo> findByCustomer(int customer_id) {
        return this.mLoyaltyCardInfoDao.findByCustomer(customer_id);
    }
}

