/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.services;

import fr.protactile.procaisse.dao.entities.LanguageInfo;
import fr.protactile.procaisse.dao.impl.LanguageInfoDao;
import java.util.List;

public class LanguageService {
    private static LanguageService m_instance;
    private LanguageInfoDao languageInfoDao = new LanguageInfoDao();

    private LanguageService() {
    }

    public static LanguageService getInstance() {
        if (m_instance == null) {
            m_instance = new LanguageService();
        }
        return m_instance;
    }

    public List<LanguageInfo> getAllLanguages() {
        return this.languageInfoDao.getAllLanguages();
    }

    public List<LanguageInfo> getEnabledLanguages() {
        return this.languageInfoDao.getEnabledLanguages();
    }

    public LanguageInfo addLanguage(LanguageInfo languageInfo) {
        return this.languageInfoDao.addLanguage(languageInfo);
    }

    public void setEnabled(List<LanguageInfo> languages) {
        for (LanguageInfo language : languages) {
            this.languageInfoDao.setEnabled(language);
        }
    }

    public void setLanguages(List<LanguageInfo> languages) {
        for (LanguageInfo language : languages) {
            LanguageInfo language_DB = this.languageInfoDao.getLanguageByCode(language.getCode_language());
            if (language_DB != null) {
                language_DB.setDefault_language(language.isDefault_language());
                language_DB.setEnabled(language.isEnabled());
                language_DB.setLabel_language(language.getLabel_language());
                this.languageInfoDao.setLanguage(language_DB);
                continue;
            }
            this.languageInfoDao.addLanguage(language);
        }
        List<LanguageInfo> languagesDB = this.getAllLanguages();
        for (LanguageInfo languageDB : languagesDB) {
            boolean languageExist = false;
            for (LanguageInfo language : languages) {
                if (language.getCode_language() == null || !language.getCode_language().equalsIgnoreCase(languageDB.getCode_language())) continue;
                languageExist = true;
                break;
            }
            if (languageExist) continue;
            languageDB.setEnabled(false);
            this.languageInfoDao.setEnabled(languageDB);
        }
    }

    public LanguageInfo getDefaultLanguage() {
        return this.languageInfoDao.getDefaultLanguage();
    }
}

