/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.services;

import com.openbravo.basic.BasicException;
import com.openbravo.components.LazyModal;
import com.openbravo.components.base.AppLoaderBuilder;
import com.openbravo.components.interfaces.EventHiddenModal;
import com.openbravo.controllers.LicenceKeyController;
import com.openbravo.pos.forms.AppConfig;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.ticket.MarqueNFC;
import com.openbravo.pos.util.AppVarUtils;
import com.openbravo.pos.util.DateUtils;
import com.openbravo.pos.util.Event;
import com.openbravo.pos.util.FilerUtils;
import com.openbravo.pos.util.Journal;
import com.openbravo.pos.util.LogToFile;
import com.openbravo.pos.util.NetWorkUtils;
import com.openbravo.pos.util.SystemUtils;
import fr.protactile.procaisse.dao.entities.CaisseInfo;
import fr.protactile.procaisse.dao.entities.InfoLicenceGenerated;
import fr.protactile.procaisse.dao.entities.LicenceInfo;
import fr.protactile.procaisse.dao.impl.CaisseInfoDao;
import fr.protactile.procaisse.dao.impl.InfoLicenceGeneratedDao;
import fr.protactile.procaisse.services.BlockingCheckService;
import fr.protactile.procaisse.services.CurrencyPOSService;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.scene.Scene;
import javafx.stage.StageStyle;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.io.FileUtils;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.json.JSONObject;

public class InfoLicenceGeneratedService {
    private static InfoLicenceGeneratedService m_instance;
    private InfoLicenceGeneratedDao mInfoLicenceGeneratedDao;
    private LazyModal mLazyModalPopUpKey = null;
    private EventHiddenModal mActionEventPopupKey = null;
    private final String licenceKeyFxml = "/fxml/popUp_licence.fxml";
    private MarqueNFC marqueNF;
    private String keenio;
    AppConfig config;
    private CaisseInfoDao mCaisseInfoDao;
    final FilerUtils m_FilerUtils = FilerUtils.getInstance();
    private BlockingCheckService blockingCheckService;
    private CurrencyPOSService currencyPOSService;

    private InfoLicenceGeneratedService() {
        try {
            this.mInfoLicenceGeneratedDao = new InfoLicenceGeneratedDao();
            this.marqueNF = MarqueNFC.fetchOrStore(AppLocal.dlSales);
            this.keenio = AppLocal.dlItems.getUserKeenIo();
            this.config = AppConfig.getInstance(true, this.m_FilerUtils.getFileProperties());
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public static InfoLicenceGeneratedService getInstance() {
        if (m_instance == null) {
            m_instance = new InfoLicenceGeneratedService();
        }
        return m_instance;
    }

    private String getLicenceIdIfExist() {
        String extractedlicenceId = null;
        String licenseKeyFileOnDisk = SystemUtils.SYS_USER_HOME + File.separator + "procaisse_licence.lic";
        if (new File(licenseKeyFileOnDisk).exists()) {
            try {
                String licenseKeyString = FileUtils.readFileToString((File)new File(licenseKeyFileOnDisk));
                System.out.println(" **************  licenseKeyString ************** : " + licenseKeyString);
                Pattern pattern = Pattern.compile("\\(id: (\\d+)\\)");
                Matcher matcher = pattern.matcher(licenseKeyString);
                if (matcher.find()) {
                    extractedlicenceId = matcher.group(1);
                    System.out.println("Licence Id Number: " + extractedlicenceId);
                    new File(licenseKeyFileOnDisk).delete();
                }
            }
            catch (IOException ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
        return extractedlicenceId;
    }

    public InfoLicenceGenerated save() {
        if (this.mInfoLicenceGeneratedDao.getSessionFactory() != null) {
            InfoLicenceGenerated mInfoLicenceGenerated = new InfoLicenceGenerated();
            long leftLimit = 1L;
            long rightLimit = 10000000000000L;
            String extractedlicenceId = this.getLicenceIdIfExist();
            long generatedLicenceId = extractedlicenceId != null ? Long.parseLong(extractedlicenceId) : leftLimit + (long)(Math.random() * (double)(rightLimit - leftLimit));
            mInfoLicenceGenerated.setLicence_id(generatedLicenceId);
            long generatedActivationId = leftLimit + (long)(Math.random() * (double)(rightLimit - leftLimit));
            mInfoLicenceGenerated.setActivation_id(generatedActivationId);
            Session session = this.mInfoLicenceGeneratedDao.getSessionFactory().getCurrentSession();
            Transaction tx = session.beginTransaction();
            session.save((Object)mInfoLicenceGenerated);
            tx.commit();
            return mInfoLicenceGenerated;
        }
        return null;
    }

    public InfoLicenceGenerated find() {
        List infosLicence = this.mInfoLicenceGeneratedDao.list();
        return infosLicence != null && !infosLicence.isEmpty() ? (InfoLicenceGenerated)infosLicence.get(0) : null;
    }

    public void setInfoLicenceGenerated() {
        InfoLicenceGenerated mInfoLicenceGenerated = this.find();
        if (mInfoLicenceGenerated == null) {
            mInfoLicenceGenerated = this.save();
        }
        if (mInfoLicenceGenerated != null) {
            AppLocal.LICENCE_ID_GENERATED = mInfoLicenceGenerated.getLicence_id();
            AppLocal.ACTIVATION_ID_GENERATED = mInfoLicenceGenerated.getActivation_id();
        } else {
            AppLocal.LICENCE_ID_GENERATED = -1L;
            AppLocal.ACTIVATION_ID_GENERATED = -1L;
        }
    }

    public void resetLicence() {
        InfoLicenceGenerated mInfoLicenceGenerated = this.find();
        mInfoLicenceGenerated = mInfoLicenceGenerated == null ? this.save() : this.update(mInfoLicenceGenerated);
        if (mInfoLicenceGenerated != null) {
            AppLocal.LICENCE_ID_GENERATED = mInfoLicenceGenerated.getLicence_id();
            AppLocal.ACTIVATION_ID_GENERATED = mInfoLicenceGenerated.getActivation_id();
        } else {
            AppLocal.LICENCE_ID_GENERATED = -1L;
            AppLocal.ACTIVATION_ID_GENERATED = -1L;
        }
    }

    public InfoLicenceGenerated update(InfoLicenceGenerated mInfoLicenceGenerated) {
        if (this.mInfoLicenceGeneratedDao.getSessionFactory() != null) {
            long leftLimit = 1L;
            long rightLimit = 10000000000000L;
            long generatedLicenceId = leftLimit + (long)(Math.random() * (double)(rightLimit - leftLimit));
            mInfoLicenceGenerated.setLicence_id(generatedLicenceId);
            long generatedActivationId = leftLimit + (long)(Math.random() * (double)(rightLimit - leftLimit));
            mInfoLicenceGenerated.setActivation_id(generatedActivationId);
            this.mInfoLicenceGeneratedDao.updateLicence(mInfoLicenceGenerated);
        }
        return null;
    }

    public void updateUserKeenIo(String keenio, String siret, LicenceInfo licence) {
        try {
            if (AppLocal.dlItems != null) {
                AppLocal.dlItems.updateUserKeenIo(keenio);
            }
            MarqueNFC marqueNF = MarqueNFC.fetchOrStore(AppLocal.dlSales);
            System.out.println("++++++ marqueNF : " + marqueNF);
            if (marqueNF == null) {
                marqueNF = new MarqueNFC();
            }
            JSONObject data = this.getInfoRestaurant(siret);
            System.out.println("++ data : " + data);
            if (data != null) {
                JSONObject countryInfo;
                String pseudo;
                if (!data.isNull("adresse")) {
                    System.out.println("+++++++++++++ data.getString(\"adresse\") : " + data.getString("adresse"));
                    marqueNF.setAdresse1(data.getString("adresse"));
                }
                if (!data.isNull("codepostal")) {
                    marqueNF.setZipCode(data.getString("codepostal"));
                }
                String name = !data.isNull("nom") ? data.getString("nom") : null;
                String string = pseudo = !data.isNull("pseudo") ? data.getString("pseudo") : null;
                if (name != null && !name.isEmpty()) {
                    marqueNF.setCompany(name);
                } else {
                    marqueNF.setCompany(pseudo);
                }
                if (!data.isNull("telephone")) {
                    marqueNF.setTel(data.getString("telephone"));
                }
                if (!data.isNull("email")) {
                    marqueNF.setEmail(data.getString("email"));
                }
                if (!data.isNull("tva_intra")) {
                    marqueNF.setIntraTVA(data.getString("tva_intra"));
                }
                if (!data.isNull("code_naf")) {
                    marqueNF.setCodeNAF(data.getString("code_naf"));
                }
                if (!data.isNull("ville")) {
                    marqueNF.setCity(data.getString("ville"));
                }
                if (!data.isNull("country")) {
                    marqueNF.setCountry(data.getString("country"));
                }
                if (!data.isNull("forme_juridique")) {
                    marqueNF.setForme_juridique(data.getString("forme_juridique"));
                }
                if (!data.isNull("capital_social")) {
                    marqueNF.setCapital_social(data.getString("capital_social"));
                }
                if (!data.isNull("rcs")) {
                    marqueNF.setRcs(data.getString("rcs"));
                }
                if (!data.isNull("ville_du_greffe")) {
                    marqueNF.setGreffe(data.getString("ville_du_greffe"));
                }
                if (!data.isNull("metier")) {
                    marqueNF.setMetier(data.getString("metier"));
                }
                if (licence != null && licence.getDateFirstConnexion() != null) {
                    marqueNF.setDateFirstConnexion(licence.getDateFirstConnexion());
                }
                if (!data.isNull("countryInfo") && !(countryInfo = data.getJSONObject("countryInfo")).isNull("name")) {
                    marqueNF.setCountry(countryInfo.getString("name"));
                }
            }
            marqueNF.setSiret(siret);
            AppLocal.dlSales.addMarqueNF(marqueNF);
            System.out.println("++++++++++++++siret Saved" + siret);
        }
        catch (BasicException ex) {
            LogToFile.log("severe", null, ex);
        }
    }

    public LicenceInfo getInfoLicence(boolean saveEquipment) {
        try {
            String siret = this.marqueNF != null ? this.marqueNF.getSiret() : null;
            return this.getInfoLicence(this.keenio, siret, saveEquipment);
        }
        catch (Exception ex) {
            LogToFile.log("severe", null, ex);
            return null;
        }
    }

    public LicenceInfo getInfoLicence(String key, String siret, boolean saveEquipment) {
        if (key == null || key.isEmpty() || siret == null || siret.isEmpty()) {
            return null;
        }
        boolean checkActiveEquipment = false;
        LicenceInfo licence = null;
        try {
            OkHttpClient client = new OkHttpClient.Builder().writeTimeout(1L, TimeUnit.MINUTES).readTimeout(1L, TimeUnit.MINUTES).build();
            String resourceUrl = "https://json.biborne.com/api/v1/VersionRestaurant/findOneCheckIfExist/" + siret + "&" + key;
            System.out.println("++++++++ resourceUrl : " + resourceUrl);
            Request request = new Request.Builder().url(resourceUrl).get().build();
            Response response = client.newCall(request).execute();
            System.out.println("response code : " + response.code());
            JSONObject data = null;
            if (response != null) {
                System.out.println("response.code() test : " + response.code());
                if (response.code() == 200) {
                    String response_body = response.body().string();
                    System.out.println("response_body : " + response_body);
                    if (response_body != null && !response_body.isEmpty()) {
                        JSONObject jsonResponse = new JSONObject(response_body);
                        licence = new LicenceInfo();
                        if (!jsonResponse.isNull("data")) {
                            String association;
                            data = jsonResponse.getJSONObject("data");
                            String string = association = data.isNull("association") ? null : data.getString("association");
                            if (association != null) {
                                switch (association) {
                                    case "exists": {
                                        JSONObject countryObject;
                                        JSONObject suppObject;
                                        boolean active = data.isNull("user_keen_id") ? false : data.getBoolean("active");
                                        boolean blocked = data.isNull("blocked") ? false : data.getBoolean("blocked");
                                        String addressMac = data.isNull("adresseMac") ? null : data.getString("adresseMac");
                                        String type = data.isNull("type") ? null : data.getString("type");
                                        String typedisplay = data.isNull("typedisplay") ? null : data.getString("typedisplay");
                                        String ipmaster = data.isNull("ipmaster") ? null : data.getString("ipmaster");
                                        int temporary_use_period = data.isNull("user_keen_id") ? null : Integer.valueOf(data.getInt("temporary_use_period"));
                                        Date daily_date = data.isNull("daily_date") ? null : DateUtils.FORMATTER_DATE_TIME_ZONE_SSS.parse(data.getString("daily_date"));
                                        Date blocked_at = data.isNull("blocked_at") ? new Date() : DateUtils.FORMATTER_DATE_TIME_ZONE_SSS.parse(data.getString("blocked_at"));
                                        licence.setActive(active);
                                        licence.setBlocked(blocked);
                                        licence.setType(type != null ? type : "");
                                        licence.setTypedisplay(typedisplay != null ? typedisplay : "");
                                        licence.setIpmaster(ipmaster != null ? ipmaster : "");
                                        licence.setTemporary_use_period(temporary_use_period);
                                        licence.setDailyDate(daily_date);
                                        licence.setActive(active);
                                        licence.setFranchise_id(data.isNull("fk_franchise") ? null : String.valueOf(data.getInt("fk_franchise")));
                                        licence.setName_machine(data.isNull("name") ? null : String.valueOf(data.getString("name")));
                                        licence.setBlockingDate(blocked_at);
                                        if (!(data.isNull("supp") || (suppObject = data.getJSONObject("supp")).isNull("countryInfo") || (countryObject = suppObject.getJSONObject("countryInfo")).isNull("currencyInfo"))) {
                                            String currency_symbol;
                                            JSONObject currencyObject = countryObject.getJSONObject("currencyInfo");
                                            int currency_decimal = currencyObject.isNull("decimals") ? 2 : currencyObject.getInt("decimals");
                                            String string2 = currency_symbol = currencyObject.isNull("symbol") ? null : currencyObject.getString("symbol");
                                            if (currency_symbol != null && !currency_symbol.isEmpty()) {
                                                NumberFormat currencyFormat = NumberFormat.getNumberInstance();
                                                currencyFormat.setMaximumFractionDigits(currency_decimal);
                                                currencyFormat.setMinimumFractionDigits(currency_decimal);
                                                StringBuilder currency_format = new StringBuilder();
                                                currency_format.append("#");
                                                currency_format.append(currencyFormat.format(0L).replace(",", "."));
                                                currency_format.append(" ");
                                                currency_format.append(currency_symbol);
                                                licence.setCurrency(currency_format.toString());
                                            }
                                            if (this.currencyPOSService == null) {
                                                this.currencyPOSService = CurrencyPOSService.getInstance();
                                            }
                                            this.currencyPOSService.checkAndSaveCurrencyPOS(currencyObject);
                                        }
                                        if (data.isNull(key)) {
                                            if (blocked) {
                                                licence.setErreurMsg("\u00c9quipement bloqu\u00e9");
                                            } else if (active && addressMac != null && !this.isMacAddressCorrect(addressMac)) {
                                                licence.setActive(false);
                                                licence.setErreurMsg("Licence activ\u00e9 sur un autre \u00e9quipement");
                                            } else if (!active) {
                                                licence.setErreurMsg("\u00c9quipement non-activ\u00e9");
                                            }
                                        }
                                        checkActiveEquipment = true;
                                        break;
                                    }
                                    case "not_linked": {
                                        licence.setErreurMsg("\u00c9quipement non associ\u00e9 au restaurant.");
                                        break;
                                    }
                                    case "not_found": {
                                        licence.setErreurMsg("\u00c9quipement inexistant");
                                    }
                                }
                            } else {
                                licence.setErreurMsg("Informations saisies incorrectes");
                            }
                        } else {
                            licence.setActive(false);
                            licence.setErreurMsg("Informations saisies incorrectes");
                        }
                    } else {
                        System.out.println("++++++++++++++++ data null");
                    }
                }
                if (response.code() == 404) {
                    licence = new LicenceInfo();
                    licence.setActive(false);
                    licence.setErreurMsg("\u00c9quipement inexistant");
                }
                System.out.println("licence error : " + licence.getErrorMsg());
            }
            response.close();
            if (checkActiveEquipment) {
                this.checkAndActiveEquipment(data, licence, saveEquipment);
            }
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return licence;
    }

    public LicenceInfo checkLicence() {
        LicenceInfo license = null;
        try {
            InfoLicenceGeneratedService infoLicenceGeneratedService = InfoLicenceGeneratedService.getInstance();
            license = infoLicenceGeneratedService.getInfoLicence(false);
            System.out.println("license : " + license);
            if (license != null) {
                boolean blocked = license.isBlocked();
                boolean active = license.isActive();
                AppLocal.licenceActivated = !blocked;
                CaisseInfo caisseInfo = AppLocal.dlSales.getCaisse(AppLocal.token);
                if (caisseInfo != null) {
                    caisseInfo.setActive(active);
                    this.mCaisseInfoDao = new CaisseInfoDao();
                    this.mCaisseInfoDao.updateStatusBlocked(caisseInfo);
                }
                this.blockingCheckService = BlockingCheckService.getInstance();
                this.blockingCheckService.setBlockingCheck(blocked, license.getBlockingDate());
                if (this.marqueNF != null && this.marqueNF.getDateFirstConnexion() == null && license.getDateFirstConnexion() != null) {
                    this.marqueNF.setDateFirstConnexion(license.getDateFirstConnexion());
                    AppLocal.dlSales.setPOSDateFirstConnexion(this.marqueNF);
                }
            }
        }
        catch (BasicException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return license;
    }

    private void loadPopUpKey(Scene parentScene, String message_error) {
        try {
            double height = this.marqueNF != null ? 700.0 : 300.0;
            this.mActionEventPopupKey = new EventHiddenModal(){
                boolean result;

                @Override
                public void onHidden() {
                    InfoLicenceGeneratedService.this.mLazyModalPopUpKey.destroyEvents();
                    InfoLicenceGeneratedService.this.mActionEventPopupKey = null;
                    if (!this.result && !AppLocal.licenceActivated.booleanValue()) {
                        InfoLicenceGeneratedService.this.exit();
                    }
                }

                @Override
                public void onHidden(AppLoaderBuilder mBuilder) {
                    if (mBuilder != null && mBuilder.getController() != null) {
                        LicenceKeyController mController = (LicenceKeyController)((Object)mBuilder.getController());
                        this.result = mController.getResult();
                    }
                    this.onHidden();
                }
            };
            if (this.mLazyModalPopUpKey == null) {
                this.mLazyModalPopUpKey = new LazyModal(StageStyle.UNDECORATED, parentScene, "/fxml/popUp_licence.fxml", new Dimension((int)AppVarUtils.getScreenDimension().getWidth(), (int)AppVarUtils.getScreenDimension().getHeight()));
            }
            this.mLazyModalPopUpKey.setEventHiddenModal(this.mActionEventPopupKey);
            this.mLazyModalPopUpKey.load(this.marqueNF, this.keenio, message_error);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void exit() {
        try {
            Journal.writeToJET(new Event(40, "Arret de l'application", "", "", new Date().getTime(), "licence indisponible"));
        }
        catch (Exception ex) {
            LogToFile.log("severe", null, ex);
        }
        System.exit(0);
    }

    public JSONObject getInfoRestaurant(String siret) {
        JSONObject data = null;
        try {
            OkHttpClient client = new OkHttpClient.Builder().writeTimeout(2L, TimeUnit.MINUTES).readTimeout(2L, TimeUnit.MINUTES).connectTimeout(1L, TimeUnit.MINUTES).build();
            String resourceUrl = "https://json.biborne.com/api/v1/restos/findOneRestaurantCheckCaisse/" + siret;
            System.out.println("++++++++ resourceUrl : " + resourceUrl);
            Request request = new Request.Builder().url(resourceUrl).get().build();
            Response response = client.newCall(request).execute();
            String response_body = response.body().string();
            System.out.println("response_body : " + response_body);
            if (response_body != null && !response_body.isEmpty()) {
                data = new JSONObject(response_body);
            }
            response.close();
        }
        catch (Exception ex) {
            LogToFile.log("severe", null, ex);
        }
        return data;
    }

    public void activateEquipment(String key, String siret, LicenceInfo licence) {
        System.out.println("+++++++++++++++++activateEquipment()");
        try {
            JSONObject jsonParams = new JSONObject();
            jsonParams.put("siret", (Object)siret);
            jsonParams.put("user_keen_id", (Object)key);
            jsonParams.put("active", true);
            jsonParams.put("adresseMac", (Object)NetWorkUtils.getMacAddress());
            jsonParams.put("version", (Object)"10.0.1.27");
            RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)jsonParams.toString());
            OkHttpClient client = new OkHttpClient.Builder().writeTimeout(1L, TimeUnit.MINUTES).readTimeout(1L, TimeUnit.MINUTES).build();
            String resourceUrl = "https://json.biborne.com/api/v1/VersionRestaurant/updateRestoAfterCheck";
            System.out.println("++++++++ resourceUrl : " + resourceUrl);
            Request request = new Request.Builder().url(resourceUrl).put(requestBody).build();
            Response response = client.newCall(request).execute();
            String response_body = response.body().string();
            System.out.println("response_body : " + response_body);
            if (response.code() == 200) {
                licence.setActive(true);
            }
            response.close();
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    private void checkAndActiveEquipment(JSONObject data, LicenceInfo licence, boolean saveEquipment) {
        if (data != null && licence != null) {
            boolean activeEuipement;
            String key = data.isNull("user_keen_id") ? null : data.getString("user_keen_id");
            String siret = data.isNull("siret") ? null : data.getString("siret");
            boolean active = data.isNull("user_keen_id") ? false : data.getBoolean("active");
            boolean blocked = data.isNull("blocked") ? false : data.getBoolean("blocked");
            String addressMac = data.isNull("adresseMac") ? null : data.getString("adresseMac");
            boolean bl = activeEuipement = (saveEquipment && (!active || active && addressMac == null) || !saveEquipment && active && addressMac == null) && !blocked && key != null && !key.isEmpty() && siret != null && !siret.isEmpty();
            if (activeEuipement) {
                this.activateEquipment(key, siret, licence);
            }
        }
    }

    public MarqueNFC getMarqueNF() {
        return this.marqueNF;
    }

    public String getKeenio() {
        return this.keenio;
    }

    public InfoLicenceGenerated save(InfoLicenceGenerated mInfoLicenceGenerated) {
        if (this.mInfoLicenceGeneratedDao.getSessionFactory() != null) {
            Session session = this.mInfoLicenceGeneratedDao.getSessionFactory().getCurrentSession();
            Transaction tx = session.beginTransaction();
            session.save((Object)mInfoLicenceGenerated);
            tx.commit();
            return mInfoLicenceGenerated;
        }
        return null;
    }

    public InfoLicenceGenerated updateLicence(InfoLicenceGenerated mInfoLicenceGenerated) {
        if (this.mInfoLicenceGeneratedDao.getSessionFactory() != null) {
            this.mInfoLicenceGeneratedDao.updateLicence(mInfoLicenceGenerated);
        }
        return null;
    }

    public boolean checkIfKeenioSiretExist() {
        String siret = this.marqueNF != null ? this.marqueNF.getSiret() : null;
        return this.keenio != null && !this.keenio.isEmpty() && siret != null && !siret.isEmpty();
    }

    private boolean isMacAddressCorrect(String addressMac) {
        List<String> macAddresses = NetWorkUtils.getMacAddresses();
        System.out.println("macAddresses : " + macAddresses);
        for (String localMacAddress : macAddresses) {
            System.out.println("localMacAddress : " + localMacAddress);
            if (localMacAddress == null || !addressMac.equalsIgnoreCase(localMacAddress)) continue;
            return true;
        }
        return false;
    }
}

