/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.services;

import com.openbravo.pos.ticket.ProductInfoExt;
import fr.protactile.procaisse.dao.entities.ImageProduct;
import fr.protactile.procaisse.dao.entities.ProductInfo;
import fr.protactile.procaisse.dao.impl.ImageProductDao;
import java.util.List;

public class ImageProductService {
    private static ImageProductService m_instance;
    private ImageProductDao imageProductDao = new ImageProductDao();

    private ImageProductService() {
    }

    public static ImageProductService getInstance() {
        if (m_instance == null) {
            m_instance = new ImageProductService();
        }
        return m_instance;
    }

    public void addImageProduct(int idProduct, ImageProduct imageProduct) {
        ProductInfo productInfo = new ProductInfo();
        productInfo.setId(idProduct);
        imageProduct.setProduct(productInfo);
        this.imageProductDao.save(imageProduct);
    }

    public List<ImageProduct> getImages(int idProduct) {
        return this.imageProductDao.getImages(idProduct);
    }

    public ImageProduct getImage(int idProduct, String nameImage) {
        return this.imageProductDao.getImage(idProduct, nameImage);
    }

    public void setImage(ImageProduct imageProduct) {
        this.imageProductDao.setImage(imageProduct);
    }

    public void setImages(List<ImageProduct> images, int idProduct) {
        for (ImageProduct image : images) {
            ImageProduct imageProduct = this.getImage(idProduct, image.getName());
            if (imageProduct != null) {
                imageProduct.setPath(image.getPath());
                imageProduct.setUrl(image.getUrl());
                imageProduct.setGraphic_type(image.getGraphic_type());
                this.setImage(imageProduct);
                continue;
            }
            this.addImageProduct(idProduct, image);
        }
    }

    public void setImagePlatform(int idProduct, String path) {
        ImageProduct imageProduct = this.getImage(idProduct, ProductInfoExt.IMAGE_PLATFORM);
        if (imageProduct != null) {
            imageProduct.setPath(path);
            this.setImage(imageProduct);
        } else if (path != null && !path.isEmpty()) {
            imageProduct = new ImageProduct();
            imageProduct.setName(ProductInfoExt.IMAGE_PLATFORM);
            imageProduct.setPath(path);
            this.addImageProduct(idProduct, imageProduct);
        }
    }

    public List<ImageProduct> getImagesPlatform() {
        return this.imageProductDao.getImagesPlatform(ProductInfoExt.IMAGE_PLATFORM);
    }
}

