/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.services;

import fr.protactile.procaisse.dao.entities.DeliverooTimeTableInfo;
import fr.protactile.procaisse.dao.entities.DeliverooWorkShiftInfo;
import fr.protactile.procaisse.dao.impl.DeliverooTimeTableInfoDao;
import fr.protactile.procaisse.dao.impl.DeliverooWorkShiftInfoDao;
import java.util.ArrayList;
import java.util.List;

public class DeliverooTimeTableService {
    private static DeliverooTimeTableService m_instance;
    private DeliverooTimeTableInfoDao mDeliverooTimeTableInfoDao = new DeliverooTimeTableInfoDao();
    private DeliverooWorkShiftInfoDao mDeliverooWorkShiftInfoDao = new DeliverooWorkShiftInfoDao();
    private final int MONDAY = 1;
    private final int TUESDAY = 2;
    private final int WEDNESDAY = 3;
    private final int THURSDAY = 4;
    private final int FRIDAY = 5;
    private final int SATURDAY = 6;
    private final int SUNDAY = 0;
    private final String START_SHIFT = "00:00:00";
    private final String END_SHIFT = "23:59:00";

    private DeliverooTimeTableService() {
    }

    public static DeliverooTimeTableService getInstance() {
        if (m_instance == null) {
            m_instance = new DeliverooTimeTableService();
        }
        return m_instance;
    }

    public DeliverooTimeTableInfo save(DeliverooTimeTableInfo mDeliverooTimeTableInfo) {
        this.mDeliverooTimeTableInfoDao.save(mDeliverooTimeTableInfo);
        this.addWorkShift(mDeliverooTimeTableInfo);
        return mDeliverooTimeTableInfo;
    }

    public List<DeliverooTimeTableInfo> listTimeTable(boolean orderByDay) {
        List<DeliverooTimeTableInfo> timesTable = null;
        timesTable = orderByDay ? this.mDeliverooTimeTableInfoDao.listTimeTableorderByDay() : this.mDeliverooTimeTableInfoDao.listTimeTable();
        if (timesTable != null && !timesTable.isEmpty()) {
            for (DeliverooTimeTableInfo deliverooTimeTableInfo : timesTable) {
                deliverooTimeTableInfo.setWorkShiftCollection(this.mDeliverooWorkShiftInfoDao.listWorkSHift(deliverooTimeTableInfo.getId()));
            }
        }
        return timesTable;
    }

    public List<DeliverooTimeTableInfo> getTimesTable() {
        return this.getTimesTable(false);
    }

    public List<DeliverooTimeTableInfo> getTimesTable(boolean orderByDay) {
        this.mDeliverooTimeTableInfoDao.getCurrentSession();
        this.mDeliverooTimeTableInfoDao.clear();
        List<DeliverooTimeTableInfo> timesTable = this.listTimeTable(orderByDay);
        if (timesTable == null || timesTable.isEmpty()) {
            this.save(new DeliverooTimeTableInfo(1, false));
            this.save(new DeliverooTimeTableInfo(2, false));
            this.save(new DeliverooTimeTableInfo(3, false));
            this.save(new DeliverooTimeTableInfo(4, false));
            this.save(new DeliverooTimeTableInfo(5, false));
            this.save(new DeliverooTimeTableInfo(6, false));
            this.save(new DeliverooTimeTableInfo(0, false));
            timesTable = this.listTimeTable(orderByDay);
        } else {
            boolean reload = false;
            for (DeliverooTimeTableInfo timeTable : timesTable) {
                if (timeTable.getWorkShiftCollection() == null || timeTable.getWorkShiftCollection().isEmpty()) {
                    this.addWorkShift(timeTable);
                    reload = true;
                    continue;
                }
                if (timeTable.getWorkShiftCollection().size() >= 2) continue;
                this.mDeliverooWorkShiftInfoDao.save(new DeliverooWorkShiftInfo("", "", timeTable));
                reload = true;
            }
            if (reload) {
                timesTable = this.listTimeTable(orderByDay);
            }
        }
        return timesTable;
    }

    public void update(List<DeliverooTimeTableInfo> timesTable) {
        for (DeliverooTimeTableInfo timeTableInfo : timesTable) {
            this.mDeliverooTimeTableInfoDao.changeTable(timeTableInfo);
            if (timeTableInfo.getWorkShiftCollection() == null) continue;
            for (DeliverooWorkShiftInfo workShiftInfo : timeTableInfo.getWorkShiftCollection()) {
                if (workShiftInfo.getId() == null) {
                    workShiftInfo.setTimetable(timeTableInfo);
                    this.mDeliverooWorkShiftInfoDao.save(workShiftInfo);
                    continue;
                }
                this.mDeliverooWorkShiftInfoDao.updateWorkShift(workShiftInfo);
            }
        }
    }

    public void addWorkShift(DeliverooTimeTableInfo mDeliverooTimeTableInfo) {
        ArrayList<DeliverooWorkShiftInfo> workShifts = new ArrayList<DeliverooWorkShiftInfo>();
        workShifts.add(new DeliverooWorkShiftInfo("00:00:00", "23:59:00", mDeliverooTimeTableInfo));
        workShifts.add(new DeliverooWorkShiftInfo("", "", mDeliverooTimeTableInfo));
        for (DeliverooWorkShiftInfo workShiftInfo : workShifts) {
            this.mDeliverooWorkShiftInfoDao.save(workShiftInfo);
        }
        mDeliverooTimeTableInfo.setWorkShiftCollection(workShifts);
    }
}

