/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.services;

import com.openbravo.basic.BasicException;
import com.openbravo.pos.payment.PaymentInfo;
import com.openbravo.pos.util.NumericUtils;
import fr.protactile.procaisse.dao.entities.CustomerInfo;
import fr.protactile.procaisse.dao.entities.DebitCustomerInfo;
import fr.protactile.procaisse.dao.entities.TicketInfo;
import fr.protactile.procaisse.dao.impl.DebitCustomerInfoDao;
import java.util.Date;
import java.util.List;

public class DebitCustomerService {
    private static DebitCustomerService m_instance;
    private DebitCustomerInfoDao mDebitCustomerInfoDao = new DebitCustomerInfoDao();
    private static final String PAYMENT_TYPE = "Debit";

    private DebitCustomerService() {
    }

    public static DebitCustomerService getInstance() {
        if (m_instance == null) {
            m_instance = new DebitCustomerService();
        }
        return m_instance;
    }

    public void addFromTicketAndPayment(PaymentInfo payment, com.openbravo.pos.ticket.TicketInfo ticket) throws BasicException {
        CustomerInfo mCustomerInfo = new CustomerInfo(payment.getIdCustomer());
        fr.protactile.procaisse.dao.entities.PaymentInfo mPaymentInfo = new fr.protactile.procaisse.dao.entities.PaymentInfo(payment.getId());
        TicketInfo mTicketInfo = new TicketInfo(ticket.getId());
        DebitCustomerInfo mDebit = new DebitCustomerInfo();
        mDebit.setAmount(NumericUtils.round(payment.getPaid()));
        mDebit.setTransferNumber(payment.getTransfer_num());
        mDebit.setDatePayment(new Date());
        mDebit.setCustomer(mCustomerInfo);
        mDebit.setPayment(mPaymentInfo);
        mDebit.setTicket(mTicketInfo);
        this.mDebitCustomerInfoDao.save(mDebit);
        if (mDebit.getId() == null) {
            throw new BasicException();
        }
    }

    public List<DebitCustomerInfo> getByCustomerId(Integer customerId) {
        List<DebitCustomerInfo> result = this.mDebitCustomerInfoDao.getByCustomerId(customerId);
        return result;
    }

    public boolean setDebitAsPaid(DebitCustomerInfo mDebitCustomerInfo, Boolean status) {
        mDebitCustomerInfo.setPaid(status);
        try {
            this.mDebitCustomerInfoDao.getCurrentSession().getTransaction().begin();
            int result = this.mDebitCustomerInfoDao.updatePaidAttribute(mDebitCustomerInfo);
            this.mDebitCustomerInfoDao.getCurrentSession().getTransaction().commit();
            if (result > 0) {
                return true;
            }
        }
        catch (Exception e) {
            this.mDebitCustomerInfoDao.getCurrentSession().getTransaction().rollback();
        }
        return false;
    }

    public void deleteByPaymentId(String paymentId) throws BasicException {
        try {
            this.mDebitCustomerInfoDao.getCurrentSession().getTransaction().begin();
            int res = this.mDebitCustomerInfoDao.deleteByPaymentId(paymentId);
            this.mDebitCustomerInfoDao.getCurrentSession().getTransaction().commit();
        }
        catch (Exception e) {
            this.mDebitCustomerInfoDao.getCurrentSession().getTransaction().rollback();
            throw new BasicException();
        }
    }
}

