/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.services;

import com.openbravo.basic.BasicException;
import com.openbravo.pos.util.NumericUtils;
import fr.protactile.procaisse.dao.entities.AddressInfo;
import fr.protactile.procaisse.dao.entities.CustomerInfo;
import fr.protactile.procaisse.dao.entities.LoyaltyCardInfo;
import fr.protactile.procaisse.dao.impl.AddressInfoDao;
import fr.protactile.procaisse.dao.impl.CustomerInfoDao;
import fr.protactile.procaisse.dao.impl.LoyaltyCardInfoDao;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class CustomerService {
    private static CustomerService m_instance;
    private AddressInfoDao mAddressInfoDao = new AddressInfoDao();
    private CustomerInfoDao mCustomerInfoDao = new CustomerInfoDao();
    private LoyaltyCardInfoDao mLoyaltyCardInfoDao = new LoyaltyCardInfoDao();

    private CustomerService() {
    }

    public static CustomerService getInstance() {
        if (m_instance == null) {
            m_instance = new CustomerService();
        }
        return m_instance;
    }

    private void setInfosDefault(CustomerInfo mCustomerInfo) {
        if (mCustomerInfo.getCompany() != null && mCustomerInfo.getCompany().equals(-1)) {
            mCustomerInfo.setCompany(0);
        }
        if (mCustomerInfo.getName() == null) {
            mCustomerInfo.setName("");
        }
        if (mCustomerInfo.getRemoved() == null) {
            mCustomerInfo.setRemoved(false);
        }
        if (mCustomerInfo.getVisible() == null) {
            mCustomerInfo.setVisible(true);
        }
        if (mCustomerInfo.getTurnover() == null) {
            mCustomerInfo.setTurnover(0.0);
        }
        if (mCustomerInfo.getNb_orders() == null) {
            mCustomerInfo.setNb_orders(0);
        }
        if (mCustomerInfo.getDiscount() != null) {
            mCustomerInfo.setDiscount(NumericUtils.round(mCustomerInfo.getDiscount()));
        }
        if (mCustomerInfo.getIsSynchro() == null) {
            mCustomerInfo.setIsSynchro(false);
        }
    }

    public CustomerInfo findOne(Integer id) {
        CustomerInfo mCustomerInfo = (CustomerInfo)this.mCustomerInfoDao.find(id);
        mCustomerInfo.setLoyaltyCardCollection(new ArrayList<LoyaltyCardInfo>());
        return mCustomerInfo;
    }

    public CustomerInfo findeOneByName(String name) {
        return this.mCustomerInfoDao.findOneByName(name);
    }

    public CustomerInfo findWithAddress(Object object) {
        Integer id = null;
        if (object instanceof CustomerInfo) {
            id = ((CustomerInfo)object).getId();
        } else if (object instanceof Integer) {
            id = (Integer)object;
        } else {
            return null;
        }
        CustomerInfo item = (CustomerInfo)this.mCustomerInfoDao.find(id);
        if (item != null) {
            item.setAdresseInfoCollection(this.mAddressInfoDao.findByCustomer(item.getId()));
        }
        return item;
    }

    public CustomerInfo save(CustomerInfo customerInfo) throws BasicException {
        this.setInfosDefault(customerInfo);
        this.mCustomerInfoDao.save(customerInfo);
        if (customerInfo.getId() == null) {
            throw new BasicException();
        }
        return customerInfo;
    }

    public CustomerInfo saveWithAddress(CustomerInfo customerInfo, AddressInfo mAddressInfo) throws BasicException {
        this.save(customerInfo);
        mAddressInfo.setIdCustomer(customerInfo.getId());
        mAddressInfo.onBeforeSave();
        this.mAddressInfoDao.save(mAddressInfo);
        if (mAddressInfo.getId() == null) {
            throw new BasicException();
        }
        return customerInfo;
    }

    public CustomerInfo updateWithAddress(CustomerInfo customerInfo, AddressInfo mAddressInfo) throws BasicException {
        if (mAddressInfo != null) {
            mAddressInfo.setCustomer(null);
        }
        try {
            this.mCustomerInfoDao.getCurrentSession().getTransaction().begin();
            customerInfo.setAdresseInfoCollection(null);
            this.setInfosDefault(customerInfo);
            this.mCustomerInfoDao.udpateCustomer(customerInfo, this.mCustomerInfoDao.getCurrentSession());
            if (mAddressInfo != null) {
                mAddressInfo.setIdCustomer(customerInfo.getId());
                if (mAddressInfo.getId() == null || mAddressInfo.getId() != null && mAddressInfo.getId().equals(-1)) {
                    mAddressInfo.onBeforeSave();
                    this.mAddressInfoDao.save(mAddressInfo);
                } else {
                    this.mAddressInfoDao.update(mAddressInfo);
                }
            }
            this.mCustomerInfoDao.getCurrentSession().getTransaction().commit();
        }
        catch (Exception e) {
            this.mCustomerInfoDao.getCurrentSession().getTransaction().rollback();
            throw new BasicException();
        }
        return this.findWithAddress(customerInfo);
    }

    public List<CustomerInfo> getAllCustomers() {
        List<CustomerInfo> result = this.mCustomerInfoDao.findAllVisibledAndNotRemoved();
        for (CustomerInfo customer : result) {
            if (customer == null) continue;
            customer.setAdresseInfoCollection(this.mAddressInfoDao.findByCustomer(customer.getId()));
            customer.setLoyaltyCardCollection(this.mLoyaltyCardInfoDao.findByCustomer(customer.getId()));
        }
        return result;
    }

    public List<CustomerInfo> getCustomersAsCompanies() {
        return this.mCustomerInfoDao.getCustomersAsType("company");
    }

    public List<CustomerInfo> getCustomers() {
        return this.mCustomerInfoDao.getCustomers();
    }

    public List<CustomerInfo> filterByPhoneOrName(String phone, String name) {
        List<CustomerInfo> result;
        if (phone != null && !phone.isEmpty() && phone.startsWith("0")) {
            phone = phone.substring(1);
        }
        if ((result = this.mCustomerInfoDao.filterByPhoneOrName(phone, name)) != null) {
            for (CustomerInfo customer : result) {
                if (customer == null) continue;
                customer.setAdresseInfoCollection(this.mAddressInfoDao.findByCustomer(customer.getId()));
            }
        }
        return result;
    }

    public void merge(CustomerInfo customerInfo) throws BasicException {
        try {
            this.mCustomerInfoDao.getCurrentSession().getTransaction().begin();
            this.setInfosDefault(customerInfo);
            this.mCustomerInfoDao.merge(customerInfo);
            this.mCustomerInfoDao.getCurrentSession().getTransaction().commit();
        }
        catch (Exception e) {
            this.mCustomerInfoDao.getCurrentSession().getTransaction().rollback();
            throw new BasicException();
        }
    }

    public boolean remove(CustomerInfo mCustomerInfo) {
        this.mCustomerInfoDao.remove(mCustomerInfo);
        return mCustomerInfo.getRemoved() != false;
    }

    public void froceRemove(Object o) throws BasicException {
        this.mCustomerInfoDao.forceRemove(o);
    }

    public void increaseTurnover(double tunover, int id_customer) {
        System.out.println("++++++++ increase tunover");
        this.mCustomerInfoDao.increaseTurnover(tunover, id_customer);
    }

    public void decreaseTurnover(double tunover, int id_customer) {
        this.mCustomerInfoDao.decreaseTurnover(tunover, id_customer);
    }

    public void increaseNBOrders(int id_customer) {
        this.mCustomerInfoDao.increaseNBOrders(id_customer);
    }

    public void decreaseNBOrders(int id_customer) {
        this.mCustomerInfoDao.decreaseNBOrders(id_customer);
    }

    public void changeLastOrder(int id_customer, Date date_last_order) {
        System.out.println("++++++++++++ changeLastOrder : ********************************************");
        this.mCustomerInfoDao.changeLastOrder(id_customer, date_last_order);
    }

    public CustomerInfo saveWithLoyaltyCard(String phone, LoyaltyCardInfo mLoyaltyCardInfo) throws BasicException {
        CustomerInfo mCustomerInfo = this.mCustomerInfoDao.findOneByPhone(phone);
        if (mCustomerInfo == null) {
            mCustomerInfo = new CustomerInfo();
            mCustomerInfo.setPhone(phone);
            this.save(mCustomerInfo);
        }
        mLoyaltyCardInfo.setCustomer(mCustomerInfo);
        mLoyaltyCardInfo.setNumber_use(0);
        mLoyaltyCardInfo.setInitialized_at(new Date());
        this.mLoyaltyCardInfoDao.save(mLoyaltyCardInfo);
        if (mCustomerInfo.getLoyaltyCardCollection() == null) {
            mCustomerInfo.setLoyaltyCardCollection(new ArrayList<LoyaltyCardInfo>());
        }
        mCustomerInfo.getLoyaltyCardCollection().add(mLoyaltyCardInfo);
        return mCustomerInfo;
    }

    public CustomerInfo getCustomerWithCards(String phone) {
        CustomerInfo customer = this.mCustomerInfoDao.findOneByPhone(phone);
        if (customer != null) {
            customer.setLoyaltyCardCollection(this.mLoyaltyCardInfoDao.findByCustomer(customer.getId()));
        }
        return customer;
    }

    public CustomerInfo findOneByPhone(String phone) {
        CustomerInfo customer = this.mCustomerInfoDao.findOneByPhone(phone);
        return customer;
    }

    public CustomerInfo findOneByPhoneName(String phone, String name) {
        CustomerInfo customer = this.mCustomerInfoDao.findOneByPhoneName(phone, name);
        return customer;
    }

    public CustomerInfo findOneByPhoneSiret(String siret) {
        CustomerInfo customer = this.mCustomerInfoDao.findOneByPhoneSiret(siret);
        return customer;
    }

    public List<CustomerInfo> fetchNotSynchronizedCostumors() {
        List<CustomerInfo> result = this.mCustomerInfoDao.fetchNotSynchronizedCostumors();
        return result;
    }

    public void updateNameCustomer(CustomerInfo mCustomerInfo) {
        this.mCustomerInfoDao.updateNameCustomer(mCustomerInfo);
    }
}

