/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.services;

import com.openbravo.format.Formats;
import fr.protactile.procaisse.dao.entities.BankNotePOS;
import fr.protactile.procaisse.dao.entities.CurrencyPOS;
import fr.protactile.procaisse.dao.impl.BankNotePOSDao;
import fr.protactile.procaisse.dao.impl.CurrencyPOSDao;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class CurrencyPOSService {
    private static CurrencyPOSService m_instance;
    private CurrencyPOSDao currencyPOSDao = new CurrencyPOSDao();
    private BankNotePOSDao bankNotePOSDao = new BankNotePOSDao();
    private int BANKNOTE_5 = 5;
    private int BANKNOTE_10 = 10;
    private int BANKNOTE_20 = 20;
    private int BANKNOTE_50 = 50;
    private int BANKNOTE_100 = 100;
    private int BANKNOTE_200 = 200;
    private String LABEL = "label";
    private String CODE = "code";
    private String SYMBOL = "symbol";
    private String BANKNOTES = "banknotes";
    private List<BankNotePOS> bankNotesAvailable;

    private CurrencyPOSService() {
    }

    public static CurrencyPOSService getInstance() {
        if (m_instance == null) {
            m_instance = new CurrencyPOSService();
        }
        return m_instance;
    }

    public void saveCurrency(CurrencyPOS currencyPOS) {
        ArrayList<BankNotePOS> bankNotes = new ArrayList<BankNotePOS>();
        if (currencyPOS.getBankNotes() != null) {
            for (BankNotePOS bankNote : currencyPOS.getBankNotes()) {
                bankNotes.add((BankNotePOS)bankNote.clone());
            }
            currencyPOS.getBankNotes().clear();
        }
        this.currencyPOSDao.save(currencyPOS);
        for (BankNotePOS bankNote : bankNotes) {
            bankNote.setCurrencyPOS(currencyPOS);
            this.bankNotePOSDao.saveBankNotePOS(bankNote);
        }
    }

    public List<BankNotePOS> getBankNotesAvailable() {
        if (this.bankNotesAvailable == null || this.bankNotesAvailable.isEmpty()) {
            this.bankNotesAvailable = new ArrayList<BankNotePOS>();
            CurrencyPOS currencyPOS = this.currencyPOSDao.getCurrencyPOS();
            if (currencyPOS == null) {
                this.addCurrencyPOS();
                currencyPOS = this.currencyPOSDao.getCurrencyPOS();
            }
            if (currencyPOS != null) {
                this.bankNotesAvailable = this.bankNotePOSDao.getBankNotes(currencyPOS.getId());
            }
            if (this.bankNotesAvailable == null || this.bankNotesAvailable.isEmpty()) {
                this.bankNotesAvailable = this.getDefaultBankNotes();
            }
        }
        return this.bankNotesAvailable;
    }

    private void addCurrencyPOS() {
        CurrencyPOS currencyPOS = new CurrencyPOS();
        currencyPOS.setSymbol(Formats.getCurrency());
        List<BankNotePOS> bankNotes = this.getDefaultBankNotes();
        currencyPOS.setBankNotes(bankNotes);
        this.saveCurrency(currencyPOS);
    }

    private BankNotePOS createBankNote(int value) {
        BankNotePOS bankNotePOS = new BankNotePOS();
        bankNotePOS.setActive(true);
        bankNotePOS.setValue(value);
        return bankNotePOS;
    }

    public List<BankNotePOS> getDefaultBankNotes() {
        ArrayList<BankNotePOS> bankNotes = new ArrayList<BankNotePOS>();
        BankNotePOS bankNotePOS_5 = this.createBankNote(this.BANKNOTE_5);
        bankNotes.add(bankNotePOS_5);
        BankNotePOS bankNotePOS_10 = this.createBankNote(this.BANKNOTE_10);
        bankNotes.add(bankNotePOS_10);
        BankNotePOS bankNotePOS_20 = this.createBankNote(this.BANKNOTE_20);
        bankNotes.add(bankNotePOS_20);
        BankNotePOS bankNotePOS_50 = this.createBankNote(this.BANKNOTE_50);
        bankNotes.add(bankNotePOS_50);
        BankNotePOS bankNotePOS_100 = this.createBankNote(this.BANKNOTE_100);
        bankNotes.add(bankNotePOS_100);
        BankNotePOS bankNotePOS_200 = this.createBankNote(this.BANKNOTE_200);
        bankNotes.add(bankNotePOS_200);
        return bankNotes;
    }

    public void checkAndSaveCurrencyPOS(JSONObject jsonCurrency) {
        CurrencyPOS currencyPOS;
        String label = jsonCurrency.isNull(this.LABEL) ? "" : jsonCurrency.getString(this.LABEL);
        String code = jsonCurrency.isNull(this.CODE) ? "" : jsonCurrency.getString(this.CODE);
        String symbol = jsonCurrency.isNull(this.SYMBOL) ? Formats.getCurrency() : jsonCurrency.getString(this.SYMBOL);
        JSONArray bankNotesArray = jsonCurrency.isNull(this.BANKNOTES) ? null : jsonCurrency.getJSONArray(this.BANKNOTES);
        ArrayList<String> bankNotesValues = new ArrayList<String>();
        if (bankNotesArray != null) {
            for (int i = 0; i < bankNotesArray.length(); ++i) {
                String bankNoteValue = bankNotesArray.getString(i);
                bankNotesValues.add(bankNoteValue);
            }
        }
        if ((currencyPOS = this.currencyPOSDao.getCurrencyPOS()) == null) {
            currencyPOS = new CurrencyPOS();
            currencyPOS.setCode(code);
            currencyPOS.setSymbol(symbol);
            currencyPOS.setLabel(label);
            if (bankNotesValues != null && !bankNotesValues.isEmpty()) {
                for (String bankNotesValue : bankNotesValues) {
                    if (!CurrencyPOSService.isNumeric(bankNotesValue)) continue;
                    BankNotePOS banckNotePOS = new BankNotePOS();
                    banckNotePOS.setActive(true);
                    banckNotePOS.setValue(Integer.parseInt(bankNotesValue));
                    if (currencyPOS.getBankNotes() == null) {
                        currencyPOS.setBankNotes(new ArrayList<BankNotePOS>());
                    }
                    currencyPOS.getBankNotes().add(banckNotePOS);
                }
            } else {
                currencyPOS.setBankNotes(this.getDefaultBankNotes());
            }
            this.saveCurrency(currencyPOS);
        } else {
            List<BankNotePOS> oldBankNotes;
            if (this.checkIfCurrencyChanged(currencyPOS, label, code, symbol)) {
                currencyPOS.setCode(code);
                currencyPOS.setSymbol(symbol);
                currencyPOS.setLabel(label);
                if (currencyPOS.getSymbol() == null || currencyPOS.getSymbol().isEmpty()) {
                    currencyPOS.setSymbol(Formats.getCurrency());
                }
                this.currencyPOSDao.setCurrencyPOS(currencyPOS);
            }
            if ((oldBankNotes = this.bankNotePOSDao.getBankNotes(currencyPOS.getId())) == null || oldBankNotes.isEmpty()) {
                if (bankNotesValues != null && !bankNotesValues.isEmpty()) {
                    for (String bankNotesValue : bankNotesValues) {
                        if (!CurrencyPOSService.isNumeric(bankNotesValue)) continue;
                        BankNotePOS banckNotePOS = new BankNotePOS();
                        banckNotePOS.setActive(true);
                        banckNotePOS.setValue(Integer.parseInt(bankNotesValue));
                        banckNotePOS.setCurrencyPOS(currencyPOS);
                        this.bankNotePOSDao.saveBankNotePOS(banckNotePOS);
                    }
                } else {
                    List<BankNotePOS> defaultBankNotes = this.getDefaultBankNotes();
                    for (BankNotePOS banckNotePOS : defaultBankNotes) {
                        banckNotePOS.setCurrencyPOS(currencyPOS);
                        this.bankNotePOSDao.saveBankNotePOS(banckNotePOS);
                    }
                }
            } else if (bankNotesValues != null && !bankNotesValues.isEmpty()) {
                for (BankNotePOS oldBankNote : oldBankNotes) {
                    if (this.checkIfBankNoteStillExist(bankNotesValues, oldBankNote)) continue;
                    this.bankNotePOSDao.deleteBankNotePOS(oldBankNote);
                }
                for (String bankNotesValue : bankNotesValues) {
                    if (!CurrencyPOSService.isNumeric(bankNotesValue) || this.checkIfBanckNoteAlreadyExistInLocal(bankNotesValue, oldBankNotes)) continue;
                    BankNotePOS banckNotePOS = new BankNotePOS();
                    banckNotePOS.setActive(true);
                    banckNotePOS.setValue(Integer.parseInt(bankNotesValue));
                    banckNotePOS.setCurrencyPOS(currencyPOS);
                    this.bankNotePOSDao.saveBankNotePOS(banckNotePOS);
                }
            }
        }
        this.getBankNotesAvailable();
    }

    private boolean checkIfCurrencyChanged(CurrencyPOS currencyPOS, String label, String code, String symbol) {
        return currencyPOS.getLabel() == null || !currencyPOS.getLabel().equalsIgnoreCase(label) || currencyPOS.getCode() == null || currencyPOS.getCode().equalsIgnoreCase(code) || currencyPOS.getSymbol() == null || currencyPOS.getSymbol().equalsIgnoreCase(symbol);
    }

    private boolean checkIfBankNoteStillExist(List<String> bankNotesValues, BankNotePOS oldBankNote) {
        try {
            for (String bankNotesValue : bankNotesValues) {
                if (oldBankNote.getValue() != (double)Integer.parseInt(bankNotesValue)) continue;
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    private boolean checkIfBanckNoteAlreadyExistInLocal(String bankNotesValue, List<BankNotePOS> oldBankNotes) {
        for (BankNotePOS oldBankNote : oldBankNotes) {
            if (oldBankNote == null || oldBankNote.getValue() != (double)Integer.parseInt(bankNotesValue)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNumeric(String str) {
        if (str == null || str.isEmpty()) {
            return false;
        }
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

