/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.services;

import fr.protactile.procaisse.dao.entities.CityInfo;
import fr.protactile.procaisse.dao.entities.ZipCodeInfo;
import fr.protactile.procaisse.dao.impl.CityInfoDao;
import fr.protactile.procaisse.dao.impl.ZipCodeDao;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class CityService {
    private static CityService m_instance;
    private CityInfoDao mCityInfoDao = new CityInfoDao();
    private ZipCodeDao mZipCodeDao = new ZipCodeDao();

    private CityService() {
    }

    public static CityService getInstance() {
        if (m_instance == null) {
            m_instance = new CityService();
        }
        return m_instance;
    }

    public CityInfo save(CityInfo mCityInfo, List<ZipCodeInfo> listZipCode) {
        if (this.mCityInfoDao.getSessionFactory() != null) {
            Session session = this.mCityInfoDao.getSessionFactory().getCurrentSession();
            Transaction tx = session.beginTransaction();
            session.save((Object)mCityInfo);
            for (ZipCodeInfo zipCodeInfo : listZipCode) {
                zipCodeInfo.setCity(mCityInfo);
                session.save((Object)zipCodeInfo);
            }
            tx.commit();
        }
        return mCityInfo;
    }

    public List<ZipCodeInfo> getZipCode() {
        return this.mZipCodeDao.list();
    }

    public List<CityInfo> getCities() {
        return this.mCityInfoDao.list();
    }

    public List<CityInfo> findByName(String zipCode) {
        List<ZipCodeInfo> zipCodes = this.mZipCodeDao.findByName(zipCode);
        ArrayList<CityInfo> cities = new ArrayList<CityInfo>();
        if (zipCodes != null) {
            for (ZipCodeInfo zipCodeInfo : zipCodes) {
                if (zipCodeInfo == null || zipCodeInfo.getCity() == null) continue;
                cities.add(zipCodeInfo.getCity());
            }
        }
        return cities;
    }
}

