/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.services;

import com.openbravo.basic.BasicException;
import com.openbravo.pos.util.Event;
import com.openbravo.pos.util.Journal;
import com.openbravo.pos.util.LogToFile;
import fr.protactile.procaisse.dao.entities.CaisseInfo;
import fr.protactile.procaisse.dao.impl.CaisseInfoDao;
import java.io.IOException;
import java.util.Date;

public class CaisseService {
    private static CaisseService m_instance;
    private CaisseInfoDao mCaisseInfoDao = new CaisseInfoDao();

    private CaisseService() {
    }

    public static CaisseService getInstance() {
        if (m_instance == null) {
            m_instance = new CaisseService();
        }
        return m_instance;
    }

    public CaisseInfo findById(Integer id) {
        return (CaisseInfo)this.mCaisseInfoDao.find(id);
    }

    public CaisseInfo findByToken(String token) {
        CaisseInfo mCaisseInfo = this.mCaisseInfoDao.findByToken(token);
        if (mCaisseInfo != null) {
            mCaisseInfo.setTicketInfoList(null);
        }
        return mCaisseInfo;
    }

    public boolean openCaisse(CaisseInfo mCaisseInfo) throws BasicException {
        block4: {
            try {
                int result = this.mCaisseInfoDao.doOpenCaisse(mCaisseInfo);
                if (result <= 0) break block4;
                try {
                    Journal.writeToJET(new Event(170, "Traitement de fond de caisse ", mCaisseInfo.getUser_open().getId(), " fond de Caisse", new Date().getTime(), "" + mCaisseInfo.getFondCaisse()));
                }
                catch (IOException ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
                return true;
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
        return false;
    }

    public boolean closeCaisse(CaisseInfo mCaisseInfo) throws BasicException {
        try {
            int result = this.mCaisseInfoDao.doCloseCaisse(mCaisseInfo);
            return true;
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
            return false;
        }
    }

    public void close() {
        this.mCaisseInfoDao.close();
    }
}

