/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.services;

import fr.protactile.procaisse.dao.entities.BorneInfo;
import fr.protactile.procaisse.dao.entities.TagInfo;
import fr.protactile.procaisse.dao.impl.BorneInfoDao;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.json.JSONArray;
import org.json.JSONObject;

public class BorneService {
    public static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private static BorneService m_instance;
    private BorneInfoDao mBorneInfoDao = new BorneInfoDao();

    private BorneService() {
    }

    public static BorneService getInstance() {
        if (m_instance == null) {
            m_instance = new BorneService();
        }
        return m_instance;
    }

    public void addBorne(BorneInfo mBorneInfo) {
        this.mBorneInfoDao.save(mBorneInfo);
    }

    public void setAddress(BorneInfo mBorneInfo) {
        this.mBorneInfoDao.setAddress(mBorneInfo);
    }

    public void setName(BorneInfo mBorneInfo) {
        this.mBorneInfoDao.setName(mBorneInfo);
    }

    public void setPaymentEnabled(BorneInfo mBorneInfo) throws IOException {
        this.changePaymentBorne(mBorneInfo);
        this.mBorneInfoDao.setPaymentEnabled(mBorneInfo);
    }

    public List<BorneInfo> getBornes() {
        return this.mBorneInfoDao.getAllBorne();
    }

    public void deleteBorne(BorneInfo mBorneInfo) {
        this.mBorneInfoDao.remove(mBorneInfo);
    }

    public void changeBorneStatus(BorneInfo mBorneInfo) {
        this.mBorneInfoDao.changeBorneStatus(mBorneInfo);
    }

    public List<BorneInfo> getBornesByName(String name) {
        return this.mBorneInfoDao.getBornesByName(name);
    }

    public void checkNamesBornes() {
        List<BorneInfo> bornes = this.getBornesByName("Equipement");
        for (BorneInfo borne : bornes) {
            String name = borne.getName_borne();
            String[] names_array = name.split(" ");
            if (names_array == null || names_array.length <= 1) continue;
            borne.setName_borne("Borne " + names_array[1]);
            this.setName(borne);
        }
    }

    private void changePaymentBorne(BorneInfo borne) throws IOException {
        if (borne != null && borne.getAddress_ip() != null) {
            JSONObject jsonPaymentBorne = new JSONObject();
            jsonPaymentBorne.put("payment_enabled", borne.isPayment_enabled());
            String url = "http://" + borne.getAddress_ip() + ":9097/newItems/changePaymentBorne";
            OkHttpClient client = new OkHttpClient();
            RequestBody body = RequestBody.create((MediaType)JSON, (String)jsonPaymentBorne.toString());
            Request request = new Request.Builder().url(url).post(body).build();
            Response response = client.newCall(request).execute();
            String reponse = response.body().string();
            JSONObject jsonResponse = new JSONObject(reponse);
            System.out.println("+++++++ jsonResponse : " + jsonResponse);
        }
    }

    public void setDisableEquipment(BorneInfo mBorneInfo) {
        this.mBorneInfoDao.setDisableEquipment(mBorneInfo);
    }

    public List<BorneInfo> getEnabledBornes() {
        return this.mBorneInfoDao.getEnabledBornes();
    }

    public JSONObject getParams(BorneInfo borne) throws IOException {
        if (borne != null && borne.getAddress_ip() != null) {
            JSONObject settingsParams = new JSONObject();
            settingsParams.put("params", List.of("payment.borne", "only.take.away.borne", "borne.in.maintenance"));
            String url = "http://" + borne.getAddress_ip() + ":9097/newItems/getParams";
            OkHttpClient client = new OkHttpClient.Builder().connectTimeout(3L, TimeUnit.SECONDS).build();
            RequestBody body = RequestBody.create((MediaType)JSON, (String)settingsParams.toString());
            Request request = new Request.Builder().url(url).post(body).build();
            Response response = client.newCall(request).execute();
            String reponse = response.body().string();
            JSONObject jsonResponse = new JSONObject(reponse);
            if (jsonResponse.getString("error").equalsIgnoreCase("ok")) {
                return jsonResponse;
            }
        }
        return null;
    }

    public void setOnseatEnabled(BorneInfo mBorneInfo) throws IOException {
        this.changeOnseatBorne(mBorneInfo);
        this.mBorneInfoDao.setOnseatEnabled(mBorneInfo);
    }

    public void setInMaintenance(BorneInfo mBorneInfo) throws IOException {
        this.changeInMaintenance(mBorneInfo);
        this.mBorneInfoDao.setInMaintenance(mBorneInfo);
    }

    public void changeOnseatBorne(BorneInfo borne) throws IOException {
        if (borne != null && borne.getAddress_ip() != null) {
            JSONObject onseat = new JSONObject();
            onseat.put("enabled", borne.isOnseatEnabled());
            String url = "http://" + borne.getAddress_ip() + ":9097/newItems/remoteSyncOnseat";
            OkHttpClient client = new OkHttpClient();
            RequestBody body = RequestBody.create((MediaType)JSON, (String)onseat.toString());
            Request request = new Request.Builder().url(url).post(body).build();
            Response response = client.newCall(request).execute();
            String reponse = response.body().string();
            JSONObject jsonResponse = new JSONObject(reponse);
            System.out.println("+++++++ jsonResponse : " + jsonResponse);
        }
    }

    public void changeInMaintenance(BorneInfo borne) throws IOException {
        if (borne != null && borne.getAddress_ip() != null) {
            JSONObject maintenance = new JSONObject();
            maintenance.put("activated", borne.isInMaintenance());
            String url = "http://" + borne.getAddress_ip() + ":9097/newItems/remoteSyncMaintenance";
            OkHttpClient client = new OkHttpClient();
            RequestBody body = RequestBody.create((MediaType)JSON, (String)maintenance.toString());
            Request request = new Request.Builder().url(url).post(body).build();
            Response response = client.newCall(request).execute();
            String reponse = response.body().string();
            JSONObject jsonResponse = new JSONObject(reponse);
            System.out.println("+++++++ jsonResponse : " + jsonResponse);
        }
    }

    public void save(BorneInfo borneInfo) {
        this.mBorneInfoDao.saveSettings(borneInfo);
    }

    public void toggleTag(BorneInfo borne, TagInfo t) throws IOException {
        if (borne != null && borne.getAddress_ip() != null) {
            JSONObject tag = new JSONObject();
            tag.put("number", t.getNumber());
            tag.put("enabled", t.isEnabled());
            tag.put("closed", t.isClosed());
            String url = "http://" + borne.getAddress_ip() + ":9097/newItems/toggleTag";
            OkHttpClient client = new OkHttpClient.Builder().writeTimeout(500L, TimeUnit.MILLISECONDS).build();
            RequestBody body = RequestBody.create((MediaType)JSON, (String)tag.toString());
            Request request = new Request.Builder().url(url).post(body).build();
            Response response = client.newCall(request).execute();
            String reponse = response.body().string();
            JSONObject jsonResponse = new JSONObject(reponse);
            System.out.println("+++++++ jsonResponse : " + jsonResponse);
        }
    }

    public List<TagInfo> parseTags(JSONObject jsonResponse) {
        boolean hasValidTags;
        ArrayList<TagInfo> tags = new ArrayList<TagInfo>();
        boolean bl = hasValidTags = jsonResponse.has("tags") && !jsonResponse.isNull("tags");
        if (hasValidTags) {
            JSONArray rawTags = jsonResponse.getJSONArray("tags");
            for (int i = 0; i < rawTags.length(); ++i) {
                JSONObject rawTag = new JSONObject(rawTags.get(i).toString());
                TagInfo tag = new TagInfo();
                tag.setDeleted(rawTag.getBoolean("deleted"));
                tag.setEnabled(rawTag.getBoolean("enabled"));
                tag.setNumber(rawTag.getInt("number"));
                tag.setName(rawTag.getString("name"));
                tag.setId(rawTag.getInt("id"));
                tags.add(tag);
            }
        }
        return tags;
    }
}

