/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.services;

import com.openbravo.pos.util.DateEncryptor;
import com.openbravo.pos.util.LogToFile;
import fr.protactile.procaisse.dao.entities.BlockingCheck;
import fr.protactile.procaisse.dao.impl.BlockingCheckDao;
import java.text.SimpleDateFormat;
import java.util.Date;

public class BlockingCheckService {
    private static BlockingCheckService m_instance;
    private BlockingCheckDao blockingCheckDao = new BlockingCheckDao();

    private BlockingCheckService() {
    }

    public static BlockingCheckService getInstance() {
        if (m_instance == null) {
            m_instance = new BlockingCheckService();
        }
        return m_instance;
    }

    public void saveBlockingCheck(Date dateBlocking) {
        try {
            BlockingCheck blockingCheck = new BlockingCheck();
            blockingCheck.setBlockingDateCrypted(DateEncryptor.encryptDate(dateBlocking));
            blockingCheck.setToBeBlocked(true);
            blockingCheck.setBlocked(true);
            this.blockingCheckDao.saveBlockingCheck(blockingCheck);
        }
        catch (Exception ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
    }

    public void setBlockingCheck(BlockingCheck blockingCheck) {
        this.blockingCheckDao.setBlockingCheck(blockingCheck);
    }

    public BlockingCheck getBlockedCheckInfo() {
        return this.blockingCheckDao.getBlockedCheckInfo();
    }

    void resertBlockingStatus() {
        BlockingCheck blockingCheck = this.blockingCheckDao.getBlockedCheckInfo();
        if (blockingCheck != null) {
            blockingCheck.setBlocked(false);
            blockingCheck.setToBeBlocked(false);
            blockingCheck.setBlockingDateCrypted(null);
            this.blockingCheckDao.setBlockingCheck(blockingCheck);
        }
    }

    public void setBlockingCheck(boolean blocked, Date blockingDate) {
        block8: {
            BlockingCheck blockingCheck = this.getBlockedCheckInfo();
            if (blocked) {
                try {
                    SimpleDateFormat dateFormat;
                    Date oldBlockingDate;
                    blockingDate.setHours(0);
                    blockingDate.setMinutes(0);
                    blockingDate.setSeconds(0);
                    boolean dateBlockingUpdated = true;
                    if (blockingCheck != null && blockingCheck.getBlockingDateCrypted() != null && !blockingCheck.getBlockingDateCrypted().isEmpty() && (oldBlockingDate = (dateFormat = new SimpleDateFormat("yyyy-MM-dd")).parse(DateEncryptor.decryptDate(blockingCheck.getBlockingDateCrypted()))).compareTo(blockingDate) == 0) {
                        dateBlockingUpdated = false;
                    }
                    if (blockingCheck != null && blockingCheck.isToBeBlocked() && !dateBlockingUpdated) break block8;
                    Date dateNow = new Date();
                    dateNow.setHours(0);
                    dateNow.setMinutes(0);
                    dateNow.setSeconds(0);
                    boolean toBeBlocked = blocked;
                    blocked = !dateNow.before(blockingDate);
                    boolean updateObjectExist = true;
                    if (blockingCheck == null) {
                        updateObjectExist = false;
                        blockingCheck = new BlockingCheck();
                    }
                    blockingCheck.setBlocked(blocked);
                    blockingCheck.setToBeBlocked(toBeBlocked);
                    blockingCheck.setBlockingDateCrypted(DateEncryptor.encryptDate(blockingDate));
                    if (updateObjectExist) {
                        this.blockingCheckDao.setBlockingCheck(blockingCheck);
                        break block8;
                    }
                    this.blockingCheckDao.saveBlockingCheck(blockingCheck);
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                }
            } else if (blockingCheck != null && blockingCheck.isToBeBlocked()) {
                this.resertBlockingStatus();
            }
        }
    }

    public BlockingCheck getBlockedCheckInfoAftercheck() {
        BlockingCheck blockingCheck = this.blockingCheckDao.getBlockedCheckInfo();
        if (blockingCheck != null && blockingCheck.isToBeBlocked() && !blockingCheck.isBlocked()) {
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                Date blockingDate = blockingCheck.getBlockingDateCrypted() != null && !blockingCheck.getBlockingDateCrypted().isEmpty() ? dateFormat.parse(DateEncryptor.decryptDate(blockingCheck.getBlockingDateCrypted())) : new Date();
                Date dateNow = new Date();
                dateNow.setHours(0);
                dateNow.setMinutes(0);
                dateNow.setSeconds(0);
                blockingDate.setHours(0);
                blockingDate.setMinutes(0);
                blockingDate.setSeconds(0);
                int compare = dateNow.compareTo(blockingDate);
                if (compare >= 0) {
                    blockingCheck.setBlocked(true);
                    this.blockingCheckDao.setBlockingCheck(blockingCheck);
                }
            }
            catch (Exception ex) {
                LogToFile.log("severe", ex.getMessage(), ex);
            }
        }
        return blockingCheck;
    }
}

