/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.services;

import fr.protactile.procaisse.dao.entities.AllergeneSupplement;
import fr.protactile.procaisse.dao.entities.SupplementItemInfo;
import fr.protactile.procaisse.dao.impl.AllergeneSupplementDao;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class AllergeneSupplementServices {
    private final AllergeneSupplementDao allergeneSupplementDao = new AllergeneSupplementDao();
    private static AllergeneSupplementServices m_instance;

    public static AllergeneSupplementServices getInstance() {
        if (m_instance == null) {
            m_instance = new AllergeneSupplementServices();
        }
        return m_instance;
    }

    public List<AllergeneSupplement> getAllAllergenes() {
        return this.allergeneSupplementDao.getAllAllergeneSupplements();
    }

    public List<AllergeneSupplement> getAllergenesForSupplement(int supplementId) {
        return this.allergeneSupplementDao.getAllergeneSupplementsForSupplement(supplementId);
    }

    public void addAllergene(int supplementId, String allergeneName) {
        this.allergeneSupplementDao.addAllergeneSupplement(supplementId, allergeneName);
    }

    public void addAllergene(AllergeneSupplement allergene) {
        this.allergeneSupplementDao.addAllergeneSupplement(allergene);
    }

    public void deleteAllergenesForSupplement(int supplementId) {
        this.allergeneSupplementDao.deleteAllAllergeneSupplementsForSupplement(supplementId);
    }

    public void deleteAllergenes() {
        this.allergeneSupplementDao.deleteAllAllergeneSupplements();
    }

    public void deleteAllergene(int supplementId, String allergeneName) {
        this.allergeneSupplementDao.deleteAllergeneSupplement(supplementId, allergeneName);
    }

    public void deleteAllergene(AllergeneSupplement allergene) {
        this.allergeneSupplementDao.deleteAllergeneSupplement(allergene);
    }

    public void updateAllergene(int supplementId, AllergeneSupplement allergene) {
        this.allergeneSupplementDao.updateAllergeneSupplement(allergene, supplementId);
    }

    public AllergeneSupplement getAllergene(int supplementId, String name) {
        return this.allergeneSupplementDao.getAllergeneSupplement(supplementId, name);
    }

    public void saveAllergene(AllergeneSupplement allergene) {
        this.allergeneSupplementDao.saveAllergeneSupplement(allergene);
    }

    public List<AllergeneSupplement> getAllergenesBySupplement(SupplementItemInfo supplement) {
        return this.allergeneSupplementDao.getAllergenesBySupplement(supplement);
    }

    public void setAllergeneSupplements(List<AllergeneSupplement> incomingAllergenes, int supplementId) {
        if (incomingAllergenes == null || incomingAllergenes.isEmpty()) {
            this.allergeneSupplementDao.deleteAllAllergeneSupplementsForSupplement(supplementId);
        } else {
            Set incomingNames = incomingAllergenes.stream().map(AllergeneSupplement::getName).collect(Collectors.toSet());
            List<AllergeneSupplement> dbAllergenes = this.allergeneSupplementDao.getAllergeneSupplementsForSupplement(supplementId);
            for (AllergeneSupplement dbAllergene : dbAllergenes) {
                if (incomingNames.contains(dbAllergene.getName())) continue;
                this.allergeneSupplementDao.deleteAllergeneSupplement(supplementId, dbAllergene.getName());
            }
            for (AllergeneSupplement allergene : incomingAllergenes) {
                AllergeneSupplement existing = this.allergeneSupplementDao.getAllergeneSupplement(supplementId, allergene.getName());
                if (existing != null) {
                    existing.setName(allergene.getName());
                    this.allergeneSupplementDao.updateAllergeneSupplement(existing, supplementId);
                    continue;
                }
                this.allergeneSupplementDao.addAllergeneSupplementItemInfo(supplementId, allergene);
            }
        }
    }
}

