/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.services;

import com.openbravo.basic.BasicException;
import fr.protactile.procaisse.dao.entities.Allergene;
import fr.protactile.procaisse.dao.entities.ProductInfo;
import fr.protactile.procaisse.dao.impl.AllergeneDao;
import java.util.List;

public class AllergeneService {
    private static AllergeneService m_instance;
    private AllergeneDao mAllergeneDao = new AllergeneDao();

    private AllergeneService() {
    }

    public static AllergeneService getInstance() {
        if (m_instance == null) {
            m_instance = new AllergeneService();
        }
        return m_instance;
    }

    public Allergene add(Allergene allergene) throws BasicException {
        if (allergene == null || allergene.getName() == null || allergene.getName().isEmpty()) {
            throw new BasicException("Nom de l\u2019allerg\u00e8ne requis.");
        }
        this.mAllergeneDao.addAllergene(allergene);
        if (allergene.getId() == null) {
            throw new BasicException("\u00c9chec de l'enregistrement de l\u2019allerg\u00e8ne.");
        }
        return allergene;
    }

    public void save(Allergene allergene) {
        if (allergene == null || allergene.getId() == null) {
            return;
        }
        this.mAllergeneDao.saveAllergene(allergene);
    }

    public void delete(Allergene allergene) {
        if (allergene != null) {
            this.mAllergeneDao.deleteAllergene(allergene);
        }
    }

    public List<Allergene> findAll() {
        return this.mAllergeneDao.getAllAllergenes();
    }

    public List<Allergene> findByProduct(ProductInfo product) {
        return this.mAllergeneDao.getAllergenesByProduct(product);
    }

    public void addToProduct(int productId, String allergeneName) {
        this.mAllergeneDao.addAllergene(productId, allergeneName);
    }

    public void deleteAllAllergenes() {
        this.mAllergeneDao.deleteAllAllergenes();
    }

    public void updateAllergene(Allergene info, int product) {
        this.mAllergeneDao.updateAllergene(info, product);
    }

    public void deleteAllAllergenesForProduct(int productId) {
        this.mAllergeneDao.deleteAllAllergenesForProduct(productId);
    }

    public void deleteAllergene(int productId, String allergeneName) {
        this.mAllergeneDao.deleteAllergene(productId, allergeneName);
    }

    public List<Allergene> getAllergenesForProduct(int productId) {
        return this.mAllergeneDao.getAllergenesForProduct(productId);
    }
}

