/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.orders.export;

import com.openbravo.basic.BasicException;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.dao.DataLogicStats;
import com.openbravo.pos.ticket.TaxeLine;
import com.openbravo.pos.util.LogToFile;
import fr.protactile.procaisse.orders.export.IZDetail;
import java.util.Date;
import java.util.List;

public class ZDayDetail
implements IZDetail {
    private DataLogicSales dlSales;
    private DataLogicStats dlStats;

    public ZDayDetail(DataLogicSales dlSales, DataLogicStats dlStats) {
        this.dlSales = dlSales;
        this.dlStats = dlStats;
    }

    @Override
    public TaxeLine getTaxe(Date dateStart, Date dateEnd) {
        TaxeLine taxeDaily = new TaxeLine();
        try {
            List<TaxeLine> mTaxesLines = this.dlSales.getTaxesBetwen(dateStart, dateEnd);
            double ht = 0.0;
            double taxe = 0.0;
            double turnover = 0.0;
            for (TaxeLine taxeLine : mTaxesLines) {
                ht += taxeLine.getHt();
                taxe += taxeLine.getTax();
                turnover += taxeLine.getTotal();
            }
            taxeDaily.setHt(ht);
            taxeDaily.setTax(taxe);
            taxeDaily.setTotal(turnover);
        }
        catch (BasicException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
        }
        return taxeDaily;
    }

    @Override
    public int getNBOrders(Date dateStart, Date dateEnd) {
        try {
            return this.dlStats.getNbOrderXDay(dateStart, dateEnd);
        }
        catch (BasicException ex) {
            LogToFile.log("severe", ex.getMessage(), ex);
            return 0;
        }
    }
}

