/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.orders.export;

import com.openbravo.format.Formats;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.ticket.GroupedTax;
import com.openbravo.pos.ticket.MarqueNFC;
import com.openbravo.pos.ticket.PaymentLine;
import com.openbravo.pos.ticket.TaxeLine;
import com.openbravo.pos.util.DateUtils;
import com.openbravo.pos.util.SignatureGenerator;
import com.openbravo.pos.util.SystemUtils;
import fr.protactile.procaisse.dao.entities.ZHostNameDTO;
import fr.protactile.procaisse.orders.export.BaseExport;
import fr.protactile.procaisse.orders.export.CAModelRowItem;
import fr.protactile.procaisse.orders.export.ExportGeneratorHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.apache.commons.io.FileUtils;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.RegionUtil;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExportTurnoverExcel
extends BaseExport {
    private Sheet selectedSheet = null;
    private int line;
    private HashMap<Integer, XSSFRow> rows;
    private boolean showDetailTurnover;
    private boolean showPeriode;
    private String[] headerTitles = new String[]{"Date", "CA TTC", "CA HT", "TVA", "NB Commande", "Panier moyen"};

    public ExportTurnoverExcel() {
        this.rows = new HashMap();
        this.headerTitles = new String[]{"Date", "CA TTC", "CA HT", "TVA", "NB Commande", "Panier moyen"};
    }

    private void generateHeader(XSSFWorkbook mWorkbook) {
        int firstRow = this.line;
        int lastRow = this.line + 1;
        CellRangeAddress titleCARegion = new CellRangeAddress(firstRow, lastRow, 0, 6);
        this.selectedSheet.addMergedRegion(titleCARegion);
        XSSFFont titleCAFont = mWorkbook.createFont();
        titleCAFont.setFontName("Arial");
        titleCAFont.setFontHeightInPoints((short)20);
        titleCAFont.setColor(IndexedColors.WHITE.index);
        titleCAFont.setBold(true);
        XSSFCellStyle titleCAStyle = mWorkbook.createCellStyle();
        titleCAStyle.setFont((Font)titleCAFont);
        titleCAStyle.setFillForegroundColor(IndexedColors.BLUE1.getIndex());
        titleCAStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        titleCAStyle.setAlignment(HorizontalAlignment.CENTER);
        XSSFRow titleCARow = this.addRow(this.line);
        Cell titleCACell = titleCARow.createCell(0);
        titleCACell.setCellValue("Chiffre d'affaire");
        titleCACell.setCellStyle((CellStyle)titleCAStyle);
        ++this.line;
        ++this.line;
        XSSFCellStyle headerStyle = mWorkbook.createCellStyle();
        headerStyle.setBorderTop(BorderStyle.MEDIUM);
        headerStyle.setBorderBottom(BorderStyle.MEDIUM);
        headerStyle.setBorderLeft(BorderStyle.MEDIUM);
        headerStyle.setBorderRight(BorderStyle.MEDIUM);
        headerStyle.setAlignment(HorizontalAlignment.CENTER);
        XSSFFont font = mWorkbook.createFont();
        font.setFontName("Arial");
        font.setFontHeightInPoints((short)9);
        font.setBold(true);
        headerStyle.setFont((Font)font);
        XSSFRow header = this.addRow(this.line);
        CellRangeAddress dateRegion = new CellRangeAddress(this.line, this.line, 0, 1);
        this.selectedSheet.addMergedRegion(dateRegion);
        RegionUtil.setBorderTop((BorderStyle)BorderStyle.MEDIUM, (CellRangeAddress)dateRegion, (Sheet)this.selectedSheet);
        RegionUtil.setBorderBottom((BorderStyle)BorderStyle.MEDIUM, (CellRangeAddress)dateRegion, (Sheet)this.selectedSheet);
        RegionUtil.setBorderLeft((BorderStyle)BorderStyle.MEDIUM, (CellRangeAddress)dateRegion, (Sheet)this.selectedSheet);
        RegionUtil.setBorderRight((BorderStyle)BorderStyle.MEDIUM, (CellRangeAddress)dateRegion, (Sheet)this.selectedSheet);
        for (int i = 0; i < this.headerTitles.length; ++i) {
            String headerTitle = this.headerTitles[i];
            int index_cell = i == 0 ? i : i + 1;
            Cell headerCell = header.createCell(index_cell);
            headerCell.setCellValue(headerTitle);
            headerCell.setCellStyle((CellStyle)headerStyle);
        }
        ++this.line;
    }

    public Sheet createSheet(String sheetName, XSSFWorkbook mWorkbook) {
        return mWorkbook != null ? mWorkbook.createSheet(sheetName) : null;
    }

    private XSSFRow addRow(int index) {
        XSSFRow row = null;
        if (index < 0) {
            index = 0;
        }
        if (this.selectedSheet != null) {
            row = (XSSFRow)this.selectedSheet.createRow(index);
            row.setHeight((short)500);
            this.rows.put(index, row);
        }
        return row;
    }

    private Cell addCell(Row row, int index, String value, CellType cellType, CellStyle rowStyle) {
        if (row != null) {
            Cell cell = row.createCell(index);
            cell.setCellValue(value);
            cell.setCellType(cellType);
            cell.setCellStyle(rowStyle);
            return cell;
        }
        return null;
    }

    @Override
    public String export() {
        return null;
    }

    private String writeOnDisk(XSSFWorkbook mWorkbook, boolean sign) throws FileNotFoundException, IOException, InvalidFormatException, GeneralSecurityException {
        Object fileLocation = "";
        File f = null;
        if (this.pathOutput != null) {
            fileLocation = this.pathOutput;
        } else {
            File currDir = new File(".");
            String path = currDir.getAbsolutePath();
            fileLocation = path.substring(0, path.length() - 1);
        }
        if (sign) {
            String fileDirectoryName = this.getFileName().replaceFirst("[.][^.]+$", "");
            fileLocation = (String)fileLocation + File.separator + fileDirectoryName;
            System.out.println("fileLocation : " + (String)fileLocation);
            File directory = new File((String)fileLocation);
            System.out.println("directory : " + directory);
            if (!directory.exists()) {
                FileUtils.forceMkdir((File)directory);
            }
        }
        f = this.getFileName() == null ? new File((String)fileLocation, "temp.xlsx") : new File((String)fileLocation, this.getFileName());
        try (FileOutputStream outputStream = new FileOutputStream(f);){
            mWorkbook.write((OutputStream)outputStream);
            mWorkbook.close();
            outputStream.close();
        }
        if (sign) {
            SignatureGenerator generator = SignatureGenerator.getGenerator();
            String signature = generator.sign(f);
            File file_signature = new File((String)fileLocation + File.separator + "signature.txt");
            FileUtils.writeStringToFile((File)file_signature, (String)signature);
        }
        return f.getAbsolutePath();
    }

    @Override
    public String export(ExportGeneratorHelper mEGH, boolean sign) {
        String $return_path = null;
        boolean isCanceled = false;
        while (this.pathOutput == null) {
            int dialogResult;
            super.selectPathOutPut();
            if (this.pathOutput != null || (dialogResult = JOptionPane.showConfirmDialog(null, "Voulez vous vraiment annuler l'op\u00e9ration d'export CA en Excel ?", "Warning", 0)) != 0) continue;
            isCanceled = true;
            break;
        }
        if (isCanceled) {
            return "canceled";
        }
        XSSFWorkbook mWorkbook = new XSSFWorkbook();
        String sheetName = mEGH.getzPeriod() != null && !mEGH.getzPeriod().isEmpty() ? mEGH.getzPeriod().replaceAll("/", " ") : DateUtils.formatDate(mEGH.getDateStart());
        this.selectedSheet = this.createSheet(this.fileName, mWorkbook);
        this.selectedSheet.setDisplayGridlines(false);
        for (int i = 0; i < 7; ++i) {
            this.selectedSheet.setColumnWidth(i, 3500);
        }
        this.generateHeaderZ(mEGH.getMarqueNFC(), mEGH.getzPeriod(), mWorkbook, DateUtils.timeFormatter.format(mEGH.getDateStart()), DateUtils.timeFormatter.format(mEGH.getDateEnd()));
        this.setTotal(mEGH.getTotal(), mEGH.getNbOrders(), mWorkbook);
        this.setPayment(mEGH.getPayments(), mWorkbook);
        this.setTaxes(mEGH.getTaxes(), mWorkbook, mEGH.getGroupedTaxes(), mEGH.getTotal());
        this.setHostsName(mEGH.getZ_hosts_name(), mWorkbook);
        if (this.showDetailTurnover) {
            mEGH.loadData();
            for (Map.Entry<String, List<CAModelRowItem>> en : mEGH.getPages().entrySet()) {
                if (!this.showDetailTurnover) continue;
                List<CAModelRowItem> rowsData = en.getValue();
                this.generateHeader(mWorkbook);
                XSSFCellStyle rowStyle = mWorkbook.createCellStyle();
                rowStyle.setBorderTop(BorderStyle.MEDIUM);
                rowStyle.setBorderBottom(BorderStyle.MEDIUM);
                rowStyle.setBorderLeft(BorderStyle.MEDIUM);
                rowStyle.setBorderRight(BorderStyle.MEDIUM);
                rowStyle.setAlignment(HorizontalAlignment.CENTER);
                XSSFFont rowFont = mWorkbook.createFont();
                rowFont.setFontName("Arial");
                rowFont.setFontHeightInPoints((short)9);
                rowFont.setBold(true);
                rowStyle.setFont((Font)rowFont);
                for (CAModelRowItem rowItem : rowsData) {
                    XSSFRow row = this.addRow(this.line);
                    CellRangeAddress dateRegion = new CellRangeAddress(this.line, this.line, 0, 1);
                    this.selectedSheet.addMergedRegion(dateRegion);
                    RegionUtil.setBorderTop((BorderStyle)BorderStyle.MEDIUM, (CellRangeAddress)dateRegion, (Sheet)this.selectedSheet);
                    RegionUtil.setBorderBottom((BorderStyle)BorderStyle.MEDIUM, (CellRangeAddress)dateRegion, (Sheet)this.selectedSheet);
                    RegionUtil.setBorderLeft((BorderStyle)BorderStyle.MEDIUM, (CellRangeAddress)dateRegion, (Sheet)this.selectedSheet);
                    RegionUtil.setBorderRight((BorderStyle)BorderStyle.MEDIUM, (CellRangeAddress)dateRegion, (Sheet)this.selectedSheet);
                    this.addCell((Row)row, 0, rowItem.getKey(), CellType.STRING, (CellStyle)rowStyle);
                    this.addCell((Row)row, 2, Formats.CURRENCY.formatValue(rowItem.getTotal()), CellType.STRING, (CellStyle)rowStyle);
                    this.addCell((Row)row, 3, Formats.CURRENCY.formatValue(rowItem.getAmount_ht()), CellType.STRING, (CellStyle)rowStyle);
                    this.addCell((Row)row, 4, Formats.CURRENCY.formatValue(rowItem.getAmount_taxe()), CellType.STRING, (CellStyle)rowStyle);
                    this.addCell((Row)row, 5, String.valueOf(rowItem.getNb_orders()), CellType.STRING, (CellStyle)rowStyle);
                    double avg = rowItem.getNb_orders() != 0 ? rowItem.getTotal() / (double)rowItem.getNb_orders() : 0.0;
                    this.addCell((Row)row, 6, Formats.CURRENCY.formatValue(avg), CellType.STRING, (CellStyle)rowStyle);
                    ++this.line;
                }
            }
        }
        try {
            $return_path = this.writeOnDisk(mWorkbook, sign);
            this.pathOutput = null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Logger.getLogger(ExportTurnoverExcel.class.getName()).log(Level.SEVERE, null, ex);
            new NotifyWindow(NotifyType.WARNING_NOTIFICATION, "Une erreur est survenue lors de la cr\u00e9ation du fichier sur votre disque !", 1500, NPosition.BOTTOM_RIGHT);
        }
        return $return_path;
    }

    public void setTemporaryDirectoryOutput() {
        String directory = System.getProperty("java.io.tmpdir");
        if (directory == null || directory.isEmpty()) {
            directory = SystemUtils.SYS_USER_HOME;
        }
        this.pathOutput = directory;
    }

    private void generateHeaderZ(MarqueNFC marqueNFC, String period_z, XSSFWorkbook mWorkbook, String startPeriode, String endPeriode) {
        XSSFRow rowSociete = this.addRow(1);
        XSSFRow rowAddress = this.addRow(2);
        XSSFRow rowSiert = this.addRow(3);
        XSSFRow rowTVA = this.addRow(4);
        XSSFRow rowTitle = this.addRow(6);
        XSSFFont fontCell = mWorkbook.createFont();
        fontCell.setFontName("Arial");
        fontCell.setFontHeightInPoints((short)9);
        fontCell.setBold(true);
        XSSFFont fontNameSociete = mWorkbook.createFont();
        fontNameSociete.setFontName("Arial");
        fontNameSociete.setFontHeightInPoints((short)16);
        fontNameSociete.setBold(true);
        fontNameSociete.setColor(IndexedColors.ORANGE.index);
        XSSFFont fontAddress = mWorkbook.createFont();
        fontAddress.setFontName("Arial");
        fontAddress.setFontHeightInPoints((short)14);
        fontAddress.setBold(true);
        XSSFFont fontTitle = mWorkbook.createFont();
        fontTitle.setFontName("Arial");
        fontTitle.setFontHeightInPoints((short)20);
        fontTitle.setBold(true);
        fontTitle.setColor(IndexedColors.BLUE.index);
        XSSFCellStyle headerStyle = mWorkbook.createCellStyle();
        headerStyle.setFont((Font)fontCell);
        XSSFCellStyle styleNameSociete = mWorkbook.createCellStyle();
        styleNameSociete.setFont((Font)fontNameSociete);
        XSSFCellStyle styleAddress = mWorkbook.createCellStyle();
        styleAddress.setFont((Font)fontAddress);
        XSSFCellStyle titleStyle = mWorkbook.createCellStyle();
        titleStyle.setAlignment(HorizontalAlignment.CENTER);
        titleStyle.setFont((Font)fontTitle);
        CellRangeAddress societeRegion = new CellRangeAddress(1, 1, 0, 2);
        this.selectedSheet.addMergedRegion(societeRegion);
        XSSFCell societeCell = rowSociete.createCell(0);
        societeCell.setCellValue(marqueNFC != null ? marqueNFC.getCompany() : "");
        societeCell.setCellStyle((CellStyle)styleNameSociete);
        CellRangeAddress addressRegion = new CellRangeAddress(2, 2, 0, 1);
        this.selectedSheet.addMergedRegion(addressRegion);
        XSSFCell addressCell = rowAddress.createCell(0);
        addressCell.setCellValue(marqueNFC != null ? marqueNFC.getAdresse1() : "");
        addressCell.setCellStyle((CellStyle)headerStyle);
        CellRangeAddress siretRegion = new CellRangeAddress(3, 3, 0, 1);
        this.selectedSheet.addMergedRegion(siretRegion);
        XSSFCell siretCell = rowSiert.createCell(0);
        siretCell.setCellValue((String)(marqueNFC != null ? "N\u00b0 Siret: " + marqueNFC.getSiret() : ""));
        siretCell.setCellStyle((CellStyle)headerStyle);
        CellRangeAddress tvaRegion = new CellRangeAddress(4, 4, 0, 1);
        this.selectedSheet.addMergedRegion(tvaRegion);
        XSSFCell tvaCell = rowTVA.createCell(0);
        tvaCell.setCellValue((String)(marqueNFC != null ? "N\u00b0 TVA: " + marqueNFC.getIntraTVA() : ""));
        tvaCell.setCellStyle((CellStyle)headerStyle);
        CellRangeAddress titleRegion = new CellRangeAddress(6, 7, 0, 6);
        this.selectedSheet.addMergedRegion(titleRegion);
        XSSFCell titleCell = rowTitle.createCell(0);
        titleCell.setCellValue("SYNTHESE CA " + period_z);
        titleCell.setCellStyle((CellStyle)titleStyle);
        if (this.showPeriode) {
            XSSFCellStyle textPeriodeStyle = mWorkbook.createCellStyle();
            textPeriodeStyle.setFont((Font)fontCell);
            textPeriodeStyle.setAlignment(HorizontalAlignment.RIGHT);
            XSSFCell periodeCell = rowSociete.createCell(5);
            periodeCell.setCellValue("Periode : ");
            periodeCell.setCellStyle((CellStyle)textPeriodeStyle);
            XSSFCell startPeriodeCell = rowSociete.createCell(6);
            startPeriodeCell.setCellValue(startPeriode);
            startPeriodeCell.setCellStyle((CellStyle)headerStyle);
            XSSFCell endPeriodeCell = rowAddress.createCell(6);
            endPeriodeCell.setCellValue(endPeriode);
            endPeriodeCell.setCellStyle((CellStyle)headerStyle);
        }
    }

    private void setPayment(List<PaymentLine> payments, XSSFWorkbook mWorkbook) {
        if (payments != null) {
            int firstRow = 13;
            int lastRow = 13;
            int firstCol = 0;
            int lastCol = 1;
            XSSFRow titelPaymentRow = this.addRow(13);
            CellRangeAddress paymentRegion = new CellRangeAddress(firstRow, lastRow, firstCol, lastCol);
            this.selectedSheet.addMergedRegion(paymentRegion);
            RegionUtil.setBorderTop((BorderStyle)BorderStyle.MEDIUM, (CellRangeAddress)paymentRegion, (Sheet)this.selectedSheet);
            RegionUtil.setBorderBottom((BorderStyle)BorderStyle.MEDIUM, (CellRangeAddress)paymentRegion, (Sheet)this.selectedSheet);
            RegionUtil.setBorderLeft((BorderStyle)BorderStyle.MEDIUM, (CellRangeAddress)paymentRegion, (Sheet)this.selectedSheet);
            RegionUtil.setBorderRight((BorderStyle)BorderStyle.MEDIUM, (CellRangeAddress)paymentRegion, (Sheet)this.selectedSheet);
            XSSFFont titlePaymentFont = mWorkbook.createFont();
            titlePaymentFont.setFontName("Arial");
            titlePaymentFont.setFontHeightInPoints((short)12);
            titlePaymentFont.setBold(true);
            XSSFCellStyle titlePaymentStyle = mWorkbook.createCellStyle();
            titlePaymentStyle.setFont((Font)titlePaymentFont);
            titlePaymentStyle.setFillForegroundColor(IndexedColors.LIGHT_BLUE.getIndex());
            titlePaymentStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            titlePaymentStyle.setBorderTop(BorderStyle.MEDIUM);
            titlePaymentStyle.setBorderBottom(BorderStyle.MEDIUM);
            titlePaymentStyle.setBorderLeft(BorderStyle.MEDIUM);
            titlePaymentStyle.setBorderRight(BorderStyle.MEDIUM);
            titlePaymentStyle.setAlignment(HorizontalAlignment.CENTER);
            XSSFCell titlePaymentCell = titelPaymentRow.createCell(0);
            titlePaymentCell.setCellValue("Mode de paiement");
            titlePaymentCell.setCellStyle((CellStyle)titlePaymentStyle);
            XSSFCellStyle paymentStyle = mWorkbook.createCellStyle();
            paymentStyle.setBorderTop(BorderStyle.MEDIUM);
            paymentStyle.setBorderBottom(BorderStyle.MEDIUM);
            paymentStyle.setBorderLeft(BorderStyle.MEDIUM);
            paymentStyle.setBorderRight(BorderStyle.MEDIUM);
            paymentStyle.setAlignment(HorizontalAlignment.CENTER);
            this.line = 14;
            for (PaymentLine payment : payments) {
                XSSFRow paymentRow = this.addRow(this.line);
                XSSFCell namePaymentCell = paymentRow.createCell(0);
                String namePayment = "cash".equals(payment.getM_PaymentType()) ? "Espese" : ("Avoir".equals(payment.getM_PaymentType()) && payment.getM_PaymentValue() > 0.0 ? "Avoir Encaiss\u00e9" : ("Avoir".equals(payment.getM_PaymentType()) && payment.getM_PaymentValue() < 0.0 ? "Avoir D\u00e9caiss\u00e9" : payment.getM_PaymentType()));
                namePaymentCell.setCellValue(namePayment);
                namePaymentCell.setCellStyle((CellStyle)paymentStyle);
                XSSFCell valuePaymentCell = paymentRow.createCell(1);
                valuePaymentCell.setCellValue(Formats.CURRENCY.formatValue(payment.getM_PaymentValue()));
                valuePaymentCell.setCellStyle((CellStyle)paymentStyle);
                ++this.line;
            }
            ++this.line;
        }
    }

    private void setTotal(double total, int nbOrders, XSSFWorkbook mWorkbook) {
        int firstRow = 9;
        int lastRow = 9;
        XSSFRow titleTotalRow = this.getRow(9);
        CellRangeAddress titleTotalRegion = new CellRangeAddress(firstRow, lastRow, 0, 2);
        this.selectedSheet.addMergedRegion(titleTotalRegion);
        RegionUtil.setBorderTop((BorderStyle)BorderStyle.MEDIUM, (CellRangeAddress)titleTotalRegion, (Sheet)this.selectedSheet);
        RegionUtil.setBorderBottom((BorderStyle)BorderStyle.MEDIUM, (CellRangeAddress)titleTotalRegion, (Sheet)this.selectedSheet);
        RegionUtil.setBorderLeft((BorderStyle)BorderStyle.MEDIUM, (CellRangeAddress)titleTotalRegion, (Sheet)this.selectedSheet);
        RegionUtil.setBorderRight((BorderStyle)BorderStyle.MEDIUM, (CellRangeAddress)titleTotalRegion, (Sheet)this.selectedSheet);
        CellRangeAddress titleNbOrdersRegion = new CellRangeAddress(firstRow, lastRow, 3, 4);
        this.selectedSheet.addMergedRegion(titleNbOrdersRegion);
        RegionUtil.setBorderTop((BorderStyle)BorderStyle.MEDIUM, (CellRangeAddress)titleNbOrdersRegion, (Sheet)this.selectedSheet);
        RegionUtil.setBorderBottom((BorderStyle)BorderStyle.MEDIUM, (CellRangeAddress)titleNbOrdersRegion, (Sheet)this.selectedSheet);
        RegionUtil.setBorderLeft((BorderStyle)BorderStyle.MEDIUM, (CellRangeAddress)titleNbOrdersRegion, (Sheet)this.selectedSheet);
        RegionUtil.setBorderRight((BorderStyle)BorderStyle.MEDIUM, (CellRangeAddress)titleNbOrdersRegion, (Sheet)this.selectedSheet);
        CellRangeAddress titleAVGRegion = new CellRangeAddress(firstRow, lastRow, 5, 6);
        this.selectedSheet.addMergedRegion(titleAVGRegion);
        RegionUtil.setBorderTop((BorderStyle)BorderStyle.MEDIUM, (CellRangeAddress)titleAVGRegion, (Sheet)this.selectedSheet);
        RegionUtil.setBorderBottom((BorderStyle)BorderStyle.MEDIUM, (CellRangeAddress)titleAVGRegion, (Sheet)this.selectedSheet);
        RegionUtil.setBorderLeft((BorderStyle)BorderStyle.MEDIUM, (CellRangeAddress)titleAVGRegion, (Sheet)this.selectedSheet);
        RegionUtil.setBorderRight((BorderStyle)BorderStyle.MEDIUM, (CellRangeAddress)titleAVGRegion, (Sheet)this.selectedSheet);
        XSSFFont titleTotalFont = mWorkbook.createFont();
        titleTotalFont.setFontName("Arial");
        titleTotalFont.setFontHeightInPoints((short)12);
        titleTotalFont.setColor(IndexedColors.WHITE.index);
        titleTotalFont.setBold(true);
        XSSFCellStyle titleTotalStyle = mWorkbook.createCellStyle();
        titleTotalStyle.setFont((Font)titleTotalFont);
        titleTotalStyle.setFillForegroundColor(IndexedColors.BLACK.getIndex());
        titleTotalStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        titleTotalStyle.setBorderTop(BorderStyle.MEDIUM);
        titleTotalStyle.setBorderBottom(BorderStyle.MEDIUM);
        titleTotalStyle.setBorderLeft(BorderStyle.MEDIUM);
        titleTotalStyle.setBorderRight(BorderStyle.MEDIUM);
        titleTotalStyle.setAlignment(HorizontalAlignment.CENTER);
        XSSFCell titleTotalCell = titleTotalRow.createCell(0);
        titleTotalCell.setCellValue("CA TOTAL TTC");
        titleTotalCell.setCellStyle((CellStyle)titleTotalStyle);
        XSSFCell titleNbOrdersCell = titleTotalRow.createCell(3);
        titleNbOrdersCell.setCellValue("Nombre de Commande");
        titleNbOrdersCell.setCellStyle((CellStyle)titleTotalStyle);
        XSSFCell titleAVGCell = titleTotalRow.createCell(5);
        titleAVGCell.setCellValue("Panier Moyen");
        titleAVGCell.setCellStyle((CellStyle)titleTotalStyle);
        XSSFRow totalRow = this.getRow(10);
        CellRangeAddress totalRegion = new CellRangeAddress(10, 11, 0, 2);
        this.selectedSheet.addMergedRegion(totalRegion);
        RegionUtil.setBorderTop((BorderStyle)BorderStyle.MEDIUM, (CellRangeAddress)totalRegion, (Sheet)this.selectedSheet);
        RegionUtil.setBorderBottom((BorderStyle)BorderStyle.MEDIUM, (CellRangeAddress)totalRegion, (Sheet)this.selectedSheet);
        RegionUtil.setBorderLeft((BorderStyle)BorderStyle.MEDIUM, (CellRangeAddress)totalRegion, (Sheet)this.selectedSheet);
        RegionUtil.setBorderRight((BorderStyle)BorderStyle.MEDIUM, (CellRangeAddress)totalRegion, (Sheet)this.selectedSheet);
        CellRangeAddress nbOrdersRegion = new CellRangeAddress(10, 11, 3, 4);
        this.selectedSheet.addMergedRegion(nbOrdersRegion);
        RegionUtil.setBorderTop((BorderStyle)BorderStyle.MEDIUM, (CellRangeAddress)nbOrdersRegion, (Sheet)this.selectedSheet);
        RegionUtil.setBorderBottom((BorderStyle)BorderStyle.MEDIUM, (CellRangeAddress)nbOrdersRegion, (Sheet)this.selectedSheet);
        RegionUtil.setBorderLeft((BorderStyle)BorderStyle.MEDIUM, (CellRangeAddress)nbOrdersRegion, (Sheet)this.selectedSheet);
        RegionUtil.setBorderRight((BorderStyle)BorderStyle.MEDIUM, (CellRangeAddress)nbOrdersRegion, (Sheet)this.selectedSheet);
        CellRangeAddress avgRegion = new CellRangeAddress(10, 11, 5, 6);
        this.selectedSheet.addMergedRegion(avgRegion);
        RegionUtil.setBorderTop((BorderStyle)BorderStyle.MEDIUM, (CellRangeAddress)avgRegion, (Sheet)this.selectedSheet);
        RegionUtil.setBorderBottom((BorderStyle)BorderStyle.MEDIUM, (CellRangeAddress)avgRegion, (Sheet)this.selectedSheet);
        RegionUtil.setBorderLeft((BorderStyle)BorderStyle.MEDIUM, (CellRangeAddress)avgRegion, (Sheet)this.selectedSheet);
        RegionUtil.setBorderRight((BorderStyle)BorderStyle.MEDIUM, (CellRangeAddress)avgRegion, (Sheet)this.selectedSheet);
        XSSFFont nbOrdersFont = mWorkbook.createFont();
        nbOrdersFont.setFontName("Arial");
        nbOrdersFont.setFontHeightInPoints((short)14);
        nbOrdersFont.setBold(true);
        XSSFFont totalFont = mWorkbook.createFont();
        totalFont.setFontName("Arial");
        totalFont.setFontHeightInPoints((short)14);
        totalFont.setColor(IndexedColors.WHITE.index);
        totalFont.setBold(true);
        XSSFCellStyle totalStyle = mWorkbook.createCellStyle();
        totalStyle.setFont((Font)totalFont);
        totalStyle.setFillForegroundColor(IndexedColors.LIGHT_BLUE.getIndex());
        totalStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        totalStyle.setBorderTop(BorderStyle.MEDIUM);
        totalStyle.setBorderBottom(BorderStyle.MEDIUM);
        totalStyle.setBorderLeft(BorderStyle.MEDIUM);
        totalStyle.setBorderRight(BorderStyle.MEDIUM);
        totalStyle.setAlignment(HorizontalAlignment.CENTER);
        XSSFCellStyle nbOrdersStyle = mWorkbook.createCellStyle();
        nbOrdersStyle.setFont((Font)nbOrdersFont);
        nbOrdersStyle.setBorderTop(BorderStyle.MEDIUM);
        nbOrdersStyle.setBorderBottom(BorderStyle.MEDIUM);
        nbOrdersStyle.setBorderLeft(BorderStyle.MEDIUM);
        nbOrdersStyle.setBorderRight(BorderStyle.MEDIUM);
        nbOrdersStyle.setAlignment(HorizontalAlignment.CENTER);
        XSSFCell totalCell = totalRow.createCell(0);
        totalCell.setCellValue(Formats.CURRENCY.formatValue(total));
        totalCell.setCellStyle((CellStyle)totalStyle);
        XSSFCell nbOrdersCell = totalRow.createCell(3);
        nbOrdersCell.setCellValue((double)nbOrders);
        nbOrdersCell.setCellStyle((CellStyle)nbOrdersStyle);
        XSSFCell avgCell = totalRow.createCell(5);
        if (nbOrders != 0) {
            avgCell.setCellValue(Formats.CURRENCY.formatValue(total / (double)nbOrders));
        }
        avgCell.setCellStyle((CellStyle)nbOrdersStyle);
    }

    private void setTaxes(List<TaxeLine> taxes, XSSFWorkbook mWorkbook, List<GroupedTax> groupedTaxes, double total) {
        if (AppLocal.MODULE_MEV || AppLocal.MODULE_TVA_GLOBAL) {
            this.setTaxes(groupedTaxes, total, mWorkbook);
        } else if (taxes != null) {
            int firstRow = 13;
            int lastRow = 13;
            XSSFRow totalTaxeRow = this.getRow(13);
            CellRangeAddress taxeRegion = new CellRangeAddress(firstRow, lastRow, 3, 4);
            this.selectedSheet.addMergedRegion(taxeRegion);
            RegionUtil.setBorderTop((BorderStyle)BorderStyle.MEDIUM, (CellRangeAddress)taxeRegion, (Sheet)this.selectedSheet);
            RegionUtil.setBorderBottom((BorderStyle)BorderStyle.MEDIUM, (CellRangeAddress)taxeRegion, (Sheet)this.selectedSheet);
            RegionUtil.setBorderLeft((BorderStyle)BorderStyle.MEDIUM, (CellRangeAddress)taxeRegion, (Sheet)this.selectedSheet);
            RegionUtil.setBorderRight((BorderStyle)BorderStyle.MEDIUM, (CellRangeAddress)taxeRegion, (Sheet)this.selectedSheet);
            CellRangeAddress totalTaxRegion = new CellRangeAddress(firstRow, lastRow, 5, 6);
            this.selectedSheet.addMergedRegion(totalTaxRegion);
            RegionUtil.setBorderTop((BorderStyle)BorderStyle.MEDIUM, (CellRangeAddress)totalTaxRegion, (Sheet)this.selectedSheet);
            RegionUtil.setBorderBottom((BorderStyle)BorderStyle.MEDIUM, (CellRangeAddress)totalTaxRegion, (Sheet)this.selectedSheet);
            RegionUtil.setBorderLeft((BorderStyle)BorderStyle.MEDIUM, (CellRangeAddress)totalTaxRegion, (Sheet)this.selectedSheet);
            RegionUtil.setBorderRight((BorderStyle)BorderStyle.MEDIUM, (CellRangeAddress)totalTaxRegion, (Sheet)this.selectedSheet);
            XSSFFont taxeFont = mWorkbook.createFont();
            taxeFont.setFontName("Arial");
            taxeFont.setFontHeightInPoints((short)14);
            taxeFont.setColor(IndexedColors.WHITE.index);
            taxeFont.setBold(true);
            XSSFCellStyle taxeStyle = mWorkbook.createCellStyle();
            taxeStyle.setFont((Font)taxeFont);
            taxeStyle.setFillForegroundColor(IndexedColors.RED.getIndex());
            taxeStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            taxeStyle.setBorderTop(BorderStyle.MEDIUM);
            taxeStyle.setBorderBottom(BorderStyle.MEDIUM);
            taxeStyle.setBorderLeft(BorderStyle.MEDIUM);
            taxeStyle.setBorderRight(BorderStyle.MEDIUM);
            taxeStyle.setAlignment(HorizontalAlignment.CENTER);
            XSSFCell textTaxeCell = totalTaxeRow.createCell(3);
            textTaxeCell.setCellValue("TVA");
            textTaxeCell.setCellStyle((CellStyle)taxeStyle);
            XSSFCellStyle totalTaxeStyle = mWorkbook.createCellStyle();
            totalTaxeStyle.setFont((Font)taxeFont);
            totalTaxeStyle.setFillForegroundColor(IndexedColors.BLACK.getIndex());
            totalTaxeStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            totalTaxeStyle.setBorderTop(BorderStyle.MEDIUM);
            totalTaxeStyle.setBorderBottom(BorderStyle.MEDIUM);
            totalTaxeStyle.setBorderLeft(BorderStyle.MEDIUM);
            totalTaxeStyle.setBorderRight(BorderStyle.MEDIUM);
            totalTaxeStyle.setAlignment(HorizontalAlignment.CENTER);
            XSSFCell totalTaxeCell = totalTaxeRow.createCell(5);
            totalTaxeCell.setCellStyle((CellStyle)totalTaxeStyle);
            XSSFCellStyle taxesStyle = mWorkbook.createCellStyle();
            taxesStyle.setBorderTop(BorderStyle.MEDIUM);
            taxesStyle.setBorderBottom(BorderStyle.MEDIUM);
            taxesStyle.setBorderLeft(BorderStyle.MEDIUM);
            taxesStyle.setBorderRight(BorderStyle.MEDIUM);
            taxesStyle.setAlignment(HorizontalAlignment.CENTER);
            XSSFRow titleTaxesRow = this.getRow(14);
            XSSFCell titleRateCell = titleTaxesRow.createCell(3);
            titleRateCell.setCellValue("Ventilation");
            titleRateCell.setCellStyle((CellStyle)taxesStyle);
            XSSFCell titleTtcCell = titleTaxesRow.createCell(4);
            titleTtcCell.setCellValue("CA TTC");
            titleTtcCell.setCellStyle((CellStyle)taxesStyle);
            XSSFCell titleHTCell = titleTaxesRow.createCell(5);
            titleHTCell.setCellValue("CA HT");
            titleHTCell.setCellStyle((CellStyle)taxesStyle);
            XSSFCell titleTaxeCell = titleTaxesRow.createCell(6);
            titleTaxeCell.setCellValue("Montant TVA");
            titleTaxeCell.setCellStyle((CellStyle)taxesStyle);
            int line_tax = 15;
            double taxe_value = 0.0;
            for (TaxeLine taxe : taxes) {
                if (taxe == null || taxe.getTotal() == 0.0) continue;
                XSSFRow taxeRow = this.getRow(line_tax);
                XSSFCell rateCell = taxeRow.createCell(3);
                rateCell.setCellValue(taxe.getName());
                rateCell.setCellStyle((CellStyle)taxesStyle);
                XSSFCell ttcCell = taxeRow.createCell(4);
                ttcCell.setCellValue(Formats.CURRENCY.formatValue(taxe.getTotal()));
                ttcCell.setCellStyle((CellStyle)taxesStyle);
                XSSFCell htCell = taxeRow.createCell(5);
                htCell.setCellValue(Formats.CURRENCY.formatValue(taxe.getHt()));
                htCell.setCellStyle((CellStyle)taxesStyle);
                XSSFCell taxeCell = taxeRow.createCell(6);
                taxeCell.setCellValue(Formats.CURRENCY.formatValue(taxe.getTax()));
                taxeCell.setCellStyle((CellStyle)taxesStyle);
                taxe_value += taxe.getTax();
                ++line_tax;
            }
            totalTaxeCell.setCellValue(Formats.CURRENCY.formatValue(taxe_value));
            if (line_tax > this.line) {
                this.line = line_tax;
            }
            ++this.line;
        }
    }

    private XSSFRow getRow(int index) {
        if (this.rows.get(index) != null) {
            return this.rows.get(index);
        }
        XSSFRow row = this.addRow(index);
        return row;
    }

    public boolean isShowDetailTurnover() {
        return this.showDetailTurnover;
    }

    public void setShowDetailTurnover(boolean showDetailTurnover) {
        this.showDetailTurnover = showDetailTurnover;
    }

    public boolean isShowPeriode() {
        return this.showPeriode;
    }

    public void setShowPeriode(boolean showPeriode) {
        this.showPeriode = showPeriode;
    }

    private void setHostsName(List<ZHostNameDTO> z_hosts_name, XSSFWorkbook mWorkbook) {
        if (z_hosts_name != null) {
            int firstRow = this.line;
            int lastRow = this.line;
            int firstCol = 0;
            int lastCol = 1;
            XSSFRow titleHostNameRow = this.addRow(this.line);
            CellRangeAddress hostNameRegion = new CellRangeAddress(firstRow, lastRow, firstCol, lastCol);
            this.selectedSheet.addMergedRegion(hostNameRegion);
            RegionUtil.setBorderTop((BorderStyle)BorderStyle.MEDIUM, (CellRangeAddress)hostNameRegion, (Sheet)this.selectedSheet);
            RegionUtil.setBorderBottom((BorderStyle)BorderStyle.MEDIUM, (CellRangeAddress)hostNameRegion, (Sheet)this.selectedSheet);
            RegionUtil.setBorderLeft((BorderStyle)BorderStyle.MEDIUM, (CellRangeAddress)hostNameRegion, (Sheet)this.selectedSheet);
            RegionUtil.setBorderRight((BorderStyle)BorderStyle.MEDIUM, (CellRangeAddress)hostNameRegion, (Sheet)this.selectedSheet);
            XSSFFont titleHostNameFont = mWorkbook.createFont();
            titleHostNameFont.setFontName("Arial");
            titleHostNameFont.setFontHeightInPoints((short)12);
            titleHostNameFont.setBold(true);
            XSSFCellStyle titleHostNameStyle = mWorkbook.createCellStyle();
            titleHostNameStyle.setFont((Font)titleHostNameFont);
            titleHostNameStyle.setFillForegroundColor(IndexedColors.LIGHT_BLUE.getIndex());
            titleHostNameStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            titleHostNameStyle.setBorderTop(BorderStyle.MEDIUM);
            titleHostNameStyle.setBorderBottom(BorderStyle.MEDIUM);
            titleHostNameStyle.setBorderLeft(BorderStyle.MEDIUM);
            titleHostNameStyle.setBorderRight(BorderStyle.MEDIUM);
            titleHostNameStyle.setAlignment(HorizontalAlignment.CENTER);
            XSSFCell titleHostNameCell = titleHostNameRow.createCell(0);
            titleHostNameCell.setCellValue("Equipements");
            titleHostNameCell.setCellStyle((CellStyle)titleHostNameStyle);
            XSSFCellStyle hostNameStyle = mWorkbook.createCellStyle();
            hostNameStyle.setBorderTop(BorderStyle.MEDIUM);
            hostNameStyle.setBorderBottom(BorderStyle.MEDIUM);
            hostNameStyle.setBorderLeft(BorderStyle.MEDIUM);
            hostNameStyle.setBorderRight(BorderStyle.MEDIUM);
            hostNameStyle.setAlignment(HorizontalAlignment.CENTER);
            ++this.line;
            for (ZHostNameDTO hostName : z_hosts_name) {
                XSSFRow hostNameRow = this.getRow(this.line);
                XSSFCell hostNameCell = hostNameRow.createCell(0);
                hostNameCell.setCellValue(hostName.getHost_name());
                hostNameCell.setCellStyle((CellStyle)hostNameStyle);
                XSSFCell turnoverByHostNameCell = hostNameRow.createCell(1);
                turnoverByHostNameCell.setCellValue(Formats.CURRENCY.formatValue(hostName.getTotal()));
                turnoverByHostNameCell.setCellStyle((CellStyle)hostNameStyle);
                ++this.line;
            }
            ++this.line;
        }
    }

    private void setTaxes(List<GroupedTax> groupedTaxes, double total, XSSFWorkbook mWorkbook) {
        double total_before_taxes = total;
        for (GroupedTax taxe : groupedTaxes) {
            total_before_taxes -= taxe.getTotal_tax();
        }
        int firstRow = 13;
        int lastRow = 13;
        XSSFRow totalTaxeRow = this.getRow(13);
        CellRangeAddress taxeRegion = new CellRangeAddress(firstRow, lastRow, 3, 4);
        this.selectedSheet.addMergedRegion(taxeRegion);
        RegionUtil.setBorderTop((BorderStyle)BorderStyle.MEDIUM, (CellRangeAddress)taxeRegion, (Sheet)this.selectedSheet);
        RegionUtil.setBorderBottom((BorderStyle)BorderStyle.MEDIUM, (CellRangeAddress)taxeRegion, (Sheet)this.selectedSheet);
        RegionUtil.setBorderLeft((BorderStyle)BorderStyle.MEDIUM, (CellRangeAddress)taxeRegion, (Sheet)this.selectedSheet);
        RegionUtil.setBorderRight((BorderStyle)BorderStyle.MEDIUM, (CellRangeAddress)taxeRegion, (Sheet)this.selectedSheet);
        CellRangeAddress totalTaxRegion = new CellRangeAddress(firstRow, lastRow, 5, 6);
        this.selectedSheet.addMergedRegion(totalTaxRegion);
        RegionUtil.setBorderTop((BorderStyle)BorderStyle.MEDIUM, (CellRangeAddress)totalTaxRegion, (Sheet)this.selectedSheet);
        RegionUtil.setBorderBottom((BorderStyle)BorderStyle.MEDIUM, (CellRangeAddress)totalTaxRegion, (Sheet)this.selectedSheet);
        RegionUtil.setBorderLeft((BorderStyle)BorderStyle.MEDIUM, (CellRangeAddress)totalTaxRegion, (Sheet)this.selectedSheet);
        RegionUtil.setBorderRight((BorderStyle)BorderStyle.MEDIUM, (CellRangeAddress)totalTaxRegion, (Sheet)this.selectedSheet);
        XSSFFont taxeFont = mWorkbook.createFont();
        taxeFont.setFontName("Arial");
        taxeFont.setFontHeightInPoints((short)14);
        taxeFont.setColor(IndexedColors.WHITE.index);
        taxeFont.setBold(true);
        XSSFCellStyle taxeStyle = mWorkbook.createCellStyle();
        taxeStyle.setFont((Font)taxeFont);
        taxeStyle.setFillForegroundColor(IndexedColors.RED.getIndex());
        taxeStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        taxeStyle.setBorderTop(BorderStyle.MEDIUM);
        taxeStyle.setBorderBottom(BorderStyle.MEDIUM);
        taxeStyle.setBorderLeft(BorderStyle.MEDIUM);
        taxeStyle.setBorderRight(BorderStyle.MEDIUM);
        taxeStyle.setAlignment(HorizontalAlignment.CENTER);
        XSSFCell textTaxeCell = totalTaxeRow.createCell(3);
        textTaxeCell.setCellValue("Total avant taxes");
        textTaxeCell.setCellStyle((CellStyle)taxeStyle);
        XSSFCellStyle totalTaxeStyle = mWorkbook.createCellStyle();
        totalTaxeStyle.setFont((Font)taxeFont);
        totalTaxeStyle.setFillForegroundColor(IndexedColors.BLACK.getIndex());
        totalTaxeStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        totalTaxeStyle.setBorderTop(BorderStyle.MEDIUM);
        totalTaxeStyle.setBorderBottom(BorderStyle.MEDIUM);
        totalTaxeStyle.setBorderLeft(BorderStyle.MEDIUM);
        totalTaxeStyle.setBorderRight(BorderStyle.MEDIUM);
        totalTaxeStyle.setAlignment(HorizontalAlignment.CENTER);
        XSSFCell totalTaxeCell = totalTaxeRow.createCell(5);
        totalTaxeCell.setCellValue(Formats.CURRENCY.formatValue(total_before_taxes));
        totalTaxeCell.setCellStyle((CellStyle)totalTaxeStyle);
        XSSFCellStyle taxesStyle = mWorkbook.createCellStyle();
        taxesStyle.setBorderTop(BorderStyle.MEDIUM);
        taxesStyle.setBorderBottom(BorderStyle.MEDIUM);
        taxesStyle.setBorderLeft(BorderStyle.MEDIUM);
        taxesStyle.setBorderRight(BorderStyle.MEDIUM);
        taxesStyle.setAlignment(HorizontalAlignment.CENTER);
        XSSFRow titleTaxesRow = this.getRow(14);
        XSSFCell titleRateCell = titleTaxesRow.createCell(3);
        titleRateCell.setCellValue("Tax");
        titleRateCell.setCellStyle((CellStyle)taxesStyle);
        XSSFCell titleTtcCell = titleTaxesRow.createCell(4);
        titleTtcCell.setCellValue("Taux Tax");
        titleTtcCell.setCellStyle((CellStyle)taxesStyle);
        XSSFCell titleHTCell = titleTaxesRow.createCell(5);
        titleHTCell.setCellValue("Total Tax");
        titleHTCell.setCellStyle((CellStyle)taxesStyle);
        int line_tax = 15;
        double taxe_value = 0.0;
        for (GroupedTax taxe : groupedTaxes) {
            if (taxe == null || taxe.getTotal_tax() == 0.0) continue;
            XSSFRow taxeRow = this.getRow(line_tax);
            XSSFCell rateCell = taxeRow.createCell(3);
            rateCell.setCellValue(taxe.getName());
            rateCell.setCellStyle((CellStyle)taxesStyle);
            XSSFCell ttcCell = taxeRow.createCell(4);
            ttcCell.setCellValue(taxe.getRate());
            ttcCell.setCellStyle((CellStyle)taxesStyle);
            XSSFCell htCell = taxeRow.createCell(5);
            htCell.setCellValue(Formats.CURRENCY.formatValue(taxe.getTotal_tax()));
            htCell.setCellStyle((CellStyle)taxesStyle);
            ++line_tax;
        }
        if (line_tax > this.line) {
            this.line = line_tax;
        }
        ++this.line;
    }
}

