/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.orders.export;

import com.openbravo.AppConstants;
import com.openbravo.dao.DataLogicSales;
import com.openbravo.dao.DataLogicStats;
import com.openbravo.pos.ticket.GroupedTax;
import com.openbravo.pos.ticket.MarqueNFC;
import com.openbravo.pos.ticket.PaymentLine;
import com.openbravo.pos.ticket.TaxeLine;
import com.openbravo.pos.util.DateUtils;
import fr.protactile.norm.beans.GrandTotalPeriode;
import fr.protactile.procaisse.dao.entities.ZHostNameDTO;
import fr.protactile.procaisse.orders.export.CAModelRowItem;
import fr.protactile.procaisse.orders.export.IZDetail;
import fr.protactile.procaisse.orders.export.ModelRowItem;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.map.LinkedMap;

public class ExportGeneratorHelper {
    private Date mDateStart = null;
    private Date mDateEnd = null;
    private Date cpyDateStart = null;
    private Date cpyDateEnd = null;
    private DataLogicSales dlSales = null;
    private DataLogicStats dlStats = null;
    private Map<String, Long> mDates = null;
    private Calendar calendar_helper = Calendar.getInstance();
    private Boolean isForClosedCaisse = false;
    private Boolean isDayly = false;
    private Boolean isMonthly = false;
    private Boolean isYearly = false;
    private List<CAModelRowItem> rows = null;
    private Map<String, List<CAModelRowItem>> pages = null;
    private final String TR_PAYMENT = AppConstants.PAYMENT_MODE.TICKET_RESTO.getStrippedAccentsName();
    private final String ESPECE_PAYMENT = AppConstants.PAYMENT_MODE.CASH.getStrippedAccentsName();
    private final String AVOIR_PAYMENT = AppConstants.PAYMENT_MODE.FREE.getStrippedAccentsName();
    private final String CB_PAYMENT = "CB";
    private final String CHEQUE_PAYMENT = "cheque";
    private final String CASHDRO_PAYMENT = "cashdro";
    private final String CASH_PAYMENT = "cash";
    private final String LOYALTY_CARD_PAYMENT = "Carte Fid\u00e9lit\u00e9";
    private final String CREDIT_EMPLOYEE_PAYMENT = "Cr\u00e9dit Employ\u00e9";
    private final String VIREMENT_PAYMENT = "Virement";
    private final String TWINT_PAYMENT = "Twint";
    private GrandTotalPeriode grandTotalPeriode;
    private double total;
    private int nbOrders;
    private List<PaymentLine> payments;
    private List<TaxeLine> taxes;
    private IZDetail zDetail;
    private MarqueNFC marqueNFC;
    private String zPeriod;
    private List<ZHostNameDTO> z_hosts_name;
    private List<GroupedTax> groupedTaxes;
    private final String DEBIT = AppConstants.PAYMENT_MODE.DEBIT.getStrippedAccentsName();

    public ExportGeneratorHelper(Date mDateStart, Date mDateEnd) {
        this.mDateStart = mDateStart;
        this.mDateEnd = mDateEnd;
        this.cpyDateStart = mDateStart;
        this.cpyDateEnd = mDateEnd;
        this.mDates = new LinkedHashMap<String, Long>();
        this.rows = new LinkedList<CAModelRowItem>();
        this.pages = new LinkedMap();
        this.fillDates();
    }

    public Date getDateStart() {
        return this.mDateStart;
    }

    public Date getDateEnd() {
        return this.mDateEnd;
    }

    public void setDlSales(DataLogicSales dlSales) {
        this.dlSales = dlSales;
    }

    public void setDlStats(DataLogicStats dlStats) {
        this.dlStats = dlStats;
    }

    private void fillDates() {
        if (this.mDateStart != null && this.mDateEnd != null) {
            this.calendar_helper.setTime(this.mDateStart);
            long diff = this.mDateEnd.getTime() - this.mDateStart.getTime();
            long hours = TimeUnit.HOURS.convert(diff, TimeUnit.MILLISECONDS);
            long days = TimeUnit.DAYS.convert(diff, TimeUnit.MILLISECONDS);
            if (hours <= 32L) {
                this.isDayly = true;
                DateUtils.fillHoursBetweenTwoDates(this.mDates, this.mDateStart, this.mDateEnd);
            } else if (days <= 31L) {
                this.isMonthly = true;
                DateUtils.fillDaysOfMonth(this.mDates, this.mDateStart, this.mDateEnd);
            } else {
                this.isYearly = true;
                DateUtils.fillMonthsOfYear(this.mDates, this.mDateStart, this.mDateEnd);
            }
        }
    }

    public void loadData() {
        System.out.println("_____________loadData ");
        if (this.mDates != null && !this.mDates.isEmpty()) {
            ModelRowItem mModelRowTotal = new ModelRowItem();
            mModelRowTotal.setKey("TOTAL");
            int indexOffset = 0;
            for (Map.Entry<String, Long> entry : this.mDates.entrySet()) {
                String key = entry.getKey();
                Long value = entry.getValue();
                Date s = new Date(value);
                Date e = null;
                CAModelRowItem mModelRowItem = new CAModelRowItem();
                this.calendar_helper.setTimeInMillis(value);
                if (this.isDayly.booleanValue()) {
                    mModelRowItem.setKey(key + "h");
                } else if (this.isMonthly.booleanValue()) {
                    this.calendar_helper.set(11, 23);
                    mModelRowItem.setKey(DateUtils.formatDate(new Date(value)));
                } else if (this.isYearly.booleanValue()) {
                    mModelRowItem.setKey(key);
                    this.calendar_helper.set(5, this.calendar_helper.getActualMaximum(5));
                    this.calendar_helper.set(11, 23);
                }
                this.calendar_helper.set(12, 59);
                this.calendar_helper.set(13, 59);
                e = this.calendar_helper.getTime();
                if (indexOffset == 0 && this.isForClosedCaisse.booleanValue()) {
                    s.setTime(this.cpyDateStart.getTime());
                }
                if (indexOffset == this.mDates.size() - 1 && this.isForClosedCaisse.booleanValue()) {
                    e.setTime(this.cpyDateEnd.getTime());
                }
                if (this.zDetail != null) {
                    TaxeLine taxeLine = this.zDetail.getTaxe(s, e);
                    int nbOrders = this.zDetail.getNBOrders(s, e);
                    if (taxeLine != null) {
                        mModelRowItem.setTotal(taxeLine.getTotal());
                        mModelRowItem.setAmount_ht(taxeLine.getHt());
                        mModelRowItem.setAmount_taxe(taxeLine.getTax());
                    }
                    mModelRowItem.setNb_orders(nbOrders);
                    this.rows.add(mModelRowItem);
                }
                ++indexOffset;
            }
            Object pageName = "Page 0";
            if (this.isDayly.booleanValue()) {
                pageName = DateUtils.formatDate(this.mDateStart);
            } else if (this.isMonthly.booleanValue()) {
                pageName = DateUtils.formatMonth(this.mDateStart) + " " + DateUtils.formatYear(this.mDateStart);
            } else if (this.isYearly.booleanValue()) {
                pageName = DateUtils.formatYear(this.mDateStart);
            }
            this.pages.put((String)pageName, this.rows);
        }
    }

    public Map<String, List<CAModelRowItem>> getPages() {
        return this.pages;
    }

    public void setIsForClosedCaisse(boolean b) {
        this.isForClosedCaisse = b;
    }

    public GrandTotalPeriode getGrandTotalPeriode() {
        return this.grandTotalPeriode;
    }

    public void setGrandTotalPeriode(GrandTotalPeriode grandTotalPeriode) {
        this.grandTotalPeriode = grandTotalPeriode;
    }

    public List<PaymentLine> getPayments() {
        return this.payments;
    }

    public void setPayments(List<PaymentLine> payments) {
        this.payments = payments;
    }

    public List<TaxeLine> getTaxes() {
        return this.taxes;
    }

    public void setTaxes(List<TaxeLine> taxes) {
        this.taxes = taxes;
    }

    public double getTotal() {
        return this.total;
    }

    public void setTotal(double total) {
        this.total = total;
    }

    public int getNbOrders() {
        return this.nbOrders;
    }

    public void setNbOrders(int nbOrders) {
        this.nbOrders = nbOrders;
    }

    public IZDetail getzDetail() {
        return this.zDetail;
    }

    public void setzDetail(IZDetail zDetail) {
        this.zDetail = zDetail;
    }

    public MarqueNFC getMarqueNFC() {
        return this.marqueNFC;
    }

    public void setMarqueNFC(MarqueNFC marqueNFC) {
        this.marqueNFC = marqueNFC;
    }

    public String getzPeriod() {
        return this.zPeriod;
    }

    public void setzPeriod(String zPeriod) {
        this.zPeriod = zPeriod;
    }

    public List<ZHostNameDTO> getZ_hosts_name() {
        return this.z_hosts_name;
    }

    public void setZ_hosts_name(List<ZHostNameDTO> z_hosts_name) {
        this.z_hosts_name = z_hosts_name;
    }

    public List<GroupedTax> getGroupedTaxes() {
        return this.groupedTaxes;
    }

    public void setGroupedTaxes(List<GroupedTax> groupedTaxes) {
        this.groupedTaxes = groupedTaxes;
    }
}

