/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.orders.export;

import com.openbravo.pos.util.SystemUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.poifs.crypt.EncryptionInfo;
import org.apache.poi.poifs.crypt.EncryptionMode;
import org.apache.poi.poifs.crypt.Encryptor;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class CreateProtectedXLSFile {
    public void generateXLS() {
        try {
            File xlsxFile = new File(SystemUtils.SYS_USER_HOME, "protected9.xlsx");
            if (!xlsxFile.exists()) {
                xlsxFile.createNewFile();
            }
            XSSFWorkbook workbook = new XSSFWorkbook();
            XSSFSheet sheet = workbook.createSheet("Employee Records");
            XSSFRow header = sheet.createRow(0);
            header.createCell(0).setCellValue("Employee Id");
            header.createCell(1).setCellValue("Employee Name");
            header.createCell(2).setCellValue("Age");
            header.createCell(3).setCellValue("Email ID");
            header.createCell(4).setCellValue("Salary");
            XSSFRow row1 = sheet.createRow(1);
            row1.createCell(0).setCellValue("101");
            row1.createCell(1).setCellValue("John william");
            row1.createCell(2).setCellValue("30");
            row1.createCell(3).setCellValue("william.john@gmail.com");
            row1.createCell(4).setCellValue("15000$");
            XSSFRow row2 = sheet.createRow(2);
            row2.createCell(0).setCellValue("102");
            row2.createCell(1).setCellValue("Harsh singh");
            row2.createCell(2).setCellValue("35");
            row2.createCell(3).setCellValue("harsh.singh@gmail.com");
            row2.createCell(4).setCellValue("20000$");
            try (FileOutputStream fos = new FileOutputStream(xlsxFile);){
                workbook.write((OutputStream)fos);
                fos.close();
                workbook.close();
            }
            try (POIFSFileSystem fs = new POIFSFileSystem();){
                EncryptionInfo info = new EncryptionInfo(EncryptionMode.agile);
                Encryptor encryptor = info.getEncryptor();
                encryptor.confirmPassword("javacodepoint");
                try (OPCPackage opc = OPCPackage.open((File)xlsxFile, (PackageAccess)PackageAccess.READ_WRITE);
                     OutputStream os = encryptor.getDataStream(fs);){
                    opc.save(os);
                }
                try (FileOutputStream fos = new FileOutputStream(xlsxFile);){
                    fs.writeFilesystem((OutputStream)fos);
                }
            }
            System.out.println("Protected Excel(.xlsx) file has been created successfully.");
        }
        catch (Exception e) {
            System.out.println("Exception while creating protected xls file");
            e.printStackTrace();
        }
    }
}

