/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.log;

import com.openbravo.basic.BasicStorage;
import com.openbravo.pos.forms.AppLocal;
import com.openbravo.pos.ticket.MarqueNFC;
import com.openbravo.pos.util.ExceptionMev;
import com.openbravo.pos.util.LogToFile;
import com.utils.NetworkUtils;
import fr.protactile.procaisse.log.InfoUserLog;
import io.sentry.SentryClient;
import io.sentry.SentryClientFactory;
import io.sentry.context.Context;
import java.util.Map;

public class SentryLogger {
    private final String SENTRY_HOST = "sentry.pro-tactile.com";
    private final String SENTRY_DSN = "https://5fcfa9cc3f411ddeff079551fc4741b3@o1137922.ingest.sentry.io/4505992266514432";
    private SentryClient sentry = SentryClientFactory.sentryClient((String)"https://5fcfa9cc3f411ddeff079551fc4741b3@o1137922.ingest.sentry.io/4505992266514432");
    private InfoUserLog mInfoUserLog = null;
    private MarqueNFC marqueNFCDB = null;
    private static SentryLogger mInstance = null;

    private SentryLogger() {
    }

    public static SentryLogger getInstance() {
        if (mInstance == null) {
            mInstance = new SentryLogger();
        }
        return mInstance;
    }

    private boolean isNetworkConnected() {
        return NetworkUtils.isNetworkConnected("sentry.pro-tactile.com", 80, 5000);
    }

    private Map<String, Object> fillInfosExtra() {
        if (this.marqueNFCDB == null && BasicStorage.contains("MARQUE_NF_INSTANCE")) {
            this.marqueNFCDB = (MarqueNFC)BasicStorage.getObject("MARQUE_NF_INSTANCE");
        }
        if (this.mInfoUserLog == null) {
            this.mInfoUserLog = new InfoUserLog();
        }
        if (this.mInfoUserLog.getMarqueNFC() == null) {
            this.mInfoUserLog.setMarqueNFC(this.marqueNFCDB);
        }
        this.mInfoUserLog.setDatabaseVersion("3.94.47");
        this.mInfoUserLog.setSoftwareVersion("10.0.1.27");
        this.mInfoUserLog.setPhoneTicket(AppLocal.phoneRestaurant);
        return this.mInfoUserLog.asMap();
    }

    private Context getContextAndFillExtra() {
        Context context = this.sentry.getContext();
        Map<String, Object> data = this.fillInfosExtra();
        context.addTag("id", "" + AppLocal.getActivationId());
        context.addTag("Teamviwer_id", LogToFile.getTeamViewerId());
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            context.addExtra(key, value);
        }
        return context;
    }

    public void log(Throwable e) {
        if (this.isNetworkConnected()) {
            System.out.println("++++ send exception to sentry");
            Context mContext = this.getContextAndFillExtra();
            this.sentry.setRelease("10.0.1.27");
            this.sentry.sendException(e);
        }
    }

    public void log(String message) {
        ExceptionMev exception = new ExceptionMev(message);
        if (this.isNetworkConnected()) {
            System.out.println("message exception : " + message);
            this.sentry.setRelease("10.0.1.27");
            this.sentry.sendException((Throwable)exception);
        }
    }
}

