/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.items.export;

import com.openbravo.models.RankProduct;
import com.openbravo.pos.notify.NPosition;
import com.openbravo.pos.notify.NotifyType;
import com.openbravo.pos.notify.NotifyWindow;
import com.openbravo.pos.ticket.MarqueNFC;
import com.openbravo.pos.util.DateUtils;
import com.openbravo.pos.util.SystemUtils;
import fr.protactile.procaisse.items.export.BaseExport;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExportItemsExcel
extends BaseExport {
    private Sheet selectedSheet = null;
    private XSSFWorkbook mWorkbook = null;
    private int line;
    private HashMap<Integer, XSSFRow> rows = new HashMap();
    private boolean showDetailTurnover;
    private boolean showPeriode;
    private String[] headerTitles = new String[]{"Produit", "Cat\u00e9gorie", "Nbre vente", "CA", "% Sur place", "% Emport\u00e9", "% Livraison", "% Uber", "% Delivero", "% Just Eat", "% Drive", "% Smood"};

    private void generateHeader(String type_items) {
        int firstRow = this.line;
        int lastRow = this.line + 1;
        CellRangeAddress titleCARegion = new CellRangeAddress(firstRow, lastRow, 0, 6);
        this.selectedSheet.addMergedRegion(titleCARegion);
        XSSFFont titleCAFont = this.mWorkbook.createFont();
        titleCAFont.setFontName("Arial");
        titleCAFont.setFontHeightInPoints((short)20);
        titleCAFont.setColor(IndexedColors.BLACK.index);
        titleCAFont.setBold(true);
        XSSFCellStyle titleCAStyle = this.mWorkbook.createCellStyle();
        titleCAStyle.setFont((Font)titleCAFont);
        titleCAStyle.setAlignment(HorizontalAlignment.CENTER);
        XSSFRow titleCARow = this.addRow(this.line);
        Cell titleCACell = titleCARow.createCell(0);
        String title = type_items != null && type_items.equalsIgnoreCase("options") ? "Classement options" : "Classement produits";
        titleCACell.setCellValue(title);
        titleCACell.setCellStyle((CellStyle)titleCAStyle);
        ++this.line;
        ++this.line;
        XSSFCellStyle headerStyle = this.mWorkbook.createCellStyle();
        headerStyle.setBorderTop(BorderStyle.MEDIUM);
        headerStyle.setBorderBottom(BorderStyle.MEDIUM);
        headerStyle.setBorderLeft(BorderStyle.MEDIUM);
        headerStyle.setBorderRight(BorderStyle.MEDIUM);
        headerStyle.setAlignment(HorizontalAlignment.CENTER);
        XSSFFont font = this.mWorkbook.createFont();
        font.setFontName("Arial");
        font.setFontHeightInPoints((short)9);
        font.setBold(true);
        headerStyle.setFont((Font)font);
        XSSFRow header = this.addRow(this.line);
        for (int i = 0; i < this.headerTitles.length; ++i) {
            String headerTitle = this.headerTitles[i];
            Cell headerCell = header.createCell(i);
            headerCell.setCellValue(headerTitle);
            headerCell.setCellStyle((CellStyle)headerStyle);
        }
        ++this.line;
    }

    public Sheet createSheet(String sheetName, XSSFWorkbook mWorkbook) {
        return mWorkbook != null ? mWorkbook.createSheet(sheetName) : null;
    }

    private XSSFRow addRow(int index) {
        XSSFRow row = null;
        if (index < 0) {
            index = 0;
        }
        if (this.selectedSheet != null) {
            row = (XSSFRow)this.selectedSheet.createRow(index);
            row.setHeight((short)500);
            this.rows.put(index, row);
        }
        return row;
    }

    private Cell addCell(Row row, int index, String value, CellType cellType, CellStyle rowStyle) {
        if (row != null) {
            Cell cell = row.createCell(index);
            cell.setCellValue(value);
            cell.setCellType(cellType);
            cell.setCellStyle(rowStyle);
            return cell;
        }
        return null;
    }

    private String writeOnDisk(XSSFWorkbook mWorkbook) throws FileNotFoundException, IOException, InvalidFormatException, GeneralSecurityException {
        String fileLocation = "";
        File f = null;
        if (this.pathOutput != null) {
            fileLocation = this.pathOutput;
        } else {
            File currDir = new File(".");
            String path = currDir.getAbsolutePath();
            fileLocation = path.substring(0, path.length() - 1);
        }
        f = this.getFileName() == null ? new File(fileLocation, "temp.xlsx") : new File(fileLocation, this.getFileName());
        try (FileOutputStream outputStream = new FileOutputStream(f);){
            mWorkbook.write((OutputStream)outputStream);
            mWorkbook.close();
            outputStream.close();
        }
        return f.getAbsolutePath();
    }

    @Override
    public String export(List<RankProduct> items, String type_items, Date dateStart, Date dateEnd, MarqueNFC marqueNFC) {
        String $return_path = null;
        boolean isCanceled = false;
        while (this.pathOutput == null) {
            int dialogResult;
            super.selectPathOutPut();
            if (this.pathOutput != null || (dialogResult = JOptionPane.showConfirmDialog(null, "Voulez vous vraiment annuler l'op\u00e9ration d'export CA en Excel ?", "Warning", 0)) != 0) continue;
            isCanceled = true;
            break;
        }
        if (isCanceled) {
            return "canceled";
        }
        this.mWorkbook = new XSSFWorkbook();
        this.selectedSheet = this.createSheet(type_items, this.mWorkbook);
        this.selectedSheet.setDisplayGridlines(false);
        this.selectedSheet.setColumnWidth(0, 4500);
        this.selectedSheet.setColumnWidth(1, 4500);
        for (int i = 2; i < 10; ++i) {
            this.selectedSheet.setColumnWidth(i, 3500);
        }
        this.generateHeaderZ(marqueNFC, DateUtils.FORMATTER_DATE_HOUR.format(dateStart), DateUtils.FORMATTER_DATE_HOUR.format(dateEnd));
        this.setItems(items, type_items);
        try {
            $return_path = this.writeOnDisk(this.mWorkbook);
            this.pathOutput = null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Logger.getLogger(ExportItemsExcel.class.getName()).log(Level.SEVERE, null, ex);
            new NotifyWindow(NotifyType.WARNING_NOTIFICATION, "Une erreur est survenue lors de la cr\u00e9ation du fichier sur votre disque !", 1500, NPosition.BOTTOM_RIGHT);
        }
        return $return_path;
    }

    public void setTemporaryDirectoryOutput() {
        String directory = System.getProperty("java.io.tmpdir");
        if (directory == null || directory.isEmpty()) {
            directory = SystemUtils.SYS_USER_HOME;
        }
        this.pathOutput = directory;
    }

    private void generateHeaderZ(MarqueNFC marqueNFC, String startPeriode, String endPeriode) {
        XSSFRow rowSociete = this.addRow(1);
        XSSFRow rowAddress = this.addRow(2);
        XSSFRow rowSiert = this.addRow(3);
        XSSFRow rowTVA = this.addRow(4);
        XSSFFont fontCell = this.mWorkbook.createFont();
        fontCell.setFontName("Arial");
        fontCell.setFontHeightInPoints((short)9);
        fontCell.setBold(true);
        XSSFFont fontNameSociete = this.mWorkbook.createFont();
        fontNameSociete.setFontName("Arial");
        fontNameSociete.setFontHeightInPoints((short)16);
        fontNameSociete.setBold(true);
        fontNameSociete.setColor(IndexedColors.ORANGE.index);
        XSSFFont fontAddress = this.mWorkbook.createFont();
        fontAddress.setFontName("Arial");
        fontAddress.setFontHeightInPoints((short)14);
        fontAddress.setBold(true);
        XSSFFont fontTitle = this.mWorkbook.createFont();
        fontTitle.setFontName("Arial");
        fontTitle.setFontHeightInPoints((short)20);
        fontTitle.setBold(true);
        fontTitle.setColor(IndexedColors.BLUE.index);
        XSSFCellStyle headerStyle = this.mWorkbook.createCellStyle();
        headerStyle.setFont((Font)fontCell);
        XSSFCellStyle styleNameSociete = this.mWorkbook.createCellStyle();
        styleNameSociete.setFont((Font)fontNameSociete);
        XSSFCellStyle styleAddress = this.mWorkbook.createCellStyle();
        styleAddress.setFont((Font)fontAddress);
        XSSFCellStyle titleStyle = this.mWorkbook.createCellStyle();
        titleStyle.setAlignment(HorizontalAlignment.CENTER);
        titleStyle.setFont((Font)fontTitle);
        CellRangeAddress societeRegion = new CellRangeAddress(1, 1, 0, 2);
        this.selectedSheet.addMergedRegion(societeRegion);
        XSSFCell societeCell = rowSociete.createCell(0);
        societeCell.setCellValue(marqueNFC != null ? marqueNFC.getCompany() : "");
        societeCell.setCellStyle((CellStyle)styleNameSociete);
        CellRangeAddress addressRegion = new CellRangeAddress(2, 2, 0, 1);
        this.selectedSheet.addMergedRegion(addressRegion);
        XSSFCell addressCell = rowAddress.createCell(0);
        addressCell.setCellValue(marqueNFC != null ? marqueNFC.getAdresse1() : "");
        addressCell.setCellStyle((CellStyle)headerStyle);
        CellRangeAddress siretRegion = new CellRangeAddress(3, 3, 0, 1);
        this.selectedSheet.addMergedRegion(siretRegion);
        XSSFCell siretCell = rowSiert.createCell(0);
        siretCell.setCellValue((String)(marqueNFC != null ? "N\u00b0 Siret: " + marqueNFC.getSiret() : ""));
        siretCell.setCellStyle((CellStyle)headerStyle);
        CellRangeAddress tvaRegion = new CellRangeAddress(4, 4, 0, 1);
        this.selectedSheet.addMergedRegion(tvaRegion);
        XSSFCell tvaCell = rowTVA.createCell(0);
        tvaCell.setCellValue((String)(marqueNFC != null ? "N\u00b0 TVA: " + marqueNFC.getIntraTVA() : ""));
        tvaCell.setCellStyle((CellStyle)headerStyle);
        XSSFCellStyle textPeriodeStyle = this.mWorkbook.createCellStyle();
        textPeriodeStyle.setFont((Font)fontCell);
        textPeriodeStyle.setAlignment(HorizontalAlignment.RIGHT);
        XSSFCell periodeCell = rowSociete.createCell(5);
        periodeCell.setCellValue("Periode : ");
        periodeCell.setCellStyle((CellStyle)textPeriodeStyle);
        XSSFCell startPeriodeCell = rowSociete.createCell(6);
        startPeriodeCell.setCellValue(startPeriode);
        startPeriodeCell.setCellStyle((CellStyle)headerStyle);
        XSSFCell endPeriodeCell = rowAddress.createCell(6);
        endPeriodeCell.setCellValue(endPeriode);
        endPeriodeCell.setCellStyle((CellStyle)headerStyle);
        this.line = 5;
    }

    private void setItems(List<RankProduct> items, String type_items) {
        if (items != null) {
            this.generateHeader(type_items);
            XSSFCellStyle rowStyle = this.mWorkbook.createCellStyle();
            rowStyle.setBorderTop(BorderStyle.MEDIUM);
            rowStyle.setBorderBottom(BorderStyle.MEDIUM);
            rowStyle.setBorderLeft(BorderStyle.MEDIUM);
            rowStyle.setBorderRight(BorderStyle.MEDIUM);
            rowStyle.setAlignment(HorizontalAlignment.CENTER);
            XSSFFont rowFont = this.mWorkbook.createFont();
            rowFont.setFontName("Arial");
            rowFont.setFontHeightInPoints((short)9);
            rowFont.setBold(true);
            rowStyle.setFont((Font)rowFont);
            for (RankProduct rowItem : items) {
                XSSFRow row = this.addRow(this.line);
                this.addCell((Row)row, 0, rowItem.getName(), CellType.STRING, (CellStyle)rowStyle);
                this.addCell((Row)row, 1, rowItem.getCategory(), CellType.STRING, (CellStyle)rowStyle);
                this.addCell((Row)row, 2, String.valueOf(rowItem.getQuantity()), CellType.STRING, (CellStyle)rowStyle);
                this.addCell((Row)row, 3, rowItem.getTurnover(), CellType.STRING, (CellStyle)rowStyle);
                this.addCell((Row)row, 4, rowItem.getS_percentAtSpot(), CellType.STRING, (CellStyle)rowStyle);
                this.addCell((Row)row, 5, rowItem.getS_percentTakeAway(), CellType.STRING, (CellStyle)rowStyle);
                this.addCell((Row)row, 6, rowItem.getS_percentDelivery(), CellType.STRING, (CellStyle)rowStyle);
                this.addCell((Row)row, 7, rowItem.getS_percentUber(), CellType.STRING, (CellStyle)rowStyle);
                this.addCell((Row)row, 8, rowItem.getS_percentDelivero(), CellType.STRING, (CellStyle)rowStyle);
                this.addCell((Row)row, 9, rowItem.getS_percentJustEat(), CellType.STRING, (CellStyle)rowStyle);
                this.addCell((Row)row, 10, rowItem.getS_percentDrive(), CellType.STRING, (CellStyle)rowStyle);
                this.addCell((Row)row, 11, rowItem.getS_percentSmood(), CellType.STRING, (CellStyle)rowStyle);
                ++this.line;
            }
        }
    }

    private XSSFRow getRow(int index) {
        if (this.rows.get(index) != null) {
            return this.rows.get(index);
        }
        XSSFRow row = this.addRow(index);
        return row;
    }
}

