/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.dao.impl;

import fr.protactile.procaisse.dao.config.DaoConfig;
import fr.protactile.procaisse.dao.entities.TagInfo;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.query.Query;

public class TagsDao
extends DaoConfig<TagInfo> {
    @Override
    protected Class<TagInfo> classType() {
        return TagInfo.class;
    }

    public List<TagInfo> getTags() {
        List<TagInfo> tags = new ArrayList<TagInfo>();
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            Transaction tx = session.beginTransaction();
            Query q = session.createQuery("from TagInfo s WHERE  s.deleted = :deleted order by s.id");
            q.setParameter("deleted", (Object)false);
            tags = q.list();
            tx.commit();
            session.close();
        }
        return tags;
    }

    public void addTagInfo(TagInfo mTagInfos) {
        this.save(mTagInfos);
    }

    public void updateTag(TagInfo mTagInfo) {
        if (!s.isOpen()) {
            this.openSession();
        }
        String hqlUpdate = "update TagInfo t set t.name = :name, t.number = :number, t.logo_tag = :logo_tag, t.background_catalog = :background_catalog, t.deleted = :deleted, t.enabled = :enabled, t.closed = :closed where t.id = :id ";
        Transaction tx = s.beginTransaction();
        int updatedEntities = s.createQuery(hqlUpdate).setString("name", mTagInfo.getName()).setInteger("number", mTagInfo.getNumber()).setString("logo_tag", mTagInfo.getLogo_tag()).setString("background_catalog", mTagInfo.getBackground_catalog()).setBoolean("deleted", mTagInfo.isDeleted()).setBoolean("enabled", mTagInfo.isEnabled()).setBoolean("closed", mTagInfo.isClosed()).setInteger("id", mTagInfo.getId().intValue()).executeUpdate();
        tx.commit();
        s.close();
    }

    public void deleteTag(TagInfo mTgInfo) {
        if (!s.isOpen()) {
            this.openSession();
        }
        String hqlUpdate = "update TagInfo s set s.deleted = :deleted where s.id = :id ";
        Transaction tx = s.beginTransaction();
        int updatedEntities = s.createQuery(hqlUpdate).setParameter("deleted", (Object)true).setInteger("id", mTgInfo.getId().intValue()).executeUpdate();
        tx.commit();
        s.close();
    }

    public TagInfo findByNumber(int number) {
        if (!s.isOpen()) {
            this.openSession();
        }
        Transaction tx = s.beginTransaction();
        Query q = s.createQuery("from TagInfo s where s.number = :number");
        q.setParameter("number", (Object)number);
        Object o = q.list() != null && !q.list().isEmpty() ? q.list().get(0) : null;
        tx.commit();
        s.close();
        if (o != null) {
            return o;
        }
        return null;
    }

    public void deleteTag(boolean deleted, int number) {
        if (!s.isOpen()) {
            this.openSession();
        }
        String hqlUpdate = "update TagInfo s set s.deleted = :deleted where s.number = :number ";
        Transaction tx = s.beginTransaction();
        int updatedEntities = s.createQuery(hqlUpdate).setParameter("deleted", (Object)deleted).setInteger("number", number).executeUpdate();
        tx.commit();
        s.close();
    }

    public void enableTag(TagInfo tagInfo, boolean enabled) {
        if (!s.isOpen()) {
            this.openSession();
        }
        String hqlUpdate = "update TagInfo s set s.enabled = :enabled where s.id = :id ";
        Transaction tx = s.beginTransaction();
        s.createQuery(hqlUpdate).setParameter("enabled", (Object)enabled).setInteger("id", tagInfo.getId().intValue()).executeUpdate();
        tx.commit();
        s.close();
    }

    public void closeTag(TagInfo tagInfo, boolean closed) {
        if (!s.isOpen()) {
            this.openSession();
        }
        String hqlUpdate = "update TagInfo s set s.closed = :closed where s.id = :id ";
        Transaction tx = s.beginTransaction();
        s.createQuery(hqlUpdate).setParameter("closed", (Object)closed).setInteger("id", tagInfo.getId().intValue()).executeUpdate();
        tx.commit();
        s.close();
    }

    public List<TagInfo> getActiveTags() {
        List<TagInfo> tags = new ArrayList<TagInfo>();
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            Transaction tx = session.beginTransaction();
            Query q = session.createQuery("from TagInfo s WHERE  s.deleted = :deleted AND s.enabled = :enabled order by s.id");
            q.setParameter("deleted", (Object)false);
            q.setParameter("enabled", (Object)true);
            tags = q.list();
            tx.commit();
            session.close();
        }
        return tags;
    }
}

