/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.dao.impl;

import com.openbravo.pos.util.LogToFile;
import fr.protactile.procaisse.dao.config.DaoConfig;
import fr.protactile.procaisse.dao.entities.SecurityCheck;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.query.Query;

public class SecurityCheckDao
extends DaoConfig<SecurityCheck> {
    @Override
    protected Class<SecurityCheck> classType() {
        return SecurityCheck.class;
    }

    public void addSecurityCheck(SecurityCheck mSecurityCheck) {
        block4: {
            if (sessionFactory != null) {
                Session session = null;
                Transaction tx = null;
                try {
                    session = sessionFactory.getCurrentSession();
                    tx = session.beginTransaction();
                    session.save((Object)mSecurityCheck);
                    tx.commit();
                    session.close();
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                    if (tx != null) {
                        tx.rollback();
                    }
                    if (session == null) break block4;
                    session.close();
                }
            }
        }
    }

    public void updateSecurityCheck(SecurityCheck mSecurityCheck) {
        block4: {
            if (sessionFactory != null) {
                Session session = null;
                Transaction tx = null;
                try {
                    session = sessionFactory.getCurrentSession();
                    String hqlUpdate = "update SecurityCheck s set  s.lastValidationDateCrypted = :lastValidationDateCrypted , s.isTemporaryPasswordUsed = :isTemporaryPasswordUsed ,s.temporary_use_period = :temporary_use_period   where s.id = :id ";
                    tx = session.beginTransaction();
                    int updatedEntities = session.createQuery(hqlUpdate).setString("lastValidationDateCrypted", mSecurityCheck.getLastValidationDateCrypted()).setBoolean("isTemporaryPasswordUsed", mSecurityCheck.isTemporaryPasswordUsed()).setInteger("temporary_use_period", mSecurityCheck.getTemporary_use_period().intValue()).setInteger("id", mSecurityCheck.getId()).executeUpdate();
                    tx.commit();
                    session.close();
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                    if (tx != null) {
                        tx.rollback();
                    }
                    if (session == null) break block4;
                    session.close();
                }
            }
        }
    }

    public SecurityCheck getLastSecurityCheck() {
        SecurityCheck securityCheck;
        block4: {
            securityCheck = null;
            if (sessionFactory != null) {
                Session session = null;
                Transaction tx = null;
                try {
                    session = sessionFactory.getCurrentSession();
                    tx = session.beginTransaction();
                    Query q = session.createQuery("from SecurityCheck s order by s.id desc");
                    List result = q.list();
                    securityCheck = result.isEmpty() ? null : (SecurityCheck)result.get(0);
                    tx.commit();
                    session.close();
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                    if (tx != null) {
                        tx.rollback();
                    }
                    if (session == null) break block4;
                    session.close();
                }
            }
        }
        return securityCheck;
    }

    public void setVerificationInfos(SecurityCheck mSecurityCheck) {
        block4: {
            if (sessionFactory != null) {
                Session session = null;
                Transaction tx = null;
                try {
                    session = sessionFactory.getCurrentSession();
                    String hqlUpdate = "update SecurityCheck s set  s.lastVerificationCodeDateCrypted = :lastVerificationCodeDateCrypted , s.isTemporaryPasswordUsed = :isTemporaryPasswordUsed ,s.unlock_period = :unlock_period   where s.id = :id ";
                    tx = session.beginTransaction();
                    int updatedEntities = session.createQuery(hqlUpdate).setString("lastVerificationCodeDateCrypted", mSecurityCheck.getLastVerificationCodeDateCrypted()).setBoolean("isTemporaryPasswordUsed", mSecurityCheck.isTemporaryPasswordUsed()).setInteger("unlock_period", mSecurityCheck.getUnlock_period()).setInteger("id", mSecurityCheck.getId()).executeUpdate();
                    tx.commit();
                    session.close();
                }
                catch (Exception ex) {
                    LogToFile.log("severe", ex.getMessage(), ex);
                    if (tx != null) {
                        tx.rollback();
                    }
                    if (session == null) break block4;
                    session.close();
                }
            }
        }
    }
}

