/*
 * Decompiled with CFR 0.152.
 */
package fr.protactile.procaisse.dao.impl;

import fr.protactile.procaisse.dao.config.DaoConfig;
import fr.protactile.procaisse.dao.entities.PertEntity;
import java.util.Date;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.query.Query;

public class PertEntityDao
extends DaoConfig<PertEntity> {
    @Override
    protected Class<PertEntity> classType() {
        return PertEntity.class;
    }

    public List<PertEntity> getPertes() {
        if (!s.isOpen()) {
            this.openSession();
        }
        Transaction tx = s.beginTransaction();
        Query q = s.createQuery("from PertEntity s WHERE  s.deleted = :deleted");
        q.setParameter("deleted", (Object)false);
        List pertes = q.list();
        tx.commit();
        s.close();
        return pertes;
    }

    public void addPerteInfo(PertEntity mPertEntity) {
        this.save(mPertEntity);
    }

    public void updatePerte(PertEntity mPertEntity) {
        if (!s.isOpen()) {
            this.openSession();
        }
        String hqlUpdate = "update PertEntity p set  p.caissier = :caissier ,p.raison = :raison , p.total = :total where p.id = :id ";
        Transaction tx = s.beginTransaction();
        int updatedEntities = s.createQuery(hqlUpdate).setString("caissier", mPertEntity.getCaissier()).setString("raison", mPertEntity.getRaison()).setDouble("total", mPertEntity.getTotal()).setInteger("id", mPertEntity.getId().intValue()).executeUpdate();
        tx.commit();
        s.close();
    }

    public void deletePerte(PertEntity mPertEntity) {
        if (!s.isOpen()) {
            this.openSession();
        }
        String hqlUpdate = "update PertEntity p set p.deleted = :deleted where p.id = :id ";
        Transaction tx = s.beginTransaction();
        int updatedEntities = s.createQuery(hqlUpdate).setParameter("deleted", (Object)true).setInteger("id", mPertEntity.getId().intValue()).executeUpdate();
        tx.commit();
        s.close();
    }

    public List<PertEntity> findPertByTimeRange(Date dateStart, Date dateEnd) {
        if (sessionFactory != null) {
            Session session = sessionFactory.getCurrentSession();
            Transaction tx = session.beginTransaction();
            Query query = session.createQuery("from PertEntity p WHERE p.deleted <> 1  and p.created_at <= :dateEnd AND p.created_at >= :dateStart  order by id desc");
            query.setParameter("dateStart", (Object)dateStart);
            query.setParameter("dateEnd", (Object)dateEnd);
            List result = query.list();
            tx.commit();
            session.close();
            return result;
        }
        return null;
    }
}

